/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer.mbimpl;

import java.util.HashMap;
import java.util.Map;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.mbimpl.RelationImpl;
import weblogic.ejb.container.persistence.spi.EjbEntityRef;
import weblogic.ejb.container.persistence.spi.EjbRelation;
import weblogic.ejb.container.persistence.spi.Relationships;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.CmrFieldBean;
import weblogic.j2ee.descriptor.EjbRelationBean;
import weblogic.j2ee.descriptor.EjbRelationshipRoleBean;
import weblogic.j2ee.descriptor.RelationshipsBean;
import weblogic.logging.Loggable;

public final class RelationshipsImpl
implements Relationships {
    private String[] m_description;
    private RelationshipsBean m_mBean;
    private Map m_ejbEntityRefs = new HashMap();
    private Map m_relations = new HashMap();

    public RelationshipsImpl(RelationshipsBean relationshipsBean, Map map) throws WLDeploymentException {
        this.m_mBean = relationshipsBean;
        if (null != relationshipsBean) {
            this.m_description = relationshipsBean.getDescriptions();
            EjbRelationBean[] ejbRelationBeanArray = relationshipsBean.getEjbRelations();
            for (int i = 0; i < ejbRelationBeanArray.length; ++i) {
                this.validateEjbRelationshipRoleNames(ejbRelationBeanArray[i]);
                String string = ejbRelationBeanArray[i].getEjbRelationName();
                if (string == null || string.length() == 0) {
                    this.createEjbRelationName(ejbRelationBeanArray[i]);
                    string = ejbRelationBeanArray[i].getEjbRelationName();
                }
                this.m_relations.put(string, new RelationImpl(ejbRelationBeanArray[i]));
            }
        }
    }

    private void createEjbRelationName(EjbRelationBean ejbRelationBean) {
        String string;
        EjbRelationshipRoleBean[] ejbRelationshipRoleBeanArray = ejbRelationBean.getEjbRelationshipRoles();
        String string2 = this.defaultRoleName(ejbRelationshipRoleBeanArray[0]);
        if (string2.compareTo(string = this.defaultRoleName(ejbRelationshipRoleBeanArray[1])) < 0) {
            ejbRelationBean.setEjbRelationName(string2 + "-" + string);
        } else if (string2.compareTo(string) > 0) {
            ejbRelationBean.setEjbRelationName(string + "-" + string2);
        } else {
            throw new AssertionError((Object)("Error: role names " + string2 + " and " + string + " are equal in relationship."));
        }
    }

    private void validateEjbRelationshipRoleNames(EjbRelationBean ejbRelationBean) throws WLDeploymentException {
        EjbRelationshipRoleBean[] ejbRelationshipRoleBeanArray = ejbRelationBean.getEjbRelationshipRoles();
        String string = ejbRelationshipRoleBeanArray[0].getEjbRelationshipRoleName();
        String string2 = ejbRelationshipRoleBeanArray[1].getEjbRelationshipRoleName();
        if (string == null) {
            string = this.defaultRoleName(ejbRelationshipRoleBeanArray[0]);
            ejbRelationshipRoleBeanArray[0].setEjbRelationshipRoleName(string);
        }
        if (string2 == null) {
            string2 = this.defaultRoleName(ejbRelationshipRoleBeanArray[1]);
            ejbRelationshipRoleBeanArray[1].setEjbRelationshipRoleName(string2);
        }
        if (string.compareTo(string2) == 0) {
            String string3 = ejbRelationshipRoleBeanArray[0].getRelationshipRoleSource().getEjbName();
            CmrFieldBean cmrFieldBean = ejbRelationshipRoleBeanArray[0].getCmrField();
            String string4 = cmrFieldBean == null ? "" : cmrFieldBean.getCmrFieldName();
            Loggable loggable = EJBLogger.logduplicateRelationshipRoleNameLoggable((String)string3, (String)string4);
            throw new WLDeploymentException(loggable.getMessage());
        }
    }

    private String defaultRoleName(EjbRelationshipRoleBean ejbRelationshipRoleBean) {
        String string = ejbRelationshipRoleBean.getRelationshipRoleSource().getEjbName();
        CmrFieldBean cmrFieldBean = ejbRelationshipRoleBean.getCmrField();
        String string2 = null;
        string2 = cmrFieldBean == null ? string : string + "." + cmrFieldBean.getCmrFieldName();
        return string2;
    }

    public String[] getDescriptions() {
        return this.m_description;
    }

    public EjbEntityRef getEjbEntityRef(String string) {
        EjbEntityRef ejbEntityRef = (EjbEntityRef)this.m_ejbEntityRefs.get(string);
        return ejbEntityRef;
    }

    public Map getAllEjbEntityRefs() {
        return this.m_ejbEntityRefs;
    }

    public EjbRelation getEjbRelation(String string) {
        return (EjbRelation)this.m_relations.get(string);
    }

    public Map getAllEjbRelations() {
        return this.m_relations;
    }
}

