/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer.mbimpl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.interfaces.NoSuchRoleException;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;

public final class SecurityRoleMappingImpl
implements SecurityRoleMapping {
    private final Map securityRoles = new HashMap();
    private Set externallyDefinedRoles = null;

    public final Collection getSecurityRoleNames() {
        return this.securityRoles.keySet();
    }

    public boolean hasRole(String string) {
        return this.securityRoles.get(string) != null;
    }

    public final Collection getSecurityRolePrincipalNames(String string) throws NoSuchRoleException {
        Collection collection = (Collection)this.securityRoles.get(string);
        if (collection == null) {
            throw new NoSuchRoleException(string + " is not a recognized role");
        }
        return collection;
    }

    public void addRoleToPrincipalsMapping(String string, Collection collection) {
        this.securityRoles.put(string, collection);
    }

    public boolean isRoleMappedToPrincipals(String string) throws NoSuchRoleException {
        if (!this.securityRoles.containsKey(string)) {
            throw new NoSuchRoleException(string + " is not a recognized role");
        }
        Collection collection = (Collection)this.securityRoles.get(string);
        return collection != null && !collection.isEmpty();
    }

    public void addExternallyDefinedRole(String string) {
        if (this.externallyDefinedRoles == null) {
            this.externallyDefinedRoles = new HashSet();
        }
        this.externallyDefinedRoles.add(string);
    }

    public boolean isExternallyDefinedRole(String string) throws NoSuchRoleException {
        if (!this.securityRoles.containsKey(string)) {
            throw new NoSuchRoleException(string + " is not a recognized role");
        }
        if (this.externallyDefinedRoles == null) {
            return false;
        }
        return this.externallyDefinedRoles.contains(string);
    }

    public String toString() {
        String string = new String("SecurityRoleMapping:\n");
        for (String string2 : this.securityRoles.keySet()) {
            string = string + "   Role:" + string2 + "\n";
            Collection collection = (Collection)this.securityRoles.get(string2);
            for (String string3 : collection) {
                string = string + "      " + string3 + "\n";
            }
        }
        return string;
    }
}

