/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientJarMaker {
    private static final DebugLogger debugLogger = EJBDebugService.compilationLogger;
    private final ClassLoader jarLoader;
    private Set<String> clientJarFiles = new HashSet<String>();
    private boolean containsRemoteEJBs = false;

    public ClientJarMaker(ClassLoader classLoader) {
        assert (classLoader != null);
        this.jarLoader = classLoader;
    }

    public String[] createClientJar(Collection<BeanInfo> collection, Collection<Class<?>> collection2) {
        for (Class<?> clazz : collection2) {
            this.addClass(clazz);
        }
        this.createClientJar(collection);
        if (this.clientJarFiles.isEmpty()) {
            if (this.containsRemoteEJBs) {
                EJBLogger.logUnableToCreateClientJarDueToClasspathIssues();
            } else {
                EJBLogger.logSkippingClientJarCreationSinceNoRemoteEJBsFound();
            }
            return new String[0];
        }
        String[] stringArray = new String[this.clientJarFiles.size()];
        stringArray = this.clientJarFiles.toArray(stringArray);
        return stringArray;
    }

    public String[] createClientJar(Collection<BeanInfo> collection) {
        for (BeanInfo beanInfo : collection) {
            ClientDrivenBeanInfo clientDrivenBeanInfo;
            ClientDrivenBeanInfo clientDrivenBeanInfo2;
            if (!(beanInfo instanceof ClientDrivenBeanInfo) || !(clientDrivenBeanInfo2 = (ClientDrivenBeanInfo)beanInfo).hasRemoteClientView()) continue;
            this.containsRemoteEJBs = true;
            if (clientDrivenBeanInfo2.hasDeclaredRemoteHome()) {
                if (!this.addClass(clientDrivenBeanInfo2.getHomeInterfaceClass())) {
                    EJBLogger.logUnableToAddToClientJarDueToClasspath((String)"home", (String)clientDrivenBeanInfo2.getHomeInterfaceClass().getName());
                }
                if (!this.addClass(clientDrivenBeanInfo2.getRemoteInterfaceClass())) {
                    EJBLogger.logUnableToAddToClientJarDueToClasspath((String)"remote", (String)clientDrivenBeanInfo2.getRemoteInterfaceClass().getName());
                }
            }
            if (beanInfo instanceof Ejb3SessionBeanInfo) {
                clientDrivenBeanInfo = (Ejb3SessionBeanInfo)beanInfo;
                for (Class clazz : clientDrivenBeanInfo.getBusinessRemotes()) {
                    if (this.addClass(clazz)) continue;
                    EJBLogger.logUnableToAddToClientJarDueToClasspath((String)"business-remote", (String)clazz.getName());
                }
            }
            if (!(beanInfo instanceof EntityBeanInfo) || (clientDrivenBeanInfo = (EntityBeanInfo)beanInfo).isUnknownPrimaryKey()) continue;
            this.addClass(clientDrivenBeanInfo.getPrimaryKeyClass());
        }
        return this.clientJarFiles.toArray(new String[this.clientJarFiles.size()]);
    }

    private void addClass(Class<?>[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            this.addClass(classArray[i]);
        }
    }

    private void addClass(Field[] fieldArray) {
        for (int i = 0; i < fieldArray.length; ++i) {
            this.addClass(fieldArray[i].getType());
        }
    }

    private void addClass(Constructor<?>[] constructorArray) {
        for (int i = 0; i < constructorArray.length; ++i) {
            this.addClass(constructorArray[i].getParameterTypes());
            this.addClass(constructorArray[i].getExceptionTypes());
        }
    }

    private void addClass(Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            this.addClass(methodArray[i].getReturnType());
            this.addClass(methodArray[i].getExceptionTypes());
            this.addClass(methodArray[i].getParameterTypes());
        }
    }

    private boolean addClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isArray()) {
            return this.addClass(clazz.getComponentType());
        }
        if (clazz.getClassLoader() != this.jarLoader) {
            if (debugLogger.isDebugEnabled()) {
                ClientJarMaker.debug("** Rejecting class not from jar: " + clazz.getName());
            }
            return false;
        }
        if (this.clientJarFiles.contains(clazz.getName())) {
            if (debugLogger.isDebugEnabled()) {
                ClientJarMaker.debug("** We already have: " + clazz.getName());
            }
            return true;
        }
        if (debugLogger.isDebugEnabled()) {
            ClientJarMaker.debug("** Adding: " + clazz.getName());
        }
        this.clientJarFiles.add(clazz.getName());
        this.addClass(clazz.getSuperclass());
        this.addClass(clazz.getInterfaces());
        this.addClass(clazz.getDeclaredFields());
        this.addClass(clazz.getConstructors());
        this.addClass(clazz.getDeclaredMethods());
        return true;
    }

    private static void debug(String string) {
        debugLogger.debug("[ClientJarMaker] " + string);
    }
}

