/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import weblogic.ejb.container.interfaces.CMPCompiler;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.PersistenceType;
import weblogic.ejb.container.persistence.spi.CMPCodeGenerator;
import weblogic.ejb.container.persistence.spi.CMPDeployer;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.ICompilerFactory;

public final class EJBCMPCompiler
implements CMPCompiler {
    private Getopt2 opts;
    private File outputDir;
    private CMPDeployer cmpDeployer = null;
    private CMPCodeGenerator cmpGenerator = null;
    private ICompilerFactory compilerFactory;

    EJBCMPCompiler(File file, Getopt2 getopt2, ICompilerFactory iCompilerFactory) {
        this.outputDir = file;
        this.opts = getopt2;
        this.compilerFactory = iCompilerFactory;
    }

    public List generatePersistenceSources(EntityBeanInfo entityBeanInfo) throws Exception {
        assert (entityBeanInfo != null);
        PersistenceType persistenceType = entityBeanInfo.getCMPInfo().getPersistenceType();
        this.cmpDeployer = entityBeanInfo.getCMPInfo().getDeployer();
        assert (this.cmpDeployer != null);
        persistenceType.setOptions(this.opts);
        this.cmpGenerator = persistenceType.getCodeGenerator();
        this.cmpGenerator.setCompilerFactory(this.compilerFactory);
        this.cmpDeployer.preCodeGeneration(this.cmpGenerator);
        List<Object> list = null;
        if (this.cmpGenerator != null) {
            this.cmpGenerator.setAssociatedType(persistenceType);
            this.cmpGenerator.setRootDirectoryName(this.outputDir.getAbsolutePath());
            this.cmpGenerator.setTargetDirectory(this.outputDir.getAbsolutePath());
            this.cmpGenerator.generate(entityBeanInfo);
            list = this.cmpGenerator.getGeneratedOutputs();
        }
        if (list == null) {
            list = new LinkedList();
        }
        return list;
    }

    public void postCompilation() throws Exception {
        this.cmpDeployer.postCodeGeneration(this.cmpGenerator);
    }
}

