/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ejb.EJBHome;
import javax.xml.stream.XMLStreamException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.ComplianceChecker;
import weblogic.ejb.container.compliance.ComplianceCheckerFactory;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.deployer.MBeanDeploymentInfoImpl;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.ClientJarMaker;
import weblogic.ejb.container.ejbc.CompilerForJDT;
import weblogic.ejb.container.ejbc.CompilerForJavac;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.EJBCMPCompiler;
import weblogic.ejb.container.ejbc.Ejb2Rmi;
import weblogic.ejb.container.ejbc.EjbCodeGenerator;
import weblogic.ejb.container.ejbc.RMICOptions;
import weblogic.ejb.container.ejbc.VersionHelperImpl;
import weblogic.ejb.container.ejbc.bytecodegen.GeneratorFactory;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.CMPCompiler;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.spi.EJBC;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.EjbDescriptorFactory;
import weblogic.ejb.spi.ICompiler;
import weblogic.ejb.spi.VersionHelper;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.ResourceDescriptionBean;
import weblogic.j2ee.descriptor.wl.ResourceEnvDescriptionBean;
import weblogic.j2ee.validation.ModuleValidationInfo;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.rmic.Remote2Java;
import weblogic.rmi.rmic.RmicMethodDescriptor;
import weblogic.rmic;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.Getopt2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.CompilerInvoker;
import weblogic.utils.compiler.ICompilerFactory;
import weblogic.utils.compiler.ICompilerInvoker;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.compiler.jdt.JDTJavaCompilerFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJBCompiler
implements EJBC {
    private static final DebugLogger debugLogger = EJBDebugService.compilationLogger;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String CHECKSUM_FILE = "_WL_GENERATED";
    private static final String JMS_RES_TYPE_ID = "javax.jms.";
    private static final String JDBC_RES_TYPE_ID = "javax.sql.";
    private static final String DISPATCH_POLICY = "dispatchPolicy";
    private static final String STICK_TO_FIRST_SERVER = "stickToFirstServer";
    private final Ejb2Rmi ejb2rmi;
    private final Getopt2 opts;
    private final File outputDir;
    private VersionHelper vHelper;
    private final boolean forceGeneration;
    private final boolean basicClientJar;
    private DeploymentInfo activeDeploymentInfo;
    private EJBComponentMBean mBean;
    private ClassLoader classLoader;
    private final boolean runComplianceChecker;
    protected ICompilerFactory compilerFactory;
    private static final int BUFFER_SIZE = 8192;

    public EJBCompiler(Getopt2 getopt2, ICompilerFactory iCompilerFactory) {
        this.ejb2rmi = new Ejb2Rmi(getopt2);
        Remote2Java.addRMIStubGeneratorOptions((Getopt2)getopt2);
        this.ejb2rmi.setCompilerFactory(iCompilerFactory);
        this.opts = getopt2;
        this.outputDir = new File(this.ejb2rmi.rootDirectory());
        this.runComplianceChecker = !getopt2.hasOption("nocompliance");
        this.forceGeneration = getopt2.hasOption("forceGeneration");
        this.basicClientJar = getopt2.hasOption("basicClientJar");
        this.compilerFactory = iCompilerFactory;
    }

    public EJBCompiler(Getopt2 getopt2) {
        this(getopt2, null);
    }

    private void setupEJB(GenericClassLoader genericClassLoader, EJBComponentMBean eJBComponentMBean, EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, VersionHelper versionHelper) throws ErrorCollectionException {
        this.classLoader = genericClassLoader;
        this.mBean = eJBComponentMBean;
        if (versionHelper != null) {
            this.activeDeploymentInfo = ((VersionHelperImpl)versionHelper).getDeploymentInfo();
            this.vHelper = versionHelper;
        } else {
            try {
                this.activeDeploymentInfo = EJBCompiler.getStandAloneDeploymentInfo(genericClassLoader, virtualJarFile, ejbDescriptorBean);
                for (BeanInfo beanInfo : this.activeDeploymentInfo.getBeanInfos()) {
                    EntityBeanInfo entityBeanInfo;
                    if (!(beanInfo instanceof EntityBeanInfo) || (entityBeanInfo = (EntityBeanInfo)beanInfo).getIsBeanManagedPersistence()) continue;
                    entityBeanInfo.getCMPInfo().setup(new File(this.activeDeploymentInfo.getJarFileName()), this.opts, virtualJarFile);
                }
                this.vHelper = new VersionHelperImpl(this.activeDeploymentInfo, virtualJarFile, this.opts);
            }
            catch (ErrorCollectionException errorCollectionException) {
                throw errorCollectionException;
            }
            catch (Exception exception) {
                throw new ErrorCollectionException((Throwable)exception);
            }
        }
        this.addIIOPOptionsToOpts();
    }

    private List<String> getSourceFilePaths(Set<EjbCodeGenerator.Output> set) {
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (EjbCodeGenerator.Output output : set) {
            arrayList.add(output.getAbsoluteFilePath());
        }
        return arrayList;
    }

    private Map<String, String> getSourceContent(Set<EjbCodeGenerator.Output> set) {
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        for (EjbCodeGenerator.Output output : set) {
            String string = output.getPackage();
            String string2 = output.getOutputFile().substring(0, output.getOutputFile().length() - 5);
            String string3 = string == null || "".equals(string) ? string2 : string + "." + string2;
            hashMap.put(string3, output.getOutputContent());
        }
        return hashMap;
    }

    private ICompiler makeCompilerInvoker() {
        if (this.ejb2rmi.isJDTBased()) {
            GenericClassLoader genericClassLoader = (GenericClassLoader)Thread.currentThread().getContextClassLoader();
            return new CompilerForJDT(this.ejb2rmi.rootDirectory(), genericClassLoader.getClassPath());
        }
        if (null != this.compilerFactory) {
            return new CompilerForJavac(this.compilerFactory.makeCompilerInvoker(this.opts));
        }
        return new CompilerForJavac((ICompilerInvoker)new CompilerInvoker(this.opts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doCompile(Collection var1_1) throws ErrorCollectionException {
        block42: {
            block41: {
                if (this.runComplianceChecker) {
                    this.checkCompliance(this.activeDeploymentInfo);
                }
                var2_2 = new HashSet<EjbCodeGenerator.Output>();
                var3_3 = this.activeDeploymentInfo.getEjbDescriptorBean();
                if (var3_3.isEjb30() && (var5_5 = (var4_4 = var3_3.getEjbJarBean()).getInterceptors()) != null) {
                    var6_6 = var5_5.getInterceptors();
                    var7_7 = new HashSet<E>();
                    for (var8_9 = 0; var8_9 < ((InterceptorBean[])var6_6).length; ++var8_9) {
                        try {
                            var9_14 = var6_6[var8_9].getInterceptorClass();
                            var10_18 = this.classLoader.loadClass(var9_14);
                            if (Serializable.class.isAssignableFrom((Class<?>)var10_18) || var7_7.contains(var10_18)) continue;
                            this.generate((InterceptorBean)var6_6[var8_9]);
                            var7_7.add(var10_18);
                            continue;
                        }
                        catch (Exception var9_15) {
                            throw new ErrorCollectionException((Throwable)var9_15);
                        }
                    }
                }
                var4_4 = new ArrayList<E>();
                var5_5 = null;
                for (Object var7_7 : var1_1) {
                    if (EJBCompiler.debugLogger.isDebugEnabled()) {
                        EJBCompiler.debug("Generating Bean Sources");
                    }
                    try {
                        var2_2.addAll(this.generate((BeanInfo)var7_7));
                    }
                    catch (Exception var8_10) {
                        throw new ErrorCollectionException((Throwable)var8_10);
                    }
                    if (!(var7_7 instanceof EntityBeanInfo) || (var8_11 = (EntityBeanInfo)var7_7).getIsBeanManagedPersistence()) continue;
                    try {
                        if (EJBCompiler.debugLogger.isDebugEnabled()) {
                            EJBCompiler.debug("Generating Persistence Sources");
                        }
                        var5_5 = new EJBCMPCompiler(this.outputDir, this.opts, this.compilerFactory);
                        var2_2.addAll(var5_5.generatePersistenceSources(var8_11));
                        var4_4.add(var5_5);
                    }
                    catch (Exception var9_16) {
                        throw new ErrorCollectionException((Throwable)var9_16);
                    }
                }
                if (!var2_2.isEmpty()) {
                    if (EJBCompiler.debugLogger.isDebugEnabled()) {
                        EJBCompiler.debug("Compiling EJB sources");
                    }
                    var7_7 = this.makeCompilerInvoker();
                    var8_9 = (int)Kernel.isServer();
                    var9_17 = false;
                    try {
                        block40: {
                            if (this.ejb2rmi.isJDTBased()) {
                                var7_7.compile(this.getSourceContent(var2_2));
                                break block40;
                            }
                            var10_18 = this.outputDir.getPath();
                            var7_7.overrideTargetDirectory((String)var10_18);
                            if (var8_9 != 0) {
                                var7_7.setWantCompilerErrors(true);
                                var7_7.setSourcepath("/dev/null");
                            }
                            var7_7.compile(this.getSourceFilePaths(var2_2));
                        }
                        var12_20 = null;
                        if (var8_9 == 0 || (var13_22 = var7_7.getCompilerErrors()) == null || var13_22.trim().length() <= 0) break block41;
                        ** if (!var9_17) goto lbl-1000
                    }
                    catch (Throwable var11_24) {
                        var12_21 = null;
                        if (var8_9 != 0 && (var13_23 = var7_7.getCompilerErrors()) != null && var13_23.trim().length() > 0) {
                            if (var9_17) {
                                EJBLogger.logJavaCompilerErrorOutput((String)var13_23);
                            } else {
                                EJBLogger.logJavaCompilerOutput((String)var13_23);
                            }
                        }
                        throw var11_24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        EJBLogger.logJavaCompilerErrorOutput((String)var13_22);
                        ** GOTO lbl84
                    }
lbl-1000:
                    // 1 sources

                    {
                        EJBLogger.logJavaCompilerOutput((String)var13_22);
                    }
                    {
                        break block41;
                        catch (IOException var10_19) {
                            var9_17 = true;
                            throw new ErrorCollectionException((Throwable)var10_19);
                        }
                    }
                }
            }
            var6_6 = var4_4.iterator();
            while (var6_6.hasNext()) {
                var5_5 = (CMPCompiler)var6_6.next();
                try {
                    var5_5.postCompilation();
                }
                catch (Exception var7_8) {
                    throw new ErrorCollectionException((Throwable)var7_8);
                }
            }
            var7_7 = null;
            var8_12 = new File(this.outputDir, "_WL_GENERATED");
            if (var8_12.exists()) {
                var8_12.delete();
            }
            var7_7 = new FileOutputStream(var8_12);
            this.vHelper.getCurrentJarHash().store((OutputStream)var7_7, null);
            var15_25 = null;
            try {
                if (var7_7 != null) {
                    var7_7.close();
                }
                break block42;
            }
            catch (Exception var16_28) {}
            break block42;
            {
                catch (Exception var8_13) {
                    EJBLogger.logErrorSavingTimestamps((Exception)var8_13);
                    var15_26 = null;
                    try {
                        if (var7_7 != null) {
                            var7_7.close();
                        }
                        break block42;
                    }
                    catch (Exception var16_29) {}
                }
            }
            catch (Throwable var14_31) {
                var15_27 = null;
                try {
                    if (var7_7 != null) {
                        var7_7.close();
                    }
                }
                catch (Exception var16_30) {
                    // empty catch block
                }
                throw var14_31;
            }
        }
    }

    private void doRmic(Collection<BeanInfo> collection) throws ErrorCollectionException {
        for (BeanInfo beanInfo : collection) {
            Map<Class<?>, String> map = this.getIfaceToImplClassNameMap(beanInfo);
            if (null == map) continue;
            if (debugLogger.isDebugEnabled()) {
                EJBCompiler.debug("Got Remote Classes: " + map.values());
            }
            if (map.isEmpty()) continue;
            this.runRmic(map, beanInfo);
        }
    }

    @Override
    public void compileEJB(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, ModuleValidationInfo moduleValidationInfo) throws ErrorCollectionException {
        String string = moduleValidationInfo == null ? this.getUriFromPlan(deploymentPlanBean) : moduleValidationInfo.getURI();
        EjbDescriptorBean ejbDescriptorBean = EJBCompiler.parseDescriptors(virtualJarFile, file, file2, deploymentPlanBean, string, genericClassLoader);
        this.compileEJB(genericClassLoader, null, ejbDescriptorBean, virtualJarFile, moduleValidationInfo, null, null);
    }

    private String getUriFromPlan(DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean == null) {
            return null;
        }
        ModuleOverrideBean[] moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides();
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
            if (!deploymentPlanBean.rootModule(moduleOverrideBean.getModuleName())) continue;
            return moduleOverrideBean.getModuleName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileEJB(GenericClassLoader genericClassLoader, EJBComponentMBean eJBComponentMBean, EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile) throws ErrorCollectionException {
        try {
            this.compileEJB(genericClassLoader, eJBComponentMBean, ejbDescriptorBean, virtualJarFile, null, null, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JDTJavaCompilerFactory.getInstance().resetCache((ClassLoader)genericClassLoader);
            throw throwable;
        }
        JDTJavaCompilerFactory.getInstance().resetCache((ClassLoader)genericClassLoader);
    }

    @Override
    public void compileEJB(GenericClassLoader genericClassLoader, EJBComponentMBean eJBComponentMBean, VirtualJarFile virtualJarFile, VersionHelper versionHelper, Collection collection) throws ErrorCollectionException {
        this.compileEJB(genericClassLoader, eJBComponentMBean, null, virtualJarFile, null, versionHelper, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileEJB(GenericClassLoader genericClassLoader, EJBComponentMBean eJBComponentMBean, EjbDescriptorBean ejbDescriptorBean, VirtualJarFile virtualJarFile, ModuleValidationInfo moduleValidationInfo, VersionHelper versionHelper, Collection collection) throws ErrorCollectionException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader);
            this.setupEJB(genericClassLoader, eJBComponentMBean, ejbDescriptorBean, virtualJarFile, versionHelper);
            EJBCompiler.populateMVI(moduleValidationInfo, this.activeDeploymentInfo);
            if (this.forceGeneration) {
                if (debugLogger.isDebugEnabled()) {
                    EJBCompiler.debug("Recompiling because of forceGeneration flag");
                }
                collection = this.activeDeploymentInfo.getBeanInfos();
            } else if (collection == null) {
                collection = this.vHelper.needsRecompile(virtualJarFile);
            }
            Collection collection2 = this.allBeansNeedRmic() ? this.activeDeploymentInfo.getBeanInfos() : collection;
            if (!collection.isEmpty()) {
                this.doCompile(collection);
                if (debugLogger.isDebugEnabled()) {
                    EJBCompiler.debug("Recompilation completed");
                }
            } else if (debugLogger.isDebugEnabled()) {
                EJBCompiler.debug("Recompilation determined unnecessary");
            }
            if (!collection2.isEmpty()) {
                this.doRmic(collection2);
                if (debugLogger.isDebugEnabled()) {
                    EJBCompiler.debug("Rmic completed");
                }
            } else if (debugLogger.isDebugEnabled()) {
                EJBCompiler.debug("Rmic determined unnecessary");
            }
            if (!Kernel.isServer()) {
                String string = this.activeDeploymentInfo.getClientJarFileName();
                try {
                    if (string != null && !"".equals(string)) {
                        this.createClientJar(string, this.activeDeploymentInfo.getBeanInfos());
                    }
                }
                catch (IOException iOException) {
                    throw new ErrorCollectionException((Throwable)iOException);
                }
            }
            Object var13_12 = null;
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            throw throwable;
        }
    }

    private boolean allBeansNeedRmic() {
        return this.isOptionPresent("idl") || this.isOptionPresent("idlOverwrite") || this.isOptionPresent("idlNoValueTypes") || this.isOptionPresent("idlFactories") || this.isOptionPresent("idlVisibroker") || this.isOptionPresent("idlDirectory") || this.isOptionPresent("idlMethodSignatures") || this.isOptionPresent("iiop") || this.isOptionPresent("iiopDirectory");
    }

    private boolean isOptionPresent(String string) {
        return this.opts.hasOption(string);
    }

    private Collection<Class<?>> getStubClasses(Collection<String> collection) {
        Iterator<String> iterator = collection.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string = iterator.next();
            string = string.substring(this.outputDir.getAbsolutePath().length() + 1, string.length());
            string = ClassUtils.fileNameToClass(string);
            try {
                Class<?> clazz = this.classLoader.loadClass(string);
                arrayList.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return arrayList;
    }

    private void createClientJar(String string, Collection<BeanInfo> collection) throws IOException {
        String[] stringArray;
        ClientJarMaker clientJarMaker = new ClientJarMaker(this.classLoader);
        Collection<Class<?>> collection2 = this.getStubClasses(this.getAllIIOPStubs(this.outputDir));
        if (this.opts.hasOption("disableHotCodeGen")) {
            stringArray = this.getStubClasses(this.getRMIStubClasses(this.outputDir));
            collection2.addAll((Collection<Class<?>>)stringArray);
        }
        stringArray = clientJarMaker.createClientJar(collection, collection2);
        if (debugLogger.isDebugEnabled()) {
            EJBCompiler.debug("** Client jar size is: " + stringArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("** Client jar files: ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        if (stringArray.length > 0) {
            this.makeJar(string, stringArray);
            EJBLogger.logClientJarCreated((String)string);
        }
    }

    private List<String> getRMIStubClasses(File file) {
        assert (file != null);
        assert (file.isDirectory());
        String[] stringArray = file.list();
        String string = ServerHelper.WLS_STUB_VERSION + ".class";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
            if (file2.isDirectory()) {
                arrayList.addAll(this.getRMIStubClasses(file2));
                continue;
            }
            if (!file2.getAbsolutePath().endsWith(string)) continue;
            arrayList.add(file2.getAbsolutePath());
        }
        return arrayList;
    }

    private List<String> getRuntimeDescriptors(File file) {
        assert (file != null);
        assert (file.isDirectory());
        String[] stringArray = file.list();
        String string = "ImplRTD.xml";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
            if (file2.isDirectory()) {
                arrayList.addAll(this.getRuntimeDescriptors(file2));
                continue;
            }
            if (!file2.getAbsolutePath().endsWith(string)) continue;
            String string2 = file2.getAbsolutePath();
            String string3 = string2.substring(this.outputDir.getAbsolutePath().length() + 1, string2.length());
            string3 = string3.replace('\\', '/');
            arrayList.add(string3);
        }
        return arrayList;
    }

    private List<String> getAllIIOPStubs(File file) {
        assert (file != null);
        assert (file.isDirectory());
        String[] stringArray = file.list();
        String string = "_Stub.class";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
            if (file2.isDirectory()) {
                arrayList.addAll(this.getAllIIOPStubs(file2));
                continue;
            }
            if (!file2.getAbsolutePath().endsWith(string)) continue;
            arrayList.add(file2.getAbsolutePath());
        }
        return arrayList;
    }

    private File makeClientJarOutputDirectoryIfNecessary() throws IOException {
        String string = this.opts.getOption("clientJarOutputDir");
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("ERROR: the clientJarOutputDir [" + file.getAbsolutePath() + "] must be directory.");
            }
        } else {
            file.mkdir();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeJar(String string, String[] stringArray) throws IOException {
        FileOutputStream fileOutputStream;
        block14: {
            assert (stringArray.length > 0);
            File file = this.makeClientJarOutputDirectoryIfNecessary();
            fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            try {
                String string2;
                Object object;
                Object object2;
                Object object3;
                String string3 = string;
                if (file != null) {
                    string3 = file.getCanonicalPath() + File.separator + string;
                }
                fileOutputStream = new FileOutputStream(string3);
                zipOutputStream = new JarOutputStream(fileOutputStream);
                for (int i = 0; i < stringArray.length; ++i) {
                    Object var13_13;
                    object3 = null;
                    object2 = null;
                    try {
                        object = stringArray[i].replace('.', '/');
                        string2 = (String)object + ".class";
                        object3 = this.classLoader.getResourceAsStream(string2);
                        object2 = new ZipEntry(string2);
                        ((JarOutputStream)zipOutputStream).putNextEntry((ZipEntry)object2);
                        this.copyBytes((InputStream)object3, zipOutputStream);
                        zipOutputStream.closeEntry();
                        var13_13 = null;
                        if (object3 == null) continue;
                    }
                    catch (Throwable throwable) {
                        var13_13 = null;
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                        throw throwable;
                    }
                    ((InputStream)object3).close();
                    {
                        continue;
                    }
                }
                if (!this.basicClientJar) {
                    InputStream inputStream = this.classLoader.getResourceAsStream("META-INF/ejb-jar.xml");
                    object3 = new ZipEntry("META-INF/ejb-jar.xml");
                    ((JarOutputStream)zipOutputStream).putNextEntry((ZipEntry)object3);
                    this.copyBytes(inputStream, zipOutputStream);
                    zipOutputStream.closeEntry();
                    inputStream = this.classLoader.getResourceAsStream("META-INF/weblogic-ejb-jar.xml");
                    if (inputStream != null) {
                        object3 = new ZipEntry("META-INF/weblogic-ejb-jar.xml");
                        ((JarOutputStream)zipOutputStream).putNextEntry((ZipEntry)object3);
                        this.copyBytes(inputStream, zipOutputStream);
                        zipOutputStream.closeEntry();
                    }
                    object2 = this.getRuntimeDescriptors(this.outputDir);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        string2 = (String)object.next();
                        inputStream = this.classLoader.getResourceAsStream(string2);
                        if (inputStream == null) continue;
                        object3 = new ZipEntry(string2);
                        ((JarOutputStream)zipOutputStream).putNextEntry((ZipEntry)object3);
                        this.copyBytes(inputStream, zipOutputStream);
                        zipOutputStream.closeEntry();
                    }
                }
                Object var15_15 = null;
                if (zipOutputStream == null) break block14;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
            zipOutputStream.close();
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    private void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private void checkCompliance(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        assert (deploymentInfo != null);
        try {
            ComplianceChecker complianceChecker = ComplianceCheckerFactory.getComplianceChecker();
            complianceChecker.checkDeploymentInfo(deploymentInfo);
            if (debugLogger.isDebugEnabled()) {
                EJBCompiler.debug("Compliance Checker said bean was compliant");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ErrorCollectionException((Throwable)new ToolFailureException("Unable to load a class required by your EJB: " + classNotFoundException.getMessage()));
        }
        catch (ErrorCollectionException errorCollectionException) {
            throw errorCollectionException;
        }
    }

    private void generate(InterceptorBean interceptorBean) throws Exception {
        if (debugLogger.isDebugEnabled()) {
            EJBCompiler.debug("Generating code for interceptor " + interceptorBean.getInterceptorClass());
        }
        assert (interceptorBean != null);
        NamingConvention namingConvention = new NamingConvention(interceptorBean.getInterceptorClass());
        GeneratorFactory.generate(interceptorBean, namingConvention, this.outputDir.getAbsolutePath());
    }

    private List<EjbCodeGenerator.Output> generate(BeanInfo beanInfo) throws Exception {
        ArrayList<EjbCodeGenerator.Output> arrayList = new ArrayList<EjbCodeGenerator.Output>();
        if (beanInfo instanceof MessageDrivenBeanInfo) {
            MessageDrivenBeanInfo messageDrivenBeanInfo = (MessageDrivenBeanInfo)beanInfo;
            if (null == messageDrivenBeanInfo.getName()) {
                EJBComplianceTextFormatter eJBComplianceTextFormatter = EJBComplianceTextFormatter.getInstance();
                throw new EJBCException(eJBComplianceTextFormatter.destinationNotFound(beanInfo.getEJBName()));
            }
            if (!messageDrivenBeanInfo.getIsWeblogicJMS() || messageDrivenBeanInfo.isIndirectlyImplMessageListener()) {
                if (debugLogger.isDebugEnabled()) {
                    EJBCompiler.debug("Generating code for ejb " + beanInfo.getEJBName());
                }
                NamingConvention namingConvention = new NamingConvention(messageDrivenBeanInfo.getBeanClassName(), messageDrivenBeanInfo.getEJBName());
                GeneratorFactory.generate(messageDrivenBeanInfo, namingConvention, this.outputDir.getAbsolutePath());
            }
        } else if (beanInfo instanceof ClientDrivenBeanInfo) {
            if (debugLogger.isDebugEnabled()) {
                EJBCompiler.debug("Generating code for ejb " + beanInfo.getEJBName());
            }
            assert (beanInfo != null);
            if (((ClientDrivenBeanInfo)beanInfo).isSessionBean()) {
                NamingConvention namingConvention = new NamingConvention(beanInfo.getBeanClassName(), beanInfo.getEJBName());
                GeneratorFactory.generate((SessionBeanInfo)beanInfo, namingConvention, this.outputDir.getAbsolutePath());
            } else {
                List list = this.ejb2rmi.generate(beanInfo);
                if (debugLogger.isDebugEnabled()) {
                    EJBCompiler.debug("Generated the following sources for this EJB: " + list);
                }
                arrayList.addAll(this.ejb2rmi.getGeneratedOutputs());
            }
        } else {
            throw new RuntimeException("Uknnown type of BeanInfo:" + beanInfo);
        }
        return arrayList;
    }

    private Map<Class<?>, String> getIfaceToImplClassNameMap(BeanInfo beanInfo) {
        ClientDrivenBeanInfo clientDrivenBeanInfo;
        HashMap<Class, String> hashMap = null;
        if (beanInfo instanceof ClientDrivenBeanInfo && (clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo).hasRemoteClientView()) {
            hashMap = new HashMap<Class, String>();
            NamingConvention namingConvention = new NamingConvention(beanInfo.getBeanClassName(), beanInfo.getEJBName());
            if (clientDrivenBeanInfo.hasDeclaredRemoteHome()) {
                hashMap.put(clientDrivenBeanInfo.getHomeInterfaceClass(), namingConvention.getHomeClassName());
                hashMap.put(clientDrivenBeanInfo.getRemoteInterfaceClass(), namingConvention.getEJBObjectClassName());
            }
            if (beanInfo instanceof Ejb3SessionBeanInfo) {
                Ejb3SessionBeanInfo ejb3SessionBeanInfo = (Ejb3SessionBeanInfo)beanInfo;
                for (Class clazz : ejb3SessionBeanInfo.getBusinessRemotes()) {
                    hashMap.put(clazz, namingConvention.getRemoteBusinessImplClassName(clazz));
                }
            }
        }
        return hashMap;
    }

    private Set<String> runRmic(Map<Class<?>, String> map, BeanInfo beanInfo) throws ErrorCollectionException {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            ClassLoader classLoader = beanInfo.getClassLoader();
            for (Map.Entry<Class<?>, String> entry : map.entrySet()) {
                RMICOptions rMICOptions = this.buildRmicOptions(entry.getKey(), beanInfo);
                String[] stringArray = this.getRmicCommandOptions(rMICOptions, entry.getValue());
                Collection<RmicMethodDescriptor> collection = rMICOptions.getRmicMethodDescriptors();
                String[] stringArray2 = rmic.main_nocompile(stringArray, classLoader, collection);
                for (int i = 0; i < stringArray2.length; ++i) {
                    hashSet.add(stringArray2[i]);
                }
            }
            return hashSet;
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
    }

    private boolean isHomeClass(Class<?> clazz) {
        return EJBHome.class.isAssignableFrom(clazz);
    }

    private RMICOptions buildRmicOptions(Class<?> clazz, BeanInfo beanInfo) {
        RMICOptions rMICOptions = new RMICOptions(beanInfo);
        rMICOptions.setIIOPSecurityOptions();
        if (this.isHomeClass(clazz)) {
            rMICOptions.setHomeOptions();
        } else {
            rMICOptions.setEOOptions(clazz);
        }
        rMICOptions.setOutputDirectory(this.outputDir.getAbsolutePath());
        return rMICOptions;
    }

    private String[] getRmicCommandOptions(RMICOptions rMICOptions, String string) {
        List<String> list = rMICOptions.asList();
        boolean bl = list.contains("-dispatchPolicy");
        boolean bl2 = list.contains("-stickToFirstServer");
        Getopt2 getopt2 = (Getopt2)this.opts.clone();
        if (bl && getopt2.hasOption(DISPATCH_POLICY)) {
            getopt2.removeOption(DISPATCH_POLICY);
        }
        if (bl2 && getopt2.hasOption(STICK_TO_FIRST_SERVER)) {
            getopt2.removeOption(STICK_TO_FIRST_SERVER);
        }
        String[] stringArray = getopt2.asCommandArray();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-output")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-maxfiles")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-plan")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-clientJarOutputDir")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-nodeploy") || stringArray[i].equals("-nocompliance") || stringArray[i].equals("-lineNumbers") || stringArray[i].equals("-forceGeneration") || stringArray[i].equals("-basicClientJar") || stringArray[i].equals("-quiet") || stringArray[i].equals("-convertDDs") || stringArray[i].equals("-writeInferredDescriptors")) continue;
            list.add(stringArray[i]);
        }
        list.add(string);
        return list.toArray(new String[list.size()]);
    }

    private void addIIOPOptionsToOpts() {
        this.opts.addOption("integrity", "integrity", "IIOP Transport integrity");
        this.opts.addOption("confidentiality", "confidentiality", "IIOP Transport confidentiality");
        this.opts.addOption("clientCertAuthentication", "clientCertAuthentication", "IIOP Transport clientCertAuthentication");
        this.opts.addOption("clientAuthentication", "clientAuthentication", "clientAuthentication");
        this.opts.addOption("identityAssertion", "identityAssertion", "identityAssertion");
    }

    private static void debug(String string) {
        debugLogger.debug("[EJBCompiler] " + string);
    }

    private void populateValidationInfo(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, ModuleValidationInfo moduleValidationInfo) throws ErrorCollectionException {
        String string = moduleValidationInfo == null ? this.getUriFromPlan(deploymentPlanBean) : moduleValidationInfo.getURI();
        EjbDescriptorBean ejbDescriptorBean = EJBCompiler.parseDescriptors(virtualJarFile, file, file2, deploymentPlanBean, string, genericClassLoader);
        DeploymentInfo deploymentInfo = null;
        try {
            deploymentInfo = EJBCompiler.getStandAloneDeploymentInfo(genericClassLoader, virtualJarFile, ejbDescriptorBean);
        }
        catch (Exception exception) {
            throw new ErrorCollectionException((Throwable)exception);
        }
        EJBCompiler.populateMVI(moduleValidationInfo, deploymentInfo);
    }

    @Override
    public void populateValidationInfo(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, ModuleValidationInfo moduleValidationInfo) throws ErrorCollectionException {
        this.populateValidationInfo(genericClassLoader, virtualJarFile, file, null, null, moduleValidationInfo);
    }

    private static void populateMVI(ModuleValidationInfo moduleValidationInfo, DeploymentInfo deploymentInfo) {
        if (moduleValidationInfo != null) {
            for (BeanInfo beanInfo : deploymentInfo.getBeanInfos()) {
                Object object;
                Object object2;
                Object object3;
                Object object42;
                moduleValidationInfo.addEJBValidationInfo(beanInfo.getEJBName(), beanInfo);
                for (Object object42 : beanInfo.getAllEJBReferences()) {
                    if (object42.getEjbLink() == null) continue;
                    moduleValidationInfo.addEJBRef(beanInfo.getEJBName(), object42.getEjbRefName(), false, object42.getRemote(), object42.getHome(), object42.getEjbRefType(), object42.getEjbLink(), false);
                }
                object42 = beanInfo.getAllEJBLocalReferences().iterator();
                while (object42.hasNext()) {
                    object3 = (EjbLocalRefBean)object42.next();
                    if (object3.getEjbLink() == null) continue;
                    moduleValidationInfo.addEJBRef(beanInfo.getEJBName(), object3.getEjbRefName(), true, object3.getLocal(), object3.getLocalHome(), object3.getEjbRefType(), object3.getEjbLink(), true);
                }
                if (beanInfo instanceof EntityBeanInfo && (object2 = (object3 = (EntityBeanInfo)beanInfo).getCacheName()) != null) {
                    moduleValidationInfo.addAppScopedCacheReference(beanInfo.getEJBName(), (String)object2);
                }
                object3 = beanInfo.getAllWlResourceReferences().iterator();
                while (object3.hasNext()) {
                    object2 = (ResourceDescriptionBean)object3.next();
                    if (object2.getResourceLink() == null) continue;
                    object = null;
                    for (Object object5 : beanInfo.getAllResourceReferences()) {
                        if (!object5.getResRefName().equals(object2.getResRefName())) continue;
                        object = object5.getResType();
                        break;
                    }
                    if (object != null && object.startsWith(JMS_RES_TYPE_ID)) {
                        moduleValidationInfo.addJMSLinkRefs(beanInfo.getEJBName(), "EJB", object2.getResRefName(), object2.getResourceLink(), (String)object, false);
                    }
                    if (object == null || !object.startsWith(JDBC_RES_TYPE_ID)) continue;
                    moduleValidationInfo.addJDBCLinkRefs(beanInfo.getEJBName(), "EJB", object2.getResRefName(), object2.getResourceLink(), (String)object, false);
                }
                object2 = beanInfo.getAllWlResourceEnvReferences().iterator();
                while (object2.hasNext()) {
                    Object object5;
                    object = (ResourceEnvDescriptionBean)object2.next();
                    if (object.getResourceLink() == null) continue;
                    Object object6 = null;
                    object5 = beanInfo.getAllResourceEnvReferences().iterator();
                    while (object5.hasNext()) {
                        ResourceEnvRefBean resourceEnvRefBean = (ResourceEnvRefBean)object5.next();
                        if (!resourceEnvRefBean.getResourceEnvRefName().equals(object.getResourceEnvRefName())) continue;
                        object6 = resourceEnvRefBean.getResourceEnvRefType();
                        break;
                    }
                    if (object6 != null && ((String)object6).startsWith(JMS_RES_TYPE_ID)) {
                        moduleValidationInfo.addJMSLinkRefs(beanInfo.getEJBName(), "EJB", object.getResourceEnvRefName(), object.getResourceLink(), (String)object6, false);
                    }
                    if (object6 == null || !((String)object6).startsWith(JDBC_RES_TYPE_ID)) continue;
                    moduleValidationInfo.addJDBCLinkRefs(beanInfo.getEJBName(), "EJB", object.getResourceEnvRefName(), object.getResourceLink(), (String)object6, false);
                }
            }
        }
    }

    private static DeploymentInfo getStandAloneDeploymentInfo(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, EjbDescriptorBean ejbDescriptorBean) throws Exception {
        return new MBeanDeploymentInfoImpl(ejbDescriptorBean, genericClassLoader, "", "", virtualJarFile, null);
    }

    private static EjbDescriptorBean parseDescriptors(VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, GenericClassLoader genericClassLoader) throws ErrorCollectionException {
        EjbDescriptorBean ejbDescriptorBean = null;
        try {
            ejbDescriptorBean = EjbDescriptorFactory.createReadOnlyDescriptorFromJarFile(virtualJarFile, file, file2, deploymentPlanBean, null, string, genericClassLoader, null);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new ErrorCollectionException((Throwable)((Object)xMLProcessingException));
        }
        catch (XMLParsingException xMLParsingException) {
            throw new ErrorCollectionException((Throwable)((Object)xMLParsingException));
        }
        catch (IOException iOException) {
            throw new ErrorCollectionException((Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ErrorCollectionException((Throwable)xMLStreamException);
        }
        catch (Throwable throwable) {
            throw new ErrorCollectionException(throwable);
        }
        return ejbDescriptorBean;
    }

    @Override
    public void setCompilerFactory(ICompilerFactory iCompilerFactory) {
        this.compilerFactory = iCompilerFactory;
        this.ejb2rmi.setCompilerFactory(iCompilerFactory);
    }
}

