/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.utils.annotation.BeaSynthetic;
import weblogic.utils.collections.EnumerationIterator;
import weblogic.utils.reflect.MethodKey;
import weblogic.utils.reflect.MethodText;
import weblogic.utils.reflect.ReflectUtils;
import weblogic.wsee.deploy.DeployUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJBMethodsUtil {
    public static final short STANDARD_METHOD = 0;
    public static final short HOME_METHOD = 1;
    private static final Set<MethodKey> EO_METHS = EJBMethodsUtil.initWith(EJBObject.class);
    private static final Set<MethodKey> EH_METHS = EJBMethodsUtil.initWith(EJBHome.class);
    private static final Set<MethodKey> ELO_METHS = EJBMethodsUtil.initWith(EJBLocalObject.class);
    private static final Set<MethodKey> ELH_METHS = EJBMethodsUtil.initWith(EJBLocalHome.class);

    private static Set<MethodKey> initWith(Class<?> clazz) {
        Method[] methodArray = clazz.getMethods();
        HashSet<MethodKey> hashSet = new HashSet<MethodKey>(methodArray.length);
        for (int i = 0; i < methodArray.length; ++i) {
            hashSet.add(new MethodKey(methodArray[i]));
        }
        return hashSet;
    }

    private EJBMethodsUtil() {
    }

    public static Map<Method, String> getMethodSigs(Method[] methodArray) {
        return EJBMethodsUtil.methodSigsInternal(methodArray, false);
    }

    public static Map<Method, String> getHomeMethodSigs(Method[] methodArray) {
        return EJBMethodsUtil.methodSigsInternal(methodArray, true);
    }

    private static Map<Method, String> methodSigsInternal(Method[] methodArray, boolean bl) {
        if (methodArray == null) {
            return Collections.emptyMap();
        }
        HashMap<Method, String> hashMap = new HashMap<Method, String>(methodArray.length);
        MethodText methodText = new MethodText();
        for (Method method : methodArray) {
            methodText.setMethod(method);
            methodText.setOptions(128);
            if (bl) {
                hashMap.put(method, EJBMethodsUtil.homeClassMethodNameMapper(methodText.toString()));
                continue;
            }
            hashMap.put(method, methodText.toString());
        }
        return hashMap;
    }

    public static String homeClassMethodNameMapper(String string) {
        if (string.startsWith("create")) {
            return "ejbC" + string.substring(1);
        }
        if (string.startsWith("find")) {
            return "ejbF" + string.substring(1);
        }
        return "ejbHome" + string;
    }

    public static Method[] getRemoteMethods(Class<?> clazz, boolean bl) {
        final Set<MethodKey> set = EO_METHS;
        return EJBMethodsUtil.getMethodsInternal(clazz, new MethodFilter(){

            public boolean accept(Method method) {
                return !set.contains(new MethodKey(method));
            }
        }, bl);
    }

    public static Method[] getLocalMethods(Class<?> clazz, boolean bl) {
        final Set<MethodKey> set = ELO_METHS;
        return EJBMethodsUtil.getMethodsInternal(clazz, new MethodFilter(){

            public boolean accept(Method method) {
                return !set.contains(new MethodKey(method));
            }
        }, bl);
    }

    public static Method[] getMethods(Class<?> clazz, boolean bl) {
        return EJBMethodsUtil.getMethodsInternal(clazz, null, bl);
    }

    private static Method[] getMethodsInternal(Class<?> clazz, MethodFilter methodFilter, boolean bl) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        if (bl) {
            Enumeration enumeration = ReflectUtils.distinctInterfaceMethods(clazz);
            while (enumeration.hasMoreElements()) {
                Method method = (Method)enumeration.nextElement();
                if (BeaSynthetic.Helper.isBeaSyntheticMethod((Method)method) || methodFilter != null && !methodFilter.accept(method)) continue;
                arrayList.add(method);
            }
        } else {
            for (Method method : clazz.getMethods()) {
                if (BeaSynthetic.Helper.isBeaSyntheticMethod((Method)method) || methodFilter != null && !methodFilter.accept(method)) continue;
                arrayList.add(method);
            }
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public static Method[] getBeanHomeClassMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith("ejbHome") && !string.startsWith("ejbCreate") && !string.startsWith("ejbFind")) continue;
            arrayList.add(methodArray[i]);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public static Method[] getLocalCreateMethods(Class<?> clazz) {
        return EJBMethodsUtil.getMethodsInternal(clazz, ELH_METHS, "create");
    }

    public static Method[] getCreateMethods(Class<?> clazz) {
        return EJBMethodsUtil.getMethodsInternal(clazz, EH_METHS, "create");
    }

    public static Method[] getLocalFindMethods(Class<?> clazz) {
        return EJBMethodsUtil.getMethodsInternal(clazz, ELH_METHS, "find");
    }

    public static Method[] getFindMethods(Class<?> clazz) {
        return EJBMethodsUtil.getMethodsInternal(clazz, EH_METHS, "find");
    }

    private static Method[] getMethodsInternal(Class<?> clazz, Set<MethodKey> set, String string) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (set.contains(new MethodKey(method)) || !method.getName().startsWith(string)) continue;
            arrayList.add(method);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public static Method[] getWebserviceMethods(SessionBeanInfo sessionBeanInfo) {
        EnumerationIterator enumerationIterator;
        ArrayList<Method> arrayList;
        Class clazz = sessionBeanInfo.getServiceEndpointClass();
        if (sessionBeanInfo.isEJB30()) {
            arrayList = DeployUtil.getWebServiceMethods(sessionBeanInfo.getBeanClass(), clazz);
            enumerationIterator = arrayList.iterator();
        } else {
            arrayList = ReflectUtils.distinctInterfaceMethods((Class)clazz);
            enumerationIterator = new EnumerationIterator((Enumeration)((Object)arrayList));
        }
        arrayList = new ArrayList<Method>();
        while (enumerationIterator.hasNext()) {
            String string;
            Method method = (Method)enumerationIterator.next();
            if (Modifier.isVolatile(method.getModifiers()) || ELO_METHS.contains(new MethodKey(method)) || (string = method.getName()).equals("remove") || string.equals("create") || string.equals("getEJBHome") || string.equals("getPrimaryKey") || string.equals("getHandle") || string.equals("isIdentical")) continue;
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public static String methodDescriptorPrefix(short s) {
        switch (s) {
            case 1: {
                return "md_";
            }
        }
        return "md_eo_";
    }

    private static interface MethodFilter {
        public boolean accept(Method var1);
    }
}

