/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.ejb.EntityContext;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.EJBMethodsUtil;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.CMPInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.persistence.spi.CMPBeanDescriptor;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.PlatformConstants;
import weblogic.utils.annotation.BeaSynthetic;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;
import weblogic.utils.reflect.MethodText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EjbCodeGenerator
extends CodeGenerator {
    private static final String EJB_HOME = "ejbHome";
    private static final boolean DEBUG = false;
    private boolean keepgenerated = false;
    private Getopt2 opts = null;
    protected final List<Output> generatedOutputs = new LinkedList<Output>();
    protected Output currentOutput;
    protected Method[] beanHomeMethods;
    protected Method[] remoteMethods;
    protected Method[] createMethods;
    protected Method[] findMethods;
    protected Method[] homeMethods;
    protected Method[] localMethods;
    protected Method[] localCreateMethods;
    protected Method[] localFindMethods;
    protected Method[] localHomeMethods;
    protected Method method;
    protected MethodSignature methodSignature;
    private MethodText mt = new MethodText();
    protected EntityBeanInfo bi;
    protected NamingConvention nc;
    protected Class ejbClass;
    protected Class homeInterfaceClass;
    protected Class remoteInterfaceClass;
    protected Class localHomeInterfaceClass;
    protected Class localInterfaceClass;
    protected Class primaryKeyClass;
    protected boolean isContainerManagedBean;
    protected boolean isCompoundPK;
    protected boolean hasLocalClientView;
    protected boolean hasRemoteClientView;
    protected boolean hasDeclaredRemoteHome;
    protected boolean hasDeclaredLocalHome;
    protected short methodType = 0;
    private Set<Method> cmpGetterSetterMethods;

    public EjbCodeGenerator() {
    }

    public EjbCodeGenerator(Getopt2 getopt2) {
        super(getopt2);
        this.opts = getopt2;
        this.keepgenerated = getopt2.hasOption("keepgenerated");
    }

    protected Enumeration outputs(List list) throws Exception {
        this.generatedOutputs.clear();
        Vector vector = new Vector();
        BeanInfo beanInfo = (BeanInfo)list.get(0);
        NamingConvention namingConvention = new NamingConvention(beanInfo.getBeanClassName(), beanInfo.getEJBName());
        this.addOutputs(vector, beanInfo, namingConvention);
        return vector.elements();
    }

    protected final void interpretBeanInfo(BeanInfo beanInfo) throws EJBCException {
        EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
        this.setBooleans(entityBeanInfo);
        this.setClasses(entityBeanInfo);
        this.setBeanHomeMethods(entityBeanInfo);
        if (this.hasDeclaredRemoteHome) {
            this.remoteMethods = EJBMethodsUtil.getRemoteMethods(this.remoteInterfaceClass, true);
            this.createMethods = EJBMethodsUtil.getCreateMethods(this.homeInterfaceClass);
            this.findMethods = EJBMethodsUtil.getFindMethods(this.homeInterfaceClass);
            this.setHomeMethods(entityBeanInfo);
        }
        if (this.hasDeclaredLocalHome) {
            this.localMethods = EJBMethodsUtil.getLocalMethods(this.localInterfaceClass, true);
            this.localCreateMethods = EJBMethodsUtil.getLocalCreateMethods(this.localHomeInterfaceClass);
            this.localFindMethods = EJBMethodsUtil.getLocalFindMethods(this.localHomeInterfaceClass);
            this.setLocalHomeMethods(entityBeanInfo);
            if (!entityBeanInfo.getIsBeanManagedPersistence() && entityBeanInfo.getCMPInfo().uses20CMP()) {
                this.setCmpGettersAndSetters(entityBeanInfo, this.localInterfaceClass);
            }
        }
    }

    protected void prepare(CodeGenerator.Output output) throws EJBCException, ClassNotFoundException {
        this.currentOutput = (Output)output;
        this.generatedOutputs.add(this.currentOutput);
        if (this.currentOutput.getBeanInfo() == null) {
            this.nc = this.currentOutput.getNamingConvention();
            return;
        }
        if (this.bi == this.currentOutput.getBeanInfo()) {
            return;
        }
        this.bi = (EntityBeanInfo)this.currentOutput.getBeanInfo();
        this.nc = this.currentOutput.getNamingConvention();
        this.interpretBeanInfo(this.bi);
    }

    private void setBooleans(EntityBeanInfo entityBeanInfo) {
        this.hasRemoteClientView = false;
        this.hasLocalClientView = false;
        this.hasDeclaredRemoteHome = false;
        this.hasDeclaredLocalHome = false;
        CMPInfo cMPInfo = entityBeanInfo.getCMPInfo();
        this.isContainerManagedBean = cMPInfo != null;
        this.isCompoundPK = this.isContainerManagedBean && cMPInfo.getCMPrimaryKeyFieldName() == null;
        this.hasRemoteClientView = entityBeanInfo.hasRemoteClientView();
        this.hasLocalClientView = entityBeanInfo.hasLocalClientView();
        this.hasDeclaredRemoteHome = entityBeanInfo.hasDeclaredRemoteHome();
        this.hasDeclaredLocalHome = entityBeanInfo.hasDeclaredLocalHome();
    }

    private final void setClasses(EntityBeanInfo entityBeanInfo) throws EJBCException {
        this.ejbClass = entityBeanInfo.getBeanClass();
        if (this.hasLocalClientView) {
            this.localInterfaceClass = entityBeanInfo.getLocalInterfaceClass();
            this.localHomeInterfaceClass = entityBeanInfo.getLocalHomeInterfaceClass();
        }
        if (this.hasRemoteClientView) {
            this.remoteInterfaceClass = entityBeanInfo.getRemoteInterfaceClass();
            this.homeInterfaceClass = entityBeanInfo.getHomeInterfaceClass();
        }
        this.primaryKeyClass = entityBeanInfo.getPrimaryKeyClass();
        if (entityBeanInfo.isUnknownPrimaryKey() && !entityBeanInfo.getIsBeanManagedPersistence()) {
            CMPBeanDescriptor cMPBeanDescriptor = entityBeanInfo.getCMPInfo().getCMPBeanDescriptor(entityBeanInfo.getEJBName());
            this.primaryKeyClass = cMPBeanDescriptor.getPrimaryKeyClass();
        }
    }

    private void setCmpGettersAndSetters(EntityBeanInfo entityBeanInfo, Class clazz) {
        CMPInfo cMPInfo = entityBeanInfo.getCMPInfo();
        CMPBeanDescriptor cMPBeanDescriptor = (CMPBeanDescriptor)cMPInfo.getBeanMap().get(entityBeanInfo.getEJBName());
        Debug.assertion((cMPBeanDescriptor != null ? 1 : 0) != 0);
        this.cmpGetterSetterMethods = new HashSet<Method>();
        for (String string : entityBeanInfo.getCMPInfo().getAllContainerManagedFieldNames()) {
            Method method = cMPBeanDescriptor.getGetterMethod(clazz, string);
            Method method2 = cMPBeanDescriptor.getSetterMethod(clazz, string);
            if (method != null) {
                this.cmpGetterSetterMethods.add(method);
            }
            if (method2 == null) continue;
            this.cmpGetterSetterMethods.add(method2);
        }
    }

    private void setBeanHomeMethods(BeanInfo beanInfo) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = beanInfo.getBeanClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            if (!string.startsWith(EJB_HOME) || Modifier.isVolatile(method.getModifiers())) continue;
            arrayList.add(method);
        }
        this.beanHomeMethods = arrayList.size() > 0 ? arrayList.toArray(new Method[arrayList.size()]) : null;
    }

    private void setHomeMethods(BeanInfo beanInfo) {
        if (this.beanHomeMethods != null) {
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (int i = 0; i < this.beanHomeMethods.length; ++i) {
                Method method = this.beanHomeMethods[i];
                String string = method.getName();
                char c = string.charAt(EJB_HOME.length());
                String string2 = Character.toLowerCase(c) + string.substring(EJB_HOME.length() + 1);
                try {
                    Method method2 = this.homeInterfaceClass.getMethod(string2, method.getParameterTypes());
                    arrayList.add(method2);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    MethodSignature methodSignature = new MethodSignature(method, beanInfo.getBeanClass());
                    Method[] methodArray = this.homeInterfaceClass.getMethods();
                    for (int j = 0; j < methodArray.length; ++j) {
                        MethodSignature methodSignature2 = new MethodSignature(methodArray[j], this.homeInterfaceClass);
                        if (!MethodSignature.equalsMethodsBySig(methodSignature, methodSignature2)) continue;
                        arrayList.add(methodArray[j]);
                    }
                }
            }
            this.homeMethods = arrayList.size() > 0 ? arrayList.toArray(new Method[arrayList.size()]) : null;
        } else {
            this.homeMethods = null;
        }
    }

    private void setLocalHomeMethods(BeanInfo beanInfo) {
        if (this.beanHomeMethods != null) {
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (int i = 0; i < this.beanHomeMethods.length; ++i) {
                Method method = this.beanHomeMethods[i];
                String string = method.getName();
                char c = string.charAt(EJB_HOME.length());
                String string2 = Character.toLowerCase(c) + string.substring(EJB_HOME.length() + 1);
                try {
                    Method method2 = this.localHomeInterfaceClass.getMethod(string2, method.getParameterTypes());
                    arrayList.add(method2);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    MethodSignature methodSignature = new MethodSignature(method, beanInfo.getBeanClass());
                    Method[] methodArray = this.localHomeInterfaceClass.getMethods();
                    for (int j = 0; j < methodArray.length; ++j) {
                        MethodSignature methodSignature2 = new MethodSignature(methodArray[j], this.localHomeInterfaceClass);
                        if (!MethodSignature.equalsMethodsBySig(methodSignature, methodSignature2)) continue;
                        arrayList.add(methodArray[j]);
                    }
                }
            }
            this.localHomeMethods = arrayList.size() > 0 ? arrayList.toArray(new Method[arrayList.size()]) : null;
        } else {
            this.localHomeMethods = null;
        }
    }

    protected abstract void addOutputs(Vector var1, BeanInfo var2, NamingConvention var3) throws EJBCException;

    public String ejb_callbacks() throws CodeGenerationException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.parse(this.getProductionRule("common_ejb_callbacks")));
        stringBuilder.append(this.parse(this.getProductionRule("entity_callbacks")));
        return stringBuilder.toString();
    }

    public String method_state() {
        String string = this.method.getName();
        if (string.startsWith("ejbCreate")) {
            return "STATE_EJB_CREATE";
        }
        if (string.startsWith("ejbPostCreate")) {
            return "STATE_EJB_POSTCREATE";
        }
        if (string.startsWith("ejbFind")) {
            return "STATE_EJBFIND";
        }
        if (string.startsWith(EJB_HOME)) {
            return "STATE_EJBHOME";
        }
        if (string.startsWith("ejbTimeout")) {
            return "STATE_EJBTIMEOUT";
        }
        return "STATE_BUSINESS_METHOD";
    }

    public String bean_postcreate_methods() throws CodeGenerationException {
        Method[] methodArray = this.ejbClass.getMethods();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith("ejbPostCreate")) continue;
            this.setMethod(methodArray[i], (short)0);
            stringBuilder.append(this.parse(this.getProductionRule("home_method")));
        }
        return stringBuilder.toString();
    }

    public String pre_home_invoke_method() {
        return "preEntityHomeInvoke";
    }

    public String post_home_invoke_method() {
        return "postEntityHomeInvoke(wrap, ee);";
    }

    public String bean_home_methods() throws CodeGenerationException {
        StringBuilder stringBuilder = new StringBuilder();
        Method[] methodArray = EJBMethodsUtil.getBeanHomeClassMethods(this.ejbClass);
        for (int i = 0; i < methodArray.length; ++i) {
            this.setMethod(methodArray[i], (short)0, this.ejbClass);
            stringBuilder.append(this.parse(this.getProductionRule("home_method")));
        }
        return stringBuilder.toString();
    }

    public String local_preInvoke() throws CodeGenerationException {
        return this.parse(this.getProductionRule("localPreInvoke"));
    }

    public String local_postInvokeTxRetry() throws CodeGenerationException {
        return this.parse(this.getProductionRule("localPostInvokeTxRetry"));
    }

    public String local_postInvokeCleanup() throws CodeGenerationException {
        return this.parse(this.getProductionRule("localPostInvokeCleanup"));
    }

    public String beanmethod_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod(this.method.getName(), this.method.getParameterTypes());
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)(this.method + " method" + " missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
        }
    }

    public String setentitycontext_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("setEntityContext", EntityContext.class);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!this.bi.isEJB30()) {
                throw new AssertionError((Object)("setEntityContext(EntityContext) method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
            }
            return "";
        }
    }

    public String unsetentitycontext_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("unsetEntityContext", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!this.bi.isEJB30()) {
                throw new AssertionError((Object)("unsetEntityContext() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
            }
            return "";
        }
    }

    public String ejbload_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("ejbLoad", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!this.bi.isEJB30()) {
                throw new AssertionError((Object)("ejbLoad() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
            }
            return "";
        }
    }

    public String ejbstore_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("ejbStore", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!this.bi.isEJB30()) {
                throw new AssertionError((Object)("ejbStore() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
            }
            return "";
        }
    }

    public String activate_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("ejbActivate", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!this.bi.isEJB30()) {
                throw new AssertionError((Object)("ejbActivate() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
            }
            return "";
        }
    }

    public String passivate_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("ejbPassivate", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!this.bi.isEJB30()) {
                throw new AssertionError((Object)("ejbPassivate() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
            }
            return "";
        }
    }

    public String remove_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("ejbRemove", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!this.bi.isEJB30()) {
                throw new AssertionError((Object)("ejbRemove() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
            }
            return "";
        }
    }

    public String afterbegin_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("afterBegin", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("afterBegin() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
        }
    }

    public String beforecompletion_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("beforeCompletion", null);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("beforeCompletion() method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
        }
    }

    public String aftercompletion_throws_clause() {
        try {
            Method method = this.ejbClass.getMethod("afterCompletion", Boolean.TYPE);
            return this.method_throws_clause(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("afterCompletion(boolean) method missing in bean class: " + this.ejbClass.getName() + " exception: " + noSuchMethodException));
        }
    }

    public String method_throws_clause(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        if (classArray == null || classArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("throws ");
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.arg_type(classArray[i]));
        }
        return stringBuilder.toString();
    }

    public String create_methods() throws CodeGenerationException {
        if (this.createMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.createMethods.length; ++i) {
            this.setMethod(this.createMethods[i], (short)1);
            stringBuilder.append(this.parse(this.getProductionRule("create_method_en")));
        }
        return stringBuilder.toString();
    }

    public String local_create_methods() throws CodeGenerationException {
        if (this.localCreateMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.localCreateMethods.length; ++i) {
            this.setMethod(this.localCreateMethods[i], (short)1, this.localHomeInterfaceClass);
            stringBuilder.append(this.parse(this.getProductionRule("create_method_en")));
        }
        return stringBuilder.toString();
    }

    public String optional_finder_type() throws CodeGenerationException {
        if (this.method.getName().equals("findByPrimaryKey")) {
            return "";
        }
        if (this.method.getReturnType().equals(this.remoteInterfaceClass)) {
            return ", weblogic.ejb.container.internal.EntityEJBHome.SCALAR_FINDER";
        }
        if (this.method.getReturnType().equals(this.localInterfaceClass)) {
            return ", weblogic.ejb.container.internal.EntityEJBHome.SCALAR_FINDER";
        }
        if (this.method.getReturnType().equals(Collection.class)) {
            return ", weblogic.ejb.container.internal.EntityEJBHome.COLL_FINDER";
        }
        if (this.method.getReturnType().equals(Enumeration.class)) {
            return ", weblogic.ejb.container.internal.EntityEJBHome.ENUM_FINDER";
        }
        throw new AssertionError((Object)("Unrecognized finder, return type is :" + this.method.getReturnType()));
    }

    public String finder_name() throws CodeGenerationException {
        if (this.method.getName().equals("findByPrimaryKey")) {
            return "findByPrimaryKey";
        }
        if (this.method.getReturnType().equals(this.remoteInterfaceClass)) {
            return "finder";
        }
        if (this.method.getReturnType().equals(this.localInterfaceClass)) {
            return "finder";
        }
        if (this.method.getReturnType().equals(Collection.class)) {
            return "finder";
        }
        if (this.method.getReturnType().equals(Enumeration.class)) {
            return "finder";
        }
        throw new AssertionError((Object)("Unrecognized finder, return type is :" + this.method.getReturnType()));
    }

    public String finder_parameters() throws CodeGenerationException {
        if (this.method.getName().equals("findByPrimaryKey")) {
            return this.wrapped_method_parameters_without_types();
        }
        return this.method_parameters_in_array();
    }

    public String find_methods() throws CodeGenerationException {
        if (this.findMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.findMethods.length; ++i) {
            Method method = this.findMethods[i];
            this.setMethod(method, (short)1);
            stringBuilder.append(this.parse(this.getProductionRule("finder")));
        }
        return stringBuilder.toString();
    }

    public String local_find_methods() throws CodeGenerationException {
        if (this.localFindMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.localFindMethods.length; ++i) {
            Method method = this.localFindMethods[i];
            this.setMethod(method, (short)1, this.localHomeInterfaceClass);
            stringBuilder.append(this.parse(this.getProductionRule("finder")));
        }
        return stringBuilder.toString();
    }

    public String home_methods() throws CodeGenerationException {
        if (this.homeMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.homeMethods.length; ++i) {
            Method method = this.homeMethods[i];
            this.setMethod(method, (short)1);
            MethodSignature methodSignature = new MethodSignature(method);
            methodSignature.setModifiers(1);
            stringBuilder.append(methodSignature + "{" + EOL);
            stringBuilder.append(this.parse(this.getProductionRule("home_method_body")));
            stringBuilder.append(EOL + "}" + EOL);
        }
        return stringBuilder.toString();
    }

    public String local_home_methods() throws CodeGenerationException {
        if (this.localHomeMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.localHomeMethods.length; ++i) {
            Method method = this.localHomeMethods[i];
            this.setMethod(method, (short)1);
            MethodSignature methodSignature = new MethodSignature(method);
            methodSignature.setModifiers(1);
            stringBuilder.append(methodSignature + "{" + EOL);
            stringBuilder.append(this.parse(this.getProductionRule("home_method_body")));
            stringBuilder.append(EOL + "}" + EOL);
        }
        return stringBuilder.toString();
    }

    public String declare_result() {
        Class<?> clazz = this.method.getReturnType();
        if (clazz.getName().equals("void")) {
            return "// No return value";
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        String string = this.methodSignature.getReturnTypeName();
        Class<?> clazz2 = ClassUtils.getPrimitiveClass(string);
        if (clazz2 == null && string != null) {
            try {
                clazz2 = Class.forName(string, false, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz2 != null) {
            stringBuilder.append(this.return_type(clazz2) + " result = ");
            if (clazz2.isPrimitive()) {
                if (clazz2.getName().equals("boolean")) {
                    stringBuilder.append("false;");
                } else {
                    stringBuilder.append("0;");
                }
            } else {
                stringBuilder.append("null;");
            }
        } else {
            stringBuilder.append(string + " result = null;");
        }
        return stringBuilder.toString();
    }

    public String ejb_class_name() {
        return this.ejbClass.getName();
    }

    public String enum_exceptions() {
        StringBuilder stringBuilder = new StringBuilder(80);
        Set<Class<?>> set = this.bi.getDeploymentInfo().getUncheckedAppExceptionClasses();
        for (Class<?> classArray2 : set) {
            stringBuilder.append("else if (e instanceof " + this.arg_type(classArray2) + ") {" + EOL);
            stringBuilder.append("   throw (" + this.arg_type(classArray2) + ") e;" + EOL + "}");
        }
        Class<?>[] classArray = this.method.getExceptionTypes();
        if (classArray.length == 0) {
            return stringBuilder.toString();
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (RemoteException.class.isAssignableFrom(clazz) || set.contains(clazz)) continue;
            stringBuilder.append("else if (e instanceof " + this.arg_type(clazz) + ") {" + EOL);
            stringBuilder.append("   throw (" + this.arg_type(clazz) + ") e;" + EOL + "}");
        }
        return stringBuilder.toString();
    }

    public String enum_exceptions_home_method() {
        Class<?>[] classArray = this.method.getExceptionTypes();
        if (classArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(80);
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            Class<RemoteException> clazz = classArray[i];
            if (clazz.isAssignableFrom(RemoteException.class)) continue;
            if (bl) {
                stringBuilder.append("else ");
            }
            stringBuilder.append("if (ee instanceof " + this.arg_type(clazz) + ") {" + EOL);
            stringBuilder.append("   throw (" + this.arg_type(clazz) + ") ee;" + EOL + "}");
            bl = true;
        }
        return stringBuilder.toString();
    }

    public String entity() {
        return "true";
    }

    public String extends_type() {
        return "weblogic.ejb.container.internal.EntityEJBObject_Activatable";
    }

    public String extends_local_type() {
        return "weblogic.ejb.container.internal.EntityEJBLocalObject";
    }

    public String find_method_throws_clause() {
        return this.exceptions(this.method);
    }

    public String home_class_name() {
        return this.nc.getHomeClassName();
    }

    public String home_interface_name() {
        return this.convertToLegalInnerClassName(this.homeInterfaceClass);
    }

    public String local_home_interface_name() {
        return this.convertToLegalInnerClassName(this.localHomeInterfaceClass);
    }

    public String create_method_name() {
        return "ejbC" + this.method.getName().substring(1);
    }

    public String postCreate_method_name() {
        return this.postCreate_method_name(this.method);
    }

    public String postCreate_method_name(Method method) {
        String string = method.getName();
        return "ejbPostC" + string.substring(1, string.length());
    }

    public String ejbCreate_method_name(Method method) {
        String string = method.getName();
        return "ejbC" + string.substring(1, string.length());
    }

    public String method_return() {
        return this.arg_type(this.method.getReturnType());
    }

    public String capitalized_method_name() {
        String string = this.method.getName();
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public String method_name() {
        return this.method.getName();
    }

    public String method_parameters_in_array() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new Object [] { ");
        stringBuilder.append(this.wrapped_method_parameters_without_types());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String method_parameters() {
        this.mt.setOptions(513);
        return this.mt.toString();
    }

    private String classToStringForm(Class clazz) {
        if (clazz.isArray()) {
            String string = this.classToStringForm(clazz.getComponentType());
            return string + "[]";
        }
        return this.arg_type(clazz);
    }

    public String method_types_as_array() {
        Debug.assertion((this.method != null ? 1 : 0) != 0);
        Class<?>[] classArray = this.method.getParameterTypes();
        if (classArray == null || classArray.length == 0) {
            return "new Class [] {}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new Class [] {");
        for (int i = 0; i < classArray.length; ++i) {
            String string = this.classToStringForm(classArray[i]) + ".class";
            if (i == 0) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(", " + string);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String method_parameters_without_types() {
        this.mt.setOptions(1);
        return this.mt.toString();
    }

    public String wrapped_method_parameters_without_types() {
        this.mt.setOptions(1024);
        return this.mt.toString();
    }

    public String method_sig() {
        this.mt.setOptions(128);
        String string = this.mt.toString();
        if (this.methodType == 1) {
            string = EJBMethodsUtil.homeClassMethodNameMapper(string);
        }
        return string;
    }

    public String method_signature_no_throws() {
        this.methodSignature.setAbstract(false);
        this.methodSignature.setPrintThrowsClause(false);
        return this.methodSignature.toString();
    }

    public String method_signature() {
        this.methodSignature.setAbstract(false);
        return this.methodSignature.toString();
    }

    public String method_signature_throws_remote_exception() {
        this.methodSignature.setAbstract(false);
        Class[] classArray = this.methodSignature.getExceptionTypes();
        Class[] classArray2 = new Class[classArray.length + 1];
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            classArray2[i] = classArray[i];
            if (!classArray[i].equals(RemoteException.class)) continue;
            bl = true;
        }
        if (bl) {
            this.methodSignature.setExceptionTypes(classArray);
        } else {
            classArray2[classArray.length] = RemoteException.class;
            this.methodSignature.setExceptionTypes(classArray2);
        }
        return this.methodSignature.toString();
    }

    public String ctor_throws_clause() {
        Constructor<?>[] constructorArray = this.ejbClass.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray != null && classArray.length != 0) continue;
            return this.exceptions(constructorArray[i].getExceptionTypes());
        }
        throw new AssertionError((Object)("Bean class: " + this.ejbClass + " did not have a no-arg constructor.  The EJB Compliance " + "Checker should have caught this."));
    }

    public String method_throws_clause() {
        return this.exceptions(this.method);
    }

    public String pk_class() {
        return this.primaryKeyClass.getName();
    }

    public String declare_static_eo_method_descriptors() throws CodeGenerationException {
        return this.declare_method_descriptors(this.remoteMethods, (short)0, true);
    }

    public String declare_static_elo_method_descriptors() throws CodeGenerationException {
        return this.declare_method_descriptors(this.localMethods, (short)0, true);
    }

    public String declare_create_method_descriptors() throws CodeGenerationException {
        return this.declare_method_descriptors(this.createMethods, (short)1);
    }

    public String declare_local_create_method_descriptors() throws CodeGenerationException {
        return this.declare_method_descriptors(this.localCreateMethods, (short)1);
    }

    public String declare_find_method_descriptors() throws CodeGenerationException {
        return this.declare_method_descriptors(this.findMethods, (short)1);
    }

    public String declare_local_find_method_descriptors() throws CodeGenerationException {
        return this.declare_method_descriptors(this.localFindMethods, (short)1);
    }

    private String declare_method_descriptors(Method[] methodArray, short s) {
        return this.declare_method_descriptors(methodArray, s, false);
    }

    private String declare_method_descriptors(Method[] methodArray, short s, boolean bl) {
        if (methodArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < methodArray.length; ++i) {
            this.setMethod(methodArray[i], s);
            this.declare_method_descriptor(bl, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String declare_create_methods() throws CodeGenerationException {
        if (this.createMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.createMethods.length; ++i) {
            Method method = this.createMethods[i];
            this.setMethod(method, (short)1);
            stringBuilder.append(this.parse(this.getProductionRule("declare_create_method")));
            stringBuilder.append(this.parse(this.getProductionRule("declare_postCreate_method")));
        }
        return stringBuilder.toString();
    }

    public String declare_local_create_methods() throws CodeGenerationException {
        if (this.localCreateMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.localCreateMethods.length; ++i) {
            Method method = this.localCreateMethods[i];
            this.setMethod(method, (short)1, this.localHomeInterfaceClass);
            stringBuilder.append(this.parse(this.getProductionRule("declare_create_method")));
            stringBuilder.append(this.parse(this.getProductionRule("declare_postCreate_method")));
        }
        return stringBuilder.toString();
    }

    public String declare_home_method_descriptors() throws CodeGenerationException {
        if (this.homeMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.homeMethods.length; ++i) {
            Method method = this.homeMethods[i];
            this.setMethod(method, (short)1);
            stringBuilder.append(this.parse(this.getProductionRule("declare_home_method_descriptor")));
        }
        return stringBuilder.toString();
    }

    public String declare_local_home_method_descriptors() throws CodeGenerationException {
        if (this.localHomeMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.localHomeMethods.length; ++i) {
            Method method = this.localHomeMethods[i];
            this.setMethod(method, (short)1);
            stringBuilder.append(this.parse(this.getProductionRule("declare_home_method_descriptor")));
        }
        return stringBuilder.toString();
    }

    private void declare_method_descriptor(boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append(" public");
        if (bl) {
            stringBuilder.append(" static");
        }
        stringBuilder.append(" weblogic.ejb.container.internal.MethodDescriptor ");
        stringBuilder.append(EJBMethodsUtil.methodDescriptorPrefix(this.methodType));
        stringBuilder.append(this.method_sig());
        stringBuilder.append(";" + PlatformConstants.EOL);
    }

    public String initialize_create_methods() throws CodeGenerationException {
        if (this.createMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.createMethods.length; ++i) {
            this.setMethod(this.createMethods[i], (short)1);
            stringBuilder.append(this.parse(this.getProductionRule("initialize_create_method")) + EOL);
            stringBuilder.append(this.parse(this.getProductionRule("initialize_postCreate_method")) + EOL);
        }
        return stringBuilder.toString();
    }

    public String initialize_local_create_methods() throws CodeGenerationException {
        if (this.localCreateMethods == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.localCreateMethods.length; ++i) {
            this.setMethod(this.localCreateMethods[i], (short)1, this.localHomeInterfaceClass);
            stringBuilder.append(this.parse(this.getProductionRule("initialize_create_method")) + EOL);
            stringBuilder.append(this.parse(this.getProductionRule("initialize_postCreate_method")) + EOL);
        }
        return stringBuilder.toString();
    }

    public String perhaps_initialize_create_methods() throws CodeGenerationException {
        return this.parse(this.getProductionRule("static_block_to_init_create_methods"));
    }

    public String perhaps_initialize_local_create_methods() throws CodeGenerationException {
        return this.parse(this.getProductionRule("static_block_to_init_create_methods"));
    }

    private List<Method> getAllMethods(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>(Arrays.asList(methodArray));
        Iterator iterator = arrayList.iterator();
        ArrayList<Method> arrayList2 = new ArrayList<Method>();
        ArrayList<Method> arrayList3 = new ArrayList<Method>();
        block2: while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!Modifier.isVolatile(method.getModifiers()) || !method.toGenericString().equals(method.toString())) continue;
            Class clazz2 = clazz.getSuperclass();
            while (!clazz2.equals(Object.class)) {
                if (!Modifier.isPublic(clazz2.getModifiers())) {
                    try {
                        Method method2 = clazz2.getMethod(method.getName(), method.getParameterTypes());
                        if (!Modifier.isVolatile(method2.getModifiers())) {
                            arrayList2.add(method);
                            arrayList3.add(method2);
                            continue block2;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
        arrayList.removeAll(arrayList2);
        arrayList3.addAll(arrayList);
        return arrayList3;
    }

    public String declare_bean_interface_methods() throws CodeGenerationException {
        StringBuilder stringBuilder = new StringBuilder(200);
        Class clazz = this.bi.getBeanClass();
        List<Method> list = this.getAllMethods(this.bi.getBeanClass());
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method object2 : list) {
            if (object2.isBridge()) continue;
            arrayList.add(object2);
        }
        Comparator<Method> comparator = new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                if (method.getName().equals(method2.getName())) {
                    Class<?>[] classArray;
                    Class<?>[] classArray2 = method.getParameterTypes();
                    if (classArray2.length == (classArray = method2.getParameterTypes()).length) {
                        Class<?> clazz;
                        Class<?> clazz2;
                        for (int i = 0; i < classArray2.length; ++i) {
                            if (classArray2[i] == classArray[i]) continue;
                            return classArray2[i].getName().compareTo(classArray[i].getName());
                        }
                        if ((method.isBridge() || method2.isBridge()) && !(clazz2 = method.getReturnType()).equals(clazz = method2.getReturnType())) {
                            return clazz2.getName().compareTo(clazz.getName());
                        }
                        return 0;
                    }
                    if (classArray2.length < classArray.length) {
                        return -1;
                    }
                    return 1;
                }
                return method.getName().compareTo(method2.getName());
            }
        };
        TreeSet<Method> treeSet = new TreeSet<Method>(comparator);
        treeSet.addAll(arrayList);
        for (Method method : treeSet) {
            int n;
            if (method.isSynthetic() || BeaSynthetic.Helper.isBeaSyntheticMethod((Method)method) || method.getDeclaringClass() == Object.class || Modifier.isStatic(n = method.getModifiers()) || Modifier.isVolatile(n)) continue;
            this.appendInterfaceMethodDeclaration(stringBuilder, method, clazz);
        }
        return stringBuilder.toString();
    }

    public String extendsCMPBean() {
        if (this.isContainerManagedBean) {
            return ", weblogic.ejb.container.persistence.spi.CMPBean";
        }
        return "";
    }

    private void appendInterfaceMethodDeclaration(StringBuilder stringBuilder, Method method, Class clazz) {
        MethodSignature methodSignature = null;
        methodSignature = !method.toGenericString().equals(method.toString()) ? new MethodSignature(method, clazz) : new MethodSignature(method);
        methodSignature.setFinal(false);
        methodSignature.setNative(false);
        stringBuilder.append(methodSignature + ";" + EOL);
    }

    public String remote_interface_methods() throws CodeGenerationException {
        return this.remote_interface_methods(this.remoteMethods, this.remoteInterfaceClass);
    }

    public String remote_interface_methods(Method[] methodArray, Class clazz) throws CodeGenerationException {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < methodArray.length; ++i) {
            this.setMethod(methodArray[i], (short)0, clazz);
            stringBuilder.append(this.parse(this.getProductionRule("remote_interface_method")));
        }
        return stringBuilder.toString();
    }

    public String local_interface_methods() throws CodeGenerationException {
        return this.local_interface_methods(this.localMethods);
    }

    private String local_interface_methods(Method[] methodArray) throws CodeGenerationException {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < methodArray.length; ++i) {
            this.setMethod(methodArray[i], (short)0, this.localInterfaceClass);
            stringBuilder.append(this.parse(this.getProductionRule("local_interface_method")));
        }
        return stringBuilder.toString();
    }

    protected String javaClassCommonMethodPrefix() {
        return "";
    }

    public String remote_interface_name() {
        return this.convertToLegalInnerClassName(this.remoteInterfaceClass);
    }

    public String local_interface_name() {
        return this.convertToLegalInnerClassName(this.localInterfaceClass);
    }

    public String result() {
        if (this.method.getReturnType().getName().equals("void")) {
            return "";
        }
        return "result = ";
    }

    public String return_result() {
        if (this.method.getReturnType().getName().equals("void")) {
            return "// No return result";
        }
        return "return result;";
    }

    public String perhaps_return() {
        if (this.method.getReturnType().getName().equals("void")) {
            return "";
        }
        return "return ";
    }

    public String declareBeanStateVar() {
        if (this.bi.isReadOnly() || this.bi.isOptimistic() && this.bi.getCacheBetweenTransactions()) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("  private weblogic.utils.concurrent.atomic.AtomicLong __WL_lastLoadTime = weblogic.utils.concurrent.atomic.AtomicFactory.createAtomicLong();");
            stringBuilder.append(EOL);
            stringBuilder.append("  public static int __WL_readTimeoutMS = 0;");
            stringBuilder.append(EOL);
            return stringBuilder.toString();
        }
        if (this.bi.getCacheBetweenTransactions()) {
            return "  private boolean __WL_beanStateValid = true;" + EOL;
        }
        return "";
    }

    public String perhapsSetLastLoadTime() {
        if (this.bi.isReadOnly() || this.bi.isOptimistic() && this.bi.getCacheBetweenTransactions()) {
            return "__WL_setLastLoadTime(System.currentTimeMillis());" + EOL;
        }
        return "";
    }

    public String perhapsSetLastLoadTimeMethodBody() throws CodeGenerationException {
        if (this.bi.isReadOnly() || this.bi.isOptimistic() && this.bi.getCacheBetweenTransactions()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" __WL_lastLoadTime.set(time);");
            stringBuilder.append(EOL);
            return stringBuilder.toString();
        }
        return "";
    }

    public String perhapsGetLastLoadTimeMethodBody() {
        if (this.bi.isReadOnly() || this.bi.isOptimistic() && this.bi.getCacheBetweenTransactions()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" return __WL_lastLoadTime.get();");
            stringBuilder.append(EOL);
            return stringBuilder.toString();
        }
        return "return 0;" + EOL;
    }

    public String perhapsDeclareBeanStateValidAccessors() throws CodeGenerationException {
        return this.parse(this.getProductionRule("bean_state_valid_accessors"));
    }

    public String setBeanStateValidMethodBody() {
        if (this.bi.isReadOnly() || this.bi.isOptimistic() && this.bi.getCacheBetweenTransactions()) {
            return "    if(!valid) __WL_setLastLoadTime(0);" + EOL;
        }
        if (this.bi.getCacheBetweenTransactions()) {
            return "    __WL_beanStateValid = valid;" + EOL;
        }
        return "";
    }

    public String isBeanStateValidMethodBody() throws CodeGenerationException {
        if (this.bi.isReadOnly() || this.bi.isOptimistic() && this.bi.getCacheBetweenTransactions()) {
            return this.parse(this.getProductionRule("bean_state_timeout_check"));
        }
        if (this.bi.getCacheBetweenTransactions()) {
            return "    return __WL_beanStateValid;" + EOL;
        }
        return "    return true;" + EOL;
    }

    public String simple_bean_class_name() {
        return this.nc.getSimpleBeanClassName();
    }

    public String simple_beanimpl_interface_name() {
        return this.nc.getSimpleGeneratedBeanInterfaceName();
    }

    public String simple_beanimpl_class_name() {
        return this.nc.getSimpleGeneratedBeanClassName();
    }

    public String simple_eoimpl_class_name() {
        return this.nc.getSimpleEJBObjectClassName();
    }

    public String simple_eloimpl_class_name() {
        return this.nc.getSimpleEJBLocalObjectClassName();
    }

    public String simple_home_class_name() {
        return this.nc.getSimpleHomeClassName();
    }

    public String simple_local_home_class_name() {
        return this.nc.getSimpleLocalHomeClassName();
    }

    public String home_superclass_name() {
        return "weblogic.ejb.container.internal.EntityEJBHome";
    }

    public String wlBeanInterface_name() {
        return "weblogic.ejb.container.interfaces.WLEntityBean";
    }

    public String invalidation_interface_name() {
        switch (this.bi.getConcurrencyStrategy()) {
            case 5: 
            case 6: {
                return ", weblogic.ejb.CachingHome";
            }
        }
        return "";
    }

    public String local_invalidation_interface_name() {
        switch (this.bi.getConcurrencyStrategy()) {
            case 5: 
            case 6: {
                return ", weblogic.ejb.CachingLocalHome";
            }
        }
        return "";
    }

    public String dynamic_query_interface_name() {
        if (this.is20CMP()) {
            return ", weblogic.ejb.QueryHome";
        }
        return "";
    }

    public String dynamic_query_local_interface_name() {
        if (this.is20CMP()) {
            return ", weblogic.ejb.QueryLocalHome";
        }
        return "";
    }

    private boolean is20CMP() {
        return this.isContainerManagedBean && this.bi.getCMPInfo().uses20CMP();
    }

    public String local_home_superclass_name() {
        return "weblogic.ejb.container.internal.EntityEJBLocalHome";
    }

    public String packageStatement() {
        String string = this.currentOutput.getPackage();
        return string == null || string.equals("") ? "" : "package " + string + ";";
    }

    public String checkExistsOnMethod() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.bi.getIsBeanManagedPersistence()) {
            String string = this.bi.getPersistenceUseIdentifier();
            String string2 = this.bi.getPersistenceUseVersion();
            if (string.equals("WebLogic_CMP_RDBMS") && string2.equals("6.0")) {
                stringBuilder.append("((weblogic.ejb.container.persistence.spi.CMPBean) __bean).__WL_checkExistsOnMethod();" + EOL);
            }
        }
        return stringBuilder.toString();
    }

    public String writeObject() throws CodeGenerationException {
        return this.parse(this.getProductionRule("write_object_code"));
    }

    public String readObject() throws CodeGenerationException {
        return this.parse(this.getProductionRule("read_object_code"));
    }

    public String wl_entitybean_fields() throws CodeGenerationException {
        return this.parse(this.getProductionRule("wl_entitybean_fields_code"));
    }

    public String wl_entitybean_methods() throws CodeGenerationException {
        return this.parse(this.getProductionRule("wl_entitybean_methods_code"));
    }

    public String return_type(Class clazz) {
        String string = null;
        string = clazz.isPrimitive() ? this.arg_type(clazz) : (clazz.isArray() && this.is_primitive_array(clazz) ? this.array_as_primitive_type(clazz) : (clazz.isArray() ? this.array_as_type(clazz) : this.arg_type(clazz)));
        return string;
    }

    public String arg_as_primitive_type(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (clazz.equals(Character.TYPE)) {
            return "char";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "byte";
        }
        if (clazz.equals(Short.TYPE)) {
            return "short";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "int";
        }
        if (clazz.equals(Long.TYPE)) {
            return "long";
        }
        if (clazz.equals(Float.TYPE)) {
            return "float";
        }
        if (clazz.equals(Double.TYPE)) {
            return "double";
        }
        throw new AssertionError((Object)"Primitive type not found");
    }

    public String array_as_type(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        StringBuilder stringBuilder = new StringBuilder(this.arg_type(clazz));
        for (int i = 0; i < n; ++i) {
            stringBuilder = stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    public String arg_type(Class clazz) {
        return ClassUtils.getCanonicalName(clazz);
    }

    public String array_as_primitive_type(Class clazz) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        int n = clazz.getName().length() - 1;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuilder = stringBuilder.append("[]");
            }
        }
        if (clazz.getName().endsWith("[Z")) {
            return "boolean" + stringBuilder;
        }
        if (clazz.getName().endsWith("[C")) {
            return "char" + stringBuilder;
        }
        if (clazz.getName().endsWith("[B")) {
            return "byte" + stringBuilder;
        }
        if (clazz.getName().endsWith("[S")) {
            return "short" + stringBuilder;
        }
        if (clazz.getName().endsWith("[I")) {
            return "int" + stringBuilder;
        }
        if (clazz.getName().endsWith("[J")) {
            return "long" + stringBuilder;
        }
        if (clazz.getName().endsWith("[F")) {
            return "float" + stringBuilder;
        }
        if (clazz.getName().endsWith("[D")) {
            return "double" + stringBuilder;
        }
        throw new AssertionError((Object)"Primitive type not found");
    }

    public void setMethod(Method method, short s) {
        this.setMethod(method, s, null, null);
    }

    public void setMethod(Method method, short s, Class clazz) {
        if (method.toGenericString().equals(method.toString())) {
            this.setMethod(method, s, null, null);
        } else {
            this.setMethod(method, s, null, clazz);
        }
    }

    public void setMethod(Method method, short s, String[] stringArray) {
        this.setMethod(method, s, stringArray, null);
    }

    public void setMethod(Method method, short s, String[] stringArray, Class clazz) {
        this.method = method;
        this.mt.setMethod(this.method);
        this.methodSignature = new MethodSignature(method, clazz);
        if (stringArray != null) {
            this.methodSignature.setParameterNames(stringArray);
        }
        this.methodType = s;
    }

    public String perhapsLite() {
        if (this.cmpGetterSetterMethods != null && this.cmpGetterSetterMethods.contains(this.method)) {
            return "Lite";
        }
        return "";
    }

    public String push_bean() {
        return "weblogic.ejb.container.internal.AllowedMethodsHelper.pushBean(this);";
    }

    public String pop_bean() {
        return "weblogic.ejb.container.internal.AllowedMethodsHelper.popBean();";
    }

    protected void writeToFile(String string, File file) throws IOException {
        this.currentOutput.setAbsoluteFilePath(file.getAbsolutePath());
        this.currentOutput.setOutputContent(string);
        if (this.keepgenerated || !this.isJDTBased()) {
            super.writeToFile(string, file);
        }
    }

    protected PrintWriter makeOutputStream(File file) throws IOException {
        if (this.keepgenerated) {
            return this.makeIndentingOutputStream(file);
        }
        return super.makeOutputStream(file);
    }

    private static void p(String string) {
        System.out.println("*** <EjbCodeGenerator> " + string);
    }

    private String convertToLegalInnerClassName(Class clazz) {
        StringBuilder stringBuilder = new StringBuilder(clazz.getName());
        for (Class<?> clazz2 = clazz.getDeclaringClass(); clazz2 != null; clazz2 = clazz2.getDeclaringClass()) {
            stringBuilder.setCharAt(clazz2.getName().length(), '.');
        }
        return stringBuilder.toString();
    }

    public boolean isJDTBased() {
        if (this.opts == null) {
            return true;
        }
        String string = this.opts.getOption("compiler");
        return string == null || "jdt".equalsIgnoreCase(string);
    }

    public List<Output> getGeneratedOutputs() {
        return this.generatedOutputs;
    }

    public static class Output
    extends CodeGenerator.Output
    implements Cloneable {
        private BeanInfo bi;
        private NamingConvention namingConvention;
        private String outputContent;
        private String absoluteFilePath;

        public String getOutputContent() {
            return this.outputContent;
        }

        private void setOutputContent(String string) {
            this.outputContent = string;
        }

        public String getAbsoluteFilePath() {
            return this.absoluteFilePath;
        }

        private void setAbsoluteFilePath(String string) {
            this.absoluteFilePath = string;
        }

        public BeanInfo getBeanInfo() {
            return this.bi;
        }

        public void setBeanInfo(BeanInfo beanInfo) {
            this.bi = beanInfo;
        }

        public NamingConvention getNamingConvention() {
            return this.namingConvention;
        }

        public void setNamingConvention(NamingConvention namingConvention) {
            this.namingConvention = namingConvention;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)(cloneNotSupportedException + ""));
            }
        }
    }
}

