/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.dd.ClusteringDescriptor;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.IIOPSecurityDescriptor;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.rmi.rmic.RmicMethodDescriptor;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;
import weblogic.utils.annotation.BeaSynthetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RMICOptions {
    private static final DebugLogger debugLogger = EJBDebugService.compilationLogger;
    static final String INTEGRITY_OPT = "integrity";
    static final String CONFIDENTIALITY_OPT = "confidentiality";
    static final String CLIENTCERTAUTHENTICATION_OPT = "clientCertAuthentication";
    static final String CLIENTAUTHENTICATION_OPT = "clientAuthentication";
    static final String IDENTITYASSERTION_OPT = "identityAssertion";
    private final boolean noMangledNames = true;
    private final boolean noExit = true;
    private boolean clusterable = false;
    private boolean methodsAreIdempotent = false;
    private boolean propagateEnvironment = false;
    private String loadAlgorithm = null;
    private String callRouter = null;
    private String replicaHandler = null;
    private String outputDirectory = null;
    private String dgcPolicy = null;
    private String dispatchPolicy = null;
    private boolean stickToFirstServer = false;
    private boolean useServersideStubs = false;
    private String remoteRefClassName = null;
    private boolean activatable = false;
    private String integrity = null;
    private String confidentiality = null;
    private String clientCertAuthentication = null;
    private String clientAuthentication = null;
    private String identityAssertion = null;
    private BeanInfo bd;
    private ClusteringDescriptor cd;
    private Collection<RmicMethodDescriptor> rmicMethodDescriptors;

    RMICOptions(BeanInfo beanInfo) {
        Debug.assertion((boolean)(beanInfo instanceof ClientDrivenBeanInfo));
        this.bd = beanInfo;
        this.cd = ((ClientDrivenBeanInfo)beanInfo).getClusteringDescriptor();
    }

    private String homeLoadAlgorithm() {
        return RMICOptions.rmiLoadAlgorithmOption(this.cd.getHomeLoadAlgorithm());
    }

    private String homeCallRouter() {
        return this.cd.getHomeCallRouterClassName();
    }

    private boolean isStatefulSession() {
        if (this.bd instanceof SessionBeanInfo) {
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.bd;
            return sessionBeanInfo.isStateful();
        }
        return false;
    }

    private boolean isStateless() {
        if (this.bd instanceof SessionBeanInfo) {
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.bd;
            return !sessionBeanInfo.isStateful();
        }
        return false;
    }

    private boolean isEntityBean() {
        return this.bd instanceof EntityBeanInfo;
    }

    private String statelessBeanLoadAlgorithm() {
        return RMICOptions.rmiLoadAlgorithmOption(this.cd.getStatelessBeanLoadAlgorithm());
    }

    private String statelessBeanCallRouter() {
        return this.cd.getStatelessBeanCallRouterClassName();
    }

    private boolean homeIsClusterable() {
        return this.cd.getHomeIsClusterable();
    }

    private boolean isUseServersideStubs() {
        return this.cd.getUseServersideStubs();
    }

    private boolean isStatefulBeanClusterable() {
        if (this.isStatefulSession()) {
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.bd;
            return sessionBeanInfo.getReplicationType() != 1;
        }
        return false;
    }

    private boolean isStatelessBeanClusterable() {
        return this.isStateless() && this.cd.getStatelessBeanIsClusterable();
    }

    private boolean isEntityBeanClusterable() {
        return this.isEntityBean() && this.homeIsClusterable();
    }

    private boolean usesBeanManagedTx() {
        if (this.bd instanceof SessionBeanInfo) {
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.bd;
            return sessionBeanInfo.usesBeanManagedTx();
        }
        return false;
    }

    private static String rmiLoadAlgorithmOption(String string) {
        if ("roundrobin".equalsIgnoreCase(string)) {
            return "round-robin";
        }
        if ("weightbased".equalsIgnoreCase(string)) {
            return "weight-based";
        }
        if ("roundrobinaffinity".equalsIgnoreCase(string)) {
            return "round-robin-affinity";
        }
        if ("weightbasedaffinity".equalsIgnoreCase(string)) {
            return "weight-based-affinity";
        }
        if ("randomaffinity".equalsIgnoreCase(string)) {
            return "random-affinity";
        }
        return string;
    }

    void setIIOPSecurityOptions() {
        IIOPSecurityDescriptor iIOPSecurityDescriptor = this.bd.getIIOPSecurityDescriptor();
        this.integrity = iIOPSecurityDescriptor.getTransport_integrity();
        this.confidentiality = iIOPSecurityDescriptor.getTransport_confidentiality();
        this.clientCertAuthentication = iIOPSecurityDescriptor.getTransport_client_cert_authentication();
        this.clientAuthentication = iIOPSecurityDescriptor.getClient_authentication();
        this.identityAssertion = iIOPSecurityDescriptor.getIdentity_assertion();
    }

    private String getDispatchPolicy() {
        return this.bd.getDispatchPolicy();
    }

    private boolean getStickToFirstServer() {
        return this.bd.getStickToFirstServer();
    }

    private int getRemoteClientTimeout() {
        return this.bd.getRemoteClientTimeout();
    }

    void setHomeOptions() {
        Collection collection = ((ClientDrivenBeanInfo)this.bd).getAllHomeMethodInfos();
        if (this.homeIsClusterable()) {
            this.clusterable = true;
            this.loadAlgorithm = this.homeLoadAlgorithm();
            this.callRouter = this.homeCallRouter();
            boolean bl = this.propagateEnvironment = this.isStatelessBeanClusterable() || this.isStatefulBeanClusterable() || this.isEntityBeanClusterable();
            if (this.isStateless()) {
                this.methodsAreIdempotent = true;
            }
            this.buildRmicMethodDescriptors(collection, true);
        } else {
            this.buildRmicMethodDescriptors(collection, false);
        }
        this.dgcPolicy = "managed";
        this.dispatchPolicy = this.getDispatchPolicy();
        this.stickToFirstServer = this.getStickToFirstServer();
        if (this.isUseServersideStubs()) {
            this.useServersideStubs = true;
        }
    }

    void setEOOptions(Class<?> clazz) {
        ClientDrivenBeanInfo clientDrivenBeanInfo = (ClientDrivenBeanInfo)this.bd;
        ArrayList<MethodInfo> arrayList = new ArrayList<MethodInfo>();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (BeaSynthetic.Helper.isBeaSyntheticMethod((Method)methodArray[i])) continue;
            arrayList.add(clientDrivenBeanInfo.getRemoteMethodInfo(methodArray[i]));
        }
        if (this.isStateless()) {
            this.dgcPolicy = "managed";
        }
        if (this.isStatelessBeanClusterable()) {
            this.clusterable = true;
            this.loadAlgorithm = this.statelessBeanLoadAlgorithm();
            this.callRouter = this.statelessBeanCallRouter();
            this.propagateEnvironment = true;
            this.methodsAreIdempotent = false;
            this.buildRmicMethodDescriptors(arrayList, true);
        } else if (this.isEntityBeanClusterable()) {
            this.clusterable = true;
            this.propagateEnvironment = true;
            this.remoteRefClassName = "weblogic.rmi.cluster.ClusterActivatableRemoteRef";
            this.dgcPolicy = "managed";
            EntityBeanInfo entityBeanInfo = (EntityBeanInfo)this.bd;
            this.methodsAreIdempotent = entityBeanInfo.getConcurrencyStrategy() == 5;
            this.buildRmicMethodDescriptors(arrayList, true);
            this.replicaHandler = "weblogic.rmi.cluster.EntityBeanReplicaHandler";
        } else if (this.isStatefulBeanClusterable()) {
            this.clusterable = true;
            this.replicaHandler = "weblogic.rmi.cluster.PrimarySecondaryReplicaHandler";
            this.buildRmicMethodDescriptors(arrayList, true);
        } else {
            this.buildRmicMethodDescriptors(arrayList, false);
        }
        this.dispatchPolicy = this.getDispatchPolicy();
        this.stickToFirstServer = this.getStickToFirstServer();
        if (this.isEntityBean() && !this.isEntityBeanClusterable() || this.isStatefulSession() && !this.isStatefulBeanClusterable()) {
            this.activatable = true;
        }
    }

    void setOutputDirectory(String string) {
        this.outputDirectory = string;
    }

    public List<String> asList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-nomanglednames");
        arrayList.add("-noexit");
        if (this.clusterable) {
            arrayList.add("-clusterable");
        }
        if (this.methodsAreIdempotent) {
            arrayList.add("-methodsAreIdempotent");
        }
        if (this.propagateEnvironment) {
            arrayList.add("-propagateEnvironment");
        }
        if (this.loadAlgorithm != null) {
            arrayList.add("-loadAlgorithm");
            arrayList.add(this.loadAlgorithm.toLowerCase(Locale.ENGLISH));
        }
        if (this.callRouter != null) {
            arrayList.add("-callRouter");
            arrayList.add(this.callRouter);
        }
        if (this.replicaHandler != null) {
            arrayList.add("-replicaHandler");
            arrayList.add(this.replicaHandler);
        }
        if (this.useServersideStubs) {
            arrayList.add("-serverSideStubs");
        }
        if (this.dgcPolicy != null) {
            arrayList.add("-dgcPolicy");
            arrayList.add(this.dgcPolicy);
        }
        if (this.dispatchPolicy != null) {
            arrayList.add("-dispatchPolicy");
            arrayList.add(this.dispatchPolicy);
        }
        if (this.stickToFirstServer) {
            arrayList.add("-stickToFirstServer");
        }
        if (!this.bd.useCallByReference()) {
            arrayList.add("-enforceCallByValue");
        }
        if (this.bd.getNetworkAccessPoint() != null) {
            arrayList.add("-networkAccessPoint");
            arrayList.add(this.bd.getNetworkAccessPoint());
        }
        if ("weblogic.rmi.cluster.EntityRemoteRef".equals(this.remoteRefClassName)) {
            arrayList.add("-remoteRefClassName");
            arrayList.add(this.remoteRefClassName);
            arrayList.add("-serverRefClassName");
            arrayList.add("weblogic.rmi.cluster.EntityServerRef");
        } else if ("weblogic.rmi.cluster.ClusterActivatableRemoteRef".equals(this.remoteRefClassName)) {
            arrayList.add("-remoteRefClassName");
            arrayList.add(this.remoteRefClassName);
            arrayList.add("-serverRefClassName");
            arrayList.add("weblogic.rmi.cluster.ClusterActivatableServerRef");
        }
        if (this.activatable) {
            arrayList.add("-activatable");
        }
        if (this.integrity != null) {
            arrayList.add("-integrity");
            arrayList.add(this.integrity.toLowerCase(Locale.ENGLISH));
        }
        if (this.confidentiality != null) {
            arrayList.add("-confidentiality");
            arrayList.add(this.confidentiality.toLowerCase(Locale.ENGLISH));
        }
        if (this.clientCertAuthentication != null) {
            arrayList.add("-clientCertAuthentication");
            arrayList.add(this.clientCertAuthentication.toLowerCase(Locale.ENGLISH));
        }
        if (this.clientAuthentication != null) {
            arrayList.add("-clientAuthentication");
            arrayList.add(this.clientAuthentication.toLowerCase(Locale.ENGLISH));
        }
        if (this.identityAssertion != null) {
            arrayList.add("-identityAssertion");
            arrayList.add(this.identityAssertion.toLowerCase(Locale.ENGLISH));
        }
        return arrayList;
    }

    public Collection<RmicMethodDescriptor> getRmicMethodDescriptors() {
        return this.rmicMethodDescriptors;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" -nomanglednames");
        stringBuilder.append(" -noexit");
        if (this.clusterable) {
            stringBuilder.append(" -clusterable");
        }
        if (this.methodsAreIdempotent) {
            stringBuilder.append(" -methodsAreIdempotent");
        }
        if (this.propagateEnvironment) {
            stringBuilder.append(" -propagateEnvironment");
        }
        if (this.loadAlgorithm != null) {
            stringBuilder.append(" -loadAlgorithm " + this.loadAlgorithm);
        }
        if (this.callRouter != null) {
            stringBuilder.append(" -callRouter " + this.callRouter);
        }
        if (this.replicaHandler != null) {
            stringBuilder.append(" -replicaHandler " + this.replicaHandler);
        }
        if (this.useServersideStubs) {
            stringBuilder.append(" -serverSideStubs");
        }
        if (this.dgcPolicy != null) {
            stringBuilder.append(" -dgcPolicy " + this.dgcPolicy);
        }
        if (this.dispatchPolicy != null) {
            stringBuilder.append(" -dispatchPolicy " + this.dispatchPolicy);
        }
        if (this.stickToFirstServer) {
            stringBuilder.append(" -stickToFirstServer");
        }
        if (!this.bd.useCallByReference()) {
            stringBuilder.append(" -enforceCallByValue");
        }
        if (this.activatable) {
            stringBuilder.append(" -activatable");
        }
        if (this.integrity != null) {
            stringBuilder.append(" -integrity ");
            stringBuilder.append(this.integrity);
        }
        if (this.confidentiality != null) {
            stringBuilder.append(" -confidentiality ");
            stringBuilder.append(this.confidentiality);
        }
        if (this.clientCertAuthentication != null) {
            stringBuilder.append(" -clientCertAuthentication ");
            stringBuilder.append(this.clientCertAuthentication);
        }
        if (this.clientAuthentication != null) {
            stringBuilder.append(" -clientAuthentication ");
            stringBuilder.append(this.clientAuthentication);
        }
        if (this.identityAssertion != null) {
            stringBuilder.append(" -identityAssertion ");
            stringBuilder.append(this.identityAssertion);
        }
        return stringBuilder.toString();
    }

    private void buildRmicMethodDescriptors(Collection<MethodInfo> collection, boolean bl) {
        boolean bl2 = this.getRemoteClientTimeout() != 0;
        this.rmicMethodDescriptors = new LinkedHashSet<RmicMethodDescriptor>();
        for (MethodInfo methodInfo : collection) {
            boolean bl3 = false;
            boolean bl4 = false;
            if (!this.usesBeanManagedTx()) {
                short s = methodInfo.getTransactionAttribute();
                switch (s) {
                    case 4: {
                        bl3 = true;
                        bl4 = true;
                        break;
                    }
                    case 1: {
                        bl3 = true;
                        bl4 = true;
                        break;
                    }
                    case 2: {
                        bl3 = true;
                        bl4 = true;
                        break;
                    }
                    case 5: {
                        bl3 = true;
                        bl4 = false;
                        break;
                    }
                    case 0: {
                        bl4 = false;
                        break;
                    }
                    case 3: {
                        bl4 = true;
                    }
                }
            }
            RmicMethodDescriptor rmicMethodDescriptor = null;
            if (methodInfo.isIdempotent() && bl || bl3 || !bl4) {
                rmicMethodDescriptor = new RmicMethodDescriptor(this.createRMIMethodSignature(methodInfo));
                if (methodInfo.isIdempotent() && bl) {
                    rmicMethodDescriptor.setIdempotent("true");
                }
                if (bl3) {
                    rmicMethodDescriptor.setRequiresTransaction(true);
                }
            }
            if (bl2) {
                if (rmicMethodDescriptor == null) {
                    rmicMethodDescriptor = new RmicMethodDescriptor(this.createRMIMethodSignature(methodInfo));
                }
                int n = this.getRemoteClientTimeout() * 1000;
                if (bl4 && this.bd.getTransactionTimeoutMS() > 0) {
                    n = Math.max(n, this.bd.getTransactionTimeoutMS());
                }
                String string = new Integer(n).toString();
                rmicMethodDescriptor.setTimeOut(string);
                if (debugLogger.isDebugEnabled()) {
                    RMICOptions.debug("Setting the remote-client-timeout to " + this.getRemoteClientTimeout() + " seconds for the method: " + methodInfo.getSignature());
                }
            }
            if (rmicMethodDescriptor == null) continue;
            this.rmicMethodDescriptors.add(rmicMethodDescriptor);
        }
        if (this.rmicMethodDescriptors.size() == 0) {
            this.rmicMethodDescriptors = null;
        }
    }

    private String createRMIMethodSignature(MethodInfo methodInfo) {
        String[] stringArray = methodInfo.getMethodParams();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(91);
            if (n == -1) continue;
            int n2 = stringArray[i].lastIndexOf(91);
            int n3 = n2 - n + 1;
            String string = null;
            char c = stringArray[i].charAt(n2 + 1);
            switch (c) {
                case 'B': {
                    string = "byte";
                    break;
                }
                case 'C': {
                    string = "char";
                    break;
                }
                case 'D': {
                    string = "double";
                    break;
                }
                case 'F': {
                    string = "float";
                    break;
                }
                case 'I': {
                    string = "int";
                    break;
                }
                case 'J': {
                    string = "long";
                    break;
                }
                case 'S': {
                    string = "short";
                    break;
                }
                case 'Z': {
                    string = "boolean";
                    break;
                }
                case 'L': {
                    string = stringArray[i].substring(n2 + 2, stringArray[i].length() - 1);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Bad object type: " + c));
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            for (int j = 0; j < n3; ++j) {
                stringBuilder.append("[]");
            }
            stringArray[i] = stringBuilder.toString();
        }
        return methodInfo.getMethodName() + "(" + StringUtils.join((String[])stringArray, (String)",") + ")";
    }

    private static void debug(String string) {
        debugLogger.debug("[RMICOptions] " + string);
    }
}

