/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.ejb.spi.VersionHelper;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorsBean;
import weblogic.j2ee.descriptor.RelationshipsBean;
import weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBean;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.version;

public final class VersionHelperImpl
implements VersionHelper {
    private static final DebugLogger debugLogger = EJBDebugService.compilationLogger;
    private static final String VERSION_TAG = "WLS_RELEASE_BUILD_VERSION_37";
    private static final String[] SAVED_OPTIONS = new String[]{"keepgenerated", "g"};
    private final DeploymentInfo di;
    private final Map<String, List<BeanInfo>> classesToBeans;
    private final Properties currentJarHash;
    private final Getopt2 opts;

    public VersionHelperImpl(DeploymentInfo deploymentInfo, VirtualJarFile virtualJarFile, Getopt2 getopt2) throws ClassNotFoundException {
        this.di = deploymentInfo;
        this.opts = getopt2;
        this.classesToBeans = new HashMap<String, List<BeanInfo>>();
        this.currentJarHash = this.makeFileHash(virtualJarFile);
    }

    public boolean needsRecompile(String string, ClassLoader classLoader) throws ClassNotFoundException {
        String string2;
        if (debugLogger.isDebugEnabled()) {
            VersionHelperImpl.debug("calculating hash for: " + string);
        }
        if ((string2 = this.currentJarHash.getProperty(string)) == null) {
            if (debugLogger.isDebugEnabled()) {
                VersionHelperImpl.debug("Hmm.  The old hash for class " + string + " was null");
            }
            return true;
        }
        boolean bl = this.classesToBeans.get(string).get(0).isEntityBean();
        long l = this.computeCRC(string, classLoader, bl);
        if (debugLogger.isDebugEnabled()) {
            VersionHelperImpl.debug("new hash: " + l + " oldHash: " + string2);
        }
        return !String.valueOf(l).equals(string2);
    }

    public Collection needsRecompile(VirtualJarFile virtualJarFile) {
        Properties properties = this.getPreviousFileHash(virtualJarFile);
        return this.needsRecompile(properties);
    }

    public Collection needsRecompile(Properties properties) {
        assert (this.currentJarHash != null);
        if (properties == null) {
            if (debugLogger.isDebugEnabled()) {
                VersionHelperImpl.debug("Recompiling because no previous hashes found");
            }
            return this.di.getBeanInfos();
        }
        if (this.currentJarHash.size() != properties.size()) {
            if (debugLogger.isDebugEnabled()) {
                VersionHelperImpl.debug("Recompiling because number of hashes different");
                VersionHelperImpl.debug("current size: " + this.currentJarHash.size() + " old size: " + properties.size());
                VersionHelperImpl.debug("Dumping hashes:");
                VersionHelperImpl.debug("CurrentHashes:");
                this.dumpHashes(this.currentJarHash);
                VersionHelperImpl.debug("OldHashes:");
                this.dumpHashes(properties);
            }
            return this.di.getBeanInfos();
        }
        Enumeration<?> enumeration = this.currentJarHash.propertyNames();
        HashSet<BeanInfo> hashSet = new HashSet<BeanInfo>();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = this.currentJarHash.getProperty(string2);
            if (string3.equals(string = properties.getProperty(string2))) continue;
            if (string2.endsWith(".xml") || VERSION_TAG.equals(string2)) {
                if (debugLogger.isDebugEnabled()) {
                    VersionHelperImpl.debug("Recompiling all due to different hash for " + string2);
                }
                return this.di.getBeanInfos();
            }
            if (this.classesToBeans.containsKey(string2)) {
                List<BeanInfo> list = this.classesToBeans.get(string2);
                if (debugLogger.isDebugEnabled()) {
                    Iterator<BeanInfo> iterator = list.iterator();
                    String string4 = "";
                    while (iterator.hasNext()) {
                        string4 = string4.concat(iterator.next().getEJBName() + " ");
                    }
                    VersionHelperImpl.debug("Recompiling the following due to different hash for " + string2 + ": " + string4);
                }
                hashSet.addAll(list);
                continue;
            }
            return this.di.getBeanInfos();
        }
        if (debugLogger.isDebugEnabled() && hashSet.isEmpty()) {
            VersionHelperImpl.debug("Need not recompile EJB component " + this.di.getEJBComponentName());
        }
        return hashSet;
    }

    public Properties getCurrentJarHash() {
        return this.currentJarHash;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.di;
    }

    public void removeCompilerOptions(Properties properties) {
        for (int i = 0; i < SAVED_OPTIONS.length; ++i) {
            properties.remove(SAVED_OPTIONS[i]);
        }
    }

    private Properties makeFileHash(VirtualJarFile virtualJarFile) throws ClassNotFoundException {
        Iterator iterator;
        Object object;
        Properties properties = new Properties();
        properties.setProperty(VERSION_TAG, version.getReleaseBuildVersion());
        Collection collection = this.di.getBeanInfos();
        for (Object object2 : collection) {
            this.addBeanDependencyToClass((BeanInfo)object2, object2.getBeanClassName());
            if (!(object2 instanceof ClientDrivenBeanInfo)) continue;
            ClientDrivenBeanInfo object3 = (ClientDrivenBeanInfo)object2;
            if (object3.hasDeclaredRemoteHome()) {
                this.addBeanDependencyToClass((BeanInfo)object2, object3.getRemoteInterfaceName());
                this.addBeanDependencyToClass((BeanInfo)object2, object3.getHomeInterfaceName());
            }
            if (object3.hasDeclaredLocalHome()) {
                this.addBeanDependencyToClass((BeanInfo)object2, object3.getLocalInterfaceName());
                this.addBeanDependencyToClass((BeanInfo)object2, object3.getLocalHomeInterfaceName());
            }
            if (object3.hasWebserviceClientView() && object3.getServiceEndpointName() != null) {
                this.addBeanDependencyToClass((BeanInfo)object2, object3.getServiceEndpointName());
            }
            if (object3 instanceof Ejb3SessionBeanInfo) {
                object = (Ejb3SessionBeanInfo)object3;
                for (Class l : object.getBusinessRemotes()) {
                    this.addBeanDependencyToClass((BeanInfo)object2, l.getName());
                }
                iterator = object.getBusinessLocals().iterator();
                while (iterator.hasNext()) {
                    Class l;
                    l = (Class)iterator.next();
                    this.addBeanDependencyToClass((BeanInfo)object2, l.getName());
                }
                continue;
            }
            if (!(object3 instanceof EntityBeanInfo) || (iterator = (object = (EntityBeanInfo)object3).getCMPInfo()) == null || object.isUnknownPrimaryKey() || iterator.getCMPrimaryKeyFieldName() != null) continue;
            this.addBeanDependencyToClass((BeanInfo)object2, object.getPrimaryKeyClassName());
        }
        for (Map.Entry entry : this.classesToBeans.entrySet()) {
            object = (String)entry.getKey();
            iterator = (BeanInfo)((List)entry.getValue()).get(0);
            long l = this.computeCRC((String)object, iterator.getClassLoader(), iterator.isEntityBean());
            properties.setProperty((String)object, String.valueOf(l));
        }
        this.addHashForDDs(properties);
        for (int i = 0; i < SAVED_OPTIONS.length; ++i) {
            this.saveOptionIfPresent(SAVED_OPTIONS[i], properties);
        }
        return properties;
    }

    private void addHashForDDs(Properties properties) throws ClassNotFoundException {
        int n;
        InterceptorsBean interceptorsBean;
        RelationshipsBean relationshipsBean;
        EnterpriseBeansBean enterpriseBeansBean;
        String string;
        EjbDescriptorBean ejbDescriptorBean = this.di.getEjbDescriptorBean();
        String string2 = ejbDescriptorBean.getEjbJarBean().getVersion();
        if (string2 != null) {
            properties.setProperty("version", string2);
        }
        if ((string = ejbDescriptorBean.getEjbJarBean().getEjbClientJar()) != null) {
            properties.setProperty("ejb-client-jar", string);
        }
        if ((enterpriseBeansBean = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans()) != null) {
            properties.setProperty("enterprise-beans", ((AbstractDescriptorBean)enterpriseBeansBean).getHashValue());
        }
        if ((relationshipsBean = ejbDescriptorBean.getEjbJarBean().getRelationships()) != null) {
            properties.setProperty("relationships", ((AbstractDescriptorBean)relationshipsBean).getHashValue());
        }
        if ((interceptorsBean = ejbDescriptorBean.getEjbJarBean().getInterceptors()) != null && interceptorsBean.getInterceptors() != null) {
            properties.setProperty("interceptors(non-serializable)", this.nonSerIcptrs(interceptorsBean));
        }
        properties.setProperty("weblogic-ejb-jar.xml", ((AbstractDescriptorBean)ejbDescriptorBean.getWeblogicEjbJarBean()).getHashValue());
        WeblogicRdbmsJarBean[] weblogicRdbmsJarBeanArray = ejbDescriptorBean.getWeblogicRdbmsJarBeans();
        Object[] objectArray = new String[weblogicRdbmsJarBeanArray.length];
        for (n = 0; n < weblogicRdbmsJarBeanArray.length; ++n) {
            objectArray[n] = ((AbstractDescriptorBean)weblogicRdbmsJarBeanArray[n]).getHashValue();
        }
        Arrays.sort(objectArray);
        for (n = 0; n < weblogicRdbmsJarBeanArray.length; ++n) {
            properties.setProperty("weblogic-cmp-rdbms-jar.xml" + n, (String)objectArray[n]);
        }
    }

    private String nonSerIcptrs(InterceptorsBean interceptorsBean) throws ClassNotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet<String> treeSet = new TreeSet<String>();
        ClassLoader classLoader = this.di.getModuleClassLoader();
        for (InterceptorBean interceptorBean : interceptorsBean.getInterceptors()) {
            String string = interceptorBean.getInterceptorClass();
            Class<?> clazz = classLoader.loadClass(string);
            if (Serializable.class.isAssignableFrom(clazz)) continue;
            treeSet.add(string);
        }
        for (String string : treeSet) {
            stringBuilder.append(string + " ");
        }
        return stringBuilder.toString();
    }

    private void addBeanDependencyToClass(BeanInfo beanInfo, String string) {
        List<BeanInfo> list = this.classesToBeans.get(string);
        if (list == null) {
            list = new LinkedList<BeanInfo>();
            list.add(beanInfo);
            this.classesToBeans.put(string, list);
        } else {
            list.add(beanInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getPreviousFileHash(VirtualJarFile virtualJarFile) {
        Properties properties2;
        ZipEntry zipEntry = virtualJarFile.getEntry("_WL_GENERATED");
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            try {
                Properties properties = new Properties();
                inputStream = virtualJarFile.getInputStream(zipEntry);
                properties.load(inputStream);
                properties2 = properties;
                Object var7_8 = null;
            }
            catch (IOException iOException) {
                EJBLogger.logExceptionLoadingTimestamp((Exception)iOException);
                Properties properties3 = null;
                Object var7_9 = null;
                try {
                    if (inputStream == null) return properties3;
                    inputStream.close();
                    return properties3;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return properties3;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return properties2;
        }
        if (inputStream == null) return properties2;
        inputStream.close();
        return properties2;
    }

    private long computeCRC(File file) throws IOException {
        return FileUtils.computeCRC((File)file);
    }

    private long computeCRC(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException {
        CRC32 cRC32 = new CRC32();
        Class<?> clazz = classLoader.loadClass(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            String string2 = null;
            string2 = bl ? new MethodSignature(method, clazz).toString(false) : method.toString();
            arrayList.add(string2);
            if (!debugLogger.isDebugEnabled()) continue;
            VersionHelperImpl.debug("Signature" + string2);
        }
        Collections.sort(arrayList);
        for (String string3 : arrayList) {
            cRC32.update(string3.getBytes());
        }
        Field[] fieldArray = clazz.getFields();
        arrayList.clear();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (((Field)fieldArray[i]).getDeclaringClass() == Object.class) continue;
            arrayList.add(((Field)fieldArray[i]).toString());
        }
        Collections.sort(arrayList);
        for (String string4 : arrayList) {
            cRC32.update(string4.getBytes());
        }
        return cRC32.getValue();
    }

    private void saveOptionIfPresent(String string, Properties properties) {
        if (this.isOptionPresent(string)) {
            properties.setProperty(string, "true");
        }
    }

    private boolean isOptionPresent(String string) {
        return this.opts != null && this.opts.hasOption(string);
    }

    private void dumpHashes(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            VersionHelperImpl.debug("Property name: " + string);
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[VersionHelper] " + string);
    }
}

