/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.Label;
import com.bea.objectweb.asm.MethodVisitor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.ejb.container.ejbc.bytecodegen.MethInfo;
import weblogic.ejb.container.interfaces.Invokable;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.utils.Serializer;
import weblogic.kernel.KernelStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BCUtil {
    public static final String WL_INVOKABLE_CLS = BCUtil.binName(Invokable.class);
    public static final String WL_MD_FIELD_DESCRIPTOR = BCUtil.fieldDesc(MethodDescriptor.class);
    public static final int PFS_CLS = 49;
    private static final int DEFAULT_CHAINING_THRESHOLD = 100;
    private static final String CHAINING_THRESHOLD_PROPERTY = "weblogic.ejb.bytecodegen.methodchainingthreshold";
    private static final int METHOD_CHAINING_THRESHOLD = KernelStatus.isApplet() ? 100 : Integer.getInteger("weblogic.ejb.bytecodegen.methodchainingthreshold", 100);
    private static final String INVOKE_METHOD_DESC = "(Ljava/lang/Object;[Ljava/lang/Object;I)Ljava/lang/Object;";
    private static final String HANDLE_EX_METHOD_DESC = "(ILjava/lang/Throwable;)V";

    private BCUtil() {
    }

    public static void boxReturn(MethodVisitor methodVisitor, Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                methodVisitor.visitInsn(1);
            } else if (clazz == Boolean.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            } else if (clazz == Byte.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            } else if (clazz == Character.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            } else if (clazz == Double.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            } else if (clazz == Float.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            } else if (clazz == Integer.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            } else if (clazz == Long.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            } else if (clazz == Short.TYPE) {
                methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            } else {
                throw new AssertionError((Object)("Unknown primitive type : " + clazz));
            }
        }
    }

    public static void unboxReturn(MethodVisitor methodVisitor, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            methodVisitor.visitTypeInsn(192, BCUtil.binName(clazz));
            methodVisitor.visitInsn(176);
        } else if (clazz == Void.TYPE) {
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(177);
        } else if (clazz == Boolean.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
            methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            methodVisitor.visitInsn(172);
        } else if (clazz == Byte.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Byte");
            methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
            methodVisitor.visitInsn(172);
        } else if (clazz == Character.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Character");
            methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            methodVisitor.visitInsn(172);
        } else if (clazz == Double.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Double");
            methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
            methodVisitor.visitInsn(175);
        } else if (clazz == Float.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Float");
            methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
            methodVisitor.visitInsn(174);
        } else if (clazz == Integer.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Integer");
            methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
            methodVisitor.visitInsn(172);
        } else if (clazz == Long.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Long");
            methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
            methodVisitor.visitInsn(173);
        } else if (clazz == Short.TYPE) {
            methodVisitor.visitTypeInsn(192, "java/lang/Short");
            methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
            methodVisitor.visitInsn(172);
        } else {
            throw new AssertionError((Object)("Unknown primitive type : " + clazz));
        }
    }

    public static void boxArgs(MethodVisitor methodVisitor, Method method) {
        int n = Modifier.isStatic(method.getModifiers()) ? 0 : 1;
        BCUtil.boxArgs(methodVisitor, method, n);
    }

    public static void boxArgs(MethodVisitor methodVisitor, Method method, int n) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            methodVisitor.visitInsn(1);
            return;
        }
        BCUtil.pushInsn(methodVisitor, classArray.length);
        methodVisitor.visitTypeInsn(189, "java/lang/Object");
        int n2 = n;
        for (int i = 0; i < classArray.length; ++i) {
            methodVisitor.visitInsn(89);
            BCUtil.pushInsn(methodVisitor, i);
            Class<?> clazz = classArray[i];
            if (!clazz.isPrimitive()) {
                methodVisitor.visitVarInsn(25, n2);
            } else if (clazz == Boolean.TYPE) {
                methodVisitor.visitVarInsn(21, n2);
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            } else if (clazz == Byte.TYPE) {
                methodVisitor.visitVarInsn(21, n2);
                methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            } else if (clazz == Character.TYPE) {
                methodVisitor.visitVarInsn(21, n2);
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            } else if (clazz == Double.TYPE) {
                methodVisitor.visitVarInsn(24, n2);
                ++n2;
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            } else if (clazz == Float.TYPE) {
                methodVisitor.visitVarInsn(23, n2);
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            } else if (clazz == Integer.TYPE) {
                methodVisitor.visitVarInsn(21, n2);
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            } else if (clazz == Long.TYPE) {
                methodVisitor.visitVarInsn(22, n2);
                ++n2;
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            } else if (clazz == Short.TYPE) {
                methodVisitor.visitVarInsn(21, n2);
                methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            } else {
                throw new AssertionError((Object)("Unknown primitive type : " + clazz));
            }
            ++n2;
            methodVisitor.visitInsn(83);
        }
    }

    private static void unboxArgs(MethodVisitor methodVisitor, Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 0) {
            for (int i = 0; i < classArray.length; ++i) {
                methodVisitor.visitVarInsn(25, 2);
                BCUtil.pushInsn(methodVisitor, i);
                methodVisitor.visitInsn(50);
                if (!classArray[i].isPrimitive()) {
                    methodVisitor.visitTypeInsn(192, BCUtil.binName(classArray[i]));
                    continue;
                }
                Class<?> clazz = classArray[i];
                if (clazz == Boolean.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                    methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                    continue;
                }
                if (clazz == Byte.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                    methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                    continue;
                }
                if (clazz == Character.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Character");
                    methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                    continue;
                }
                if (clazz == Double.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Double");
                    methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                    continue;
                }
                if (clazz == Float.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Float");
                    methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                    continue;
                }
                if (clazz == Integer.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                    methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                    continue;
                }
                if (clazz == Long.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Long");
                    methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                    continue;
                }
                if (clazz == Short.TYPE) {
                    methodVisitor.visitTypeInsn(192, "java/lang/Short");
                    methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                    continue;
                }
                throw new AssertionError((Object)("Unknown primitive type : " + clazz));
            }
        }
    }

    public static String getBoxedClassBinName(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            throw new AssertionError((Object)("Invoked for a NON primitive class : " + clazz));
        }
        if (clazz == Void.TYPE) {
            return "java/lang/Void";
        }
        if (clazz == Boolean.TYPE) {
            return "java/lang/Boolean";
        }
        if (clazz == Byte.TYPE) {
            return "java/lang/Byte";
        }
        if (clazz == Character.TYPE) {
            return "java/lang/Character";
        }
        if (clazz == Double.TYPE) {
            return "java/lang/Double";
        }
        if (clazz == Float.TYPE) {
            return "java/lang/Float";
        }
        if (clazz == Integer.TYPE) {
            return "java/lang/Integer";
        }
        if (clazz == Long.TYPE) {
            return "java/lang/Long";
        }
        if (clazz == Short.TYPE) {
            return "java/lang/Short";
        }
        throw new AssertionError((Object)("Unknown primitive type : " + clazz));
    }

    public static void addReturnDefaultValue(MethodVisitor methodVisitor, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(176);
        } else if (clazz == Void.TYPE) {
            methodVisitor.visitInsn(177);
        } else if (clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Integer.TYPE || clazz == Short.TYPE) {
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(172);
        } else if (clazz == Double.TYPE) {
            methodVisitor.visitInsn(14);
            methodVisitor.visitInsn(175);
        } else if (clazz == Float.TYPE) {
            methodVisitor.visitInsn(11);
            methodVisitor.visitInsn(174);
        } else if (clazz == Long.TYPE) {
            methodVisitor.visitInsn(9);
            methodVisitor.visitInsn(173);
        } else {
            throw new AssertionError((Object)("Unknown primitive type : " + clazz));
        }
    }

    public static void addInvoke(ClassWriter classWriter, Method[] methodArray, String string, String string2) {
        if (methodArray == null || methodArray.length == 0) {
            return;
        }
        BCUtil.chainedInvokeAdder(classWriter, methodArray, string, string2, 0);
    }

    private static void chainedInvokeAdder(ClassWriter classWriter, Method[] methodArray, String string, String string2, int n) {
        int n2 = n / METHOD_CHAINING_THRESHOLD;
        String string3 = "__WL_invoke" + (n2 == 0 ? "" : "_" + n2);
        int n3 = Math.min(n + METHOD_CHAINING_THRESHOLD, methodArray.length);
        MethodVisitor methodVisitor = classWriter.visitMethod(n2 == 0 ? 1 : 2, string3, INVOKE_METHOD_DESC, null, new String[]{"java/lang/Throwable"});
        methodVisitor.visitCode();
        Label[] labelArray = new Label[n3 - n];
        for (int i = 0; i < labelArray.length; ++i) {
            labelArray[i] = new Label();
        }
        Label label = new Label();
        methodVisitor.visitVarInsn(21, 3);
        methodVisitor.visitTableSwitchInsn(n, n3 - 1, label, labelArray);
        for (int i = n; i < n3; ++i) {
            Method method = methodArray[i];
            methodVisitor.visitLabel(labelArray[i - n]);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, string);
            BCUtil.unboxArgs(methodVisitor, method);
            methodVisitor.visitMethodInsn(185, string, method.getName(), BCUtil.methodDesc(method));
            BCUtil.boxReturn(methodVisitor, method.getReturnType());
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitLabel(label);
        if (n3 == methodArray.length) {
            methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            methodVisitor.visitInsn(89);
            methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
            methodVisitor.visitLdcInsn((Object)"No method found for index : ");
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            methodVisitor.visitVarInsn(21, 3);
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
            methodVisitor.visitInsn(191);
        } else {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(21, 3);
            methodVisitor.visitMethodInsn(183, string2, "__WL_invoke_" + (n2 + 1), INVOKE_METHOD_DESC);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        if (n3 != methodArray.length) {
            BCUtil.chainedInvokeAdder(classWriter, methodArray, string, string2, n3);
        }
    }

    public static void addHandleException(ClassWriter classWriter, Method[] methodArray, String string, Set<Class<?>> set) {
        if (methodArray == null || methodArray.length == 0) {
            return;
        }
        BCUtil.chainedHandleExceptionAdder(classWriter, methodArray, string, set, 0);
    }

    private static void chainedHandleExceptionAdder(ClassWriter classWriter, Method[] methodArray, String string, Set<Class<?>> set, int n) {
        int n2 = n / METHOD_CHAINING_THRESHOLD;
        String string2 = "__WL_handleException" + (n2 == 0 ? "" : "_" + n2);
        int n3 = Math.min(n + METHOD_CHAINING_THRESHOLD, methodArray.length);
        MethodVisitor methodVisitor = classWriter.visitMethod(n2 == 0 ? 1 : 2, string2, HANDLE_EX_METHOD_DESC, null, new String[]{"java/lang/Throwable"});
        methodVisitor.visitCode();
        Label label = new Label();
        Label[] labelArray = new Label[n3 - n];
        for (int i = 0; i < labelArray.length; ++i) {
            labelArray[i] = new Label();
        }
        Label label2 = new Label();
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitTableSwitchInsn(n, n3 - 1, label2, labelArray);
        for (int i = n; i < n3; ++i) {
            Method method = methodArray[i];
            methodVisitor.visitLabel(labelArray[i - n]);
            List<Class<?>> list = BCUtil.combineExs(set, method);
            if (list.isEmpty()) {
                methodVisitor.visitJumpInsn(167, label);
                continue;
            }
            Label label3 = new Label();
            Iterator<Class<?>> iterator = list.iterator();
            while (iterator.hasNext()) {
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitTypeInsn(193, BCUtil.binName(iterator.next()));
                if (iterator.hasNext()) {
                    methodVisitor.visitJumpInsn(154, label3);
                    continue;
                }
                methodVisitor.visitJumpInsn(153, label);
                methodVisitor.visitLabel(label3);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitInsn(191);
            }
        }
        methodVisitor.visitLabel(label2);
        if (n3 == methodArray.length) {
            methodVisitor.visitTypeInsn(187, "java/lang/IllegalArgumentException");
            methodVisitor.visitInsn(89);
            methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
            methodVisitor.visitLdcInsn((Object)"No method found for index : ");
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            methodVisitor.visitVarInsn(21, 1);
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
            methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            methodVisitor.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
            methodVisitor.visitInsn(191);
        } else {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(21, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(183, string, "__WL_handleException_" + (n2 + 1), HANDLE_EX_METHOD_DESC);
        }
        methodVisitor.visitLabel(label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        if (n3 != methodArray.length) {
            BCUtil.chainedHandleExceptionAdder(classWriter, methodArray, string, set, n3);
        }
    }

    public static void addHandleExceptionAssertMethod(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "__WL_handleException", HANDLE_EX_METHOD_DESC, null, new String[]{"java/lang/Throwable"});
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/lang/AssertionError");
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)"This method should NOT get called");
        methodVisitor.visitMethodInsn(183, "java/lang/AssertionError", "<init>", "(Ljava/lang/Object;)V");
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    public static String binName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String binName(String string) {
        return string.replace('.', '/');
    }

    public static String fieldDesc(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new AssertionError((Object)("Unknown primitive type : " + clazz));
        }
        if (clazz.isArray()) {
            return BCUtil.binName(clazz);
        }
        return "L" + BCUtil.binName(clazz) + ";";
    }

    public static String methodDesc(Method method) {
        return BCUtil.methodDesc(method.getReturnType(), method.getParameterTypes());
    }

    public static String methodDesc(Class<?> clazz, Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (classArray != null) {
            for (Class<?> clazz2 : classArray) {
                stringBuilder.append(BCUtil.fieldDesc(clazz2));
            }
        }
        stringBuilder.append(")");
        stringBuilder.append(BCUtil.fieldDesc(clazz));
        return stringBuilder.toString();
    }

    public static String[] exceptionsDesc(Class<?>[] classArray) {
        if (classArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = BCUtil.binName(classArray[i]);
        }
        return stringArray;
    }

    public static int loadOpcode(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException("Invalid type " + clazz);
        }
        if (!clazz.isPrimitive()) {
            return 25;
        }
        if (clazz == Float.TYPE) {
            return 23;
        }
        if (clazz == Double.TYPE) {
            return 24;
        }
        if (clazz == Long.TYPE) {
            return 22;
        }
        return 21;
    }

    public static int storeOpcode(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException("Invalid type " + clazz);
        }
        if (!clazz.isPrimitive()) {
            return 58;
        }
        if (clazz == Float.TYPE) {
            return 56;
        }
        if (clazz == Double.TYPE) {
            return 57;
        }
        if (clazz == Long.TYPE) {
            return 55;
        }
        return 54;
    }

    public static int returnOpcode(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return 176;
        }
        if (clazz == Void.TYPE) {
            return 177;
        }
        if (clazz == Double.TYPE) {
            return 175;
        }
        if (clazz == Float.TYPE) {
            return 174;
        }
        if (clazz == Long.TYPE) {
            return 173;
        }
        return 172;
    }

    public static void pushInsn(MethodVisitor methodVisitor, int n) {
        if (n < -1) {
            methodVisitor.visitLdcInsn((Object)n);
        } else if (n <= 5) {
            switch (n) {
                case -1: {
                    methodVisitor.visitInsn(2);
                    break;
                }
                case 0: {
                    methodVisitor.visitInsn(3);
                    break;
                }
                case 1: {
                    methodVisitor.visitInsn(4);
                    break;
                }
                case 2: {
                    methodVisitor.visitInsn(5);
                    break;
                }
                case 3: {
                    methodVisitor.visitInsn(6);
                    break;
                }
                case 4: {
                    methodVisitor.visitInsn(7);
                    break;
                }
                case 5: {
                    methodVisitor.visitInsn(8);
                }
            }
        } else if (n <= 127) {
            methodVisitor.visitIntInsn(16, n);
        } else if (n <= Short.MAX_VALUE) {
            methodVisitor.visitIntInsn(17, n);
        } else {
            methodVisitor.visitLdcInsn((Object)n);
        }
    }

    public static int sizeOf(Class<?> ... classArray) {
        if (classArray == null) {
            return 0;
        }
        int n = 0;
        for (Class<?> clazz : classArray) {
            if (clazz == Long.TYPE || clazz == Double.TYPE) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    public static void addDefInit(ClassWriter classWriter, String string) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    public static void addGetter(ClassWriter classWriter, String string, String string2, String string3, Class<?> clazz) {
        String string4 = BCUtil.fieldDesc(clazz);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, "()" + string4, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, string, string3, string4);
        methodVisitor.visitInsn(BCUtil.returnOpcode(clazz));
        methodVisitor.visitMaxs(BCUtil.sizeOf(clazz), 1);
        methodVisitor.visitEnd();
    }

    public static void addSetter(ClassWriter classWriter, String string, String string2, String string3, Class<?> clazz) {
        String string4 = BCUtil.fieldDesc(clazz);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, "(" + string4 + ")V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(BCUtil.loadOpcode(clazz), 1);
        methodVisitor.visitFieldInsn(181, string, string3, string4);
        methodVisitor.visitInsn(177);
        int n = 1 + BCUtil.sizeOf(clazz);
        methodVisitor.visitMaxs(n, n);
        methodVisitor.visitEnd();
    }

    public static void addSerializationAssertMethods(ClassWriter classWriter, String string, String string2) {
        MethodVisitor methodVisitor = classWriter.visitMethod(2, "writeObject", "(Ljava/io/ObjectOutputStream;)V", null, new String[]{"java/io/IOException"});
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, string);
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)string2);
        methodVisitor.visitMethodInsn(183, string, "<init>", "(Ljava/lang/String;)V");
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        MethodVisitor methodVisitor2 = classWriter.visitMethod(2, "readObject", "(Ljava/io/ObjectInputStream;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        methodVisitor2.visitCode();
        methodVisitor2.visitTypeInsn(187, string);
        methodVisitor2.visitInsn(89);
        methodVisitor2.visitLdcInsn((Object)string2);
        methodVisitor2.visitMethodInsn(183, string, "<init>", "(Ljava/lang/String;)V");
        methodVisitor2.visitInsn(191);
        methodVisitor2.visitMaxs(3, 2);
        methodVisitor2.visitEnd();
    }

    public static List<Class<?>> combineExs(Set<Class<?>> set, Method method) {
        ArrayList arrayList = new ArrayList(set);
        for (Class<?> clazz : method.getExceptionTypes()) {
            if (RemoteException.class.isAssignableFrom(clazz) || set.contains(clazz)) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public static void addSerializationMethods(ClassWriter classWriter) {
        String string = BCUtil.binName(Serializer.class);
        MethodVisitor methodVisitor = classWriter.visitMethod(2, "writeObject", "(Ljava/io/ObjectOutputStream;)V", null, new String[]{"java/io/IOException", "java/lang/IllegalAccessException"});
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(184, string, "writeObject", "(Ljava/io/ObjectOutputStream;Ljava/lang/Object;)V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        MethodVisitor methodVisitor2 = classWriter.visitMethod(2, "readObject", "(Ljava/io/ObjectInputStream;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException", "java/lang/IllegalAccessException"});
        methodVisitor2.visitCode();
        methodVisitor2.visitVarInsn(25, 1);
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitMethodInsn(184, string, "readObject", "(Ljava/io/ObjectInputStream;Ljava/lang/Object;)V");
        methodVisitor2.visitInsn(177);
        methodVisitor2.visitMaxs(2, 2);
        methodVisitor2.visitEnd();
    }

    public static void addDistinctMDFields(ClassWriter classWriter, String string, Collection<String> collection, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(collection);
        for (String string2 : hashSet) {
            BCUtil.addMDField(classWriter, string + string2, bl);
        }
    }

    public static void addMDField(ClassWriter classWriter, String string, boolean bl) {
        int n = 1;
        if (bl) {
            n += 8;
        }
        classWriter.visitField(n, string, WL_MD_FIELD_DESCRIPTOR, null, null).visitEnd();
    }

    public static void addEOMembers(ClassWriter classWriter, String string, String string2, MethInfo ... methInfoArray) {
        BCUtil.addMembers(classWriter, string, string2, true, methInfoArray);
    }

    public static void addHomeMembers(ClassWriter classWriter, String string, String string2, MethInfo ... methInfoArray) {
        BCUtil.addMembers(classWriter, string, string2, false, methInfoArray);
    }

    private static void addMembers(ClassWriter classWriter, String string, String string2, boolean bl, MethInfo ... methInfoArray) {
        if (methInfoArray == null) {
            return;
        }
        for (MethInfo methInfo : methInfoArray) {
            BCUtil.addMDField(classWriter, methInfo.getMdName(), bl);
            StringBuilder stringBuilder = new StringBuilder();
            if (methInfo.getArgs() != null) {
                for (Class<?> clazz : methInfo.getArgs()) {
                    stringBuilder.append(BCUtil.fieldDesc(clazz));
                }
            }
            String object = BCUtil.fieldDesc(methInfo.getRetType());
            String string3 = "(" + stringBuilder + ")" + object;
            String[] stringArray = BCUtil.exceptionsDesc(methInfo.getExs());
            MethodVisitor methodVisitor = classWriter.visitMethod(1, methInfo.getMethodName(), string3, null, stringArray);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            if (bl) {
                methodVisitor.visitFieldInsn(178, string, methInfo.getMdName(), WL_MD_FIELD_DESCRIPTOR);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, string, methInfo.getMdName(), WL_MD_FIELD_DESCRIPTOR);
            }
            if (methInfo.getArgs() != null) {
                int n = 1;
                for (Class<?> clazz : methInfo.getArgs()) {
                    methodVisitor.visitVarInsn(BCUtil.loadOpcode(clazz), n);
                    n += BCUtil.sizeOf(clazz);
                }
            }
            methodVisitor.visitMethodInsn(183, string2, methInfo.getMethodName(), "(" + WL_MD_FIELD_DESCRIPTOR + stringBuilder + ")" + object);
            methodVisitor.visitInsn(BCUtil.returnOpcode(methInfo.getRetType()));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
    }
}

