/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.Label;
import com.bea.objectweb.asm.MethodVisitor;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.ejb.EJBContext;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.transaction.Transaction;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBMethodsUtil;
import weblogic.ejb.container.ejbc.bytecodegen.BCUtil;
import weblogic.ejb.container.ejbc.bytecodegen.ClassFileOutput;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.interfaces.WLSessionBean;
import weblogic.ejb.container.internal.AllowedMethodsHelper;
import weblogic.ejb.container.internal.ExtendedPersistenceContextWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanImplGenerator
implements Generator {
    private final NamingConvention nc;
    private final SessionBeanInfo sbi;
    private final String clsName;
    private final String superClsName;
    private static final String WL_ALLOWED_METHODS_HELPER_CLS = BCUtil.binName(AllowedMethodsHelper.class);

    BeanImplGenerator(NamingConvention namingConvention, SessionBeanInfo sessionBeanInfo) {
        this.nc = namingConvention;
        this.sbi = sessionBeanInfo;
        this.clsName = BCUtil.binName(namingConvention.getGeneratedBeanClassName());
        this.superClsName = BCUtil.binName(namingConvention.getBeanClassName());
    }

    @Override
    public Generator.Output generate() {
        boolean bl;
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(49, 49, this.clsName, null, this.superClsName, this.getInterfaces());
        this.addMembers(classWriter, "__WL_method_state", Integer.TYPE, "__WL_getMethodState", "__WL_setMethodState");
        this.addMembers(classWriter, "__WL_busy", Boolean.TYPE, "__WL_isBusy", "__WL_setBusy");
        this.addMembers(classWriter, "__WL_isLocal", Boolean.TYPE, "__WL_getIsLocal", "__WL_setIsLocal");
        this.addMembers(classWriter, "__WL_needsRemove", Boolean.TYPE, "__WL_needsRemove", "__WL_setNeedsRemove");
        this.addMembers(classWriter, "__WL_creatorOfTx", Boolean.TYPE, "__WL_isCreatorOfTx", "__WL_setCreatorOfTx");
        this.addMembers(classWriter, "__WL_EJBContext", EJBContext.class, "__WL_getEJBContext", "__WL_setEJBContext");
        this.addMembers(classWriter, "__WL_bmtx", Transaction.class, "__WL_getBeanManagedTransaction", "__WL_setBeanManagedTransaction");
        this.addMembers(classWriter, "__WL_loadUser", Object.class, "__WL_getLoadUser", "__WL_setLoadUser");
        boolean bl2 = this.sbi.isStateful();
        if (bl2) {
            this.addMembers(classWriter, "__WL_needsSessionSynchronization", Boolean.TYPE, "__WL_needsSessionSynchronization", "__WL_setNeedsSessionSynchronization");
        }
        boolean bl3 = bl = this.sbi.isStateful() && this.sbi.isEJB30() && ((Ejb3SessionBeanInfo)this.sbi).containsExtendedPersistenceContextRefs();
        if (bl) {
            classWriter.visitField(2, "__WL_persistenceContexts", "Ljava/util/Set;", null, null).visitEnd();
        }
        this.addInit(classWriter, bl, bl2);
        if (SessionBean.class.isAssignableFrom(this.sbi.getBeanClass())) {
            this.addSessionBeanCallbacks(classWriter);
        }
        if (this.sbi.isStateful() && SessionSynchronization.class.isAssignableFrom(this.sbi.getBeanClass())) {
            this.addSessionSyncCallbacks(classWriter);
        }
        for (Method method : EJBMethodsUtil.getBeanHomeClassMethods(this.sbi.getBeanClass())) {
            this.addXMethod(classWriter, method, 4);
        }
        if (this.sbi.isStateful()) {
            this.addGetExtendedPersistenceContexts(classWriter, bl);
            this.addCloseExtendedPersistenceContexts(classWriter);
        }
        if (this.sbi.isEJB30() && this.sbi.isStateful() && !Serializable.class.isAssignableFrom(this.sbi.getBeanClass())) {
            BCUtil.addSerializationMethods(classWriter);
        }
        classWriter.visitEnd();
        return new ClassFileOutput(this.clsName, classWriter.toByteArray());
    }

    private String[] getInterfaces() {
        String string = BCUtil.binName(this.nc.getGeneratedBeanInterfaceName());
        if (this.sbi.isStateful() && this.sbi.isEJB30() && !Serializable.class.isAssignableFrom(this.sbi.getBeanClass())) {
            return new String[]{string, BCUtil.binName(WLSessionBean.class), "java/io/Serializable"};
        }
        if (this.sbi.isStateful()) {
            return new String[]{string, BCUtil.binName(WLSessionBean.class)};
        }
        return new String[]{string, BCUtil.binName(WLEnterpriseBean.class)};
    }

    private void addInit(ClassWriter classWriter, boolean bl, boolean bl2) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, BCUtil.exceptionsDesc(this.beanInitExs()));
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, this.superClsName, "<init>", "()V");
        if (bl) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, "java/util/HashSet");
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V");
            methodVisitor.visitFieldInsn(181, this.clsName, "__WL_persistenceContexts", "Ljava/util/Set;");
        }
        if (bl2) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitInsn(4);
            methodVisitor.visitFieldInsn(181, this.clsName, "__WL_needsSessionSynchronization", "Z");
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addSessionBeanCallbacks(ClassWriter classWriter) {
        Method method = null;
        try {
            method = this.sbi.getBeanClass().getMethod("ejbActivate", new Class[0]);
            this.addXMethod(classWriter, method, 32);
            method = this.sbi.getBeanClass().getMethod("ejbPassivate", new Class[0]);
            this.addXMethod(classWriter, method, 64);
            method = this.sbi.getBeanClass().getMethod("ejbRemove", new Class[0]);
            this.addXMethod(classWriter, method, 16);
            method = this.sbi.getBeanClass().getMethod("setSessionContext", SessionContext.class);
            this.addXMethod(classWriter, method, 1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Method missing from " + this.sbi.getBeanClass() + ". " + noSuchMethodException));
        }
    }

    private void addSessionSyncCallbacks(ClassWriter classWriter) {
        Method method = null;
        try {
            method = this.sbi.getBeanClass().getMethod("afterBegin", new Class[0]);
            this.addXMethod(classWriter, method, 256);
            method = this.sbi.getBeanClass().getMethod("beforeCompletion", new Class[0]);
            this.addXMethod(classWriter, method, 512);
            method = this.sbi.getBeanClass().getMethod("afterCompletion", Boolean.TYPE);
            this.addXMethod(classWriter, method, 1024);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Method missing from " + this.sbi.getBeanClass() + ". " + noSuchMethodException));
        }
    }

    private void addGetExtendedPersistenceContexts(ClassWriter classWriter, boolean bl) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "getExtendedPersistenceContexts", "()Ljava/util/Set;", null, null);
        methodVisitor.visitCode();
        if (bl) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.clsName, "__WL_persistenceContexts", "Ljava/util/Set;");
        } else {
            methodVisitor.visitInsn(1);
        }
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    private void addXMethod(ClassWriter classWriter, Method method, int n) {
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray2 = method.getExceptionTypes();
        String string = BCUtil.methodDesc(clazz, classArray);
        boolean bl = clazz == Void.TYPE;
        int n2 = classArray == null ? 0 : BCUtil.sizeOf(classArray);
        int n3 = n2 + 1;
        int n4 = n2 + 2;
        int n5 = n2 + 2 + (bl ? 0 : BCUtil.sizeOf(clazz));
        MethodVisitor methodVisitor = classWriter.visitMethod(1, method.getName(), string, null, BCUtil.exceptionsDesc(classArray2));
        methodVisitor.visitCode();
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        methodVisitor.visitTryCatchBlock(label, label2, label3, null);
        Label label4 = new Label();
        methodVisitor.visitTryCatchBlock(label3, label4, label3, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.clsName, "__WL_method_state", "I");
        methodVisitor.visitVarInsn(54, n3);
        methodVisitor.visitLabel(label);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(184, WL_ALLOWED_METHODS_HELPER_CLS, "pushBean", "(Lweblogic/ejb/container/interfaces/WLEnterpriseBean;)V");
        methodVisitor.visitVarInsn(25, 0);
        BCUtil.pushInsn(methodVisitor, n);
        methodVisitor.visitFieldInsn(181, this.clsName, "__WL_method_state", "I");
        methodVisitor.visitVarInsn(25, 0);
        if (classArray != null) {
            int n6 = 1;
            for (Class<?> clazz2 : classArray) {
                methodVisitor.visitVarInsn(BCUtil.loadOpcode(clazz2), n6);
                n6 += BCUtil.sizeOf(clazz2);
            }
        }
        methodVisitor.visitMethodInsn(183, this.superClsName, method.getName(), string);
        if (!bl) {
            methodVisitor.visitVarInsn(BCUtil.storeOpcode(clazz), n4);
        }
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, n3);
        methodVisitor.visitFieldInsn(181, this.clsName, "__WL_method_state", "I");
        methodVisitor.visitMethodInsn(184, WL_ALLOWED_METHODS_HELPER_CLS, "popBean", "()V");
        Label label5 = new Label();
        if (bl) {
            methodVisitor.visitJumpInsn(167, label5);
        } else {
            methodVisitor.visitVarInsn(BCUtil.loadOpcode(clazz), n4);
            methodVisitor.visitInsn(BCUtil.returnOpcode(clazz));
        }
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(58, n5);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, n3);
        methodVisitor.visitFieldInsn(181, this.clsName, "__WL_method_state", "I");
        methodVisitor.visitMethodInsn(184, WL_ALLOWED_METHODS_HELPER_CLS, "popBean", "()V");
        methodVisitor.visitVarInsn(25, n5);
        methodVisitor.visitInsn(191);
        if (bl) {
            methodVisitor.visitLabel(label5);
            methodVisitor.visitInsn(177);
        }
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addMembers(ClassWriter classWriter, String string, Class<?> clazz, String string2, String string3) {
        classWriter.visitField(2, string, BCUtil.fieldDesc(clazz), null, null).visitEnd();
        BCUtil.addGetter(classWriter, this.clsName, string2, string, clazz);
        BCUtil.addSetter(classWriter, this.clsName, string3, string, clazz);
    }

    private Class<?>[] beanInitExs() {
        try {
            return this.sbi.getBeanClass().getConstructor(new Class[0]).getExceptionTypes();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Class: " + this.sbi.getBeanClass().getName() + " does not have a no-arg constructor. Exception: " + noSuchMethodException));
        }
    }

    private void addCloseExtendedPersistenceContexts(ClassWriter classWriter) {
        String string = BCUtil.binName(ExtendedPersistenceContextWrapper.class);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "closeExtendedPersistenceContexts", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, this.clsName, "getExtendedPersistenceContexts", "()Ljava/util/Set;");
        methodVisitor.visitVarInsn(58, 1);
        methodVisitor.visitVarInsn(25, 1);
        Label label = new Label();
        methodVisitor.visitJumpInsn(198, label);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;");
        methodVisitor.visitVarInsn(58, 2);
        Label label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
        Label label3 = new Label();
        methodVisitor.visitJumpInsn(153, label3);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
        methodVisitor.visitTypeInsn(192, string);
        methodVisitor.visitVarInsn(58, 3);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, string, "decrementReferenceCount", "()V");
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "clear", "()V");
        methodVisitor.visitLabel(label);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 4);
        methodVisitor.visitEnd();
    }
}

