/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import com.bea.objectweb.asm.ClassWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.bytecodegen.BCUtil;
import weblogic.ejb.container.ejbc.bytecodegen.ClassFileOutput;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.utils.annotation.BeaSynthetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanIntfGenerator
implements Generator {
    private final SessionBeanInfo sbi;
    private final String clsName;

    BeanIntfGenerator(NamingConvention namingConvention, SessionBeanInfo sessionBeanInfo) {
        this.sbi = sessionBeanInfo;
        this.clsName = BCUtil.binName(namingConvention.getGeneratedBeanInterfaceName());
    }

    @Override
    public Generator.Output generate() {
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(49, 1537, this.clsName, null, "java/lang/Object", new String[]{BCUtil.binName(WLEnterpriseBean.class)});
        int n = 1025;
        for (Method method : this.getMethods(this.sbi.getBeanClass())) {
            int n2 = n;
            if (method.isVarArgs()) {
                n2 += 128;
            }
            classWriter.visitMethod(n2, method.getName(), BCUtil.methodDesc(method), null, BCUtil.exceptionsDesc(method.getExceptionTypes())).visitEnd();
        }
        classWriter.visitEnd();
        return new ClassFileOutput(this.clsName, classWriter.toByteArray());
    }

    private Set<Method> getMethods(Class<?> clazz) {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (Method method : clazz.getMethods()) {
            if (Modifier.isAbstract(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || BeaSynthetic.Helper.isBeaSyntheticMethod((Method)method) || method.getDeclaringClass() == Object.class) continue;
            hashSet.add(method);
        }
        return hashSet;
    }
}

