/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.MethodVisitor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.RemoveException;
import weblogic.ejb.EJBLocalObject;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBMethodsUtil;
import weblogic.ejb.container.ejbc.bytecodegen.BCUtil;
import weblogic.ejb.container.ejbc.bytecodegen.ClassFileOutput;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.ejbc.bytecodegen.MethInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.SessionLocalMethodInvoker;
import weblogic.ejb.container.internal.StatefulEJBLocalObject;
import weblogic.ejb.container.internal.StatelessEJBLocalObject;
import weblogic.ejb20.interfaces.LocalHandle;

class ELOImplGenerator
implements Generator {
    private static final MethInfo REMOVE_MI = MethInfo.of("remove", "md_eo_remove").exceps(RemoveException.class).create();
    private static final MethInfo GET_EJB_LOCAL_HOME_MI = MethInfo.of("getEJBLocalHome", "md_eo_getEJBLocalHome").returns(EJBLocalHome.class).exceps(EJBException.class).create();
    private static final MethInfo GET_LOCAL_HANDLE_MI = MethInfo.of("getLocalHandle", "md_eo_getLocalHandle").returns(LocalHandle.class).exceps(EJBException.class).create();
    private static final MethInfo GET_PRIMARY_KEY_MI = MethInfo.of("getPrimaryKey", "md_eo_getPrimaryKey").returns(Object.class).exceps(EJBException.class).create();
    private static final MethInfo IS_IDENTICAL_MI = MethInfo.of("isIdentical", "md_eo_isIdentical_javax_ejb_EJBLocalObject").args(javax.ejb.EJBLocalObject.class).returns(Boolean.TYPE).exceps(EJBException.class).create();
    private static final String SLO_INVOKER = BCUtil.binName(SessionLocalMethodInvoker.class);
    private static final String INVOKE_METHOD_DESC = "(Lweblogic/ejb/container/internal/BaseLocalObject;Lweblogic/ejb/container/internal/MethodDescriptor;[Ljava/lang/Object;ILjava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;";
    private static final String SERIALIZATION_ERROR_MSG = "Attempt to pass a reference to an EJBLocalObject to a remote client. A local EJB component may only be accessed by clients co-located in the same ear or standalone jar file.";
    private final NamingConvention nc;
    private final SessionBeanInfo sbi;
    private final String clsName;
    private final String superClsName;

    ELOImplGenerator(NamingConvention namingConvention, SessionBeanInfo sessionBeanInfo) {
        this.nc = namingConvention;
        this.sbi = sessionBeanInfo;
        this.clsName = BCUtil.binName(namingConvention.getEJBLocalObjectClassName());
        this.superClsName = sessionBeanInfo.isStateful() ? BCUtil.binName(StatefulEJBLocalObject.class) : BCUtil.binName(StatelessEJBLocalObject.class);
    }

    public Generator.Output generate() {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(49, 49, this.clsName, null, this.superClsName, this.getInterfaces());
        BCUtil.addDefInit(classWriter, this.superClsName);
        Method[] methodArray = EJBMethodsUtil.getLocalMethods(this.sbi.getLocalInterfaceClass(), false);
        Map<Method, String> map = EJBMethodsUtil.getMethodSigs(methodArray);
        String string = EJBMethodsUtil.methodDescriptorPrefix((short)0);
        BCUtil.addDistinctMDFields(classWriter, string, map.values(), true);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string2 = string + map.get(method);
            String string3 = BCUtil.methodDesc(method);
            String[] stringArray = BCUtil.exceptionsDesc(method.getExceptionTypes());
            MethodVisitor methodVisitor = classWriter.visitMethod(1, method.getName(), string3, null, stringArray);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, this.clsName, string2, BCUtil.WL_MD_FIELD_DESCRIPTOR);
            BCUtil.boxArgs(methodVisitor, method);
            BCUtil.pushInsn(methodVisitor, i);
            methodVisitor.visitLdcInsn((Object)(this.sbi.getBeanClass().getName() + "." + method.getName()));
            methodVisitor.visitInsn(1);
            methodVisitor.visitMethodInsn(184, SLO_INVOKER, "invoke", INVOKE_METHOD_DESC);
            BCUtil.unboxReturn(methodVisitor, method.getReturnType());
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        BCUtil.addInvoke(classWriter, methodArray, BCUtil.binName(this.nc.getGeneratedBeanInterfaceName()), this.clsName);
        Set<Class<?>> set = this.sbi.getDeploymentInfo().getUncheckedAppExceptionClasses();
        BCUtil.addHandleException(classWriter, methodArray, this.clsName, set);
        BCUtil.addEOMembers(classWriter, this.clsName, this.superClsName, REMOVE_MI, GET_EJB_LOCAL_HOME_MI, GET_LOCAL_HANDLE_MI, GET_PRIMARY_KEY_MI, IS_IDENTICAL_MI);
        this.addOperationsComplete(classWriter);
        BCUtil.addSerializationAssertMethods(classWriter, "javax/ejb/EJBException", SERIALIZATION_ERROR_MSG);
        classWriter.visitEnd();
        return new ClassFileOutput(this.clsName, classWriter.toByteArray());
    }

    private String[] getInterfaces() {
        return new String[]{BCUtil.binName(this.sbi.getLocalInterfaceClass()), "java/io/Serializable", BCUtil.binName(EJBLocalObject.class), BCUtil.WL_INVOKABLE_CLS};
    }

    private void addOperationsComplete(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "operationsComplete", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, this.superClsName, "operationsComplete", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }
}

