/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.MethodVisitor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import weblogic.ejb.EJBObject;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBMethodsUtil;
import weblogic.ejb.container.ejbc.bytecodegen.BCUtil;
import weblogic.ejb.container.ejbc.bytecodegen.ClassFileOutput;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.ejbc.bytecodegen.MethInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.SessionRemoteMethodInvoker;
import weblogic.ejb.container.internal.StatefulEJBObject;
import weblogic.ejb.container.internal.StatelessEJBObject;
import weblogic.rmi.extensions.activation.Activatable;

class EOImplGenerator
implements Generator {
    private static final MethInfo REMOVE_OBJ_MI = MethInfo.of("remove", "md_eo_remove").exceps(RemoveException.class, RemoteException.class).create();
    private static final MethInfo GET_EJB_HOME_MI = MethInfo.of("getEJBHome", "md_eo_getEJBHome").returns(EJBHome.class).exceps(RemoteException.class).create();
    private static final MethInfo GET_HANDLE_MI = MethInfo.of("getHandle", "md_eo_getHandle").returns(Handle.class).exceps(RemoteException.class).create();
    private static final MethInfo GET_PRIMARY_KEY_MI = MethInfo.of("getPrimaryKey", "md_eo_getPrimaryKey").returns(Object.class).exceps(RemoteException.class).create();
    private static final MethInfo IS_IDENTICAL_MI = MethInfo.of("isIdentical", "md_eo_isIdentical_javax_ejb_EJBObject").args(javax.ejb.EJBObject.class).returns(Boolean.TYPE).exceps(RemoteException.class).create();
    private static final String SRO_INVOKER = BCUtil.binName(SessionRemoteMethodInvoker.class);
    private static final String INVOKE_METHOD_DESC = "(Lweblogic/ejb/container/internal/BaseRemoteObject;Lweblogic/ejb/container/internal/MethodDescriptor;[Ljava/lang/Object;ILjava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;";
    private final NamingConvention nc;
    private final SessionBeanInfo sbi;
    private final String clsName;
    private final String superClsName;

    EOImplGenerator(NamingConvention namingConvention, SessionBeanInfo sessionBeanInfo) {
        this.nc = namingConvention;
        this.sbi = sessionBeanInfo;
        this.clsName = BCUtil.binName(namingConvention.getEJBObjectClassName());
        this.superClsName = sessionBeanInfo.isStateful() ? BCUtil.binName(StatefulEJBObject.class) : BCUtil.binName(StatelessEJBObject.class);
    }

    public Generator.Output generate() {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(49, 49, this.clsName, null, this.superClsName, this.getInterfaces());
        BCUtil.addDefInit(classWriter, this.superClsName);
        Method[] methodArray = EJBMethodsUtil.getRemoteMethods(this.sbi.getRemoteInterfaceClass(), false);
        Map<Method, String> map = EJBMethodsUtil.getMethodSigs(methodArray);
        String string = EJBMethodsUtil.methodDescriptorPrefix((short)0);
        BCUtil.addDistinctMDFields(classWriter, string, map.values(), true);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string2 = string + map.get(method);
            String string3 = BCUtil.methodDesc(method);
            String[] stringArray = BCUtil.exceptionsDesc(method.getExceptionTypes());
            MethodVisitor methodVisitor = classWriter.visitMethod(1, method.getName(), string3, null, stringArray);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, this.clsName, string2, BCUtil.WL_MD_FIELD_DESCRIPTOR);
            BCUtil.boxArgs(methodVisitor, method);
            BCUtil.pushInsn(methodVisitor, i);
            methodVisitor.visitLdcInsn((Object)(this.sbi.getBeanClass().getName() + "." + method.getName()));
            methodVisitor.visitInsn(1);
            methodVisitor.visitMethodInsn(184, SRO_INVOKER, "invoke", INVOKE_METHOD_DESC);
            BCUtil.unboxReturn(methodVisitor, method.getReturnType());
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        BCUtil.addInvoke(classWriter, methodArray, BCUtil.binName(this.nc.getGeneratedBeanInterfaceName()), this.clsName);
        Set<Class<?>> set = this.sbi.getDeploymentInfo().getUncheckedAppExceptionClasses();
        BCUtil.addHandleException(classWriter, methodArray, this.clsName, set);
        BCUtil.addEOMembers(classWriter, this.clsName, this.superClsName, REMOVE_OBJ_MI, GET_EJB_HOME_MI, GET_HANDLE_MI, GET_PRIMARY_KEY_MI, IS_IDENTICAL_MI);
        this.addOperationsComplete(classWriter);
        classWriter.visitEnd();
        return new ClassFileOutput(this.clsName, classWriter.toByteArray());
    }

    private String[] getInterfaces() {
        if (this.sbi.isStateful() && this.sbi.getReplicationType() != 2) {
            return new String[]{BCUtil.binName(this.sbi.getRemoteInterfaceClass()), BCUtil.binName(Activatable.class), BCUtil.binName(EJBObject.class), BCUtil.WL_INVOKABLE_CLS};
        }
        return new String[]{BCUtil.binName(this.sbi.getRemoteInterfaceClass()), BCUtil.binName(EJBObject.class), BCUtil.WL_INVOKABLE_CLS};
    }

    private void addOperationsComplete(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "operationsComplete", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, this.superClsName, "operationsComplete", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }
}

