/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import java.io.File;
import java.io.IOException;
import java.rmi.Remote;
import java.util.Set;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.bytecodegen.BeanImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.BeanIntfGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.ELOImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.EOImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.ejbc.bytecodegen.HomeImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.LocalBusImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.LocalHomeImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.MDOImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.MessageDrivenBeanImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.RemoteBusImplGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.RemoteBusIntfGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.SerializableIcptrGenerator;
import weblogic.ejb.container.ejbc.bytecodegen.WSOImplGenerator;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.utils.FileUtils;

public final class GeneratorFactory {
    private GeneratorFactory() {
    }

    public static void generate(MessageDrivenBeanInfo messageDrivenBeanInfo, NamingConvention namingConvention, String string) throws EJBCException {
        if (!messageDrivenBeanInfo.getIsWeblogicJMS()) {
            GeneratorFactory.write(string, new MDOImplGenerator(namingConvention, messageDrivenBeanInfo).generate());
        } else if (messageDrivenBeanInfo.isIndirectlyImplMessageListener()) {
            GeneratorFactory.write(string, new MessageDrivenBeanImplGenerator(namingConvention, messageDrivenBeanInfo).generate());
        }
    }

    public static void generate(InterceptorBean interceptorBean, NamingConvention namingConvention, String string) throws EJBCException {
        SerializableIcptrGenerator serializableIcptrGenerator = new SerializableIcptrGenerator(namingConvention.getInterceptorImplClassName(), interceptorBean.getInterceptorClass());
        GeneratorFactory.write(string, serializableIcptrGenerator.generate());
    }

    public static void generate(SessionBeanInfo sessionBeanInfo, NamingConvention namingConvention, String string) throws EJBCException {
        Set set;
        GeneratorFactory.write(string, new BeanIntfGenerator(namingConvention, sessionBeanInfo).generate());
        GeneratorFactory.write(string, new BeanImplGenerator(namingConvention, sessionBeanInfo).generate());
        if (sessionBeanInfo.hasRemoteClientView()) {
            if (sessionBeanInfo.hasDeclaredRemoteHome()) {
                GeneratorFactory.write(string, new HomeImplGenerator(namingConvention, sessionBeanInfo).generate());
                GeneratorFactory.write(string, new EOImplGenerator(namingConvention, sessionBeanInfo).generate());
            }
            set = sessionBeanInfo.getBusinessRemotes();
            for (Class clazz : set) {
                if (!Remote.class.isAssignableFrom(clazz)) {
                    GeneratorFactory.write(string, new RemoteBusIntfGenerator(namingConvention.getRemoteBusinessIntfClassName(clazz), clazz).generate());
                }
                GeneratorFactory.write(string, new RemoteBusImplGenerator(namingConvention, sessionBeanInfo, clazz).generate());
            }
        }
        if (sessionBeanInfo.hasLocalClientView()) {
            if (sessionBeanInfo.hasDeclaredLocalHome()) {
                GeneratorFactory.write(string, new LocalHomeImplGenerator(namingConvention, sessionBeanInfo).generate());
                GeneratorFactory.write(string, new ELOImplGenerator(namingConvention, sessionBeanInfo).generate());
            }
            set = sessionBeanInfo.getBusinessLocals();
            for (Class clazz : set) {
                GeneratorFactory.write(string, new LocalBusImplGenerator(namingConvention, sessionBeanInfo, clazz).generate());
            }
        }
        if (sessionBeanInfo.hasWebserviceClientView()) {
            GeneratorFactory.write(string, new WSOImplGenerator(namingConvention, sessionBeanInfo).generate());
        }
    }

    private static void write(String string, Generator.Output output) throws EJBCException {
        try {
            FileUtils.writeToFile((byte[])output.bytes(), (String)(string + File.separator + output.relativeFilePath()));
        }
        catch (IOException iOException) {
            throw new EJBCException("Error writing bytes to class file.", iOException);
        }
    }
}

