/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.MethodVisitor;
import com.bea.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBMethodsUtil;
import weblogic.ejb.container.ejbc.bytecodegen.BCUtil;
import weblogic.ejb.container.ejbc.bytecodegen.ClassFileOutput;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.SessionLocalMethodInvoker;
import weblogic.ejb.container.internal.StatefulLocalObject;
import weblogic.ejb.container.internal.StatelessLocalObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalBusImplGenerator
implements Generator {
    private static final String SLO_INVOKER = BCUtil.binName(SessionLocalMethodInvoker.class);
    private static final String INVOKE_METHOD_DESC = "(Lweblogic/ejb/container/internal/BaseLocalObject;Lweblogic/ejb/container/internal/MethodDescriptor;[Ljava/lang/Object;ILjava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;";
    private static final String SERIALIZATION_ERROR_MSG = "Attempt to pass a reference to an EJBLocalObject to a remote client. A local EJB component may only be accessed by clients co-located in the same ear or standalone jar file.";
    private final NamingConvention nc;
    private final SessionBeanInfo sbi;
    private final String clsName;
    private final String superClsName;
    private final Class<?> busIntf;

    LocalBusImplGenerator(NamingConvention namingConvention, SessionBeanInfo sessionBeanInfo, Class<?> clazz) {
        this.nc = namingConvention;
        this.sbi = sessionBeanInfo;
        this.busIntf = clazz;
        this.clsName = BCUtil.binName(namingConvention.getLocalBusinessImplClassName(this.busIntf));
        this.superClsName = sessionBeanInfo.isStateful() ? BCUtil.binName(StatefulLocalObject.class) : BCUtil.binName(StatelessLocalObject.class);
    }

    @Override
    public Generator.Output generate() {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(49, 49, this.clsName, null, this.superClsName, this.getInterfaces());
        classWriter.visitField(26, "bIClass", "Ljava/lang/Class;", null, null).visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn((Object)Type.getType(this.busIntf));
        methodVisitor.visitFieldInsn(179, this.clsName, "bIClass", "Ljava/lang/Class;");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 0);
        methodVisitor.visitEnd();
        BCUtil.addDefInit(classWriter, this.superClsName);
        Method[] methodArray = EJBMethodsUtil.getMethods(this.busIntf, false);
        Map<Method, String> map = EJBMethodsUtil.getMethodSigs(methodArray);
        String string = EJBMethodsUtil.methodDescriptorPrefix((short)0);
        BCUtil.addDistinctMDFields(classWriter, string, map.values(), true);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string2 = string + map.get(method);
            String string3 = BCUtil.methodDesc(method);
            String[] stringArray = BCUtil.exceptionsDesc(method.getExceptionTypes());
            MethodVisitor methodVisitor2 = classWriter.visitMethod(1, method.getName(), string3, null, stringArray);
            methodVisitor2.visitCode();
            methodVisitor2.visitVarInsn(25, 0);
            methodVisitor2.visitFieldInsn(178, this.clsName, string2, BCUtil.WL_MD_FIELD_DESCRIPTOR);
            BCUtil.boxArgs(methodVisitor2, method);
            BCUtil.pushInsn(methodVisitor2, i);
            methodVisitor2.visitLdcInsn((Object)(this.sbi.getBeanClass().getName() + "." + method.getName()));
            methodVisitor2.visitFieldInsn(178, this.clsName, "bIClass", "Ljava/lang/Class;");
            methodVisitor2.visitMethodInsn(184, SLO_INVOKER, "invoke", INVOKE_METHOD_DESC);
            BCUtil.unboxReturn(methodVisitor2, method.getReturnType());
            methodVisitor2.visitMaxs(0, 0);
            methodVisitor2.visitEnd();
        }
        BCUtil.addInvoke(classWriter, methodArray, BCUtil.binName(this.nc.getGeneratedBeanInterfaceName()), this.clsName);
        Set<Class<?>> set = this.sbi.getDeploymentInfo().getUncheckedAppExceptionClasses();
        BCUtil.addHandleException(classWriter, methodArray, this.clsName, set);
        BCUtil.addSerializationAssertMethods(classWriter, "javax/ejb/EJBException", SERIALIZATION_ERROR_MSG);
        classWriter.visitEnd();
        return new ClassFileOutput(this.clsName, classWriter.toByteArray());
    }

    private String[] getInterfaces() {
        return new String[]{BCUtil.binName(this.busIntf), "java/io/Serializable", BCUtil.WL_INVOKABLE_CLS};
    }
}

