/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import java.io.IOException;
import weblogic.ejb.container.ejbc.EJBCException;
import weblogic.ejb.container.ejbc.bytecodegen.BCUtil;
import weblogic.ejb.container.ejbc.bytecodegen.ClassFileOutput;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.ejbc.bytecodegen.RemoteBusIntfClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteBusIntfGenerator
implements Generator {
    private final Class<?> busIntf;
    private final String clsName;

    RemoteBusIntfGenerator(String string, Class<?> clazz) {
        this.clsName = BCUtil.binName(string);
        this.busIntf = clazz;
    }

    @Override
    public Generator.Output generate() throws EJBCException {
        try {
            byte[] byArray = RemoteBusIntfClassAdapter.getRBIBytes(this.busIntf, this.clsName);
            return new ClassFileOutput(this.clsName, byArray);
        }
        catch (IOException iOException) {
            throw new EJBCException("Error reading the class file of " + this.busIntf, iOException);
        }
    }
}

