/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.bytecodegen;

import com.bea.objectweb.asm.ClassWriter;
import com.bea.objectweb.asm.MethodVisitor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.ejbc.EJBMethodsUtil;
import weblogic.ejb.container.ejbc.bytecodegen.BCUtil;
import weblogic.ejb.container.ejbc.bytecodegen.ClassFileOutput;
import weblogic.ejb.container.ejbc.bytecodegen.Generator;
import weblogic.ejb.container.interfaces.SessionBeanInfo;
import weblogic.ejb.container.internal.BaseWSLocalObject;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.WSOMethodInvoker;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.ejb.spi.BaseWSObjectIntf;
import weblogic.utils.Debug;

class WSOImplGenerator
implements Generator {
    private static final String WSO_INVOKER = BCUtil.binName(WSOMethodInvoker.class);
    private static final String INVOKE_METHOD_DESC = "(Lweblogic/ejb/container/internal/BaseWSLocalObject;Lweblogic/ejb/container/internal/MethodDescriptor;[Ljava/lang/Object;I)Ljava/lang/Object;";
    private static final String WL_WEBLOGIC_EJB_CONTEXT_HANDLER_CLS = BCUtil.binName(EJBContextHandler.class);
    private static final String WL_UTILS_DEBUG_CLS = BCUtil.binName(Debug.class);
    private static final String SUPER_PRE_INVOKE_METHOD_DESC = "(Lweblogic/ejb/container/internal/MethodDescriptor;Lweblogic/security/service/ContextHandler;Lweblogic/security/service/ContextHandler;Lweblogic/security/acl/internal/AuthenticatedSubject;)Lweblogic/ejb/container/internal/InvocationWrapper;";
    private static final String EJB_CTX_HANDLER_METHOD_DESC = "(Lweblogic/ejb/container/internal/MethodDescriptor;[Ljava/lang/Object;)V";
    private final NamingConvention nc;
    private final SessionBeanInfo sbi;
    private final String clsName;
    private final String superClsName;

    WSOImplGenerator(NamingConvention namingConvention, SessionBeanInfo sessionBeanInfo) {
        this.nc = namingConvention;
        this.sbi = sessionBeanInfo;
        this.clsName = BCUtil.binName(namingConvention.getWsObjectClassName());
        this.superClsName = BCUtil.binName(BaseWSLocalObject.class);
    }

    public Generator.Output generate() {
        ClassWriter classWriter = new ClassWriter(1);
        classWriter.visit(49, 49, this.clsName, null, this.superClsName, this.getInterfaces());
        BCUtil.addDefInit(classWriter, this.superClsName);
        Method[] methodArray = EJBMethodsUtil.getWebserviceMethods(this.sbi);
        Map<Method, String> map = EJBMethodsUtil.getMethodSigs(methodArray);
        String string = EJBMethodsUtil.methodDescriptorPrefix((short)0);
        BCUtil.addDistinctMDFields(classWriter, string, map.values(), true);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string2 = string + map.get(method);
            String string3 = BCUtil.methodDesc(method);
            this.addPreInvokeMethod(classWriter, method, string2);
            this.addBusMethod(classWriter, method, string2, string3, i);
            this.addDummyMethod(classWriter, method, string3);
        }
        this.addPostInvoke(classWriter);
        BCUtil.addInvoke(classWriter, methodArray, BCUtil.binName(this.nc.getGeneratedBeanInterfaceName()), this.clsName);
        BCUtil.addHandleExceptionAssertMethod(classWriter);
        classWriter.visitEnd();
        return new ClassFileOutput(this.clsName, classWriter.toByteArray());
    }

    private String[] getInterfaces() {
        return new String[]{BCUtil.binName(BaseWSObjectIntf.class), "java/io/Serializable", BCUtil.WL_INVOKABLE_CLS};
    }

    private void addPostInvoke(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "__WL__WS_postInvoke", "()V", null, new String[]{"java/lang/Exception"});
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, this.superClsName, "__WL_wsPostInvoke", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    private void addPreInvokeMethod(ClassWriter classWriter, Method method, String string) {
        String string2 = MethodUtils.getWSOPreInvokeMethodName(method);
        StringBuilder stringBuilder = new StringBuilder("(Lweblogic/security/acl/internal/AuthenticatedSubject;Lweblogic/security/service/ContextHandler;");
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(BCUtil.fieldDesc(clazz));
        }
        stringBuilder.append(")V");
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, stringBuilder.toString(), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitFieldInsn(178, this.clsName, string, BCUtil.WL_MD_FIELD_DESCRIPTOR);
        int n = BCUtil.sizeOf(method.getParameterTypes()) + 3;
        methodVisitor.visitVarInsn(58, n);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, n);
        methodVisitor.visitTypeInsn(187, WL_WEBLOGIC_EJB_CONTEXT_HANDLER_CLS);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, n);
        if (method.getParameterTypes().length == 0) {
            methodVisitor.visitInsn(3);
            methodVisitor.visitTypeInsn(189, "java/lang/Object");
        } else {
            BCUtil.boxArgs(methodVisitor, method, 3);
        }
        methodVisitor.visitMethodInsn(183, WL_WEBLOGIC_EJB_CONTEXT_HANDLER_CLS, "<init>", EJB_CTX_HANDLER_METHOD_DESC);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, this.superClsName, "__WL_preInvoke", SUPER_PRE_INVOKE_METHOD_DESC);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addBusMethod(ClassWriter classWriter, Method method, String string, String string2, int n) {
        String string3 = MethodUtils.getWSOBusinessMethodName(method);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string3, string2, null, new String[]{"java/lang/Throwable"});
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(178, this.clsName, string, BCUtil.WL_MD_FIELD_DESCRIPTOR);
        BCUtil.boxArgs(methodVisitor, method);
        BCUtil.pushInsn(methodVisitor, n);
        methodVisitor.visitMethodInsn(184, WSO_INVOKER, "invoke", INVOKE_METHOD_DESC);
        BCUtil.unboxReturn(methodVisitor, method.getReturnType());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void addDummyMethod(ClassWriter classWriter, Method method, String string) {
        String[] stringArray = BCUtil.exceptionsDesc(method.getExceptionTypes());
        MethodVisitor methodVisitor = classWriter.visitMethod(1, method.getName(), string, null, stringArray);
        methodVisitor.visitCode();
        methodVisitor.visitInsn(3);
        methodVisitor.visitLdcInsn((Object)(" invalid call on " + method.getName() + "."));
        methodVisitor.visitMethodInsn(184, WL_UTILS_DEBUG_CLS, "assertion", "(ZLjava/lang/String;)V");
        BCUtil.addReturnDefaultValue(methodVisitor, method.getReturnType());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }
}

