/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.codegen;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.utils.PlatformConstants;

public final class GenericMethodSignature
implements PlatformConstants {
    private boolean rmiSignature = false;
    private Method method;
    private List paramterizingHierarchy;

    public GenericMethodSignature(Method method, Class clazz) {
        this.setMethod(method);
        this.paramterizingHierarchy = clazz == null ? null : this.getMethodDeclareHierarchy(clazz, method);
    }

    public GenericMethodSignature(Method method) {
        this.setMethod(method);
        this.paramterizingHierarchy = null;
    }

    public void setRmiSignature(boolean bl) {
        this.rmiSignature = bl;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    private List getMethodDeclareHierarchy(Type type, Method method) {
        if (!GenericMethodSignature.hasMethodDeclared(type, method)) {
            return null;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.add(type);
        Class clazz = GenericMethodSignature.getClassFromTypeIfPossible(type);
        Type[] typeArray = null;
        block0: do {
            if (clazz == null) {
                return arrayList;
            }
            if (clazz.isInterface()) {
                typeArray = clazz.getGenericInterfaces();
            } else {
                Type[] typeArray2 = clazz.getGenericInterfaces();
                typeArray = new Type[typeArray2.length + 1];
                typeArray[0] = clazz.getGenericSuperclass();
                for (int i = 1; i < typeArray2.length + 1; ++i) {
                    typeArray[i] = typeArray2[i - 1];
                }
            }
            if (typeArray == null) {
                return arrayList;
            }
            for (int i = 0; i < typeArray.length; ++i) {
                clazz = GenericMethodSignature.getClassFromTypeIfPossible(typeArray[i]);
                if (!GenericMethodSignature.hasMethodDeclared(typeArray[i], method)) continue;
                if (method.getDeclaringClass().equals(clazz) && !(typeArray[i] instanceof ParameterizedType)) {
                    return null;
                }
                if (method.getDeclaringClass().equals(clazz)) {
                    arrayList.add(typeArray[i]);
                    return arrayList;
                }
                arrayList.add(typeArray[i]);
                continue block0;
            }
        } while (typeArray.length > 0);
        return arrayList;
    }

    public String getRealNameForTypeVariable(Type type, boolean bl) {
        if (!(type instanceof TypeVariable)) {
            return null;
        }
        TypeVariable typeVariable = (TypeVariable)type;
        StringBuffer stringBuffer = new StringBuffer();
        Type[] typeArray = typeVariable.getBounds();
        if (GenericMethodSignature.isDelcaredInTypes(typeVariable, this.method.getTypeParameters())) {
            if (typeArray[0] instanceof Class && ((Class)typeArray[0]).equals(Object.class)) {
                return this.getSimpleClassNameForType(typeVariable);
            }
            stringBuffer.append(this.getSimpleClassNameForType(typeVariable));
            if (bl) {
                stringBuffer.append(" extends ");
                for (int i = 0; i < typeArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" & ");
                    }
                    stringBuffer.append(this.getParameterizedName(typeArray[i]));
                }
            }
            return stringBuffer.toString();
        }
        Type type2 = this.getMappedTypeForTypeVariable(typeVariable, this.paramterizingHierarchy);
        if (type2 == null) {
            int n = 0;
            if (n < typeArray.length) {
                stringBuffer.append(this.getSimpleClassNameForType(typeArray[n]));
            }
            return stringBuffer.toString();
        }
        return this.getParameterizedName(type2);
    }

    public String getRealNameForWildcardType(Type type) {
        if (!(type instanceof WildcardType)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (type.toString().equals("?")) {
            stringBuffer.append("?");
        } else {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            Type[] typeArray2 = ((WildcardType)type).getLowerBounds();
            if (typeArray2.length == 0) {
                stringBuffer.append("? extends ");
                int n = 0;
                if (n < typeArray.length) {
                    stringBuffer.append(this.getParameterizedName(typeArray[n]));
                }
            } else {
                stringBuffer.append("? super ");
                int n = 0;
                if (n < typeArray2.length) {
                    stringBuffer.append(this.getParameterizedName(typeArray2[n]));
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getRealNameForParameterizedType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Type type2 = ((ParameterizedType)type).getRawType();
        if (type2 instanceof Class) {
            stringBuffer.append(this.getSimpleClassNameForType(type2) + "<");
        }
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i] instanceof Class) {
                stringBuffer.append(this.getSimpleClassNameForType(typeArray[i]));
            } else if (typeArray[i] instanceof TypeVariable) {
                stringBuffer.append(this.getRealNameForTypeVariable(typeArray[i], false));
            } else if (typeArray[i] instanceof ParameterizedType) {
                stringBuffer.append(this.getRealNameForParameterizedType(typeArray[i]));
            } else if (typeArray[i] instanceof WildcardType) {
                stringBuffer.append(this.getRealNameForWildcardType(typeArray[i]));
            } else if (typeArray[i] instanceof GenericArrayType) {
                stringBuffer.append(this.getParameterizedName(typeArray[i]));
            }
            if (i >= typeArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String getParameterizedName(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return this.getSimpleClassNameForType(type);
        }
        if (type instanceof TypeVariable) {
            return this.getRealNameForTypeVariable(type, false);
        }
        if (type instanceof ParameterizedType) {
            return this.getRealNameForParameterizedType(type);
        }
        if (type instanceof GenericArrayType) {
            return this.getParameterizedName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        return null;
    }

    private Type findClassDeclarationInHierarchy(Type type, List list) {
        if (!(type instanceof TypeVariable) || list == null) {
            return null;
        }
        Object d = ((TypeVariable)type).getGenericDeclaration();
        if (d instanceof Method || d instanceof Constructor) {
            return null;
        }
        Type type2 = null;
        for (Type type3 : list) {
            if (d instanceof Class) {
                if (!this.getSimpleClassNameForType(type3).equals(this.getSimpleClassNameForType((Class)d))) continue;
                type2 = type3;
                break;
            }
            return null;
        }
        return type2;
    }

    private Map getSuperGenericMapping(Type type) {
        if (type != null) {
            HashMap hashMap = new HashMap();
            if (type instanceof ParameterizedType) {
                Type[] typeArray;
                Type type2 = ((ParameterizedType)type).getRawType();
                Class clazz = GenericMethodSignature.getClassFromTypeIfPossible(type2);
                TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
                if (typeVariableArray.length != (typeArray = ((ParameterizedType)type).getActualTypeArguments()).length) {
                    throw new MalformedParameterizedTypeException();
                }
                for (int i = 0; i < typeVariableArray.length; ++i) {
                    hashMap.put(typeVariableArray[i], typeArray[i]);
                }
            }
            return hashMap;
        }
        return null;
    }

    private Type getMappedTypeForTypeVariable(Type type, List list) {
        if (!(type instanceof TypeVariable)) {
            return null;
        }
        Type type2 = this.findClassDeclarationInHierarchy(type, list);
        Map map = this.getSuperGenericMapping(type2);
        if (map == null) {
            return null;
        }
        return (Type)map.get(type);
    }

    public String getSimpleClassNameForType(Type type) {
        Type type2;
        Class<?> clazz = null;
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            clazz = (Class<?>)type;
            int n = 0;
            while (clazz.isArray()) {
                ++n;
                clazz = clazz.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer(clazz.getName());
            if (!this.rmiSignature) {
                for (Class<?> clazz2 = clazz.getDeclaringClass(); clazz2 != null; clazz2 = clazz2.getDeclaringClass()) {
                    stringBuffer.setCharAt(clazz2.getName().length(), '.');
                }
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }
        if (type instanceof ParameterizedType && (type2 = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return ((Class)type2).getName();
        }
        return type.toString().replaceFirst("(class |interface )", "").trim();
    }

    public static Class getClassFromTypeIfPossible(Type type) {
        Type type2;
        if (type instanceof ParameterizedType && (type2 = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)type2;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static boolean hasMethodDeclared(Type type, Method method) {
        Class clazz = GenericMethodSignature.getClassFromTypeIfPossible(type);
        if (clazz != null) {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].equals(method)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDelcaredInTypes(Type type, Type[] typeArray) {
        if (type == null || typeArray == null) {
            return false;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (!typeArray[i].equals(type)) continue;
            return true;
        }
        return false;
    }
}

