/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.codegen;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import weblogic.ejb.container.ejbc.codegen.GenericMethodSignature;
import weblogic.ejb.container.ejbc.codegen.MalformedMethodSignatureException;
import weblogic.ejb.container.ejbc.codegen.MethodSignatureParser;
import weblogic.utils.PlatformConstants;
import weblogic.utils.collections.AggregateKey;

public final class MethodSignature
implements PlatformConstants {
    private static final boolean debug = false;
    private static final int MAX_LINE = 80;
    private boolean printThrowsClause = true;
    private GenericMethodSignature genericMethodSig;
    private String name;
    private Method method;
    private Class returnType;
    private Class[] parameterTypes;
    private Type[] typeParameters;
    private String[] parameterNames;
    private Class[] exceptionTypes;
    private int modifiers;

    MethodSignature() {
        this.parameterTypes = new Class[0];
        this.exceptionTypes = new Class[0];
    }

    public MethodSignature(Method method) {
        this.setMethod(method);
        this.setName(method.getName());
        this.setReturnType(method.getReturnType());
        this.setParameterTypes(method.getParameterTypes());
        this.parameterNames = new String[this.parameterTypes.length];
        for (int i = 0; i < this.parameterNames.length; ++i) {
            this.parameterNames[i] = "arg" + i;
        }
        this.setExceptionTypes(method.getExceptionTypes());
        this.setModifiers(method.getModifiers());
        GenericMethodSignature genericMethodSignature = new GenericMethodSignature(method);
        this.setGenericMethodSignature(genericMethodSignature);
    }

    public MethodSignature(Method method, Class clazz) {
        this.setMethod(method);
        this.setName(method.getName());
        this.setReturnType(method.getReturnType());
        this.setTypeParameters(method.getTypeParameters());
        this.setParameterTypes(method.getParameterTypes());
        this.parameterNames = new String[this.parameterTypes.length];
        for (int i = 0; i < this.parameterNames.length; ++i) {
            this.parameterNames[i] = "arg" + i;
        }
        this.setExceptionTypes(method.getExceptionTypes());
        this.setModifiers(method.getModifiers());
        GenericMethodSignature genericMethodSignature = new GenericMethodSignature(method, clazz);
        this.setGenericMethodSignature(genericMethodSignature);
    }

    public MethodSignature(String string) throws MalformedMethodSignatureException {
        this.exceptionTypes = new Class[0];
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(string);
        if (!methodSignatureParser.matchSignature(this)) {
            throw new MalformedMethodSignatureException(string);
        }
    }

    public void setPrintThrowsClause(boolean bl) {
        this.printThrowsClause = bl;
    }

    public Object asNameAndParamTypesKey() {
        return new AggregateKey((Object)this.name, (Object)new AggregateKey((Object[])this.parameterTypes));
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(this.modifiers & 0xFFFFFF7F & 0xFFFFFFBF)).append(" ");
        String string = stringBuffer.toString();
        int n2 = string.indexOf("strict ");
        if (n2 != -1) {
            stringBuffer.insert(n2 + "strict".length(), "fp");
        }
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            stringBuffer.append(" <");
            stringBuffer.append(this.getTypeParametersName());
            stringBuffer.append("> ");
        }
        if (this.returnType != null) {
            stringBuffer.append(this.genericMethodSig.getParameterizedName(this.getGenericReturnType())).append(" ");
        }
        stringBuffer.append(this.name).append("(");
        for (n = 0; n < this.parameterTypes.length; ++n) {
            stringBuffer.append(this.genericMethodSig.getParameterizedName(this.getGenericParameterTypes()[n])).append(" ").append(this.parameterNames[n]);
            if (n >= this.parameterTypes.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        if (this.printThrowsClause && this.exceptionTypes.length > 0) {
            n = stringBuffer.length();
            stringBuffer.append(" throws ");
            Type[] typeArray = this.getGenericExceptionTypes();
            for (int i = 0; i < this.exceptionTypes.length; ++i) {
                if (typeArray.length != this.exceptionTypes.length) {
                    stringBuffer.append(this.toJavaCode(this.exceptionTypes[i]));
                } else {
                    stringBuffer.append(this.genericMethodSig.getParameterizedName(typeArray[i]));
                }
                if (i >= this.exceptionTypes.length - 1) continue;
                stringBuffer.append(", ");
            }
            if (bl && stringBuffer.length() > 80) {
                stringBuffer.insert(n, EOL + "    ");
            }
        }
        return stringBuffer.toString();
    }

    public void setParameterNames(int n, String string) {
        this.parameterNames[n] = string;
    }

    public int getParameterIndex(String string) throws Exception {
        for (int i = 0; i < this.parameterNames.length; ++i) {
            if (!this.parameterNames[i].equals(string)) continue;
            return i;
        }
        throw new Exception("No param named " + string);
    }

    public Class getParameterType(String string) throws Exception {
        int n = this.getParameterIndex(string);
        return this.parameterTypes[n];
    }

    public String getParameterNames(int n) {
        return this.parameterNames[n];
    }

    public void setRmiSignature(boolean bl) {
        this.genericMethodSig.setRmiSignature(bl);
    }

    public String getParameterTypesAsArgs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.genericMethodSig.getParameterizedName(this.getGenericParameterTypes()[i]));
        }
        return stringBuffer.toString();
    }

    public String getParametersAsArgs() {
        StringBuffer stringBuffer = new StringBuffer(4 * this.parameterNames.length);
        for (int i = 0; i < this.parameterNames.length; ++i) {
            stringBuffer.append(this.parameterNames[i]);
            if (i >= this.parameterNames.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public GenericMethodSignature getGenericMethodSignature() {
        return this.genericMethodSig;
    }

    public void setGenericMethodSignature(GenericMethodSignature genericMethodSignature) {
        this.genericMethodSig = genericMethodSignature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class clazz) {
        this.returnType = clazz;
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public String getReturnTypeName() {
        return this.genericMethodSig.getParameterizedName(this.getGenericReturnType());
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class[] classArray) {
        this.parameterTypes = classArray;
    }

    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    public Type[] getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(Type[] typeArray) {
        this.typeParameters = typeArray;
    }

    public String getTypeParametersName() {
        if (this.typeParameters == null || this.typeParameters.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.typeParameters.length; ++i) {
            Type type = this.typeParameters[i];
            if (type instanceof TypeVariable) {
                stringBuffer.append(this.genericMethodSig.getRealNameForTypeVariable(type, true));
            }
            if (i >= this.typeParameters.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(String[] stringArray) {
        this.parameterNames = stringArray;
    }

    public int getNumberOfParameters() {
        return this.parameterTypes.length;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setExceptionTypes(Class[] classArray) {
        this.exceptionTypes = classArray;
    }

    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public void setPublic(boolean bl) {
        if (bl) {
            this.modifiers |= 1;
            this.setPrivate(false);
            this.setProtected(false);
        } else {
            this.modifiers &= 0xFFFFFFFE;
        }
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public void setPrivate(boolean bl) {
        if (bl) {
            this.modifiers |= 2;
            this.setPublic(false);
            this.setProtected(false);
        } else {
            this.modifiers &= 0xFFFFFFFD;
        }
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public void setProtected(boolean bl) {
        if (bl) {
            this.modifiers |= 4;
            this.setPublic(false);
            this.setPrivate(false);
        } else {
            this.modifiers &= 0xFFFFFFFB;
        }
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public void setStatic(boolean bl) {
        this.modifiers = bl ? (this.modifiers |= 8) : (this.modifiers &= 0xFFFFFFF7);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public void setFinal(boolean bl) {
        if (bl) {
            this.modifiers |= 0x10;
            this.setAbstract(false);
        } else {
            this.modifiers &= 0xFFFFFFEF;
        }
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public void setSynchronized(boolean bl) {
        this.modifiers = bl ? (this.modifiers |= 0x20) : (this.modifiers &= 0xFFFFFFDF);
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.modifiers);
    }

    public void setVolatile(boolean bl) {
        this.modifiers = bl ? (this.modifiers |= 0x40) : (this.modifiers &= 0xFFFFFFBF);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public void setTransient(boolean bl) {
        this.modifiers = bl ? (this.modifiers |= 0x80) : (this.modifiers &= 0xFFFFFF7F);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public void setNative(boolean bl) {
        if (bl) {
            this.modifiers |= 0x100;
            this.setAbstract(false);
        } else {
            this.modifiers &= 0xFFFFFEFF;
        }
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public void setAbstract(boolean bl) {
        if (bl) {
            this.modifiers |= 0x400;
            this.setFinal(false);
            this.setNative(false);
        } else {
            this.modifiers &= 0xFFFFFBFF;
        }
    }

    public static boolean equalsMethodsBySig(MethodSignature methodSignature, MethodSignature methodSignature2) {
        if (methodSignature == null || methodSignature2 == null) {
            return false;
        }
        if (methodSignature.getName().equals(methodSignature2.getName())) {
            if (methodSignature.getNumberOfParameters() != methodSignature2.getNumberOfParameters()) {
                return false;
            }
            if (methodSignature.getParameterTypesAsArgs().equals(methodSignature2.getParameterTypesAsArgs())) {
                return true;
            }
            for (int i = 0; i < methodSignature.getNumberOfParameters(); ++i) {
                String string;
                String string2 = methodSignature.getGenericMethodSignature().getParameterizedName(methodSignature.getGenericParameterTypes()[i]);
                if (string2.equals(string = methodSignature2.getGenericMethodSignature().getParameterizedName(methodSignature2.getGenericParameterTypes()[i])) || methodSignature.equalsParameterTypeWithClass(methodSignature.getGenericParameterTypes()[i], methodSignature2.getGenericParameterTypes()[i]) || methodSignature2.equalsParameterTypeWithClass(methodSignature2.getGenericParameterTypes()[i], methodSignature.getGenericParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equalsParameterTypeWithClass(Type type, Type type2) {
        String string;
        String string2;
        int n;
        return type2 instanceof Class && (n = (string2 = this.genericMethodSig.getParameterizedName(type)).indexOf("<")) > 0 && n < string2.length() - 1 && (string = string2.substring(0, n)).equals(((Class)type2).getName());
    }

    public static void compare(MethodSignature methodSignature, MethodSignature methodSignature2) {
        if (methodSignature.getName().equals(methodSignature2.getName())) {
            System.out.println("name ok.");
        } else {
            System.out.println(methodSignature.getName() + " != " + methodSignature2.getName());
        }
        if (methodSignature.getReturnType().equals(methodSignature2.getReturnType())) {
            System.out.println("return type ok.");
        } else {
            System.out.println(methodSignature.getReturnType() + " != " + methodSignature2.getReturnType());
        }
        if (methodSignature.getModifiers() == methodSignature2.getModifiers()) {
            System.out.println("mods ok.");
        } else {
            System.out.println(methodSignature.getModifiers() + " != " + methodSignature2.getModifiers());
        }
    }

    private String toJavaCode(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        for (Class<?> clazz2 = clazz.getDeclaringClass(); clazz2 != null; clazz2 = clazz2.getDeclaringClass()) {
            stringBuffer.setCharAt(clazz2.getName().length(), '.');
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }
}

