/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.codegen;

import java.util.ArrayList;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.utils.RecursiveDescentParser;

class MethodSignatureParser
extends RecursiveDescentParser {
    private static final boolean debug = false;
    private static final boolean verbose = false;

    public MethodSignatureParser(String string) {
        this.setSkipWhiteSpace(true);
        this.buf = string.toCharArray();
    }

    public boolean matchSignature(MethodSignature methodSignature) {
        this.startMatch();
        if (this.matchModifiers()) {
            methodSignature.setModifiers((Integer)this.oval);
        }
        if (this.matchType()) {
            methodSignature.setReturnType((Class)this.oval);
        }
        if (!this.matchID()) {
            return this.failure();
        }
        methodSignature.setName(this.sval);
        if (!this.match('(')) {
            return this.failure();
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        do {
            String string = null;
            if (!this.matchType()) break;
            Class clazz = (Class)this.oval;
            if (!this.matchID()) {
                return this.failure();
            }
            string = this.sval;
            arrayList.add(clazz);
            arrayList2.add(string);
        } while (this.match(','));
        int n = arrayList.size();
        methodSignature.setParameterTypes(arrayList.toArray(new Class[n]));
        methodSignature.setParameterNames(arrayList2.toArray(new String[n]));
        if (!this.match(')')) {
            return this.failure();
        }
        if (this.matchThrows()) {
            methodSignature.setExceptionTypes((Class[])this.oval);
        }
        return this.success();
    }

    public boolean matchID() {
        this.startMatch();
        int n = this.peek;
        if (Character.isJavaIdentifierStart(this.buf[this.peek])) {
            ++this.peek;
            int n2 = this.buf.length;
            while (this.peek < n2 && Character.isJavaIdentifierPart(this.buf[this.peek])) {
                ++this.peek;
            }
        }
        return this.peek > n ? this.success() : this.failure();
    }

    public boolean matchType() {
        this.startMatch();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.matchPrimitiveType()) {
            return this.success();
        }
        if (this.matchID()) {
            stringBuffer.append(this.sval);
        }
        while (true) {
            this.startMatch();
            if (!this.match('.') || !this.matchID()) break;
            this.success();
            stringBuffer.append(this.sval);
        }
        this.failure();
        if (stringBuffer.length() == 0) {
            return this.failure();
        }
        int n = 0;
        while (this.match("[]")) {
            ++n;
        }
        Class clazz = this.getType(stringBuffer.toString(), n);
        if (clazz != null) {
            this.oval = clazz;
            return this.success();
        }
        return this.failure();
    }

    private Class getType(String string, int n) {
        String string2 = "";
        String string3 = "";
        try {
            if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("[");
                }
                stringBuffer.append("L");
                string2 = stringBuffer.toString();
                string3 = ";";
            }
            try {
                return Class.forName(string2 + string + string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return Class.forName(string2 + "java.lang." + string + string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public boolean matchPrimitiveType() {
        this.startMatch();
        if (this.match("boolean")) {
            this.oval = Boolean.TYPE;
        } else if (this.match("byte")) {
            this.oval = Byte.TYPE;
        } else if (this.match("char")) {
            this.oval = Character.TYPE;
        } else if (this.match("double")) {
            this.oval = Double.TYPE;
        } else if (this.match("float")) {
            this.oval = Float.TYPE;
        } else if (this.match("int")) {
            this.oval = Integer.TYPE;
        } else if (this.match("long")) {
            this.oval = Long.TYPE;
        } else if (this.match("short")) {
            this.oval = Short.TYPE;
        } else if (this.match("void")) {
            this.oval = Void.TYPE;
        } else {
            return this.failure();
        }
        int n = 0;
        while (this.match("[]")) {
            ++n;
        }
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[");
            }
            if (this.oval == Boolean.TYPE) {
                stringBuffer.append("Z");
            } else if (this.oval == Byte.TYPE) {
                stringBuffer.append("B");
            } else if (this.oval == Character.TYPE) {
                stringBuffer.append("C");
            } else if (this.oval == Double.TYPE) {
                stringBuffer.append("D");
            } else if (this.oval == Float.TYPE) {
                stringBuffer.append("F");
            } else if (this.oval == Integer.TYPE) {
                stringBuffer.append("I");
            } else if (this.oval == Long.TYPE) {
                stringBuffer.append("J");
            } else if (this.oval == Short.TYPE) {
                stringBuffer.append("S");
            }
            try {
                this.oval = Class.forName(stringBuffer.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.failure();
            }
        }
        return this.success();
    }

    public boolean matchModifiers() {
        this.startMatch();
        int n = 0;
        int n2 = this.peek;
        while (true) {
            if (this.match("public")) {
                n ^= 1;
                continue;
            }
            if (this.match("protected")) {
                n ^= 4;
                continue;
            }
            if (this.match("private")) {
                n ^= 2;
                continue;
            }
            if (this.match("abstract")) {
                n ^= 0x400;
                continue;
            }
            if (this.match("static")) {
                n ^= 8;
                continue;
            }
            if (this.match("final")) {
                n ^= 0x10;
                continue;
            }
            if (this.match("synchronized")) {
                n ^= 0x20;
                continue;
            }
            if (!this.match("native")) break;
            n ^= 0x100;
        }
        if (this.peek > n2) {
            this.oval = new Integer(n);
            return this.success();
        }
        return this.failure();
    }

    public boolean matchThrows() {
        this.startMatch();
        if (this.match("throws")) {
            int n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (this.matchType()) {
                arrayList.add(this.oval);
                if (this.match(',')) continue;
            }
            if ((n = arrayList.size()) > 0) {
                this.oval = arrayList.toArray(new Class[n]);
                return this.success();
            }
        }
        return this.failure();
    }
}

