/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.injection;

import com.oracle.pitchfork.interfaces.EnvironmentInterceptorCallback;
import com.oracle.pitchfork.interfaces.MetadataParseException;
import com.oracle.pitchfork.interfaces.ejb.BeanType;
import com.oracle.pitchfork.interfaces.ejb.EjbProxyMetadataI;
import com.oracle.pitchfork.interfaces.inject.DeploymentUnitMetadataI;
import com.oracle.pitchfork.interfaces.inject.EnricherI;
import com.oracle.pitchfork.interfaces.inject.Jsr250MetadataI;
import com.oracle.pitchfork.interfaces.inject.LifecycleEvent;
import com.oracle.pitchfork.interfaces.intercept.InterceptionMetadataI;
import com.oracle.pitchfork.interfaces.intercept.InterceptorMetadataI;
import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.MessageDrivenBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.interceptor.InvocationContext;
import weblogic.ejb.container.deployer.NamingConvention;
import weblogic.ejb.container.injection.EnvironmentInterceptorCallbackImpl;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.interfaces.WLSessionBean;
import weblogic.ejb.spi.SessionBeanInfo;
import weblogic.j2ee.descriptor.AroundInvokeBean;
import weblogic.j2ee.descriptor.EjbCallbackBean;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.InterceptorBindingBean;
import weblogic.j2ee.descriptor.J2eeEnvironmentBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.injection.J2eeComponentContributor;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.utils.collections.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbComponentContributor
extends J2eeComponentContributor {
    private final DeploymentInfo dinfo;
    private boolean defaultInterceptorAdded = false;
    private ConcurrentHashMap metadataMap = new ConcurrentHashMap();

    public EjbComponentContributor(DeploymentInfo deploymentInfo, PitchforkContext pitchforkContext) {
        super(pitchforkContext);
        this.dinfo = deploymentInfo;
    }

    public EjbComponentContributor(DeploymentInfo deploymentInfo, ClassLoader classLoader, PitchforkContext pitchforkContext) {
        this(deploymentInfo, pitchforkContext);
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    public void contribute(EnricherI enricherI) {
        String string;
        String string2;
        BeanInfo beanInfo;
        EjbJarBean ejbJarBean = this.dinfo.getEjbDescriptorBean().getEjbJarBean();
        for (SessionBeanBean sessionBeanBean : ejbJarBean.getEnterpriseBeans().getSessions()) {
            beanInfo = this.dinfo.getBeanInfo(sessionBeanBean.getEjbName());
            if (!beanInfo.isEJB30()) continue;
            string2 = sessionBeanBean.getEjbName();
            string = this.getEjbClassName(beanInfo);
            this.debug("Convert environmentGroupBean to jsr250Metadata for EJB : " + string2);
            this.contribute(enricherI, string2, string, (J2eeEnvironmentBean)sessionBeanBean);
        }
        for (SessionBeanBean sessionBeanBean : ejbJarBean.getEnterpriseBeans().getMessageDrivens()) {
            beanInfo = this.dinfo.getBeanInfo(sessionBeanBean.getEjbName());
            if (!beanInfo.isEJB30()) continue;
            string2 = sessionBeanBean.getEjbName();
            string = this.getEjbClassName(beanInfo);
            this.debug("Convert environmentGroupBean to jsr250Metadata for EJB : " + string2);
            this.contribute(enricherI, string2, string, (J2eeEnvironmentBean)sessionBeanBean);
        }
    }

    public Jsr250MetadataI newJsr250Metadata(String string, Class<?> clazz, DeploymentUnitMetadataI deploymentUnitMetadataI) {
        EnvironmentInterceptorCallbackImpl environmentInterceptorCallbackImpl = new EnvironmentInterceptorCallbackImpl();
        EjbProxyMetadataI ejbProxyMetadataI = this.pitchforkContext.getPitchforkUtils().createEjbProxyMetadata(string, clazz, deploymentUnitMetadataI, (EnvironmentInterceptorCallback)environmentInterceptorCallbackImpl);
        BeanInfo beanInfo = this.dinfo.getBeanInfo(string);
        if (beanInfo.isSessionBean()) {
            if (((SessionBeanInfo)((Object)beanInfo)).isStateful()) {
                ejbProxyMetadataI.setBeanType(BeanType.STATEFUL);
            } else {
                ejbProxyMetadataI.setBeanType(BeanType.STATELESS);
            }
        } else if (!beanInfo.isEntityBean()) {
            ejbProxyMetadataI.setBeanType(BeanType.MESSAGE_DRIVEN);
        }
        this.metadataMap.put((Object)string, (Object)ejbProxyMetadataI);
        return ejbProxyMetadataI;
    }

    public Jsr250MetadataI getMetadata(String string) {
        return (Jsr250MetadataI)this.metadataMap.get((Object)string);
    }

    public ConcurrentHashMap getMetadataMap() {
        return this.metadataMap;
    }

    private String getEjbClassName(BeanInfo beanInfo) {
        String string = beanInfo instanceof ClientDrivenBeanInfo ? ((ClientDrivenBeanInfo)beanInfo).getGeneratedBeanClassName() : (beanInfo instanceof MessageDrivenBeanInfo && ((MessageDrivenBeanInfo)beanInfo).isIndirectlyImplMessageListener() ? ((MessageDrivenBeanInfo)beanInfo).getGeneratedBeanClassName() : beanInfo.getBeanClassName());
        return string;
    }

    private Set<Class> getEjbIntfClasses(BeanInfo beanInfo) {
        HashSet<Class> hashSet = new HashSet<Class>();
        if (beanInfo instanceof ClientDrivenBeanInfo) {
            ClientDrivenBeanInfo clientDrivenBeanInfo;
            if (beanInfo instanceof Ejb3SessionBeanInfo) {
                clientDrivenBeanInfo = (Ejb3SessionBeanInfo)beanInfo;
                if (clientDrivenBeanInfo.hasBusinessLocals()) {
                    hashSet.addAll(clientDrivenBeanInfo.getBusinessLocals());
                }
                if (clientDrivenBeanInfo.hasBusinessRemotes()) {
                    hashSet.addAll(clientDrivenBeanInfo.getBusinessRemotes());
                }
            }
            if ((clientDrivenBeanInfo = (ClientDrivenBeanInfo)beanInfo).getLocalInterfaceClass() != null) {
                hashSet.add(clientDrivenBeanInfo.getLocalInterfaceClass());
            }
            if (clientDrivenBeanInfo.getRemoteInterfaceClass() != null) {
                hashSet.add(clientDrivenBeanInfo.getRemoteInterfaceClass());
            }
        } else if (beanInfo instanceof MessageDrivenBeanInfo) {
            hashSet.add(((MessageDrivenBeanInfo)beanInfo).getMessagingTypeInterfaceClass());
        } else {
            throw new MetadataParseException(beanInfo.getBeanClassName() + " is unknow bean type.");
        }
        return hashSet;
    }

    private Set<Method> getBeanControlInterfaceMethods(Class clazz, Set<Class> set) {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (Class clazz2 : set) {
            this.addBeanControlInterfaceMethods(clazz, hashSet, clazz2);
        }
        return hashSet;
    }

    private void addBeanControlInterfaceMethods(Class clazz, Set<Method> set, Class clazz2) {
        for (Method genericDeclaration : clazz2.getDeclaredMethods()) {
            try {
                set.add(clazz.getMethod(genericDeclaration.getName(), genericDeclaration.getParameterTypes()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (GenericDeclaration genericDeclaration : clazz2.getInterfaces()) {
            this.addBeanControlInterfaceMethods(clazz, set, (Class)genericDeclaration);
        }
    }

    private void addBeanControlInterfaceMethodsForWebService(Class clazz, Set<Method> set, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Method method = ((MethodInfo)iterator.next()).getMethod();
            try {
                set.add(clazz.getMethod(method.getName(), method.getParameterTypes()));
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void contribute(Jsr250MetadataI jsr250MetadataI, J2eeEnvironmentBean j2eeEnvironmentBean) {
        this.buildInterceptionMetadata((InterceptionMetadataI)jsr250MetadataI, j2eeEnvironmentBean);
    }

    private void buildInterceptionMetadata(InterceptionMetadataI interceptionMetadataI, J2eeEnvironmentBean j2eeEnvironmentBean) {
        String string;
        Object object;
        String string2 = null;
        String string3 = null;
        AroundInvokeBean[] aroundInvokeBeanArray = null;
        BeanInfo beanInfo = this.dinfo.getBeanInfo(interceptionMetadataI.getComponentName());
        Class clazz = null;
        if (j2eeEnvironmentBean instanceof SessionBeanBean) {
            object = (SessionBeanBean)j2eeEnvironmentBean;
            string2 = object.getEjbName();
            string3 = object.getEjbClass();
            aroundInvokeBeanArray = object.getAroundInvokes();
            clazz = ((ClientDrivenBeanInfo)beanInfo).getGeneratedBeanInterface();
            if (beanInfo.getTimeoutMethod() != null) {
                string = beanInfo.getTimeoutMethod().getName();
                ((EjbProxyMetadataI)interceptionMetadataI).setTimeoutMethodName(string);
            }
        } else if (j2eeEnvironmentBean instanceof MessageDrivenBeanBean) {
            object = (MessageDrivenBeanBean)j2eeEnvironmentBean;
            string2 = object.getEjbName();
            string3 = object.getEjbClass();
            aroundInvokeBeanArray = object.getAroundInvokes();
            clazz = ((MessageDrivenBeanInfo)beanInfo).getMessagingTypeInterfaceClass();
            if (beanInfo.getTimeoutMethod() != null) {
                string = beanInfo.getTimeoutMethod().getName();
                ((EjbProxyMetadataI)interceptionMetadataI).setTimeoutMethodName(string);
            }
        } else {
            throw new MetadataParseException("Bean: " + j2eeEnvironmentBean + " is not a SessionBean or MessageDrivenBean.");
        }
        object = this.getEjbIntfClasses(beanInfo);
        List list = interceptionMetadataI.findBusinessInterfacesFromClassOrAnnotation(interceptionMetadataI.getComponentClass());
        if (j2eeEnvironmentBean instanceof SessionBeanBean) {
            list.removeAll((Collection<?>)object);
            if (!list.contains(SessionBean.class)) {
                list.add(SessionBean.class);
            }
        } else if (j2eeEnvironmentBean instanceof MessageDrivenBeanBean && !list.contains(MessageDrivenBean.class)) {
            list.add(MessageDrivenBean.class);
        }
        list.remove(clazz);
        for (Object object2 : list) {
            interceptionMetadataI.addBusinessInterface((Class)object2);
        }
        Set<Method> set = this.getBeanControlInterfaceMethods(clazz, (Set<Class>)object);
        if (j2eeEnvironmentBean instanceof SessionBeanBean && ((ClientDrivenBeanInfo)beanInfo).hasWebserviceClientView()) {
            Object object2;
            object2 = ((ClientDrivenBeanInfo)beanInfo).getAllWebserviceMethodInfos();
            this.addBeanControlInterfaceMethodsForWebService(clazz, set, (Collection)object2);
        }
        interceptionMetadataI.setBeanControlInterface(clazz);
        interceptionMetadataI.setBeanControlInterfaceMethods((Set)set);
        if (beanInfo.isSessionBean()) {
            interceptionMetadataI.getDeploymentUnitMetadata().registerContainerControlInterface(WLSessionBean.class);
            interceptionMetadataI.getDeploymentUnitMetadata().registerContainerControlInterface(WLEnterpriseBean.class);
            if (SessionSynchronization.class.isAssignableFrom(interceptionMetadataI.getComponentClass())) {
                interceptionMetadataI.getDeploymentUnitMetadata().registerContainerControlInterface(SessionSynchronization.class);
            }
        } else {
            interceptionMetadataI.getDeploymentUnitMetadata().registerContainerControlInterface(WLEnterpriseBean.class);
        }
        this.addDefaultInterceptors(interceptionMetadataI, this.dinfo.getEjbDescriptorBean().getEjbJarBean());
        this.addClassLevelInterceptors(interceptionMetadataI, this.dinfo.getEjbDescriptorBean().getEjbJarBean(), string2, interceptionMetadataI.getComponentClass());
        this.addMethodLevelInterceptors(interceptionMetadataI, this.dinfo.getEjbDescriptorBean().getEjbJarBean(), string2, clazz);
        this.addSelfInterceptors(interceptionMetadataI, aroundInvokeBeanArray, string3);
    }

    private void addDefaultInterceptors(InterceptionMetadataI interceptionMetadataI, EjbJarBean ejbJarBean) {
        if (this.defaultInterceptorAdded) {
            return;
        }
        if (ejbJarBean.getAssemblyDescriptor() == null) {
            this.defaultInterceptorAdded = true;
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (InterceptorBindingBean interceptorBindingBean : ejbJarBean.getAssemblyDescriptor().getInterceptorBindings()) {
            if (!"*".equals(interceptorBindingBean.getEjbName())) continue;
            String[] stringArray = null;
            stringArray = interceptorBindingBean.getInterceptorOrder() != null ? interceptorBindingBean.getInterceptorOrder().getInterceptorClasses() : interceptorBindingBean.getInterceptorClasses();
            for (String string : stringArray) {
                if (hashSet.contains(string)) continue;
                InterceptorMetadataI interceptorMetadataI = this.createInterceptorMetadata(string, null);
                interceptorMetadataI.setDefaultInterceptor(true);
                interceptionMetadataI.getDeploymentUnitMetadata().registerDefaultInterceptorMetadata(interceptorMetadataI);
                hashSet.add(string);
            }
        }
        this.defaultInterceptorAdded = true;
    }

    private void addClassLevelInterceptors(InterceptionMetadataI interceptionMetadataI, EjbJarBean ejbJarBean, String string, Class clazz) {
        if (ejbJarBean.getAssemblyDescriptor() == null) {
            return;
        }
        for (InterceptorBindingBean interceptorBindingBean : ejbJarBean.getAssemblyDescriptor().getInterceptorBindings()) {
            if (!string.equals(interceptorBindingBean.getEjbName()) || interceptorBindingBean.getMethod() != null) continue;
            if (interceptorBindingBean.getInterceptorOrder() != null) {
                this.createInterceptorOrder(interceptionMetadataI, interceptorBindingBean, null);
                continue;
            }
            for (String string2 : interceptorBindingBean.getInterceptorClasses()) {
                InterceptorMetadataI interceptorMetadataI = this.createInterceptorMetadata(string2, null);
                interceptorMetadataI.setClassInterceptor(true);
                interceptionMetadataI.registerInterceptorMetadata(interceptorMetadataI);
            }
            this.setExcludeInterceptors(interceptorBindingBean, interceptionMetadataI, clazz);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addMethodLevelInterceptors(InterceptionMetadataI interceptionMetadataI, EjbJarBean ejbJarBean, String string, Class clazz) {
        if (ejbJarBean.getAssemblyDescriptor() == null) {
            return;
        }
        for (InterceptorBindingBean interceptorBindingBean : ejbJarBean.getAssemblyDescriptor().getInterceptorBindings()) {
            if (!string.equals(interceptorBindingBean.getEjbName()) || interceptorBindingBean.getMethod() == null) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (interceptorBindingBean.getMethod().getMethodParams() == null) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!interceptorBindingBean.getMethod().getMethodName().equals(method.getName())) continue;
                    arrayList.add(method);
                }
            } else {
                void var11_14;
                Object object = null;
                String[] stringArray = new String[]{};
                if (interceptorBindingBean.getMethod().getMethodParams() != null) {
                    String[] method = interceptorBindingBean.getMethod().getMethodParams().getMethodParams();
                }
                Class[] classArray = new Class[((void)var11_14).length];
                int n = 0;
                for (void var17_27 : var11_14) {
                    classArray[n] = this.forName((String)var17_27, this.classLoader);
                    ++n;
                }
                object = this.getDeclaredMethod(clazz, interceptorBindingBean.getMethod().getMethodName(), classArray);
                arrayList.add(object);
            }
            for (Method method : arrayList) {
                if (interceptorBindingBean.getInterceptorOrder() != null) {
                    this.createInterceptorOrder(interceptionMetadataI, interceptorBindingBean, method);
                    continue;
                }
                for (String string2 : interceptorBindingBean.getInterceptorClasses()) {
                    InterceptorMetadataI interceptorMetadataI = this.createInterceptorMetadata(string2, method);
                    interceptionMetadataI.registerInterceptorMetadata(interceptorMetadataI);
                }
                this.setExcludeInterceptors(interceptorBindingBean, interceptionMetadataI, method);
            }
        }
    }

    private void addSelfInterceptors(InterceptionMetadataI interceptionMetadataI, AroundInvokeBean[] aroundInvokeBeanArray, String string) {
        for (AroundInvokeBean aroundInvokeBean : aroundInvokeBeanArray) {
            Class clazz = aroundInvokeBean.getClassName() != null ? this.loadClass(aroundInvokeBean.getClassName(), this.classLoader) : this.loadClass(string, this.classLoader);
            Method method = this.getDeclaredMethod(clazz, aroundInvokeBean.getMethodName(), InvocationContext.class);
            interceptionMetadataI.registerSelfInterceptorMethod(method);
        }
    }

    private void createInterceptorOrder(InterceptionMetadataI interceptionMetadataI, InterceptorBindingBean interceptorBindingBean, Method method) {
        for (String string : interceptorBindingBean.getInterceptorOrder().getInterceptorClasses()) {
            InterceptorMetadataI interceptorMetadataI = this.createInterceptorMetadata(string, method);
            GenericDeclaration genericDeclaration = null;
            genericDeclaration = method != null ? method : interceptionMetadataI.getComponentClass();
            interceptionMetadataI.registerInterceptorOrder(interceptorMetadataI, (Object)genericDeclaration);
        }
    }

    private InterceptorMetadataI createInterceptorMetadata(String string, Method method) {
        Object object;
        Class clazz = this.loadClass(string, this.classLoader);
        InterceptorBean interceptorBean = null;
        InterceptorBean[] interceptorBeanArray = this.dinfo.getEjbDescriptorBean().getEjbJarBean().getInterceptors().getInterceptors();
        for (InterceptorBean interceptorBean2 : interceptorBeanArray) {
            if (!clazz.getName().equals(interceptorBean2.getInterceptorClass())) continue;
            interceptorBean = interceptorBean2;
        }
        this.debug("+++++adding interceptor=" + clazz.getName() + " on method " + method);
        ArrayList arrayList = new ArrayList();
        for (AroundInvokeBean aroundInvokeBean : interceptorBean.getAroundInvokes()) {
            Class clazz2 = clazz.getName().equals(aroundInvokeBean.getClassName()) ? clazz : this.loadClass(aroundInvokeBean.getClassName(), this.classLoader);
            arrayList.add(this.getDeclaredMethod(clazz2, aroundInvokeBean.getMethodName(), InvocationContext.class));
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            object = new NamingConvention(string);
            clazz = this.loadClass(((NamingConvention)object).getInterceptorImplClassName(), this.classLoader);
        }
        object = this.pitchforkContext.getPitchforkUtils().createInterceptorMetadata(clazz, (List)arrayList, method);
        this.buildInjectionMetadata((Jsr250MetadataI)object, (J2eeEnvironmentBean)interceptorBean);
        this.addLifecycleMethods((Jsr250MetadataI)object, (J2eeEnvironmentBean)interceptorBean, true);
        return object;
    }

    private void setExcludeInterceptors(InterceptorBindingBean interceptorBindingBean, InterceptionMetadataI interceptionMetadataI, Object object) {
        if (interceptorBindingBean.isExcludeClassInterceptors()) {
            interceptionMetadataI.setExcludeClassInterceptors(object);
            this.debug("-----excludeClassInterceptors for " + object);
        }
        if (interceptorBindingBean.isExcludeDefaultInterceptors()) {
            interceptionMetadataI.setExcludeDefaultInterceptors(object);
            this.debug("-----excludeDefaultInterceptors for " + object);
        }
    }

    @Override
    protected void addLifecycleMethods(Jsr250MetadataI jsr250MetadataI, J2eeEnvironmentBean j2eeEnvironmentBean) {
        this.addLifecycleMethods(jsr250MetadataI, j2eeEnvironmentBean, false);
    }

    protected void addLifecycleMethods(Jsr250MetadataI jsr250MetadataI, J2eeEnvironmentBean j2eeEnvironmentBean, boolean bl) {
        int n;
        Object object;
        super.addLifecycleMethods(jsr250MetadataI, j2eeEnvironmentBean);
        if (j2eeEnvironmentBean instanceof EjbCallbackBean) {
            object = (EjbCallbackBean)j2eeEnvironmentBean;
            for (LifecycleCallbackBean lifecycleCallbackBean : object.getPostActivates()) {
                this.addLifecycleMethods(jsr250MetadataI, lifecycleCallbackBean, LifecycleEvent.POST_ACTIVATE);
            }
            LifecycleCallbackBean[] lifecycleCallbackBeanArray = object.getPrePassivates();
            n = lifecycleCallbackBeanArray.length;
            for (int i = 0; i < n; ++i) {
                LifecycleCallbackBean lifecycleCallbackBean;
                lifecycleCallbackBean = lifecycleCallbackBeanArray[i];
                this.addLifecycleMethods(jsr250MetadataI, lifecycleCallbackBean, LifecycleEvent.PRE_PASSIVATE);
            }
        }
        if (bl) {
            return;
        }
        object = this.dinfo.getBeanInfo(jsr250MetadataI.getComponentName());
        boolean bl2 = object.isSessionBean() && ((SessionBeanInfo)object).isStateful();
        this.addEjb21LifecycleMethods(jsr250MetadataI, LifecycleEvent.POST_CONSTRUCT, "ejbCreate", bl2);
        int n2 = n = SessionBean.class.isAssignableFrom(object.getBeanClass()) || MessageDrivenBean.class.isAssignableFrom(object.getBeanClass()) ? 1 : 0;
        if (n != 0) {
            this.addEjb21LifecycleMethods(jsr250MetadataI, LifecycleEvent.PRE_DESTROY, "ejbRemove", bl2);
            if (bl2) {
                this.addEjb21LifecycleMethods(jsr250MetadataI, LifecycleEvent.POST_ACTIVATE, "ejbActivate", bl2);
                this.addEjb21LifecycleMethods(jsr250MetadataI, LifecycleEvent.PRE_PASSIVATE, "ejbPassivate", bl2);
            }
        }
    }

    private void addEjb21LifecycleMethods(Jsr250MetadataI jsr250MetadataI, LifecycleEvent lifecycleEvent, String string, boolean bl) {
        Method method = null;
        for (Method method2 : jsr250MetadataI.getComponentClass().getDeclaredMethods()) {
            if (!string.equals(method2.getName()) || method2.getParameterTypes().length != 0) continue;
            method = method2;
            break;
        }
        if (method != null) {
            if ("ejbCreate".equals(string) && (method.getAnnotation(PostConstruct.class) != null || bl)) {
                return;
            }
            this.debug("+++++adding ejb2.x callbackMethod=" + string + " for bean " + jsr250MetadataI.getComponentName());
            jsr250MetadataI.registerLifecycleEventCallbackMethod(lifecycleEvent, method);
        }
    }

    @Override
    protected void debug(String string) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("[EjbComponentContributor] " + string);
        }
    }
}

