/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.injection;

import com.oracle.pitchfork.interfaces.EjbComponentCreatorBroker;
import com.oracle.pitchfork.interfaces.PitchforkRuntimeMode;
import com.oracle.pitchfork.interfaces.inject.ComponentContributor;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.injection.EjbComponentContributor;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.EjbComponentCreator;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.management.DeploymentException;
import weblogic.utils.StackTraceUtils;

public class EjbComponentCreatorImpl
implements EjbComponentCreator {
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    public static final String SPRING_EJB_JAR_XML_LOCATION = "/META-INF/spring-ejb-jar.xml";
    private PitchforkContext pitchforkContext;
    private EjbComponentCreatorBroker ejbComponentCreatorBroker;

    public EjbComponentCreatorImpl(PitchforkContext pitchforkContext) {
        this.pitchforkContext = pitchforkContext;
        this.ejbComponentCreatorBroker = pitchforkContext.getPitchforkUtils().createEjbComponentCreatorBroker();
    }

    public void initialize(DeploymentInfo deploymentInfo, ClassLoader classLoader) throws DeploymentException {
        PitchforkRuntimeMode pitchforkRuntimeMode = this.pitchforkContext.getPitchforkRuntimeMode();
        EjbComponentContributor ejbComponentContributor = new EjbComponentContributor(deploymentInfo, classLoader, this.pitchforkContext);
        try {
            this.ejbComponentCreatorBroker.initialize(classLoader, SPRING_EJB_JAR_XML_LOCATION, (ComponentContributor)ejbComponentContributor, pitchforkRuntimeMode);
        }
        catch (Throwable throwable) {
            this.debug("Exception when creating spring bean factory " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            throw new DeploymentException(throwable);
        }
    }

    public Object getBean(String string, Class clazz, boolean bl) throws IllegalAccessException, InstantiationException {
        return this.ejbComponentCreatorBroker.getBean(string, clazz, bl);
    }

    public void invokePostConstruct(Object object) {
        this.ejbComponentCreatorBroker.invokePostConstruct(object);
    }

    public Object assembleEJB3Proxy(Object object, String string) {
        return this.ejbComponentCreatorBroker.assembleEJB3Proxy(object, string);
    }

    protected void debug(String string) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("[EjbComponentCreatorImpl] " + string);
        }
    }
}

