/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import weblogic.ejb.container.EJBLogger;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.internal.NamingNode;
import weblogic.logging.Loggable;
import weblogic.rjvm.JVMID;

public class AggregatableOpaqueReference
implements OpaqueReference,
Aggregatable {
    private static final long serialVersionUID = 464050940789719368L;
    private final String uniqueEJBIdentifier;
    private final String interfaceName;
    private final Object referent;
    private final Set serverIDs = new HashSet();
    private Object serverID;
    private transient Map serverIdToReferent;
    private static final Object localServerID = JVMID.localID();

    public AggregatableOpaqueReference(String string, String string2, Object object) {
        this.uniqueEJBIdentifier = string;
        this.interfaceName = string2;
        this.referent = object;
        this.serverID = localServerID;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getUniqueEJBIdentifier() {
        return this.uniqueEJBIdentifier;
    }

    public Object getServerID() {
        return this.serverID;
    }

    public Object getReferentInstance() {
        return this.referent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        AggregatableOpaqueReference aggregatableOpaqueReference;
        if (aggregatable != null) {
            this.validateAdditionalBinding(string, aggregatable);
        }
        if ((aggregatableOpaqueReference = (AggregatableOpaqueReference)aggregatable) == null) {
            aggregatableOpaqueReference = this;
        }
        AggregatableOpaqueReference aggregatableOpaqueReference2 = this;
        synchronized (aggregatableOpaqueReference2) {
            if (this.serverIdToReferent == null) {
                this.serverIdToReferent = new HashMap();
            }
            this.serverIdToReferent.put(aggregatableOpaqueReference.getServerID(), aggregatableOpaqueReference.getReferentInstance());
            this.serverIDs.add(aggregatableOpaqueReference.getServerID());
        }
    }

    public void onRebind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        this.onBind(namingNode, string, aggregatable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        Object object = null;
        object = aggregatable == null ? localServerID : ((AggregatableOpaqueReference)aggregatable).getServerID();
        AggregatableOpaqueReference aggregatableOpaqueReference = this;
        synchronized (aggregatableOpaqueReference) {
            this.serverIdToReferent.remove(object);
            this.serverIDs.remove(object);
        }
        return this.serverIDs.isEmpty();
    }

    public Object getReferent(Name name, Context context) throws NamingException {
        Object object;
        if (this.serverIdToReferent == null) {
            this.serverIdToReferent = new HashMap();
        }
        if ((object = this.serverIdToReferent.get(localServerID)) == null) {
            Iterator iterator = this.serverIdToReferent.values().iterator();
            if (iterator.hasNext()) {
                Object v = iterator.next();
                object = v;
            }
            if (object == null) {
                object = this.referent;
            }
        }
        if (object instanceof OpaqueReference) {
            return ((OpaqueReference)object).getReferent(name, context);
        }
        return object;
    }

    public String toString() {
        return "AggregatableOpaqueReference for interface " + this.interfaceName + " of EJB " + this.uniqueEJBIdentifier;
    }

    private void validateAdditionalBinding(String string, Object object) throws NameAlreadyBoundException {
        if (!(object instanceof AggregatableOpaqueReference)) {
            throw new NameAlreadyBoundException();
        }
        AggregatableOpaqueReference aggregatableOpaqueReference = (AggregatableOpaqueReference)object;
        if (!this.uniqueEJBIdentifier.equals(aggregatableOpaqueReference.getUniqueEJBIdentifier())) {
            Loggable loggable = EJBLogger.logAlreadyBindInterfaceWithNameLoggable((String)aggregatableOpaqueReference.getInterfaceName(), (String)string);
            throw new NameAlreadyBoundException(loggable.getMessage());
        }
        if (!this.interfaceName.equals(aggregatableOpaqueReference.getInterfaceName())) {
            Loggable loggable = EJBLogger.logAnotherInterfaceBindWithNameLoggable((String)aggregatableOpaqueReference.getInterfaceName(), (String)string);
            throw new NameAlreadyBoundException(loggable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        AggregatableOpaqueReference aggregatableOpaqueReference = this;
        synchronized (aggregatableOpaqueReference) {
            objectOutputStream.defaultWriteObject();
        }
    }
}

