/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import weblogic.ejb.WLTimerService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.WLEJBContext;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.BaseEJBHome;
import weblogic.ejb.container.internal.BaseEJBLocalHome;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.RuntimeHelper;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.internal.TimerServiceImpl;
import weblogic.ejb.container.internal.usertransactioncheck.BaseUserTransactionProxy;
import weblogic.ejb.container.internal.usertransactioncheck.MDBUserTransactionProxy;
import weblogic.ejb.container.internal.usertransactioncheck.SFSBUserTransactionProxy;
import weblogic.ejb.container.internal.usertransactioncheck.SLSBUserTransactionProxy;
import weblogic.ejb.container.manager.BaseEJBManager;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb.container.manager.MessageDrivenManager;
import weblogic.ejb.container.manager.StatefulSessionManager;
import weblogic.ejb.container.manager.StatelessManager;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.logging.Loggable;
import weblogic.security.acl.User;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.StackTraceUtils;

public abstract class BaseEJBContext
implements WLEJBContext {
    protected final BaseEJBHomeIntf ejbHome;
    protected final EJBHome remoteHome;
    protected final BaseEJBLocalHome localHome;
    protected final BeanManager beanManager;
    protected EJBObject ejbObject;
    protected EJBLocalObject ejbLocalObject;
    private TimerService timerService;
    private EnterpriseBean bean;
    private Context compEnv;
    private boolean isSession = false;
    private boolean isStateless = false;
    private boolean isStateful = false;
    private boolean isEntity = false;
    private boolean isMessageDriven = false;

    BaseEJBContext(EnterpriseBean enterpriseBean, BeanManager beanManager, BaseEJBHome baseEJBHome, BaseEJBLocalHome baseEJBLocalHome, EJBObject eJBObject, EJBLocalObject eJBLocalObject) {
        this.bean = enterpriseBean;
        this.beanManager = beanManager;
        this.localHome = baseEJBLocalHome;
        this.ejbObject = eJBObject;
        this.ejbLocalObject = eJBLocalObject;
        this.ejbHome = baseEJBHome != null ? baseEJBHome : this.localHome;
        this.setBeanType();
        this.remoteHome = baseEJBHome != null && !baseEJBHome.getBeanInfo().useCallByReference() ? baseEJBHome.getCBVHomeStub() : baseEJBHome;
    }

    private void setBeanType() {
        if (this.beanManager instanceof StatelessManager) {
            this.isSession = true;
            this.isStateless = true;
        } else if (this.beanManager instanceof StatefulSessionManager) {
            this.isSession = true;
            this.isStateful = true;
        } else if (this.beanManager instanceof BaseEntityManager) {
            this.isEntity = true;
        } else if (this.beanManager instanceof MessageDrivenManager) {
            this.isMessageDriven = true;
        } else {
            throw new AssertionError((Object)("Unexpected manager type: " + this.beanManager.getClass().getName()));
        }
    }

    protected void checkAllowedMethod(int n) throws IllegalStateException {
        int n2;
        if (!this.isMessageDriven && ((n2 = RuntimeHelper.getCurrentState(this.bean)) & n) == 0) {
            Loggable loggable = EJBLogger.logillegalCallToEJBContextMethodLoggable((String)EJBRuntimeUtils.getEJBStateAsString(n2), (String)EJBRuntimeUtils.ejbEJBOperationAsString(n));
            throw new IllegalStateException(loggable.getMessage());
        }
    }

    public void setBean(EnterpriseBean enterpriseBean) {
        this.bean = enterpriseBean;
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        UserTransaction userTransaction = null;
        if (!this.beanManager.usesBeanManagedTx()) {
            Loggable loggable = EJBLogger.logbmtCanUseUserTransactionLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        this.checkAllowedMethod(196852);
        userTransaction = TxHelper.getUserTransaction();
        if (this.isEntity) {
            return new BaseUserTransactionProxy(true, userTransaction);
        }
        if (this.isMessageDriven) {
            return new MDBUserTransactionProxy(userTransaction);
        }
        if (this.isSession && this.isStateful) {
            return new SFSBUserTransactionProxy(userTransaction);
        }
        return new SLSBUserTransactionProxy(userTransaction);
    }

    public Identity getCallerIdentity() {
        if (this.isStateful) {
            this.checkAllowedMethod(2036);
        } else if (this.isStateless) {
            this.checkAllowedMethod(196736);
        } else if (this.isEntity) {
            this.checkAllowedMethod(125084);
        }
        Principal principal = this.getCallerPrincipal();
        String string = principal.getName();
        return new User(principal.getName());
    }

    public Principal getCallerPrincipal() {
        Principal principal;
        if (this.isStateful) {
            this.checkAllowedMethod(2036);
        } else if (this.isStateless) {
            this.checkAllowedMethod(196736);
        } else if (this.isEntity) {
            this.checkAllowedMethod(125084);
        }
        try {
            if (this.bean instanceof WLEnterpriseBean && ((WLEnterpriseBean)this.bean).__WL_getMethodState() == 32768) {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)((WLEnterpriseBean)this.bean).__WL_getLoadUser();
                Principal principal2 = SecurityHelper.getPrincipalFromSubject(authenticatedSubject);
                if (principal2 == null) {
                    String string = "getCallerPrincipal";
                    Loggable loggable = EJBLogger.logmissingCallerPrincipalLoggable((String)string);
                    throw new PrincipalNotFoundException(loggable.getMessage());
                }
                return principal2;
            }
            principal = SecurityHelper.getCallerPrincipal();
        }
        catch (PrincipalNotFoundException principalNotFoundException) {
            throw new EJBException((Exception)((Object)principalNotFoundException));
        }
        return principal;
    }

    public EJBHome getEJBHome() {
        this.checkAllowedMethod(258047);
        return this.remoteHome;
    }

    public EJBLocalHome getEJBLocalHome() {
        this.checkAllowedMethod(258047);
        return this.localHome;
    }

    public EJBObject getEJBObject() {
        if (this.remoteHome == null) {
            Loggable loggable = EJBLogger.logonlyRemoteCanInvokeGetEJBObjectLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (this.isSession) {
            this.checkAllowedMethod(198644);
        } else if (this.isEntity) {
            this.checkAllowedMethod(114936);
        }
        return this.ejbObject;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        if (this.localHome == null) {
            Loggable loggable = EJBLogger.logonlyLocalCanInvokeGetEJBObjectLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (this.isSession) {
            this.checkAllowedMethod(198644);
        } else if (this.isEntity) {
            this.checkAllowedMethod(114936);
        }
        return this.ejbLocalObject;
    }

    public void setEJBObject(EJBObject eJBObject) {
        this.ejbObject = eJBObject;
    }

    public void setEJBLocalObject(EJBLocalObject eJBLocalObject) {
        this.ejbLocalObject = eJBLocalObject;
    }

    public String getApplicationName() {
        return this.ejbHome.getDeploymentInfo().getApplicationName();
    }

    public String getComponentName() {
        return this.beanManager.getBeanInfo().getComponentName();
    }

    public String getComponentURI() {
        return this.beanManager.getBeanInfo().getComponentURI();
    }

    public String getEJBName() {
        return this.beanManager.getBeanInfo().getEJBName();
    }

    public Properties getEnvironment() {
        Loggable loggable = EJBLogger.loggetEnvironmentDeprecatedLoggable();
        throw new RuntimeException(loggable.getMessage());
    }

    private boolean isLocalEntityTx(Transaction transaction) {
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        return transactionImpl.getProperty("LOCAL_ENTITY_TX") != null;
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.beanManager.usesBeanManagedTx()) {
            Loggable loggable = EJBLogger.logonlyCMTBeanCanInvokeGetRollbackOnlyLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (this.isSession) {
            this.checkAllowedMethod(197504);
        } else if (this.isEntity) {
            this.checkAllowedMethod(125084);
        }
        try {
            weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
            if (transaction == null || transaction != null && this.isLocalEntityTx((Transaction)transaction)) {
                Loggable loggable = EJBLogger.logillegalCallToGetRollbackOnlyLoggable();
                throw new IllegalStateException(loggable.getMessage());
            }
            int n = transaction.getStatus();
            boolean bl = false;
            if (n == 1 || n == 9 || n == 4) {
                bl = true;
            }
            return bl;
        }
        catch (SystemException systemException) {
            EJBLogger.logExcepLookingUpXn2((String)StackTraceUtils.throwable2StackTrace((Throwable)systemException));
            return false;
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.beanManager.usesBeanManagedTx()) {
            Loggable loggable = EJBLogger.logonlyCMTBeanCanInvokeSetRollbackOnlyLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        if (this.isSession) {
            this.checkAllowedMethod(197504);
        } else if (this.isEntity) {
            this.checkAllowedMethod(125084);
        }
        try {
            weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
            if (transaction == null || transaction != null && this.isLocalEntityTx((Transaction)transaction)) {
                Loggable loggable = EJBLogger.logillegalCallToSetRollbackOnlyLoggable();
                throw new IllegalStateException(loggable.getMessage());
            }
            transaction.setRollbackOnly();
        }
        catch (SystemException systemException) {
            EJBLogger.logExcepLookingUpXn3((String)StackTraceUtils.throwable2StackTrace((Throwable)systemException));
        }
    }

    public boolean isCallerInRole(String string) {
        if (this.isStateful) {
            this.checkAllowedMethod(2036);
        } else if (this.isStateless) {
            this.checkAllowedMethod(196736);
        } else if (this.isEntity) {
            this.checkAllowedMethod(125084);
        }
        return ((BaseEJBManager)this.beanManager).checkWritable(string);
    }

    public boolean isCallerInRole(Identity identity) {
        return this.isCallerInRole(identity.getName());
    }

    public TimerService getTimerService() {
        this.checkAllowedToGetTimerService();
        if (this.timerService == null) {
            this.timerService = this.beanManager.getBeanInfo().isTimerDriven() ? new TimerServiceImpl(this.beanManager.getTimerManager(), this, this.beanManager.getBeanInfo().isClusteredTimers()) : (TimerService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TimerService.class, WLTimerService.class}, new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) {
                    Loggable loggable = EJBLogger.logIllegalAttemptToAccessTimerServiceLoggable();
                    throw new IllegalStateException(loggable.getMessage());
                }
            });
        }
        return this.timerService;
    }

    public void checkAllowedToUseTimerService() {
        this.checkAllowedMethod(245912);
    }

    protected void checkAllowedToGetTimerService() {
        this.checkAllowedMethod(254204);
    }

    public void checkAllowedToGetMessageContext() {
        this.checkAllowedMethod(131072);
    }

    public Object lookup(String string) throws IllegalArgumentException {
        if (string != null) {
            try {
                if (string.startsWith("java:")) {
                    return new InitialContext().lookup(string);
                }
                return this.beanManager.getEnvironmentContext().lookup("comp/env/" + string);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Argument " + string + " is not found in environment context.");
    }
}

