/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.Name;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBRemoteHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.SecurityRoleReference;
import weblogic.ejb.container.internal.BaseRemoteObject;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.internal.URLDelegateProvider;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.ejb20.interfaces.RemoteHome;
import weblogic.ejb20.internal.HomeHandleImpl;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.jndi.OpaqueReference;
import weblogic.logging.Loggable;
import weblogic.rmi.SupportsInterfaceBasedCallByReference;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.EJBResource;
import weblogic.transaction.RollbackException;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.AppSetRollbackOnlyException;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public abstract class BaseEJBHome
implements BaseEJBRemoteHomeIntf,
RemoteHome,
SupportsInterfaceBasedCallByReference {
    protected static final DebugLogger debugLogger = EJBDebugService.invokeLogger;
    protected Class eoClass;
    protected BeanManager beanManager;
    protected DeploymentInfo deploymentInfo;
    protected ClientDrivenBeanInfo beanInfo;
    private CBVHomeRef cbvHomeRef;
    private boolean securityInitialized = false;
    private SecurityHelper helper = null;
    private EJBResource ejbResource = null;
    private EJBMetaData ejbMetaData;
    private boolean isDeployed;

    BaseEJBHome(Class clazz) {
        this.eoClass = clazz;
    }

    public void setup(BeanInfo beanInfo, BaseEJBHomeIntf baseEJBHomeIntf, BeanManager beanManager) throws WLDeploymentException {
        this.beanInfo = (ClientDrivenBeanInfo)beanInfo;
        this.beanManager = beanManager;
        if (!beanInfo.useCallByReference()) {
            this.cbvHomeRef = new CBVHomeRef(this);
        }
    }

    public void unprepare() {
        if (!this.beanInfo.useCallByReference()) {
            this.cbvHomeRef.removeResolvedRef();
        }
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.beanInfo = (ClientDrivenBeanInfo)beanInfo;
    }

    public BeanManager getBeanManager() {
        assert (this.beanManager != null);
        return this.beanManager;
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public Name getJNDIName() {
        return this.beanInfo.getJNDIName();
    }

    public String getJNDINameAsString() {
        Name name = this.getJNDIName();
        return name == null ? null : name.toString();
    }

    public abstract EJBMetaData getEJBMetaData() throws RemoteException;

    protected abstract EJBMetaData getEJBMetaDataInstance();

    protected EJBMetaData getEJBMetaData(MethodDescriptor methodDescriptor) throws RemoteException {
        methodDescriptor.checkMethodPermissionsRemote(new EJBContextHandler(methodDescriptor, new Object[0]));
        if (this.ejbMetaData == null) {
            this.ejbMetaData = this.getEJBMetaDataInstance();
        }
        return this.ejbMetaData;
    }

    public HomeHandle getHomeHandle(MethodDescriptor methodDescriptor) throws RemoteException {
        methodDescriptor.checkMethodPermissionsRemote(new EJBContextHandler(methodDescriptor, new Object[0]));
        if (this.getJNDIName() == null) {
            Loggable loggable = EJBLogger.logneedJNDINameForHomeHandlesLoggable((String)this.getDisplayName());
            throw new RemoteException(loggable.getMessage());
        }
        return this.getHomeHandleObject();
    }

    private HomeHandle getHomeHandleObject() {
        return new HomeHandleImpl(this, this.getJNDIName(), URLDelegateProvider.getURLDelegate(this.isHomeClusterable()));
    }

    public abstract void remove(MethodDescriptor var1, Object var2) throws RemoteException, RemoveException;

    public abstract void remove(MethodDescriptor var1, Handle var2) throws RemoteException, RemoveException;

    public abstract EJBObject allocateEO(Object var1);

    public abstract EJBObject allocateEO();

    public abstract void cleanup();

    public EJBHome getCBVHomeStub() {
        return this.cbvHomeRef.getStub();
    }

    public Object getReferenceToBind() {
        if (!this.beanInfo.useCallByReference()) {
            return this.cbvHomeRef;
        }
        return this;
    }

    public EJBObject allocateEJBObject() throws RemoteException {
        return this.allocateEO();
    }

    public EJBObject allocateEJBObject(Object object) throws RemoteException {
        return this.allocateEO(object);
    }

    public String getIsIdenticalKey() {
        return this.beanInfo.getIsIdenticalKey();
    }

    public abstract boolean usesBeanManagedTx();

    public boolean isDeployed() {
        return this.isDeployed;
    }

    public void setIsDeployed(boolean bl) {
        this.isDeployed = bl;
    }

    public void activate() throws WLDeploymentException {
    }

    public void undeploy() {
        this.cleanup();
        if (this.beanInfo.useCallByReference()) {
            try {
                ServerHelper.unexportObject((Object)this, (boolean)true, (boolean)true);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        } else {
            this.cbvHomeRef.removeResolvedRef();
        }
    }

    public void unexportEO(EJBObject eJBObject) {
        this.unexportEO(eJBObject, true);
    }

    public void unexportEO(Remote remote) {
        try {
            ServerHelper.unexportObject((Object)remote, (boolean)true, (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void unexportEO(EJBObject eJBObject, boolean bl) {
        try {
            ServerHelper.unexportObject((Object)eJBObject, (boolean)true, (boolean)bl);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public void unexportEJBActivator(Activator activator, Class clazz) {
        try {
            ServerHelper.removeRuntimeDescriptor((Class)clazz);
            ServerHelper.unexportObject((Activator)activator);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    void handleSystemException(InvocationWrapper invocationWrapper, Throwable throwable) throws RemoteException {
        BaseRemoteObject.handleSystemException(invocationWrapper, this.usesBeanManagedTx(), throwable);
    }

    public void pushEnvironment() {
        EJBRuntimeUtils.pushEnvironment(this.beanManager.getEnvironmentContext());
    }

    public void popEnvironment() {
        EJBRuntimeUtils.popEnvironment();
    }

    protected InvocationWrapper preHomeInvoke(MethodDescriptor methodDescriptor, ContextHandler contextHandler) throws RemoteException {
        InvocationWrapper invocationWrapper = null;
        methodDescriptor.checkMethodPermissionsRemote(contextHandler);
        try {
            invocationWrapper = EJBRuntimeUtils.createWrapWithTxs(methodDescriptor);
        }
        catch (InternalException internalException) {
            if (debugLogger.isDebugEnabled()) {
                BaseEJBHome.debug("Failed to create a wrapper", internalException);
            }
            try {
                weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
                if (transaction != null) {
                    if (transaction instanceof weblogic.transaction.Transaction) {
                        transaction.setRollbackOnly((Throwable)internalException);
                    } else {
                        transaction.setRollbackOnly();
                    }
                }
            }
            catch (Exception exception) {
                EJBLogger.logErrorMarkingForRollback((Exception)exception);
            }
            EJBRuntimeUtils.throwRemoteException(internalException);
        }
        MethodInvocationHelper.pushMethodObject(this.getBeanInfo());
        SecurityHelper.pushCallerPrincipal();
        methodDescriptor.pushRunAsIdentity();
        return invocationWrapper;
    }

    private void postHomeInvokeNoInvokeTx(MethodDescriptor methodDescriptor, InvocationWrapper invocationWrapper) throws RemoteException {
        if (invocationWrapper.getInvokeTx() == null) {
            try {
                this.getBeanManager().beforeCompletion(invocationWrapper);
                this.getBeanManager().afterCompletion(invocationWrapper);
            }
            catch (InternalException internalException) {
                if (EJBRuntimeUtils.isAppException(methodDescriptor.getMethod(), internalException)) {
                    EJBRuntimeUtils.throwRemoteException(internalException);
                }
                this.handleSystemException(invocationWrapper, internalException);
                throw new AssertionError((Object)"Should never have reached here");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postHomeInvoke(InvocationWrapper invocationWrapper, Throwable throwable) throws RemoteException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        try {
            this.postHomeInvokeNoInvokeTx(methodDescriptor, invocationWrapper);
            if (transaction != null && !transaction.equals(transaction2)) {
                int n = -1;
                try {
                    n = transaction.getStatus();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                switch (n) {
                    case 0: {
                        try {
                            if (throwable != null && this.beanInfo.isEJB30() && EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) {
                                try {
                                    transaction.rollback();
                                }
                                catch (Exception exception) {
                                    EJBLogger.logErrorDuringRollback1((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                                }
                                break;
                            }
                            transaction.commit();
                            break;
                        }
                        catch (Exception exception) {
                            if (exception instanceof RollbackException && ((RollbackException)exception).getNested() instanceof AppSetRollbackOnlyException) break;
                            try {
                                this.getBeanManager().destroyInstance(invocationWrapper, exception);
                            }
                            catch (InternalException internalException) {
                                EJBLogger.logErrorDuringCommit((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)internalException));
                            }
                            EJBRuntimeUtils.throwRemoteException("Error committing transaction:", exception);
                            throw new AssertionError((Object)"Should never reach here");
                        }
                    }
                    case 1: {
                        try {
                            transaction.rollback();
                            break;
                        }
                        catch (Exception exception) {
                            EJBLogger.logErrorDuringRollback((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                        }
                    }
                }
            } else if (transaction != null && transaction.equals(transaction2) && throwable != null && this.beanInfo.isEJB30() && EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) {
                try {
                    transaction2.setRollbackOnly();
                }
                catch (Exception exception) {
                    EJBLogger.logExcepDuringSetRollbackOnly((Exception)exception);
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable2) {
            Object var10_14 = null;
            this.postHomeInvokeCleanup(invocationWrapper);
            throw throwable2;
        }
        this.postHomeInvokeCleanup(invocationWrapper);
    }

    protected void postHomeInvokeCleanup(InvocationWrapper invocationWrapper) throws RemoteException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        methodDescriptor.popRunAsIdentity();
        try {
            SecurityHelper.popCallerPrincipal();
        }
        catch (PrincipalNotFoundException principalNotFoundException) {
            EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
        }
        try {
            if (MethodInvocationHelper.popMethodObject(this.getBeanInfo())) {
                this.getBeanManager().handleUncommittedLocalTransaction(invocationWrapper);
            }
        }
        catch (InternalException internalException) {
            EJBRuntimeUtils.throwRemoteException(internalException);
        }
        try {
            EJBRuntimeUtils.resumeCallersTransaction(transaction2, transaction);
        }
        catch (InternalException internalException) {
            EJBRuntimeUtils.throwRemoteException(internalException);
        }
    }

    protected void validateHandleFromHome(Handle handle) throws RemoteException {
        String string;
        if (handle == null) {
            Loggable loggable = EJBLogger.loghandleNullLoggable();
            throw new RemoteException(loggable.getMessage());
        }
        EJBObject eJBObject = handle.getEJBObject();
        if (eJBObject == null) {
            Loggable loggable = EJBLogger.logejbObjectNullLoggable();
            throw new RemoteException(loggable.getMessage());
        }
        EJBHome eJBHome = eJBObject.getEJBHome();
        if (eJBHome == null) {
            Loggable loggable = EJBLogger.loghomeWasNullLoggable();
            throw new RemoteException(loggable.getMessage());
        }
        if (!(eJBHome instanceof RemoteHome)) {
            Loggable loggable = EJBLogger.logejbObjectNotFromThisHomeLoggable();
            throw new RemoteException(loggable.getMessage());
        }
        RemoteHome remoteHome = (RemoteHome)eJBHome;
        String string2 = this.getIsIdenticalKey();
        if (!string2.equals(string = remoteHome.getIsIdenticalKey())) {
            Loggable loggable = EJBLogger.logejbObjectNotFromThisHomeLoggable();
            throw new RemoteException(loggable.getMessage());
        }
    }

    public boolean isCallerInRole(String string) {
        this.initSecurity();
        String string2 = string;
        String string3 = string;
        SecurityRoleReference securityRoleReference = this.beanInfo.getSecurityRoleReference(string);
        if (securityRoleReference != null) {
            String string4 = securityRoleReference.getReferencedRole();
            if (debugLogger.isDebugEnabled()) {
                BaseEJBHome.debug(" referenced role for roleName: '" + string + "', is '" + string4 + "'");
            }
            string3 = string4;
        }
        return this.helper.isCallerInRole(this.beanInfo.getEJBName(), this.ejbResource, string2, string3);
    }

    public String getDisplayName() {
        return this.beanInfo.getDisplayName();
    }

    private void initSecurity() {
        if (!this.securityInitialized) {
            try {
                this.helper = new SecurityHelper(this.deploymentInfo.getSecurityRealmName(), this.deploymentInfo.getJACCPolicyConfig(), this.deploymentInfo.getJACCPolicyContextId(), this.deploymentInfo.getJACCCodeSource(), this.deploymentInfo.getJACCRoleMapper());
            }
            catch (Throwable throwable) {
                Debug.assertion((boolean)false, (String)("could not create SecurityHelper: " + throwable.getMessage()));
            }
            this.ejbResource = SecurityHelper.createEJBResource(this.deploymentInfo);
            this.securityInitialized = true;
        }
    }

    public boolean isHomeClusterable() {
        return ServerHelper.isClusterable((Remote)((Object)this));
    }

    private static void debug(String string) {
        debugLogger.debug("[BaseEJBHome] " + string);
    }

    private static void debug(String string, Throwable throwable) {
        debugLogger.debug("[BaseEJBHome] " + string, throwable);
    }

    public Object getInstance() {
        return this;
    }

    private static class CBVHomeRef
    implements OpaqueReference {
        private final BaseEJBHome home;
        private EJBHome cbvStub;
        private Object referent;

        CBVHomeRef(BaseEJBHome baseEJBHome) {
            this.home = baseEJBHome;
        }

        public synchronized Object getReferent(Name name, Context context) {
            this.ensureResolved();
            return this.referent;
        }

        synchronized EJBHome getStub() {
            this.ensureResolved();
            return this.cbvStub;
        }

        private void ensureResolved() {
            if (this.cbvStub != null) {
                return;
            }
            try {
                this.cbvStub = this.home.isHomeClusterable() ? (EJBHome)ServerHelper.exportObject((Remote)((Object)this.home), (String)this.home.getJNDINameAsString()) : (EJBHome)ServerHelper.exportObject((Remote)((Object)this.home));
                this.referent = ServerHelper.getCBVWrapperObject((Object)this.home);
            }
            catch (RemoteException remoteException) {
                throw new AssertionError((Object)remoteException);
            }
        }

        synchronized void removeResolvedRef() {
            this.cbvStub = null;
            this.referent = null;
            try {
                ServerHelper.unexportObject((Object)this.home, (boolean)true, (boolean)true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }
}

