/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BaseEJBLocalObjectIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.SecurityRoleReference;
import weblogic.ejb.container.internal.BaseLocalObject;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.interfaces.LocalHomeHandle;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.ejb20.internal.LocalHomeHandleImpl;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.EJBResource;
import weblogic.transaction.RollbackException;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.AppSetRollbackOnlyException;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public abstract class BaseEJBLocalHome
implements BaseEJBLocalHomeIntf {
    protected static final DebugLogger debugLogger = EJBDebugService.invokeLogger;
    protected Class eloClass;
    protected DeploymentInfo deploymentInfo;
    protected ClientDrivenBeanInfo beanInfo;
    private BaseEJBHomeIntf otherHome;
    protected BeanManager beanManager;
    private boolean securityInitialized = false;
    private SecurityHelper helper = null;
    private EJBResource ejbResource = null;
    private boolean isDeployed;

    BaseEJBLocalHome(Class clazz) {
        this.eloClass = clazz;
    }

    public void setup(BeanInfo beanInfo, BaseEJBHomeIntf baseEJBHomeIntf, BeanManager beanManager) throws WLDeploymentException {
        this.beanInfo = (ClientDrivenBeanInfo)beanInfo;
        this.otherHome = baseEJBHomeIntf;
        this.beanManager = beanManager;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.beanInfo = (ClientDrivenBeanInfo)beanInfo;
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public Name getJNDIName() {
        return this.beanInfo.getLocalJNDIName();
    }

    public String getIsIdenticalKey() {
        return this.beanInfo.getIsIdenticalKey();
    }

    public String getJNDINameAsString() {
        Name name = this.getJNDIName();
        return name == null ? null : name.toString();
    }

    public abstract void remove(MethodDescriptor var1, Object var2) throws RemoveException;

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public boolean isDeployed() {
        return this.isDeployed;
    }

    public void setIsDeployed(boolean bl) {
        this.isDeployed = bl;
    }

    public void undeploy() {
        this.unbindInJNDI();
        this.cleanup();
    }

    protected void unbindInJNDI() {
        String string = this.getJNDINameAsString();
        if (string == null) {
            return;
        }
        try {
            new InitialContext().unbind(string);
        }
        catch (NamingException namingException) {
            throw new AssertionError("Unbind of " + string + " failed", (Throwable)namingException);
        }
    }

    public abstract BaseEJBLocalObjectIntf allocateELO(Object var1);

    public abstract BaseEJBLocalObjectIntf allocateELO();

    public abstract void cleanup();

    void handleSystemException(InvocationWrapper invocationWrapper, Throwable throwable) throws EJBException {
        BaseLocalObject.handleSystemException(invocationWrapper, this.usesBeanManagedTx(), throwable);
    }

    public void pushEnvironment() {
        EJBRuntimeUtils.pushEnvironment(this.beanManager.getEnvironmentContext());
    }

    public void popEnvironment() {
        EJBRuntimeUtils.popEnvironment();
    }

    protected InvocationWrapper preHomeInvoke(MethodDescriptor methodDescriptor, ContextHandler contextHandler) throws EJBException {
        methodDescriptor.checkMethodPermissionsLocal(contextHandler);
        InvocationWrapper invocationWrapper = null;
        try {
            invocationWrapper = EJBRuntimeUtils.createWrapWithTxs(methodDescriptor);
        }
        catch (InternalException internalException) {
            if (debugLogger.isDebugEnabled()) {
                BaseEJBLocalHome.debug("Failed to create a wrapper: " + internalException);
            }
            try {
                weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
                if (transaction != null) {
                    transaction.setRollbackOnly();
                }
            }
            catch (Exception exception) {
                EJBLogger.logErrorMarkingForRollback((Exception)exception);
            }
            EJBRuntimeUtils.throwEJBException(internalException);
        }
        MethodInvocationHelper.pushMethodObject(this.getBeanInfo());
        SecurityHelper.pushCallerPrincipal();
        methodDescriptor.pushRunAsIdentity();
        return invocationWrapper;
    }

    private void postHomeInvokeNoInvokeTx(MethodDescriptor methodDescriptor, InvocationWrapper invocationWrapper) throws EJBException {
        if (invocationWrapper.getInvokeTx() == null) {
            try {
                this.getBeanManager().beforeCompletion(invocationWrapper);
                this.getBeanManager().afterCompletion(invocationWrapper);
            }
            catch (InternalException internalException) {
                if (EJBRuntimeUtils.isAppException(methodDescriptor.getMethod(), internalException)) {
                    EJBRuntimeUtils.throwEJBException(internalException);
                }
                this.handleSystemException(invocationWrapper, internalException);
                throw new AssertionError("Should never have reached here");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postHomeInvoke(InvocationWrapper invocationWrapper, Throwable throwable) throws EJBException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        try {
            this.postHomeInvokeNoInvokeTx(methodDescriptor, invocationWrapper);
            if (transaction != null && !transaction.equals(transaction2)) {
                int n = -1;
                try {
                    n = transaction.getStatus();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                switch (n) {
                    case 0: {
                        try {
                            if (throwable != null && this.beanInfo.isEJB30() && EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) {
                                try {
                                    transaction.rollback();
                                }
                                catch (Exception exception) {
                                    EJBLogger.logErrorDuringRollback1((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                                }
                                break;
                            }
                            transaction.commit();
                            break;
                        }
                        catch (Exception exception) {
                            if (exception instanceof RollbackException && ((RollbackException)exception).getNested() instanceof AppSetRollbackOnlyException) break;
                            try {
                                this.getBeanManager().destroyInstance(invocationWrapper, exception);
                            }
                            catch (InternalException internalException) {
                                EJBLogger.logErrorDuringCommit((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)internalException));
                            }
                            EJBRuntimeUtils.throwEJBException("Error committing transaction:", exception);
                            throw new AssertionError("Should never reach here");
                        }
                    }
                    case 1: {
                        try {
                            transaction.rollback();
                            break;
                        }
                        catch (Exception exception) {
                            EJBLogger.logErrorDuringRollback((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                        }
                    }
                }
            } else if (transaction != null && transaction.equals(transaction2) && throwable != null && this.beanInfo.isEJB30() && EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) {
                try {
                    transaction2.setRollbackOnly();
                }
                catch (Exception exception) {
                    EJBLogger.logExcepDuringSetRollbackOnly((Exception)exception);
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable2) {
            Object var10_14 = null;
            this.postHomeInvokeCleanup(invocationWrapper);
            throw throwable2;
        }
        this.postHomeInvokeCleanup(invocationWrapper);
    }

    protected void postHomeInvokeCleanup(InvocationWrapper invocationWrapper) throws EJBException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        methodDescriptor.popRunAsIdentity();
        try {
            SecurityHelper.popCallerPrincipal();
        }
        catch (PrincipalNotFoundException principalNotFoundException) {
            EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
        }
        try {
            if (MethodInvocationHelper.popMethodObject(this.getBeanInfo())) {
                this.getBeanManager().handleUncommittedLocalTransaction(invocationWrapper);
            }
        }
        catch (InternalException internalException) {
            EJBRuntimeUtils.throwEJBException(internalException);
        }
        try {
            EJBRuntimeUtils.resumeCallersTransaction(transaction2, transaction);
        }
        catch (InternalException internalException) {
            EJBRuntimeUtils.throwEJBException(internalException);
        }
    }

    public LocalHomeHandle getLocalHomeHandle(MethodDescriptor methodDescriptor) throws EJBException {
        methodDescriptor.checkMethodPermissionsLocal(new EJBContextHandler(methodDescriptor, new Object[0]));
        return this.getLocalHomeHandleObject();
    }

    public LocalHomeHandle getLocalHomeHandleObject() {
        return new LocalHomeHandleImpl(this, this.getJNDIName());
    }

    public boolean isCallerInRole(String string) {
        this.initSecurity();
        String string2 = string;
        String string3 = string;
        SecurityRoleReference securityRoleReference = this.beanInfo.getSecurityRoleReference(string);
        if (securityRoleReference != null) {
            String string4 = securityRoleReference.getReferencedRole();
            if (debugLogger.isDebugEnabled()) {
                BaseEJBLocalHome.debug(" referenced role for roleName: '" + string + "', is '" + string4 + "'");
            }
            string3 = string4;
        }
        return this.helper.isCallerInRole(this.beanInfo.getEJBName(), this.ejbResource, string2, string3);
    }

    public String getDisplayName() {
        return this.beanInfo.getDisplayName();
    }

    private void initSecurity() {
        if (!this.securityInitialized) {
            try {
                this.helper = new SecurityHelper(this.deploymentInfo.getSecurityRealmName(), this.deploymentInfo.getJACCPolicyConfig(), this.deploymentInfo.getJACCPolicyContextId(), this.deploymentInfo.getJACCCodeSource(), this.deploymentInfo.getJACCRoleMapper());
            }
            catch (Throwable throwable) {
                Debug.assertion((boolean)false, (String)("could not create SecurityHelper: " + throwable.getMessage()));
            }
            this.ejbResource = SecurityHelper.createEJBResource(this.deploymentInfo);
            this.securityInitialized = true;
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[BaseEJBLocalHome] " + string);
    }
}

