/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.AccessLocalException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BaseEJBLocalHomeIntf;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLSessionBean;
import weblogic.ejb.container.internal.BaseEJBLocalHome;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.internal.StatefulLocalObject;
import weblogic.ejb20.interfaces.LocalHandle;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.transaction.RollbackException;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.StackTraceUtils;

public abstract class BaseLocalObject {
    protected static final DebugLogger debugLogger;
    protected BeanManager beanManager;
    protected BeanInfo beanInfo;
    protected BaseEJBLocalHome ejbLocalHome;
    protected int txRetryCount;
    private boolean isEJB30ClientView = true;
    static final long serialVersionUID = -4972824511795923466L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    public void setIsEJB30ClientView(boolean bl) {
        this.isEJB30ClientView = bl;
    }

    public boolean isEJB30ClientView() {
        return this.isEJB30ClientView;
    }

    public String toString() {
        if (this.beanInfo != null) {
            return "[BaseLocalObject]  for EJB: '" + this.beanInfo.getEJBName() + "'";
        }
        return "[BaseLocalObject]  for EJB: ' '";
    }

    public void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    protected void checkMethodPermissions(MethodDescriptor methodDescriptor, EJBContextHandler eJBContextHandler) {
        if (this.isEJB30ClientView) {
            methodDescriptor.checkMethodPermissionsBusiness(eJBContextHandler);
        } else {
            methodDescriptor.checkMethodPermissionsLocal(eJBContextHandler);
        }
    }

    void setEJBLocalHome(BaseEJBLocalHome baseEJBLocalHome) {
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug("Setting home to :" + baseEJBLocalHome + " in elo:" + this);
        }
        this.ejbLocalHome = baseEJBLocalHome;
        this.beanManager = baseEJBLocalHome.getBeanManager();
    }

    protected EJBLocalHome getEJBLocalHome(MethodDescriptor methodDescriptor) {
        assert (this.ejbLocalHome != null);
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug("Getting home in elo:" + this);
        }
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[0]));
        return this.ejbLocalHome;
    }

    protected Object getPrimaryKey(MethodDescriptor methodDescriptor) throws EJBException {
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[0]));
        return this.getPrimaryKeyObject();
    }

    protected boolean isIdentical(MethodDescriptor methodDescriptor, EJBLocalObject eJBLocalObject) throws EJBException {
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[]{eJBLocalObject}));
        if (eJBLocalObject == null) {
            return false;
        }
        String string = this.ejbLocalHome.getIsIdenticalKey();
        String string2 = ((BaseEJBLocalHomeIntf)eJBLocalObject.getEJBLocalHome()).getIsIdenticalKey();
        assert (string != null);
        assert (string2 != null);
        return string.equals(string2);
    }

    protected LocalHandle getLocalHandle(MethodDescriptor methodDescriptor) throws EJBException {
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug("Getting handle in elo:" + this);
        }
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[0]));
        return this.getLocalHandleObject();
    }

    protected Object getPrimaryKeyObject() throws EJBException {
        throw new AssertionError((Object)"Method not supported by this object type");
    }

    public LocalHandle getLocalHandleObject() throws EJBException {
        throw new AssertionError((Object)"Method not supported by this object type");
    }

    protected abstract InvocationWrapper __WL_preInvoke(MethodDescriptor var1, ContextHandler var2) throws EJBException;

    protected InvocationWrapper preInvokeLite(InvocationWrapper invocationWrapper, ContextHandler contextHandler) throws EJBException {
        return this.preInvoke(invocationWrapper, contextHandler, true, null);
    }

    protected InvocationWrapper preInvoke(InvocationWrapper invocationWrapper, ContextHandler contextHandler) throws EJBException {
        return this.preInvoke(invocationWrapper, contextHandler, false, null);
    }

    protected InvocationWrapper preInvoke(InvocationWrapper invocationWrapper, ContextHandler contextHandler, AuthenticatedSubject authenticatedSubject) throws EJBException {
        return this.preInvoke(invocationWrapper, contextHandler, false, authenticatedSubject);
    }

    protected InvocationWrapper preInvoke(InvocationWrapper invocationWrapper, ContextHandler contextHandler, boolean bl, AuthenticatedSubject authenticatedSubject) throws EJBException {
        boolean bl2 = false;
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug("preInvoke called with:" + invocationWrapper + " on:" + this + "\n");
        }
        if (!bl) {
            this.pushEnvironment();
            SecurityHelper.pushCallerPrincipal();
        }
        MethodInvocationHelper.pushMethodObject(this.beanInfo);
        Transaction transaction = invocationWrapper.getInvokeTx();
        try {
            assert (this.beanManager != null);
            EnterpriseBean enterpriseBean = null;
            try {
                try {
                    enterpriseBean = this.beanManager.preInvoke(invocationWrapper);
                }
                catch (InternalException internalException) {
                    if (!this.isEJB30ClientView) {
                        if (internalException.detail instanceof NoSuchEJBException) {
                            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(internalException.getMessage());
                            EJBRuntimeUtils.throwInternalException(internalException.getMessage(), (Throwable)noSuchObjectLocalException);
                        }
                        if (internalException.detail instanceof ConcurrentAccessException) {
                            throw new InternalException(internalException.getMessage());
                        }
                    }
                    throw internalException;
                }
            }
            catch (InternalException internalException) {
                if (debugLogger.isDebugEnabled()) {
                    BaseLocalObject.debug("Manager's preInvoke threw " + internalException);
                }
                this.handleSystemException(invocationWrapper, internalException);
                throw new AssertionError((Object)"Should never reach here");
            }
            catch (Throwable throwable) {
                this.handleSystemException(invocationWrapper, throwable);
                throw new AssertionError((Object)"Should never reach here");
            }
            invocationWrapper.setBean(enterpriseBean);
            ((EJBContextHandler)contextHandler).setEjb(enterpriseBean);
            this.checkMethodPermissions(methodDescriptor, (EJBContextHandler)contextHandler);
            if (!bl) {
                methodDescriptor.pushRunAsIdentity(authenticatedSubject);
                bl2 = true;
            }
            this.initTxRetryCount(invocationWrapper);
            if (debugLogger.isDebugEnabled()) {
                BaseLocalObject.debug("Manager.preInvoke returned a bean:" + enterpriseBean + "\n");
            }
            return invocationWrapper;
        }
        catch (EJBAccessException eJBAccessException) {
            if (debugLogger.isDebugEnabled()) {
                BaseLocalObject.debug("Method permission has been denied.  Do postInvoke sequence. \n" + (Object)((Object)eJBAccessException));
            }
            if (!bl && !bl2) {
                methodDescriptor.pushRunAsIdentity();
            }
            Throwable throwable = null;
            try {
                this.postInvoke1(0, invocationWrapper, eJBAccessException);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            try {
                this.postInvokeCleanup(invocationWrapper, throwable, bl);
            }
            catch (Exception exception) {
                if (exception instanceof EJBAccessException) {
                    throw (EJBAccessException)((Object)exception);
                }
                if (exception instanceof EJBException) {
                    throw (EJBException)((Object)exception);
                }
                EJBRuntimeUtils.throwEJBException("EJB Exception after method permission failure: ", exception);
            }
            throw eJBAccessException;
        }
        catch (AccessLocalException accessLocalException) {
            if (debugLogger.isDebugEnabled()) {
                BaseLocalObject.debug("Method permission check failed.  Do postInvoke sequence. \n" + (Object)((Object)accessLocalException));
            }
            if (!bl && !bl2) {
                methodDescriptor.pushRunAsIdentity();
            }
            Throwable throwable = null;
            try {
                this.postInvoke1(0, invocationWrapper, accessLocalException);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
            try {
                this.postInvokeCleanup(invocationWrapper, throwable, bl);
            }
            catch (Exception exception) {
                if (exception instanceof AccessLocalException) {
                    throw (AccessLocalException)((Object)exception);
                }
                if (exception instanceof EJBException) {
                    throw (EJBException)((Object)exception);
                }
                EJBRuntimeUtils.throwEJBException("EJB Exception after method permission failure: ", exception);
            }
            throw accessLocalException;
        }
        catch (EJBException eJBException) {
            if (!bl) {
                this.popEnvironment();
                if (bl2) {
                    methodDescriptor.popRunAsIdentity();
                }
                try {
                    SecurityHelper.popCallerPrincipal();
                }
                catch (PrincipalNotFoundException principalNotFoundException) {
                    EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
                }
            }
            MethodInvocationHelper.popMethodObject(this.beanInfo);
            try {
                Transaction transaction2 = invocationWrapper.getCallerTx();
                EJBRuntimeUtils.resumeCallersTransaction(transaction2, transaction);
            }
            catch (InternalException internalException) {
                // empty catch block
            }
            throw eJBException;
        }
    }

    private void retryPreInvoke(InvocationWrapper invocationWrapper) throws Exception {
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug("retryPreInvoke entered \n");
        }
        if (this.isEJB30ClientView) {
            EJBRuntimeUtils.setWrapWithTxsForBus(invocationWrapper);
        } else {
            EJBRuntimeUtils.setWrapWithTxs(invocationWrapper);
        }
        EnterpriseBean enterpriseBean = null;
        try {
            try {
                enterpriseBean = this.beanManager.preInvoke(invocationWrapper);
            }
            catch (InternalException internalException) {
                if (!this.isEJB30ClientView) {
                    if (internalException.detail instanceof NoSuchEJBException) {
                        NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(internalException.getMessage());
                        EJBRuntimeUtils.throwInternalException(internalException.getMessage(), (Throwable)noSuchObjectLocalException);
                    }
                    if (internalException.detail instanceof ConcurrentAccessException) {
                        throw new InternalException(internalException.getMessage());
                    }
                }
                throw internalException;
            }
        }
        catch (InternalException internalException) {
            if (debugLogger.isDebugEnabled()) {
                BaseLocalObject.debug("Manager's preInvoke threw " + internalException);
            }
            this.handleSystemException(invocationWrapper, internalException);
            throw new AssertionError((Object)"Should never reach here");
        }
        catch (Throwable throwable) {
            this.handleSystemException(invocationWrapper, throwable);
            throw new AssertionError((Object)"Should never reach here");
        }
        invocationWrapper.setBean(enterpriseBean);
    }

    protected boolean __WL_postInvokeTxRetry(InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        boolean bl;
        if (_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low.isEnabledAndNotDyeFiltered()) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper, throwable};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (bl = this.postInvoke1(this.getNextTxRetryCount(), invocationWrapper, throwable)) {
            this.retryPreInvoke(invocationWrapper);
            throwable = null;
        }
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug("__WL_postInvokeTxRetry returning with retry = " + bl + "\n");
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean postInvoke1(int n, InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        Object object;
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug("postInvoke1 called with txRetryCount = " + n + "\n" + "wrap:" + invocationWrapper + "\n Exception: " + throwable + " on: " + this + "\n");
            if (null != throwable) {
                throwable.printStackTrace();
            }
        }
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        Method method = methodDescriptor.getMethod();
        boolean bl = false;
        if (throwable == null || EJBRuntimeUtils.isAppException(this.beanInfo, method, throwable) || throwable instanceof AccessLocalException || throwable instanceof EJBAccessException) {
            try {
                this.beanManager.postInvoke(invocationWrapper);
            }
            catch (InternalException internalException) {
                throwable = internalException;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.beanManager.destroyInstance(invocationWrapper, throwable);
            this.handleSystemException(invocationWrapper, throwable);
            throw new AssertionError((Object)"Should never be reached");
        }
        if (throwable instanceof AccessLocalException || throwable instanceof EJBAccessException) {
            this.handleSystemException(invocationWrapper, throwable);
            throw new AssertionError((Object)"Should never be reached");
        }
        if (invocationWrapper.getInvokeTx() == null) {
            try {
                this.getBeanManager().beforeCompletion(invocationWrapper);
                this.getBeanManager().afterCompletion(invocationWrapper);
            }
            catch (InternalException internalException) {
                if (EJBRuntimeUtils.isAppException(method, internalException)) {
                    throw (Exception)internalException.detail;
                }
                this.handleSystemException(invocationWrapper, internalException);
                throw new AssertionError((Object)"Should never have reached here");
            }
        } else if (this instanceof StatefulLocalObject && this.beanInfo instanceof Ejb3SessionBeanInfo) {
            object = (WLSessionBean)invocationWrapper.getBean();
            boolean bl2 = ((Ejb3SessionBeanInfo)this.beanInfo).isRemoveMethod(method);
            boolean bl3 = ((Ejb3SessionBeanInfo)this.beanInfo).isRetainifException(method);
            if (bl2 && (throwable == null || EJBRuntimeUtils.isAppException(this.beanInfo, method, throwable) && !bl3)) {
                object.__WL_setNeedsSessionSynchronization(false);
            }
        }
        if (EJBRuntimeUtils.runningInOurTx(invocationWrapper)) {
            if (EJBRuntimeUtils.isRollback(invocationWrapper)) {
                if (debugLogger.isDebugEnabled()) {
                    BaseLocalObject.debug(" our tx marked for Rollback, attempt to rollback ");
                }
                try {
                    transaction.rollback();
                    if (debugLogger.isDebugEnabled()) {
                        BaseLocalObject.debug(" Rollback succeeded. ");
                    }
                }
                catch (Exception exception) {
                    EJBLogger.logErrorDuringRollback1((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
                if (!EJBRuntimeUtils.isSystemRollback(invocationWrapper)) return this.isTxRetry(n);
                if (debugLogger.isDebugEnabled()) {
                    BaseLocalObject.debug(" system Rollback, throw exception");
                }
                object = ((TransactionImpl)transaction).getRollbackReason();
                EJBRuntimeUtils.throwEJBException("Transaction Rolledback.", (Throwable)object);
                return false;
            }
            try {
                if (throwable != null && this.isEJB30ClientView && EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) {
                    if (debugLogger.isDebugEnabled()) {
                        BaseLocalObject.debug(throwable.getClass().getName() + " is thrown, attempt to rollback ");
                    }
                    try {
                        transaction.rollback();
                        if (!debugLogger.isDebugEnabled()) return this.isTxRetry(n);
                        BaseLocalObject.debug(" Rollback succeeded. ");
                        return this.isTxRetry(n);
                    }
                    catch (Exception exception) {
                        EJBLogger.logErrorDuringRollback1((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    }
                    return this.isTxRetry(n);
                }
                if (debugLogger.isDebugEnabled()) {
                    BaseLocalObject.debug("Committing our tx: " + transaction + "\n");
                }
                transaction.commit();
                if (!debugLogger.isDebugEnabled()) return false;
                BaseLocalObject.debug("Committing our tx: SUCCESS\n");
                return false;
            }
            catch (Exception exception) {
                if (exception instanceof RollbackException) {
                    RollbackException rollbackException;
                    if (debugLogger.isDebugEnabled()) {
                        BaseLocalObject.debug("Committing our tx: ROLLBACK\n");
                    }
                    if (!EJBRuntimeUtils.isOptimisticLockException((rollbackException = (RollbackException)exception).getNested())) {
                        EJBLogger.logErrorDuringCommit((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    }
                    if (n > 0) {
                        return this.isTxRetry(n);
                    }
                }
                EJBRuntimeUtils.throwEJBException("Error committing transaction:", exception);
            }
            return false;
        }
        if (!EJBRuntimeUtils.runningInCallerTx(invocationWrapper) || throwable == null || !this.isEJB30ClientView || !EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) return false;
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug(" caller tx marked for Rollback, attempt to rollback ");
        }
        try {
            transaction2.setRollbackOnly();
            if (!debugLogger.isDebugEnabled()) return false;
            BaseLocalObject.debug(" SetRollbackOnly succeeded. ");
            return false;
        }
        catch (Exception exception) {
            EJBLogger.logExcepDuringSetRollbackOnly((Exception)exception);
        }
        return false;
    }

    public void __WL_postInvokeCleanup(InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        this.postInvokeCleanup(invocationWrapper, throwable, false);
    }

    public void __WL_postInvokeCleanupLite(InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        this.postInvokeCleanup(invocationWrapper, throwable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postInvokeCleanup(InvocationWrapper invocationWrapper, Throwable throwable, boolean bl) throws Exception {
        boolean bl2 = _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var14_7 = null;
        if (bl2) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper, throwable, InstrumentationSupport.convertToObject((boolean)bl)};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            Transaction transaction;
            MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
            try {
                if (!bl) {
                    this.popEnvironment();
                    methodDescriptor.popRunAsIdentity();
                    SecurityHelper.popCallerPrincipal();
                }
                if (MethodInvocationHelper.popMethodObject(this.beanInfo)) {
                    this.beanManager.handleUncommittedLocalTransaction(invocationWrapper);
                }
                if (throwable != null) {
                    Method method = invocationWrapper.getMethodDescriptor().getMethod();
                    if (EJBRuntimeUtils.isAppException(method, throwable)) {
                        EJBRuntimeUtils.throwException(throwable);
                    } else {
                        if (throwable instanceof Exception) {
                            throw (Exception)throwable;
                        }
                        assert (throwable instanceof Exception);
                        EJBRuntimeUtils.throwEJBException("EJB encountered System Exception: ", throwable);
                    }
                }
                Object var7_13 = null;
                transaction = invocationWrapper.getCallerTx();
            }
            catch (Throwable throwable2) {
                Object var7_14 = null;
                Transaction transaction2 = invocationWrapper.getCallerTx();
                EJBRuntimeUtils.resumeCallersTransaction(transaction2, invocationWrapper.getInvokeTx());
                throw throwable2;
            }
            EJBRuntimeUtils.resumeCallersTransaction(transaction, invocationWrapper.getInvokeTx());
            Object var12_18 = null;
            if (!bl2) return;
        }
        catch (Throwable throwable3) {
            Object var12_19 = null;
            if (!bl2) throw throwable3;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable3;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    public void postInvoke(InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        Throwable throwable2 = throwable;
        try {
            this.postInvoke1(0, invocationWrapper, throwable2);
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
        }
        this.__WL_postInvokeCleanup(invocationWrapper, throwable2);
    }

    private boolean isTxRetry(int n) {
        if (n > 0) {
            if (debugLogger.isDebugEnabled()) {
                BaseLocalObject.debug(" txRetryCount " + n + " return retry = true");
            }
            return true;
        }
        if (debugLogger.isDebugEnabled()) {
            BaseLocalObject.debug(" txRetryCount " + n + " return retry = false");
        }
        return false;
    }

    private void initTxRetryCount(InvocationWrapper invocationWrapper) {
        this.txRetryCount = invocationWrapper.getMethodDescriptor().getRetryOnRollbackCount();
    }

    private int getNextTxRetryCount() {
        if (--this.txRetryCount < 0) {
            this.txRetryCount = 0;
        }
        return this.txRetryCount;
    }

    public void pushEnvironment() {
        EJBRuntimeUtils.pushEnvironment(this.beanManager.getEnvironmentContext());
    }

    public void popEnvironment() {
        EJBRuntimeUtils.popEnvironment();
    }

    protected void operationsComplete() {
    }

    protected void handleSystemException(InvocationWrapper invocationWrapper, Throwable throwable) {
        try {
            BaseLocalObject.handleSystemException(invocationWrapper, this.beanManager.usesBeanManagedTx(), throwable);
        }
        catch (TransactionRolledbackLocalException transactionRolledbackLocalException) {
            if (this.isEJB30ClientView) {
                EJBTransactionRolledbackException eJBTransactionRolledbackException = null;
                if (transactionRolledbackLocalException.getCause() instanceof Exception) {
                    eJBTransactionRolledbackException = new EJBTransactionRolledbackException(transactionRolledbackLocalException.getMessage(), (Exception)transactionRolledbackLocalException.getCause());
                    eJBTransactionRolledbackException.initCause(transactionRolledbackLocalException.getCause());
                } else {
                    eJBTransactionRolledbackException = new EJBTransactionRolledbackException(transactionRolledbackLocalException.getMessage(), (Exception)((Object)transactionRolledbackLocalException));
                    eJBTransactionRolledbackException.initCause((Throwable)transactionRolledbackLocalException);
                }
                throw eJBTransactionRolledbackException;
            }
            throw transactionRolledbackLocalException;
        }
    }

    public static void handleSystemException(InvocationWrapper invocationWrapper, boolean bl, Throwable throwable) throws EJBException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        if (bl && TxHelper.getTransaction() != null) {
            try {
                weblogic.transaction.Transaction transaction2 = TxHelper.getTransaction();
                if (transaction2.getStatus() == 0) {
                    transaction2.rollback();
                }
            }
            catch (Exception exception) {
                EJBLogger.logStackTrace((Throwable)exception);
                EJBLogger.logErrorOnRollback((Exception)exception);
            }
            if (throwable instanceof AccessLocalException) {
                throw (AccessLocalException)throwable;
            }
            EJBRuntimeUtils.throwEJBException("EJB Exception: ", throwable);
        } else if (transaction == null) {
            if (throwable instanceof AccessLocalException) {
                throw (AccessLocalException)throwable;
            }
            EJBRuntimeUtils.throwEJBException("EJB Exception: ", throwable);
        } else if (EJBRuntimeUtils.runningInOurTx(invocationWrapper)) {
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                EJBLogger.logStackTrace((Throwable)exception);
                EJBLogger.logErrorOnRollback((Exception)exception);
            }
            if (throwable instanceof AccessLocalException) {
                throw (AccessLocalException)throwable;
            }
            EJBRuntimeUtils.throwEJBException("EJB Exception: ", throwable);
        } else {
            try {
                transaction.setRollbackOnly();
            }
            catch (Exception exception) {
                EJBLogger.logErrorMarkingRollback((Exception)exception);
            }
            if (EJBRuntimeUtils.isSpecialSystemException(throwable)) {
                EJBRuntimeUtils.throwEJBException("called setRollbackOnly", throwable);
            }
            EJBRuntimeUtils.throwTransactionRolledbackLocal("EJB Exception: ", throwable);
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[BaseLocalObject] " + string);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.internal.BaseLocalObject");
        _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Business_Method_Postinvoke_Before_Low");
        _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"BaseLocalObject.java", (String)"weblogic.ejb.container.internal.BaseLocalObject", (String)"__WL_postInvokeTxRetry", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;Ljava/lang/Throwable;)Z", (int)455, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Business_Method_Postinvoke_Before_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"BaseLocalObject.java", (String)"weblogic.ejb.container.internal.BaseLocalObject", (String)"postInvokeCleanup", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;Ljava/lang/Throwable;Z)V", (int)706, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true), null, null})}), (boolean)false);
        debugLogger = EJBDebugService.invokeLogger;
    }
}

