/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.EnterpriseBean;
import javax.ejb.Handle;
import javax.ejb.NoSuchEJBException;
import javax.ejb.RemoveException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.BeanManager;
import weblogic.ejb.container.interfaces.ClientDrivenBeanInfo;
import weblogic.ejb.container.interfaces.Ejb3SessionBeanInfo;
import weblogic.ejb.container.interfaces.WLSessionBean;
import weblogic.ejb.container.internal.BaseEJBHome;
import weblogic.ejb.container.internal.EJBContextHandler;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.internal.StatefulRemoteObject;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.ejb20.interfaces.RemoteHome;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.kernel.ThreadLocalStack;
import weblogic.rmi.SupportsInterfaceBasedCallByReference;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.security.service.ContextHandler;
import weblogic.transaction.RollbackException;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.GenericClassLoader;

public abstract class BaseRemoteObject
implements SupportsInterfaceBasedCallByReference {
    protected static final DebugLogger debugLogger;
    protected BeanManager beanManager;
    protected ClientDrivenBeanInfo beanInfo;
    protected BaseEJBHome ejbHome;
    protected int txRetryCount;
    protected static final ThreadLocalStack currentInvocationWrapper;
    private boolean isImplementsRemote = true;
    private static ThreadLocalStack envStack;
    static final long serialVersionUID = -3749648514302390289L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High;
    public static final DelegatingMonitor _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    public String toString() {
        return "[BaseRemoteObject] home: " + this.ejbHome;
    }

    public void setIsImplementsRemote(boolean bl) {
        this.isImplementsRemote = bl;
    }

    public boolean isImplementsRemote() {
        return this.isImplementsRemote;
    }

    public void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.beanInfo = (ClientDrivenBeanInfo)beanInfo;
    }

    protected void checkMethodPermissions(MethodDescriptor methodDescriptor, EJBContextHandler eJBContextHandler) throws AccessException {
        if (!this.isImplementsRemote) {
            methodDescriptor.checkMethodPermissionsBusiness(eJBContextHandler);
        } else {
            methodDescriptor.checkMethodPermissionsRemote(eJBContextHandler);
        }
    }

    void setEJBHome(BaseEJBHome baseEJBHome) {
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug("Setting home to :" + baseEJBHome + " in eo:" + this);
        }
        this.ejbHome = baseEJBHome;
    }

    protected EJBHome getEJBHome(MethodDescriptor methodDescriptor) throws RemoteException {
        assert (this.ejbHome != null);
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug("Getting home in eo:" + this);
        }
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[0]));
        return this.ejbHome;
    }

    protected abstract Object getPrimaryKeyObject() throws RemoteException;

    protected abstract Handle getHandleObject() throws RemoteException;

    protected Object getPrimaryKey(MethodDescriptor methodDescriptor) throws RemoteException {
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[0]));
        return this.getPrimaryKeyObject();
    }

    protected Handle getHandle(MethodDescriptor methodDescriptor) throws RemoteException {
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[0]));
        return this.getHandleObject();
    }

    protected boolean isIdentical(MethodDescriptor methodDescriptor, EJBObject eJBObject) throws RemoteException {
        this.checkMethodPermissions(methodDescriptor, new EJBContextHandler(methodDescriptor, new Object[]{eJBObject}));
        if (eJBObject == null) {
            return false;
        }
        String string = this.ejbHome.getIsIdenticalKey();
        RemoteHome remoteHome = null;
        try {
            remoteHome = (RemoteHome)PortableRemoteObject.narrow((Object)eJBObject.getEJBHome(), RemoteHome.class);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        String string2 = remoteHome.getIsIdenticalKey();
        return string.equals(string2);
    }

    protected abstract void remove(MethodDescriptor var1) throws RemoteException, RemoveException;

    protected abstract InvocationWrapper __WL_preInvoke(MethodDescriptor var1, ContextHandler var2) throws RemoteException;

    protected InvocationWrapper preInvoke(InvocationWrapper invocationWrapper, ContextHandler contextHandler) throws RemoteException {
        boolean bl = false;
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug("preInvoke called with:" + invocationWrapper + " on:" + this);
        }
        this.pushEnvironment();
        MethodInvocationHelper.pushMethodObject(this.beanInfo);
        SecurityHelper.pushCallerPrincipal();
        Transaction transaction = invocationWrapper.getInvokeTx();
        try {
            assert (this.beanManager != null);
            EnterpriseBean enterpriseBean = null;
            this.pushInvocationWrapperInThreadLocal(invocationWrapper);
            try {
                try {
                    enterpriseBean = this.beanManager.preInvoke(invocationWrapper);
                }
                catch (InternalException internalException) {
                    if (this.isImplementsRemote) {
                        Throwable throwable;
                        if (internalException.detail instanceof NoSuchEJBException) {
                            throwable = new NoSuchObjectException(internalException.getMessage());
                            EJBRuntimeUtils.throwInternalException(internalException.getMessage(), throwable);
                        }
                        if (internalException.detail instanceof ConcurrentAccessException) {
                            throwable = internalException.detail.getCause();
                            EJBRuntimeUtils.throwInternalException(internalException.getMessage(), throwable);
                        }
                    }
                    throw internalException;
                }
            }
            catch (InternalException internalException) {
                if (debugLogger.isDebugEnabled()) {
                    BaseRemoteObject.debug("Manager's preInvoke threw " + internalException);
                }
                this.handleSystemException(invocationWrapper, internalException);
            }
            catch (Throwable throwable) {
                if (debugLogger.isDebugEnabled()) {
                    BaseRemoteObject.debug("Manager's preInvoke threw " + throwable);
                }
                this.handleSystemException(invocationWrapper, throwable);
            }
            invocationWrapper.setBean(enterpriseBean);
            this.setTxCreateAttributeOnBean(invocationWrapper);
            ((EJBContextHandler)contextHandler).setEjb(enterpriseBean);
            this.checkMethodPermissions(methodDescriptor, (EJBContextHandler)contextHandler);
            methodDescriptor.pushRunAsIdentity();
            bl = true;
            this.initTxRetryCount(invocationWrapper);
            if (debugLogger.isDebugEnabled()) {
                BaseRemoteObject.debug("Manager.preInvoke returned a bean:" + enterpriseBean);
            }
            return invocationWrapper;
        }
        catch (EJBAccessException eJBAccessException) {
            this.handleAccessExceptions((Exception)((Object)eJBAccessException), methodDescriptor, bl, invocationWrapper);
            throw new AssertionError("Should never be reached");
        }
        catch (AccessException accessException) {
            this.handleAccessExceptions(accessException, methodDescriptor, bl, invocationWrapper);
            throw new AssertionError("Should never be reached");
        }
        catch (RemoteException remoteException) {
            this.popInvocationWrapperInThreadLocalOnError(invocationWrapper);
            if (bl) {
                methodDescriptor.popRunAsIdentity();
            }
            try {
                SecurityHelper.popCallerPrincipal();
            }
            catch (PrincipalNotFoundException principalNotFoundException) {
                EJBLogger.logErrorPoppingCallerPrincipal((Exception)((Object)principalNotFoundException));
            }
            MethodInvocationHelper.popMethodObject(this.beanInfo);
            this.popEnvironment();
            try {
                Transaction transaction2 = invocationWrapper.getCallerTx();
                EJBRuntimeUtils.resumeCallersTransaction(transaction2, transaction);
            }
            catch (InternalException internalException) {
                // empty catch block
            }
            throw remoteException;
        }
    }

    private void handleAccessExceptions(Exception exception, MethodDescriptor methodDescriptor, boolean bl, InvocationWrapper invocationWrapper) throws RemoteException {
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug("Method permission check failed.  Do postInvoke sequence. \n" + exception);
        }
        if (!bl) {
            if (debugLogger.isDebugEnabled()) {
                BaseRemoteObject.debug("Method permission check failed. pushRunAsIdentity");
            }
            methodDescriptor.pushRunAsIdentity();
        }
        Throwable throwable = null;
        try {
            this.postInvoke1(0, invocationWrapper, exception);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        try {
            this.__WL_postInvokeCleanup(invocationWrapper, throwable);
        }
        catch (Exception exception2) {
            EJBRuntimeUtils.throwRemoteException("EJB Exception after method permission failure: ", exception2);
        }
    }

    protected abstract void pushInvocationWrapperInThreadLocal(InvocationWrapper var1);

    protected abstract void popInvocationWrapperInThreadLocalOnError(InvocationWrapper var1);

    protected abstract void notifyRemoteCallBegin();

    protected void setTxCreateAttributeOnBean(InvocationWrapper invocationWrapper) {
    }

    private void retryPreInvoke(InvocationWrapper invocationWrapper) throws Exception {
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug("retryPreInvoke entered \n");
        }
        if (!this.isImplementsRemote) {
            EJBRuntimeUtils.setWrapWithTxsForBus(invocationWrapper);
        } else {
            EJBRuntimeUtils.setWrapWithTxs(invocationWrapper);
        }
        EnterpriseBean enterpriseBean = null;
        try {
            try {
                enterpriseBean = this.beanManager.preInvoke(invocationWrapper);
            }
            catch (InternalException internalException) {
                if (this.isImplementsRemote) {
                    Throwable throwable;
                    if (internalException.detail instanceof NoSuchEJBException) {
                        throwable = new NoSuchObjectException(internalException.getMessage());
                        EJBRuntimeUtils.throwInternalException(internalException.getMessage(), throwable);
                    }
                    if (internalException.detail instanceof ConcurrentAccessException) {
                        throwable = internalException.detail.getCause();
                        EJBRuntimeUtils.throwInternalException(internalException.getMessage(), throwable);
                    }
                }
                throw internalException;
            }
        }
        catch (InternalException internalException) {
            if (debugLogger.isDebugEnabled()) {
                BaseRemoteObject.debug("Manager's preInvoke threw " + internalException);
            }
            this.handleSystemException(invocationWrapper, internalException);
            throw new AssertionError("Should never reach here");
        }
        catch (Throwable throwable) {
            this.handleSystemException(invocationWrapper, throwable);
            throw new AssertionError("Should never reach here");
        }
        invocationWrapper.setBean(enterpriseBean);
    }

    protected boolean __WL_postInvokeTxRetry(InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        boolean bl;
        if (_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low.isEnabledAndNotDyeFiltered()) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper, throwable};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (bl = this.postInvoke1(this.getNextTxRetryCount(), invocationWrapper, throwable)) {
            this.retryPreInvoke(invocationWrapper);
            throwable = null;
        }
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug("__WL_postInvokeTxRetry returning with retry = " + bl + "\n");
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean postInvoke1(int n, InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        Object object;
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug("prePostInvoke called with txRetryCount = " + n + "\n" + " wrap:" + invocationWrapper + " Exception: " + throwable + " on: " + this);
            if (null != throwable) {
                throwable.printStackTrace();
            }
        }
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        Method method = methodDescriptor.getMethod();
        boolean bl = false;
        if (throwable == null || EJBRuntimeUtils.isAppException(this.beanInfo, method, throwable) || throwable instanceof AccessException || throwable instanceof EJBAccessException) {
            try {
                this.beanManager.postInvoke(invocationWrapper);
            }
            catch (InternalException internalException) {
                throwable = internalException;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (RemoteException.class.equals(throwable.getClass())) {
                throwable = new RemoteException("EJB Exception:", throwable);
            }
            invocationWrapper.setSystemExceptionOccured();
            this.beanManager.destroyInstance(invocationWrapper, throwable);
            this.handleSystemException(invocationWrapper, throwable);
            throw new AssertionError("Should never be reached");
        }
        if (throwable instanceof AccessException || throwable instanceof EJBAccessException) {
            this.handleSystemException(invocationWrapper, throwable);
            throw new AssertionError("Should never be reached");
        }
        if (invocationWrapper.getInvokeTx() == null) {
            try {
                this.getBeanManager().beforeCompletion(invocationWrapper);
                this.getBeanManager().afterCompletion(invocationWrapper);
            }
            catch (InternalException internalException) {
                if (EJBRuntimeUtils.isAppException(method, internalException)) {
                    throw (Exception)internalException.detail;
                }
                this.handleSystemException(invocationWrapper, internalException);
                throw new AssertionError("Should never have reached here");
            }
        } else if (this instanceof StatefulRemoteObject && this.beanInfo instanceof Ejb3SessionBeanInfo) {
            object = (WLSessionBean)invocationWrapper.getBean();
            boolean bl2 = ((Ejb3SessionBeanInfo)this.beanInfo).isRemoveMethod(method);
            boolean bl3 = ((Ejb3SessionBeanInfo)this.beanInfo).isRetainifException(method);
            if (bl2 && (throwable == null || EJBRuntimeUtils.isAppException(this.beanInfo, method, throwable) && !bl3)) {
                object.__WL_setNeedsSessionSynchronization(false);
            }
        }
        if (EJBRuntimeUtils.runningInOurTx(invocationWrapper)) {
            if (EJBRuntimeUtils.isRollback(invocationWrapper)) {
                if (debugLogger.isDebugEnabled()) {
                    BaseRemoteObject.debug(" our tx marked for Rollback, attempt to rollback ");
                }
                try {
                    transaction.rollback();
                    if (debugLogger.isDebugEnabled()) {
                        BaseRemoteObject.debug(" Rollback succeeded. ");
                    }
                }
                catch (Exception exception) {
                    EJBLogger.logErrorDuringRollback1((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
                if (!EJBRuntimeUtils.isSystemRollback(invocationWrapper)) return this.isTxRetry(n);
                if (debugLogger.isDebugEnabled()) {
                    BaseRemoteObject.debug(" system Rollback, throw exception");
                }
                object = ((TransactionImpl)transaction).getRollbackReason();
                EJBRuntimeUtils.throwRemoteException("Transaction Rolledback.", (Throwable)object);
                return false;
            }
            try {
                if (throwable != null && this.beanInfo.isEJB30() && EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) {
                    if (debugLogger.isDebugEnabled()) {
                        BaseRemoteObject.debug(throwable.getClass().getName() + " is thrown, attempt to rollback ");
                    }
                    try {
                        transaction.rollback();
                        if (!debugLogger.isDebugEnabled()) return this.isTxRetry(n);
                        BaseRemoteObject.debug(" Rollback succeeded. ");
                        return this.isTxRetry(n);
                    }
                    catch (Exception exception) {
                        EJBLogger.logErrorDuringRollback1((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    }
                    return this.isTxRetry(n);
                }
                if (debugLogger.isDebugEnabled()) {
                    BaseRemoteObject.debug("Committing tx: " + transaction);
                }
                transaction.commit();
                if (!debugLogger.isDebugEnabled()) return false;
                BaseRemoteObject.debug("Committing our tx: SUCCESS\n");
                return false;
            }
            catch (Exception exception) {
                if (exception instanceof RollbackException) {
                    RollbackException rollbackException;
                    if (debugLogger.isDebugEnabled()) {
                        BaseRemoteObject.debug("Committing our tx: ROLLBACK\n");
                    }
                    if (!EJBRuntimeUtils.isOptimisticLockException((rollbackException = (RollbackException)exception).getNested())) {
                        EJBLogger.logErrorDuringCommit((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    }
                    if (n > 0) {
                        return this.isTxRetry(n);
                    }
                }
                EJBRuntimeUtils.throwRemoteException(((weblogic.transaction.Transaction)transaction).getXid().toString(), exception);
            }
            return false;
        }
        if (!EJBRuntimeUtils.runningInCallerTx(invocationWrapper) || throwable == null || !this.beanInfo.isEJB30() || !EJBRuntimeUtils.isAppExceptionNeedtoRollback(this.beanInfo.getDeploymentInfo(), throwable)) return false;
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug(" caller tx marked for Rollback, attempt to rollback ");
        }
        try {
            transaction2.setRollbackOnly();
            if (!debugLogger.isDebugEnabled()) return false;
            BaseRemoteObject.debug(" SetRollbackOnly succeeded. ");
            return false;
        }
        catch (Exception exception) {
            EJBLogger.logExcepDuringSetRollbackOnly((Exception)exception);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void __WL_postInvokeCleanup(InvocationWrapper invocationWrapper, Throwable throwable) throws Exception {
        boolean bl = _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var13_6 = null;
        if (bl) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, invocationWrapper, throwable};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        try {
            Transaction transaction;
            MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
            try {
                this.popEnvironment();
                methodDescriptor.popRunAsIdentity();
                SecurityHelper.popCallerPrincipal();
                if (MethodInvocationHelper.popMethodObject(this.beanInfo)) {
                    this.beanManager.handleUncommittedLocalTransaction(invocationWrapper);
                }
                if (throwable != null) {
                    Method method = invocationWrapper.getMethodDescriptor().getMethod();
                    if (EJBRuntimeUtils.isAppException(method, throwable)) {
                        EJBRuntimeUtils.throwException(throwable);
                    } else {
                        if (throwable instanceof Exception) {
                            throw (Exception)throwable;
                        }
                        assert (throwable instanceof Exception);
                        EJBRuntimeUtils.throwEJBException("EJB encountered System Exception: ", throwable);
                    }
                }
                Object var6_12 = null;
                transaction = invocationWrapper.getCallerTx();
            }
            catch (Throwable throwable2) {
                Object var6_13 = null;
                Transaction transaction2 = invocationWrapper.getCallerTx();
                EJBRuntimeUtils.resumeCallersTransaction(transaction2, invocationWrapper.getInvokeTx());
                throw throwable2;
            }
            EJBRuntimeUtils.resumeCallersTransaction(transaction, invocationWrapper.getInvokeTx());
            Object var11_17 = null;
            if (!bl) return;
        }
        catch (Throwable throwable3) {
            Object var11_18 = null;
            if (!bl) throw throwable3;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High, diagnosticActionArray, diagnosticActionStateArray);
            throw throwable3;
        }
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    private boolean isTxRetry(int n) {
        if (n > 0) {
            if (debugLogger.isDebugEnabled()) {
                BaseRemoteObject.debug(" txRetryCount " + n + " return retry = true");
            }
            return true;
        }
        if (debugLogger.isDebugEnabled()) {
            BaseRemoteObject.debug(" txRetryCount " + n + " return retry = false");
        }
        return false;
    }

    private void initTxRetryCount(InvocationWrapper invocationWrapper) {
        this.txRetryCount = invocationWrapper.getMethodDescriptor().getRetryOnRollbackCount();
    }

    private int getNextTxRetryCount() {
        if (--this.txRetryCount < 0) {
            this.txRetryCount = 0;
        }
        return this.txRetryCount;
    }

    public void pushEnvironment() {
        Thread thread2;
        ClassLoader classLoader;
        EnvInfo envInfo = new EnvInfo();
        ClassLoader classLoader2 = this.beanInfo.getClassLoader();
        if (classLoader2 instanceof GenericClassLoader && (classLoader = (thread2 = Thread.currentThread()).getContextClassLoader()) != classLoader2) {
            envInfo.captureClassloader(classLoader);
            thread2.setContextClassLoader(classLoader2);
        }
        envStack.push((Object)envInfo);
        EJBRuntimeUtils.pushEnvironment(this.beanManager.getEnvironmentContext());
    }

    public void popEnvironment() {
        EnvInfo envInfo = (EnvInfo)envStack.pop();
        if (envInfo.wasSet()) {
            Thread.currentThread().setContextClassLoader(envInfo.getClassLoader());
        }
        EJBRuntimeUtils.popEnvironment();
    }

    protected void operationsComplete() {
    }

    protected void handleSystemException(InvocationWrapper invocationWrapper, Throwable throwable) throws RemoteException {
        try {
            BaseRemoteObject.handleSystemException(invocationWrapper, this.beanManager.usesBeanManagedTx(), throwable);
        }
        catch (TransactionRolledbackException transactionRolledbackException) {
            if (!this.isImplementsRemote) {
                EJBTransactionRolledbackException eJBTransactionRolledbackException = null;
                if (transactionRolledbackException.detail instanceof Exception) {
                    eJBTransactionRolledbackException = new EJBTransactionRolledbackException(transactionRolledbackException.getMessage(), (Exception)transactionRolledbackException.detail);
                    eJBTransactionRolledbackException.initCause(transactionRolledbackException.detail);
                } else {
                    eJBTransactionRolledbackException = new EJBTransactionRolledbackException(transactionRolledbackException.getMessage(), (Exception)((Object)transactionRolledbackException));
                    eJBTransactionRolledbackException.initCause((Throwable)transactionRolledbackException);
                }
                EJBRuntimeUtils.throwRemoteException(transactionRolledbackException.getMessage(), (Throwable)eJBTransactionRolledbackException);
            }
            throw transactionRolledbackException;
        }
    }

    public static void handleSystemException(InvocationWrapper invocationWrapper, boolean bl, Throwable throwable) throws RemoteException {
        Transaction transaction = invocationWrapper.getInvokeTx();
        if (bl && TxHelper.getTransaction() != null) {
            try {
                weblogic.transaction.Transaction transaction2 = TxHelper.getTransaction();
                if (transaction2.getStatus() == 0) {
                    transaction2.rollback();
                }
            }
            catch (Exception exception) {
                EJBLogger.logStackTrace((Throwable)exception);
                EJBLogger.logErrorOnRollback((Exception)exception);
            }
            EJBRuntimeUtils.throwRemoteException("EJB Exception: ", throwable);
        } else if (transaction == null) {
            EJBRuntimeUtils.throwRemoteException("EJB Exception: ", throwable);
        } else if (EJBRuntimeUtils.runningInOurTx(invocationWrapper)) {
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                EJBLogger.logErrorOnRollback((Exception)exception);
            }
            EJBRuntimeUtils.throwRemoteException("EJB Exception: ", throwable);
        } else {
            try {
                if (transaction instanceof weblogic.transaction.Transaction) {
                    ((weblogic.transaction.Transaction)transaction).setRollbackOnly(throwable);
                } else {
                    transaction.setRollbackOnly();
                }
            }
            catch (Exception exception) {
                EJBLogger.logErrorMarkingRollback((Exception)exception);
            }
            if (EJBRuntimeUtils.isSpecialSystemException(throwable)) {
                EJBRuntimeUtils.throwRemoteException("called setRollbackOnly", throwable);
            }
            EJBRuntimeUtils.throwTransactionRolledback("EJB Exception: ", throwable);
        }
    }

    public Object getInstance() {
        return this.ejbHome;
    }

    protected String getImplementedBusinessInterfaceName() {
        return null;
    }

    private static void debug(String string) {
        debugLogger.debug("[BaseRemoteObject] " + string);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.ejb.container.internal.BaseRemoteObject");
        _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High");
        _WLDF$INST_FLD_EJB_Diagnostic_Business_Method_Postinvoke_Before_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"EJB_Diagnostic_Business_Method_Postinvoke_Before_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"BaseRemoteObject.java", (String)"weblogic.ejb.container.internal.BaseRemoteObject", (String)"__WL_postInvokeTxRetry", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;Ljava/lang/Throwable;)Z", (int)444, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Business_Method_Postinvoke_Before_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"BaseRemoteObject.java", (String)"weblogic.ejb.container.internal.BaseRemoteObject", (String)"__WL_postInvokeCleanup", (String)"(Lweblogic/ejb/container/internal/InvocationWrapper;Ljava/lang/Throwable;)V", (int)697, (Map)InstrumentationSupport.makeMap((String[])new String[]{"EJB_Diagnostic_Business_Method_Postinvoke_Cleanup_Around_High"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"wrap", (String)"weblogic.diagnostics.instrumentation.gathering.EJBInvocationWrapperRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        debugLogger = EJBDebugService.invokeLogger;
        currentInvocationWrapper = new ThreadLocalStack();
        envStack = new ThreadLocalStack(true);
    }

    private static class EnvInfo {
        private boolean clWasSet = false;
        private ClassLoader classLoader = null;

        private EnvInfo() {
        }

        public boolean wasSet() {
            return this.clWasSet;
        }

        public void captureClassloader(ClassLoader classLoader) {
            this.clWasSet = true;
            this.classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    protected class ThreadLocalObject {
        public boolean isRemoteBean = false;
        public final BaseRemoteObject baseRemoteObject;

        public ThreadLocalObject(boolean bl, BaseRemoteObject baseRemoteObject2) {
            this.isRemoteBean = bl;
            this.baseRemoteObject = baseRemoteObject2;
        }

        public boolean isRemote() {
            return this.isRemoteBean;
        }

        public BaseRemoteObject getBaseRemoteObject() {
            return this.baseRemoteObject;
        }
    }
}

