/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.MARSHAL;
import weblogic.common.WLObjectInput;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.ReplacerObjectInputStream;
import weblogic.common.internal.ReplacerObjectOutputStream;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.spi.BusinessHandle;
import weblogic.ejb.spi.BusinessObject;
import weblogic.ejb.spi.PortableReplaceable;
import weblogic.ejb20.internal.HomeHandleImpl;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.utils.io.Replacer;

public final class BusinessHandleImpl
implements BusinessHandle,
Externalizable,
PortableReplaceable {
    private static final long serialVersionUID = -339809761282601060L;
    private transient BusinessObject businessObject = null;
    private HomeHandleImpl homeHandle = null;
    private static final boolean debug = false;
    private Object primaryKey = null;
    private Object stubInfo = null;
    private Object ifaceName = null;

    public BusinessHandleImpl() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.homeHandle.writeExternal(objectOutput);
        objectOutput.writeObject(this.primaryKey);
        objectOutput.writeObject(this.ifaceName);
        if (objectOutput instanceof WLObjectOutput) {
            objectOutput.writeObject(this.stubInfo);
        } else {
            ReplacerObjectOutputStream replacerObjectOutputStream = new ReplacerObjectOutputStream((OutputStream)((Object)objectOutput), RemoteObjectReplacer.getReplacer());
            replacerObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
            if (this.stubInfo != null) {
                replacerObjectOutputStream.writeObject(this.stubInfo);
            } else {
                objectOutput.writeObject(this.stubInfo);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.homeHandle = new HomeHandleImpl();
        this.homeHandle.readExternal(objectInput);
        this.primaryKey = objectInput.readObject();
        this.ifaceName = objectInput.readObject();
        try {
            if (objectInput instanceof WLObjectInput) {
                this.stubInfo = objectInput.readObject();
            } else {
                Replacer replacer = RemoteObjectReplacer.getReplacer();
                ReplacerObjectInputStream replacerObjectInputStream = new ReplacerObjectInputStream((InputStream)((Object)objectInput), replacer, null);
                this.stubInfo = replacerObjectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
        }
        catch (MARSHAL mARSHAL) {
            // empty catch block
        }
    }

    public String toString() {
        return this.homeHandle + "#" + this.primaryKey;
    }

    public BusinessHandleImpl(EJBHome eJBHome, BusinessObject businessObject, String string) throws RemoteException {
        this.businessObject = businessObject;
        this.ifaceName = string;
        this.primaryKey = null;
        this.homeHandle = (HomeHandleImpl)eJBHome.getHomeHandle();
    }

    public BusinessHandleImpl(EJBHome eJBHome, BusinessObject businessObject, Object object) throws RemoteException {
        this.businessObject = businessObject;
        this.ifaceName = null;
        this.primaryKey = object;
        this.homeHandle = (HomeHandleImpl)eJBHome.getHomeHandle();
        this.stubInfo = businessObject;
    }

    private BusinessObject allocateBO(EJBHome eJBHome, Class[] classArray, Object[] objectArray) throws RemoteException {
        Class<?> clazz = eJBHome.getClass();
        try {
            Method method = clazz.getMethod("getBusinessImpl", classArray);
            Object object = method.invoke((Object)eJBHome, objectArray);
            return (BusinessObject)PortableRemoteObject.narrow((Object)object, BusinessObject.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Class " + clazz.getName() + " did not have allocateBO method"));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            EJBRuntimeUtils.throwRemoteException("Exception re-establishing business handle", throwable);
            throw new AssertionError((Object)"cannot reach here");
        }
        catch (IllegalAccessException illegalAccessException) {
            EJBRuntimeUtils.throwRemoteException("Exception re-establishing business handle", illegalAccessException);
            throw new AssertionError((Object)"cannot reach here");
        }
    }

    public BusinessObject getBusinessObject() throws RemoteException {
        if (this.businessObject != null) {
            return this.businessObject;
        }
        if (this.primaryKey == null) {
            EJBHome eJBHome = this.homeHandle.getEJBHome();
            return this.allocateBO(eJBHome, new Class[]{Object.class, String.class}, new Object[]{this.primaryKey, this.ifaceName});
        }
        BusinessObject businessObject = (BusinessObject)this.stubInfo;
        return businessObject;
    }
}

