/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.ejb.container.internal.JMSConnectionPoller;
import weblogic.ejb.container.internal.JMSMessagePoller;
import weblogic.ejb.container.internal.MDListener;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerImpl;

public class ContinuousJMSMessagePoller
extends JMSMessagePoller {
    private static final String TRANSACTION_NAME_PREFIX = "ContinuousJMSMessagePoller.";
    private TransactionManager tranManager;
    private String transactionName;
    private LinkedList supendedChildren = new LinkedList();

    public ContinuousJMSMessagePoller(String string, JMSConnectionPoller jMSConnectionPoller, JMSMessagePoller jMSMessagePoller, MessageConsumer messageConsumer, MDListener mDListener, WorkManager workManager, int n) {
        super(string, jMSConnectionPoller, jMSMessagePoller, messageConsumer, mDListener, workManager, n, false);
        this.tranManager = TxHelper.getTransactionManager();
        this.transactionName = TRANSACTION_NAME_PREFIX + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processOneMessage(boolean bl, int n) throws JMSException, NotSupportedException, SystemException, RollbackException {
        Message message;
        block7: {
            message = null;
            int n2 = 0;
            int n3 = this.getMDListener().getTransactionTimeoutMS();
            n3 += this.getMessageWaitTime();
            this.tranManager.begin(this.transactionName, n3 /= 1000);
            Transaction transaction = this.tranManager.getTransaction();
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    message = (Message)this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ContinuousJMSMessagePoller.this.getConsumer().receive((long)ContinuousJMSMessagePoller.this.getMessageWaitTime());
                        }
                    });
                    if (message != null) {
                        if (this.getDebugLogger().isDebugEnabled()) {
                            Debug.say((String)(this + " batched message #" + n2 + ". Message is " + message.getJMSMessageID()));
                        }
                        if (this.isParent()) {
                            this.wakeUpChildContinuousPoller();
                        }
                        if (n2 >= n - 1) {
                            this.getMDListener().transactionalOnMessage(message, true);
                            transaction = null;
                            continue;
                        }
                        if (this.getMDListener().transactionalOnMessage(message, false)) continue;
                        transaction = null;
                        break;
                    }
                    if (n2 <= 0) break;
                    this.getMDListener().transactionalOnMessage(null, true);
                    transaction = null;
                    break;
                }
                Object var8_7 = null;
                if (transaction == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (transaction == null) throw throwable;
                transaction.rollback();
                throw throwable;
            }
            transaction.rollback();
        }
        if (message == null) return false;
        return true;
    }

    private void wakeUpChildContinuousPoller() {
        ContinuousJMSMessagePoller continuousJMSMessagePoller = (ContinuousJMSMessagePoller)this.getChildFromPool();
        if (continuousJMSMessagePoller != null) {
            if (this.getDebugLogger().isDebugEnabled()) {
                Debug.say((String)("Using daemon thread for child :" + continuousJMSMessagePoller));
            }
            WorkManagerImpl.executeDaemonTask((String)("ContinuousJMSMessagePoller :" + this.getMDBName()), (int)5, (Runnable)continuousJMSMessagePoller);
        }
    }

    void pollForChild() {
        this.pollContinuously();
        ContinuousJMSMessagePoller continuousJMSMessagePoller = (ContinuousJMSMessagePoller)this.getParentPoller();
        if (this.getDebugLogger().isDebugEnabled()) {
            Debug.assertion((continuousJMSMessagePoller != null ? 1 : 0) != 0);
            Debug.say((String)("Adding :" + this + " to suspended list"));
        }
        continuousJMSMessagePoller.addToSuspendedList(this);
    }

    void pollForParent() {
        this.wakeupSuspendedChildren();
        this.pollContinuously();
    }

    private synchronized void wakeupSuspendedChildren() {
        while (this.supendedChildren.size() > 0) {
            ContinuousJMSMessagePoller continuousJMSMessagePoller = (ContinuousJMSMessagePoller)this.supendedChildren.removeFirst();
            if (this.getDebugLogger().isDebugEnabled()) {
                Debug.assertion((continuousJMSMessagePoller != null ? 1 : 0) != 0);
                Debug.say((String)("Waking up the suspended child :" + continuousJMSMessagePoller));
            }
            WorkManagerImpl.executeDaemonTask((String)("ContinuousJMSMessagePoller :" + this.getMDBName()), (int)5, (Runnable)continuousJMSMessagePoller);
        }
    }

    private synchronized void addToSuspendedList(ContinuousJMSMessagePoller continuousJMSMessagePoller) {
        this.supendedChildren.addLast(continuousJMSMessagePoller);
    }

    public String toString() {
        return "[Continuous] " + super.toString();
    }
}

