/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.kodo.monitoring.KodoPersistenceUnitParent;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.CoherenceClusterRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.EJBRuntimeMBean;
import weblogic.management.runtime.KodoPersistenceUnitRuntimeMBean;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SpringRuntimeMBean;
import weblogic.management.runtime.WseeClientConfigurationRuntimeMBean;
import weblogic.management.runtime.WseeClientRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class EJBComponentRuntimeMBeanImpl
extends ComponentRuntimeMBeanImpl
implements EJBComponentRuntimeMBean,
KodoPersistenceUnitParent {
    private Map m_runtimeMBeans = new HashMap();
    private Map m_runtimePersistenUnit = new HashMap();
    private String applicationName = null;
    private SpringRuntimeMBean springRuntimeMBean;
    private CoherenceClusterRuntimeMBean coherenceClusterRuntimeMBean;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final HashSet<WseeClientRuntimeMBean> wseeClientRuntimes = new HashSet();
    private final HashSet<WseeV2RuntimeMBean> wseeV2Runtimes = new HashSet();
    private final Set<WseeClientConfigurationRuntimeMBean> wseeClientConfigurationRuntimes = new HashSet<WseeClientConfigurationRuntimeMBean>();

    public EJBComponentRuntimeMBeanImpl(String string, String string2, RuntimeMBean runtimeMBean, String string3) throws ManagementException {
        super(string, string2, runtimeMBean, true);
        this.applicationName = string3;
    }

    public int getStatus() {
        return 0;
    }

    public EJBRuntimeMBean[] getEJBRuntimes() {
        EJBRuntimeMBean[] eJBRuntimeMBeanArray = new EJBRuntimeMBean[this.m_runtimeMBeans.size()];
        eJBRuntimeMBeanArray = this.m_runtimeMBeans.values().toArray(eJBRuntimeMBeanArray);
        return eJBRuntimeMBeanArray;
    }

    public EJBRuntimeMBean getEJBRuntime(String string) {
        return (EJBRuntimeMBean)this.m_runtimeMBeans.get(string);
    }

    public void addEJBRuntimeMBean(EJBRuntimeMBean eJBRuntimeMBean) {
        if (eJBRuntimeMBean instanceof MessageDrivenEJBRuntimeMBean) {
            MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean = (MessageDrivenEJBRuntimeMBean)eJBRuntimeMBean;
            String string = messageDrivenEJBRuntimeMBean.getEJBName();
            String string2 = messageDrivenEJBRuntimeMBean.getEJBName() + "_" + messageDrivenEJBRuntimeMBean.getDestination();
            if (this.m_runtimeMBeans.containsKey(string)) {
                this.m_runtimeMBeans.remove(string);
            }
            if (this.m_runtimeMBeans.containsKey(string2)) {
                this.m_runtimeMBeans.remove(string2);
            }
            this.m_runtimeMBeans.put(eJBRuntimeMBean.getName(), eJBRuntimeMBean);
        } else {
            this.m_runtimeMBeans.put(eJBRuntimeMBean.getEJBName(), eJBRuntimeMBean);
        }
    }

    public void removeEJBRuntimeMBean(EJBRuntimeMBean eJBRuntimeMBean) {
        if (eJBRuntimeMBean instanceof MessageDrivenEJBRuntimeMBean) {
            this.m_runtimeMBeans.remove(eJBRuntimeMBean.getName());
        } else {
            this.m_runtimeMBeans.remove(eJBRuntimeMBean.getEJBName());
        }
    }

    public EJBComponentMBean getEJBComponent() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(this.applicationName);
        if (applicationMBean == null) {
            return null;
        }
        return applicationMBean.lookupEJBComponent(this.getName());
    }

    public String toString() {
        return "EJBComponentRuntimeMBean: name=" + this.getName();
    }

    public void unregisterDependents() throws ManagementException {
        for (RuntimeMBeanDelegate runtimeMBeanDelegate : this.m_runtimeMBeans.values()) {
            runtimeMBeanDelegate.unregister();
        }
        this.m_runtimeMBeans.clear();
    }

    public void addKodoPersistenceUnit(KodoPersistenceUnitRuntimeMBean kodoPersistenceUnitRuntimeMBean) {
        this.m_runtimePersistenUnit.put(kodoPersistenceUnitRuntimeMBean.getPersistenceUnitName(), kodoPersistenceUnitRuntimeMBean);
    }

    public KodoPersistenceUnitRuntimeMBean[] getKodoPersistenceUnitRuntimes() {
        KodoPersistenceUnitRuntimeMBean[] kodoPersistenceUnitRuntimeMBeanArray = new KodoPersistenceUnitRuntimeMBean[this.m_runtimePersistenUnit.size()];
        kodoPersistenceUnitRuntimeMBeanArray = this.m_runtimePersistenUnit.values().toArray(kodoPersistenceUnitRuntimeMBeanArray);
        return kodoPersistenceUnitRuntimeMBeanArray;
    }

    public KodoPersistenceUnitRuntimeMBean getKodoPersistenceUnitRuntime(String string) {
        return (KodoPersistenceUnitRuntimeMBean)this.m_runtimePersistenUnit.get(string);
    }

    public SpringRuntimeMBean getSpringRuntimeMBean() {
        return this.springRuntimeMBean;
    }

    public void setSpringRuntimeMBean(SpringRuntimeMBean springRuntimeMBean) {
        this.springRuntimeMBean = springRuntimeMBean;
    }

    public CoherenceClusterRuntimeMBean getCoherenceClusterRuntime() {
        return this.coherenceClusterRuntimeMBean;
    }

    public void setCoherenceClusterRuntime(CoherenceClusterRuntimeMBean coherenceClusterRuntimeMBean) {
        this.coherenceClusterRuntimeMBean = coherenceClusterRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientRuntimeMBean[] getWseeClientRuntimes() {
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            int n = this.wseeClientRuntimes.size();
            return this.wseeClientRuntimes.toArray(new WseeClientRuntimeMBean[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientRuntimeMBean lookupWseeClientRuntime(String string) {
        WseeClientRuntimeMBean wseeClientRuntimeMBean = null;
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            for (WseeClientRuntimeMBean wseeClientRuntimeMBean2 : this.wseeClientRuntimes) {
                if (!wseeClientRuntimeMBean2.getName().equals(string)) continue;
                wseeClientRuntimeMBean = wseeClientRuntimeMBean2;
                break;
            }
        }
        return wseeClientRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWseeClientRuntime(WseeClientRuntimeMBean wseeClientRuntimeMBean) {
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            this.wseeClientRuntimes.add(wseeClientRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWseeClientRuntime(WseeClientRuntimeMBean wseeClientRuntimeMBean) {
        HashSet<WseeClientRuntimeMBean> hashSet = this.wseeClientRuntimes;
        synchronized (hashSet) {
            this.wseeClientRuntimes.remove(wseeClientRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeV2RuntimeMBean[] getWseeV2Runtimes() {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            int n = this.wseeV2Runtimes.size();
            return this.wseeV2Runtimes.toArray(new WseeV2RuntimeMBean[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeV2RuntimeMBean lookupWseeV2Runtime(String string) {
        WseeV2RuntimeMBean wseeV2RuntimeMBean = null;
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            for (WseeV2RuntimeMBean wseeV2RuntimeMBean2 : this.wseeV2Runtimes) {
                if (!wseeV2RuntimeMBean2.getName().equals(string)) continue;
                wseeV2RuntimeMBean = wseeV2RuntimeMBean2;
                break;
            }
        }
        return wseeV2RuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWseeV2Runtime(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            this.wseeV2Runtimes.add(wseeV2RuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWseeV2Runtime(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            this.wseeV2Runtimes.remove(wseeV2RuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientConfigurationRuntimeMBean[] getWseeClientConfigurationRuntimes() {
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            return this.wseeClientConfigurationRuntimes.toArray(new WseeClientConfigurationRuntimeMBean[this.wseeClientConfigurationRuntimes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeClientConfigurationRuntimeMBean lookupWseeClientConfigurationRuntime(String string) {
        WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean = null;
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            for (WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean2 : this.wseeClientConfigurationRuntimes) {
                if (!wseeClientConfigurationRuntimeMBean2.getName().equals(string)) continue;
                wseeClientConfigurationRuntimeMBean = wseeClientConfigurationRuntimeMBean2;
                break;
            }
        }
        return wseeClientConfigurationRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWseeClientConfigurationRuntime(WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean) {
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            this.wseeClientConfigurationRuntimes.add(wseeClientConfigurationRuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWseeClientConfigurationRuntime(WseeClientConfigurationRuntimeMBean wseeClientConfigurationRuntimeMBean) {
        Set<WseeClientConfigurationRuntimeMBean> set = this.wseeClientConfigurationRuntimes;
        synchronized (set) {
            this.wseeClientConfigurationRuntimes.remove(wseeClientConfigurationRuntimeMBean);
        }
    }
}

