/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import javax.ejb.EnterpriseBean;
import javax.security.jacc.PolicyContextException;
import javax.xml.soap.SOAPMessage;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.security.jacc.PolicyContextHandlerData;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;

public class EJBContextHandler
implements ContextHandler,
PolicyContextHandlerData {
    public static final EJBContextHandler EMPTY = new EJBContextHandler(new String[0], new Object[0]);
    public static final String JACC_SOAP_MSG_KEY = "javax.xml.soap.SOAPMessage";
    public static final String JACC_EJB_KEY = "javax.ejb.EnterpriseBean";
    public static final String JACC_ARGUMENTS_KEY = "javax.ejb.arguments";
    private static final String[] jacc_keys = new String[]{"javax.xml.soap.SOAPMessage", "javax.ejb.EnterpriseBean", "javax.ejb.arguments"};
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String[] names;
    private MethodDescriptor methodDescriptor;
    private Object[] values;
    private EnterpriseBean ejb;
    private SOAPMessage msg;

    public EJBContextHandler(EnterpriseBean enterpriseBean, Object[] objectArray, SOAPMessage sOAPMessage) {
        this.ejb = enterpriseBean;
        this.values = objectArray != null ? objectArray : EMPTY_ARGS;
        this.msg = sOAPMessage;
    }

    public EJBContextHandler(MethodDescriptor methodDescriptor, Object[] objectArray) {
        this.methodDescriptor = methodDescriptor;
        this.values = objectArray != null ? objectArray : EMPTY_ARGS;
    }

    private EJBContextHandler(String[] stringArray, Object[] objectArray) {
        this.names = stringArray;
        this.values = objectArray;
    }

    void setSOAPMessage(SOAPMessage sOAPMessage) {
        this.msg = sOAPMessage;
    }

    void setEjb(EnterpriseBean enterpriseBean) {
        this.ejb = enterpriseBean;
    }

    public int size() {
        return this.values.length;
    }

    public String[] getNames() {
        if (this.names == null) {
            this.names = EJBContextHandler.md2paramNames(this.methodDescriptor);
        }
        return this.names;
    }

    public Object getValue(String string) {
        try {
            return this.values[this.indexOf(string)];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private int indexOf(String string) {
        if (this.names == null) {
            this.names = EJBContextHandler.md2paramNames(this.methodDescriptor);
        }
        int n = this.names.length / 2;
        for (int i = 0; i < this.names.length; ++i) {
            if (!string.equals(this.names[i])) continue;
            if (i < n) {
                return i;
            }
            return i - n;
        }
        return -1;
    }

    public ContextElement[] getValues(String[] stringArray) {
        ContextElement[] contextElementArray = new ContextElement[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.indexOf(stringArray[i]);
            if (n2 == -1) continue;
            contextElementArray[n++] = new ContextElement(stringArray[i], this.values[n2]);
        }
        if (n < stringArray.length) {
            ContextElement[] contextElementArray2 = contextElementArray;
            contextElementArray = new ContextElement[n];
            System.arraycopy(contextElementArray2, 0, contextElementArray, 0, n);
        }
        return contextElementArray;
    }

    public Object getContext(String string) throws PolicyContextException {
        if (string == null) {
            return null;
        }
        if (string.equals(JACC_ARGUMENTS_KEY)) {
            return this.values;
        }
        if (string.equals(JACC_SOAP_MSG_KEY)) {
            return this.msg;
        }
        if (string.equals(JACC_EJB_KEY)) {
            return this.ejb;
        }
        return null;
    }

    static String[] md2paramNames(MethodDescriptor methodDescriptor) {
        int n = methodDescriptor.getMethodInfo().getMethodParams().length;
        int n2 = n * 2;
        if (n2 == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n2];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "Parameter" + (i + 1);
            stringArray[i + n] = "com.bea.contextelement.ejb20.Parameter" + (i + 1);
        }
        return stringArray;
    }

    public static String[] getKeys() {
        return jacc_keys;
    }
}

