/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import com.oracle.pitchfork.interfaces.intercept.__ProxyControl;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.Context;
import javax.persistence.OptimisticLockException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import weblogic.ejb.OptimisticConcurrencyException;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.deployer.MBeanDeploymentInfoImpl;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.internal.InvocationWrapper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb20.persistence.spi.PersistenceRuntimeException;
import weblogic.health.HealthMonitorService;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.transaction.RollbackException;
import weblogic.transaction.TimedOutException;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TransactionSystemException;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.StackTraceUtils;

public final class EJBRuntimeUtils {
    private static final boolean debug = false;
    private static final boolean ignoreStackTraceInMsg = Boolean.getBoolean("weblogic.ejb.ignoreStackTraceInExceptionMessage");
    private static final HashMap ejbStateMap = new HashMap();
    private static final HashMap ejbAllowedActionsMap;

    public static void throwException(Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        throw (Error)throwable;
    }

    public static void throwRemoteException(InternalException internalException) throws RemoteException {
        EJBRuntimeUtils.throwRemoteException("EJB Exception: ", internalException);
    }

    public static void throwRemoteException(String string, Throwable throwable) throws RemoteException {
        if (throwable instanceof OutOfMemoryError) {
            HealthMonitorService.panic(throwable);
        }
        RemoteException remoteException = null;
        if (throwable instanceof InternalException) {
            InternalException internalException = (InternalException)throwable;
            if (internalException.detail != null) {
                throwable = internalException.detail;
                string = internalException.getMessage();
            } else {
                throw new RemoteException(internalException.getMessage() + ": " + StackTraceUtils.throwable2StackTrace((Throwable)internalException));
            }
        }
        if (throwable instanceof javax.transaction.RollbackException) {
            EJBRuntimeUtils.throwTransactionRolledback(string, throwable);
        } else {
            remoteException = throwable instanceof NoSuchEntityException ? new NoSuchObjectException(string + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable)) : (throwable instanceof RemoteException ? (RemoteException)throwable : new RemoteException(string, throwable));
        }
        throw remoteException;
    }

    public static void throwEJBException(InternalException internalException) throws EJBException {
        EJBRuntimeUtils.throwEJBException("EJB Exception: ", internalException);
    }

    public static void throwEJBException(String string, Throwable throwable) throws EJBException {
        InternalException internalException;
        if (throwable instanceof InternalException) {
            internalException = (InternalException)throwable;
            if (internalException.detail != null) {
                throwable = internalException.detail;
                string = internalException.getMessage();
            } else {
                throw new EJBException(internalException.getMessage() + ": " + StackTraceUtils.throwable2StackTrace((Throwable)internalException));
            }
        }
        if (!(throwable instanceof javax.transaction.RollbackException)) {
            if (throwable instanceof NoSuchEntityException) {
                internalException = new NoSuchObjectLocalException(throwable.getMessage() + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable), (Exception)throwable);
                internalException.initCause(throwable);
                throw internalException;
            }
            if (throwable instanceof EJBException) {
                throw (EJBException)throwable;
            }
            if (throwable instanceof NoSuchObjectException) {
                throw new NoSuchObjectLocalException(throwable.getMessage() + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
            if (throwable instanceof Exception) {
                internalException = new EJBException(string + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable), (Exception)throwable);
                internalException.initCause(throwable);
                throw internalException;
            }
            throw new EJBException(string + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
        EJBRuntimeUtils.throwTransactionRolledbackLocal(string, throwable);
    }

    public static void throwInternalException(String string, Throwable throwable) throws InternalException {
        if (throwable instanceof InternalException) {
            throw (InternalException)throwable;
        }
        if (throwable instanceof PersistenceRuntimeException) {
            PersistenceRuntimeException persistenceRuntimeException = (PersistenceRuntimeException)throwable;
            if (persistenceRuntimeException.getCausedByException() instanceof InternalException) {
                throw (InternalException)persistenceRuntimeException.getCausedByException();
            }
            throw new InternalException(string, persistenceRuntimeException.getCausedByException());
        }
        throw new InternalException(string, throwable);
    }

    public static void throwTransactionRolledback(String string, Throwable throwable) throws RemoteException {
        Object object;
        if (throwable instanceof InternalException) {
            object = (InternalException)throwable;
            if (((InternalException)object).detail != null) {
                throwable = ((InternalException)object).detail;
                string = ((Throwable)object).getMessage();
            } else {
                throw new TransactionRolledbackException(((Throwable)object).getMessage() + ": " + StackTraceUtils.throwable2StackTrace((Throwable)object));
            }
        }
        throwable = EJBRuntimeUtils.unwrapRollbackException(throwable);
        object = ignoreStackTraceInMsg ? string : string + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable);
        TransactionRolledbackException transactionRolledbackException = new TransactionRolledbackException((String)object);
        transactionRolledbackException.detail = throwable;
        throw transactionRolledbackException;
    }

    public static void throwWrappedTransactionRolledback(String string, Throwable throwable) throws InternalException {
        try {
            EJBRuntimeUtils.throwTransactionRolledback(string, throwable);
        }
        catch (RemoteException remoteException) {
            throw new InternalException("EJB Exception: ", remoteException);
        }
    }

    public static void throwTransactionRolledbackLocal(String string, Throwable throwable) throws TransactionRolledbackLocalException {
        Object object;
        if (throwable instanceof InternalException) {
            object = (InternalException)throwable;
            if (((InternalException)object).detail != null) {
                throwable = ((InternalException)object).detail;
                string = ((Throwable)object).getMessage();
            } else {
                throw new TransactionRolledbackLocalException(((Throwable)object).getMessage() + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
        if ((throwable = EJBRuntimeUtils.unwrapRollbackException(throwable)) instanceof Exception) {
            object = new TransactionRolledbackLocalException(string, (Exception)throwable);
            object.initCause(throwable);
            throw object;
        }
        object = ignoreStackTraceInMsg ? string : string + ": " + StackTraceUtils.throwable2StackTrace((Throwable)throwable);
        TransactionRolledbackLocalException transactionRolledbackLocalException = new TransactionRolledbackLocalException((String)object);
        transactionRolledbackLocalException.initCause(throwable);
        throw transactionRolledbackLocalException;
    }

    public static void throwWrappedTransactionRolledbackLocal(String string, Throwable throwable) throws InternalException {
        try {
            EJBRuntimeUtils.throwTransactionRolledbackLocal(string, throwable);
        }
        catch (TransactionRolledbackLocalException transactionRolledbackLocalException) {
            throw new InternalException("EJB Exception: ", transactionRolledbackLocalException);
        }
    }

    public static void throwRuntimeException(String string, InternalException internalException) {
        Throwable throwable = null;
        throwable = internalException.detail == null ? new NestedRuntimeException(string, (Throwable)internalException) : (internalException.detail instanceof RuntimeException ? (RuntimeException)internalException.detail : new NestedRuntimeException(string, internalException.detail));
        throw throwable;
    }

    private static Throwable unwrapRollbackException(Throwable throwable) {
        RollbackException rollbackException;
        if (throwable instanceof RollbackException && (rollbackException = (RollbackException)throwable).getNested() != null) {
            throwable = rollbackException.getNested();
            while (throwable instanceof NestedRuntimeException && throwable.getCause() != null) {
                throwable = ((NestedRuntimeException)throwable).getNestedException();
            }
        }
        return throwable;
    }

    public static boolean isSpecialSystemException(Throwable throwable) {
        if (throwable instanceof InternalException) {
            InternalException internalException = (InternalException)throwable;
            if (internalException.detail != null) {
                throwable = internalException.detail;
            }
        }
        return throwable instanceof NoSuchObjectException || throwable instanceof NoSuchEntityException || throwable instanceof NoSuchObjectLocalException || throwable instanceof NoSuchEJBException;
    }

    static InvocationWrapper createWrapWithTxs(MethodDescriptor methodDescriptor) throws InternalException {
        Transaction transaction = methodDescriptor.getCallerTx();
        Transaction transaction2 = null;
        Thread thread2 = null;
        Object object = methodDescriptor.getInvokeTxForCom(transaction);
        if (object instanceof Transaction) {
            transaction2 = (Transaction)object;
        } else {
            thread2 = (Thread)object;
        }
        InvocationWrapper invocationWrapper = new InvocationWrapper(transaction, transaction2, thread2, methodDescriptor);
        return invocationWrapper;
    }

    static InvocationWrapper createWrapWithTxsForBus(MethodDescriptor methodDescriptor) throws InternalException {
        Transaction transaction = methodDescriptor.getCallerTx();
        Transaction transaction2 = null;
        Thread thread2 = null;
        Object object = methodDescriptor.getInvokeTxForBus(transaction);
        if (object instanceof Transaction) {
            transaction2 = (Transaction)object;
        } else {
            thread2 = (Thread)object;
        }
        InvocationWrapper invocationWrapper = new InvocationWrapper(transaction, transaction2, thread2, methodDescriptor);
        return invocationWrapper;
    }

    public static InvocationWrapper createWrap() {
        Transaction transaction = null;
        Transaction transaction2 = null;
        Thread thread2 = Thread.currentThread();
        InvocationWrapper invocationWrapper = new InvocationWrapper(transaction, transaction2, thread2);
        return invocationWrapper;
    }

    public static Object getInvokeTxOrThread() {
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        if (transaction == null) {
            return Thread.currentThread();
        }
        return transaction;
    }

    static InvocationWrapper createWrapWithTxs(MethodDescriptor methodDescriptor, Object object) throws InternalException {
        InvocationWrapper invocationWrapper = EJBRuntimeUtils.createWrapWithTxs(methodDescriptor);
        invocationWrapper.setPrimaryKey(object);
        return invocationWrapper;
    }

    static InvocationWrapper createWrapWithTxsForBus(MethodDescriptor methodDescriptor, Object object) throws InternalException {
        InvocationWrapper invocationWrapper = EJBRuntimeUtils.createWrapWithTxsForBus(methodDescriptor);
        invocationWrapper.setPrimaryKey(object);
        return invocationWrapper;
    }

    static void setWrapWithTxs(InvocationWrapper invocationWrapper) throws InternalException {
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        Transaction transaction = methodDescriptor.getCallerTx();
        Transaction transaction2 = null;
        Thread thread2 = null;
        Object object = methodDescriptor.getInvokeTxForCom(transaction);
        if (object instanceof Transaction) {
            transaction2 = (Transaction)object;
        } else {
            thread2 = (Thread)object;
        }
        invocationWrapper.setInvokeTx(transaction2);
        invocationWrapper.setThread(thread2);
    }

    static void setWrapWithTxsForBus(InvocationWrapper invocationWrapper) throws InternalException {
        MethodDescriptor methodDescriptor = invocationWrapper.getMethodDescriptor();
        Transaction transaction = methodDescriptor.getCallerTx();
        Transaction transaction2 = null;
        Thread thread2 = null;
        Object object = methodDescriptor.getInvokeTxForBus(transaction);
        if (object instanceof Transaction) {
            transaction2 = (Transaction)object;
        } else {
            thread2 = (Thread)object;
        }
        invocationWrapper.setInvokeTx(transaction2);
        invocationWrapper.setThread(thread2);
    }

    public static boolean isAppExceptionNeedtoRollback(DeploymentInfo deploymentInfo, Throwable throwable) {
        Class<?> clazz;
        Map map = deploymentInfo.getApplicationExceptions();
        ConcurrentHashMap<Class<?>, Boolean> concurrentHashMap = ((MBeanDeploymentInfoImpl)deploymentInfo).getRollBackExeptionsCache();
        Boolean bl = (Boolean)concurrentHashMap.get(clazz = throwable.getClass());
        if (bl == null) {
            String string = clazz.getName();
            if (map.containsKey(string)) {
                bl = (boolean)((Boolean)map.get(string));
                concurrentHashMap.put(clazz, bl);
                return bl;
            }
            if (((MBeanDeploymentInfoImpl)deploymentInfo).addApplicationException(clazz)) {
                return EJBRuntimeUtils.isAppExceptionNeedtoRollback(deploymentInfo, throwable);
            }
        } else {
            return bl;
        }
        concurrentHashMap.put(clazz, false);
        return false;
    }

    public static boolean isAppException(BeanInfo beanInfo, Method method, Throwable throwable) {
        if (!beanInfo.isEJB30()) {
            return EJBRuntimeUtils.isAppException(method, throwable);
        }
        if (Error.class.isAssignableFrom(throwable.getClass())) {
            return false;
        }
        if (RemoteException.class.isAssignableFrom(throwable.getClass())) {
            return false;
        }
        if (!RuntimeException.class.isAssignableFrom(throwable.getClass())) {
            return true;
        }
        Map map = beanInfo.getDeploymentInfo().getApplicationExceptions();
        Class<?> clazz = throwable.getClass();
        MBeanDeploymentInfoImpl mBeanDeploymentInfoImpl = (MBeanDeploymentInfoImpl)beanInfo.getDeploymentInfo();
        ConcurrentHashMap<Class<?>, Boolean> concurrentHashMap = mBeanDeploymentInfoImpl.getApplicationExeptionsCache();
        Boolean bl = (Boolean)concurrentHashMap.get(clazz);
        if (bl == null) {
            String string = clazz.getName();
            if (map.containsKey(string)) {
                concurrentHashMap.put(clazz, true);
                return true;
            }
            if (mBeanDeploymentInfoImpl.addApplicationException(clazz)) {
                return EJBRuntimeUtils.isAppException(beanInfo, method, throwable);
            }
        } else {
            return bl;
        }
        concurrentHashMap.put(clazz, false);
        return false;
    }

    public static boolean isAppException(Method method, Throwable throwable) {
        return EJBRuntimeUtils.isAppException(method, null, throwable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAppException(Method method, Class[] classArray, Throwable throwable) {
        int n;
        if (throwable instanceof InternalException) {
            InternalException internalException = (InternalException)throwable;
            if (internalException.detail == null) return false;
            throwable = internalException.detail;
        } else if (throwable instanceof PersistenceRuntimeException) {
            throwable = ((PersistenceRuntimeException)throwable).getCausedByException();
        }
        if (throwable instanceof RemoteException) {
            return false;
        }
        if (throwable instanceof RuntimeException) {
            return false;
        }
        Class<?> clazz = throwable.getClass();
        Class<?>[] classArray2 = method.getExceptionTypes();
        for (n = 0; n < classArray2.length; ++n) {
            if (!classArray2[n].isAssignableFrom(clazz)) continue;
            return true;
        }
        if (classArray == null) return false;
        for (n = 0; n < classArray.length; ++n) {
            if (!classArray[n].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean runningInOurTx(InvocationWrapper invocationWrapper) {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        if (transaction == null) {
            return false;
        }
        return !transaction.equals(transaction2);
    }

    public static boolean runningInCallerTx(InvocationWrapper invocationWrapper) {
        Transaction transaction = invocationWrapper.getInvokeTx();
        Transaction transaction2 = invocationWrapper.getCallerTx();
        if (transaction == null) {
            return false;
        }
        return transaction.equals(transaction2);
    }

    public static void pushEnvironment(Context context) {
        javaURLContextFactory.pushContext(context);
    }

    public static void popEnvironment() {
        javaURLContextFactory.popContext();
    }

    public static void resumeCallersTransaction(Transaction transaction, Transaction transaction2) throws InternalException {
        try {
            if (transaction != null && !transaction.equals(transaction2)) {
                TransactionManager transactionManager = TxHelper.getTransactionManager();
                try {
                    transactionManager.resume(transaction);
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    transactionManager.forceResume(transaction);
                }
            }
        }
        catch (SystemException systemException) {
            EJBLogger.logErrorResumingTx((Exception)((Object)systemException));
            throw new InternalException("Error resuming caller's transaction", systemException);
        }
    }

    public static boolean isRollback(InvocationWrapper invocationWrapper) {
        boolean bl = false;
        Transaction transaction = invocationWrapper.getInvokeTx();
        try {
            int n;
            if (invocationWrapper.getBean() != null && transaction != null && ((n = transaction.getStatus()) == 1 || n == 9 || n == 4)) {
                bl = true;
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isSystemRollback(InvocationWrapper invocationWrapper) {
        boolean bl = false;
        Transaction transaction = invocationWrapper.getInvokeTx();
        Throwable throwable = ((TransactionImpl)transaction).getRollbackReason();
        if (throwable instanceof TimedOutException || throwable instanceof TransactionSystemException) {
            bl = true;
        }
        return bl;
    }

    static String getEJBStateAsString(int n) {
        return (String)ejbStateMap.get(new Integer(n));
    }

    static void addOperationToejbAllowedActionsMap(Object object, String string) {
        String string2 = (String)ejbAllowedActionsMap.get(object);
        string = string2 != null ? string2 + " OR '" + string + "'" : "'" + string + "'";
        ejbAllowedActionsMap.put(object, string);
    }

    static String ejbEJBOperationAsString(int n) {
        return (String)ejbAllowedActionsMap.get(new Integer(n));
    }

    public static boolean beanEq(Class clazz, EnterpriseBean enterpriseBean, PitchforkContext pitchforkContext) {
        if (enterpriseBean == null) {
            return false;
        }
        if (enterpriseBean instanceof __ProxyControl) {
            Class clazz2 = pitchforkContext.getPitchforkUtils().getTargetClass(enterpriseBean);
            return clazz2 == clazz;
        }
        return clazz == enterpriseBean.getClass();
    }

    public static boolean isOptimisticLockException(Throwable throwable) {
        return throwable instanceof OptimisticLockException || throwable instanceof OptimisticConcurrencyException;
    }

    static {
        ejbStateMap.put(new Integer(1), "context setting");
        ejbStateMap.put(new Integer(2), "context unsetting");
        ejbStateMap.put(new Integer(4), "ejbCreate");
        ejbStateMap.put(new Integer(8), "ejbPostCreate");
        ejbStateMap.put(new Integer(16), "ejbRemove");
        ejbStateMap.put(new Integer(32), "ejbActivate");
        ejbStateMap.put(new Integer(64), "ejbPassivate");
        ejbStateMap.put(new Integer(128), "running business method");
        ejbStateMap.put(new Integer(256), "after begining business method");
        ejbStateMap.put(new Integer(512), "before completing business method");
        ejbStateMap.put(new Integer(1024), "after completing business method");
        ejbStateMap.put(new Integer(2048), "finder method");
        ejbStateMap.put(new Integer(4096), "select method");
        ejbStateMap.put(new Integer(8192), "home method");
        ejbStateMap.put(new Integer(16384), "ejbLoad");
        ejbStateMap.put(new Integer(32768), "ejbStore");
        ejbStateMap.put(new Integer(65536), "ejbTimeout");
        ejbStateMap.put(new Integer(131072), "webservice business method");
        ejbAllowedActionsMap = new HashMap();
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(258047), "getting ejb home");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(2036), "getting caller principal for the Stateful EJB");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(196736), "getting caller principal for the Stateless EJB");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(125084), "getting caller principal for Entity EJB");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(2036), "is caller in role for Stateful EJB");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(196736), "is caller in role for Stateless EJB");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(125084), "is caller in role for Entity EJB");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(198644), "getting EJB object for Session bean");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(114936), "getting EJB object for Entity bean");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(197504), "getting rollback only for session bean");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(125084), "getting rollback only for entity bean");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(197504), "setting rollback only for session bean");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(125084), "setting rollback only for entity bean");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(196852), "getting the user transaction");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(114936), "getting the primary key");
        EJBRuntimeUtils.addOperationToejbAllowedActionsMap(new Integer(254204), "getting the Timer Service");
    }
}

