/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import javax.persistence.EntityManager;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.ejb.container.EJBLogger;
import weblogic.logging.Loggable;

public final class ExtendedPersistenceContextWrapper {
    private final PersistenceUnitInfoImpl persistenceUnit;
    private final String persistenceUnitName;
    private int referenceCount;
    private EntityManager entityManager = null;

    public ExtendedPersistenceContextWrapper(PersistenceUnitInfoImpl persistenceUnitInfoImpl) {
        this.persistenceUnit = persistenceUnitInfoImpl;
        this.persistenceUnitName = persistenceUnitInfoImpl.getPersistenceUnitId();
        this.referenceCount = 1;
        this.entityManager = this.persistenceUnit.getUnwrappedEntityManagerFactory().createEntityManager();
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        if (this.referenceCount < 1 && this.entityManager != null) {
            this.entityManager.close();
            this.entityManager = null;
        }
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public EntityManager getEntityManager() {
        if (this.referenceCount < 1) {
            Loggable loggable = EJBLogger.logExtendedPersistenceContextClosedLoggable();
            throw new IllegalStateException(loggable.getMessage());
        }
        return this.entityManager;
    }
}

