/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import javax.ejb.EnterpriseBean;
import javax.transaction.Transaction;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.utils.Debug;

public final class InvocationWrapper {
    private static boolean verbose = false;
    private Transaction callerTx;
    private Transaction invokeTx;
    private Thread thread;
    private EnterpriseBean bean;
    private Object primaryKey;
    private MethodDescriptor md;
    private boolean isLocal;
    private boolean hasSystemExceptionOccured;
    private boolean isRemoteInvocation;
    private boolean shouldLogException = true;

    public InvocationWrapper(Transaction transaction, Transaction transaction2, Thread thread2, MethodDescriptor methodDescriptor) {
        this.callerTx = transaction;
        this.invokeTx = transaction2;
        this.thread = thread2;
        this.md = methodDescriptor;
        this.isLocal = methodDescriptor.isLocal();
    }

    public InvocationWrapper(Transaction transaction, Transaction transaction2, Thread thread2) {
        this.callerTx = transaction;
        this.invokeTx = transaction2;
        this.thread = thread2;
    }

    public final String toString() {
        return "[InvocationWrapper] callerTx: " + this.callerTx + " invokeTx: " + this.invokeTx + " bean:" + this.bean + " primaryKey: " + this.primaryKey + "MethodDescriptor: " + this.md;
    }

    public EnterpriseBean getBean() {
        return this.bean;
    }

    public void setBean(EnterpriseBean enterpriseBean) {
        this.bean = enterpriseBean;
    }

    public Transaction getCallerTx() {
        if (verbose) {
            Debug.say((String)("Returning a caller tx of " + this.callerTx));
        }
        return this.callerTx;
    }

    void setCallerTx(Transaction transaction) {
        this.callerTx = transaction;
    }

    public Transaction getInvokeTx() {
        if (verbose) {
            Debug.say((String)("Returning an invoke tx: " + this.invokeTx));
        }
        return this.invokeTx;
    }

    public void setInvokeTx(Transaction transaction) {
        this.invokeTx = transaction;
    }

    public Thread getThread() {
        if (verbose) {
            Debug.say((String)("Returning thread: " + this.thread));
        }
        return this.thread;
    }

    public void setThread(Thread thread2) {
        this.thread = thread2;
    }

    public Object getInvokeTxOrThread() {
        if (this.invokeTx != null) {
            return this.invokeTx;
        }
        return this.thread;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Object object) {
        this.primaryKey = object;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.md;
    }

    void setMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.md = methodDescriptor;
        this.isLocal = this.md.isLocal();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setIsLocal(boolean bl) {
        this.isLocal = bl;
    }

    public boolean hasSystemExceptionOccured() {
        return this.hasSystemExceptionOccured;
    }

    public void setSystemExceptionOccured() {
        this.hasSystemExceptionOccured = true;
    }

    public void setIsRemoteInvocation() {
        this.isRemoteInvocation = true;
    }

    public boolean isRemoteInvocation() {
        return this.isRemoteInvocation;
    }

    public boolean shouldLogException() {
        return this.shouldLogException;
    }

    public void skipLoggingException() {
        this.shouldLogException = false;
    }
}

