/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.resource.spi.ActivationSpec;
import weblogic.connector.external.EndpointActivationException;
import weblogic.connector.external.EndpointActivationUtils;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenManagerIntf;
import weblogic.ejb.container.internal.MDConnectionManager;
import weblogic.ejb.container.internal.MessageEndpointFactoryImpl;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.descriptor.ActivationConfigBean;
import weblogic.j2ee.descriptor.ActivationConfigPropertyBean;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.bean.BeanInitializer;
import weblogic.utils.bean.ConversionException;

public final class JCABindingManager
extends MDConnectionManager {
    private MessageDrivenManagerIntf mdManager;
    private Context environmentContext;
    private MessageEndpointFactoryImpl factory;
    private ActivationSpec activationSpec;

    public JCABindingManager(MessageDrivenBeanInfo messageDrivenBeanInfo, Context context, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) throws WLDeploymentException {
        super(messageDrivenBeanInfo, context, messageDrivenEJBRuntimeMBean);
        this.mdManager = (MessageDrivenManagerIntf)this.info.getBeanManager();
        this.environmentContext = context;
    }

    protected void disconnect(boolean bl) throws EndpointActivationException {
        if (this.factory != null) {
            this.factory.setReady(false);
        }
        try {
            if (debugLogger.isDebugEnabled()) {
                this.debugState();
            }
            if (debugLogger.isDebugEnabled()) {
                JCABindingManager.debug("activationSpec=" + this.activationSpec);
            }
            if (this.activationSpec == null) {
                if (debugLogger.isDebugEnabled()) {
                    JCABindingManager.debug("The activationSpec is null, deActivation is skipped");
                }
            } else {
                EndpointActivationUtils.accessor.deActivateEndpoint(this.info.getDisplayName(), this.mdManager.getResourceAdapterJndiName(), this.info.getMessagingTypeInterfaceName(), this.activationSpec, this.factory, this.runtimeMBean);
            }
            this.setState(1);
        }
        catch (EndpointActivationException endpointActivationException) {
            if (debugLogger.isDebugEnabled()) {
                JCABindingManager.debug("** FAILED to deactivate endpoint: " + (Object)((Object)endpointActivationException));
                endpointActivationException.printStackTrace(System.err);
            }
            throw endpointActivationException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void connect() throws EndpointActivationException {
        assert (this.getState() != 2);
        ActivationConfigBean activationConfigBean = this.info.getActivationConfigBean();
        try {
            block14: {
                try {
                    if (debugLogger.isDebugEnabled()) {
                        this.debugState();
                    }
                    ++this.reconnectionCount;
                    this.activationSpec = (ActivationSpec)EndpointActivationUtils.accessor.getActivationSpec(this.mdManager.getResourceAdapterJndiName(), this.info.getMessagingTypeInterfaceName());
                    if (this.activationSpec == null) {
                        throw new RuntimeException("Problem during connect, activationSpec is null");
                    }
                    this.setActivationSpec(this.activationSpec, activationConfigBean);
                    if (debugLogger.isDebugEnabled()) {
                        JCABindingManager.debug("activationSpec=" + this.activationSpec);
                    }
                    this.factory = new MessageEndpointFactoryImpl(this.info);
                    if (this.factory != null) {
                        this.factory.setReady(true);
                    }
                    EndpointActivationUtils.accessor.activateEndpoint(this.info.getDisplayName(), this.mdManager.getResourceAdapterJndiName(), this.info.getMessagingTypeInterfaceName(), this.activationSpec, this.factory, this.runtimeMBean);
                    if (this.state != 3) {
                        this.setState(2);
                    }
                    this.runtimeMBean.setMDBStatus("running");
                    if (debugLogger.isDebugEnabled()) {
                        this.debugState();
                    }
                    if (!debugLogger.isDebugEnabled()) break block14;
                    JCABindingManager.debug("\n\n +++++++++++  Got Connection ++++++++++\n");
                }
                catch (EndpointActivationException endpointActivationException) {
                    if (!debugLogger.isDebugEnabled()) throw endpointActivationException;
                    JCABindingManager.debug("** FAILED to activate endpoint: " + (Object)((Object)endpointActivationException));
                    endpointActivationException.printStackTrace(System.err);
                    throw endpointActivationException;
                }
                catch (RuntimeException runtimeException) {
                    if (!debugLogger.isDebugEnabled()) throw runtimeException;
                    JCABindingManager.debug("** FAILED to activate endpoint with: " + runtimeException);
                    runtimeException.printStackTrace(System.err);
                    throw runtimeException;
                }
            }
            Object var4_2 = null;
            this.runtimeMBean.setJMSConnectionAlive(this.getState() == 2);
            if (this.getState() == 2) {
                this.runtimeMBean.setConnectionStatus("Connected");
                return;
            }
            this.runtimeMBean.setConnectionStatus("re-connecting");
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.runtimeMBean.setJMSConnectionAlive(this.getState() == 2);
            if (this.getState() == 2) {
                this.runtimeMBean.setConnectionStatus("Connected");
                throw throwable;
            }
            this.runtimeMBean.setConnectionStatus("re-connecting");
            throw throwable;
        }
    }

    protected void logException(Exception exception) {
        if (exception instanceof EndpointActivationException) {
            EJBLogger.logMDBUnableToConnectToJCA((String)this.info.getEJBName(), (String)this.mdManager.getResourceAdapterJndiName(), (String)((EndpointActivationException)((Object)exception)).getMessage());
        } else if (exception instanceof RuntimeException) {
            EJBLogger.logMDBUnableToConnectToJCA((String)this.info.getEJBName(), (String)this.mdManager.getResourceAdapterJndiName(), (String)(exception.getMessage() == null ? StackTraceUtils.throwable2StackTrace((Throwable)exception) : exception.getMessage()));
        }
    }

    private void setActivationSpec(ActivationSpec activationSpec, ActivationConfigBean activationConfigBean) {
        if (activationConfigBean == null) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ActivationConfigPropertyBean[] activationConfigPropertyBeanArray = activationConfigBean.getActivationConfigProperties();
        for (int i = 0; i < activationConfigPropertyBeanArray.length; ++i) {
            String string = activationConfigPropertyBeanArray[i].getActivationConfigPropertyName();
            String string2 = activationConfigPropertyBeanArray[i].getActivationConfigPropertyValue();
            if ("MESSAGESELECTOR".equalsIgnoreCase(string) && string2 == "" || string == null || string2 == null) continue;
            hashtable.put(string, string2);
        }
        BeanInitializer beanInitializer = new BeanInitializer();
        try {
            beanInitializer.initializeBean((Object)activationSpec, hashtable);
        }
        catch (ConversionException conversionException) {
            Debug.say((String)("Fail to set ActivationSpec. " + conversionException.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRAUndeploy() {
        this.setState(6);
        ClassLoader classLoader = this.info.getClassLoader();
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader2 = thread2.getContextClassLoader();
        thread2.setContextClassLoader(classLoader);
        this.activationSpec = null;
        try {
            this.scheduleReconnection();
            Object var5_4 = null;
            if (classLoader2 != null) {
                thread2.setContextClassLoader(classLoader2);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (classLoader2 != null) {
                thread2.setContextClassLoader(classLoader2);
            }
            throw throwable;
        }
    }

    public synchronized void signalBackgroundThreads() {
        Debug.say((String)"This operation is not supported for JCA based MDB");
    }

    public synchronized boolean suspend(boolean bl) {
        try {
            EndpointActivationUtils.accessor.suspendInbound(this.info.getResourceAdapterJndiName(), this.factory, null);
            this.factory.setReady(false);
            this.runtimeMBean.setMDBStatus("Suspended at " + new Date(System.currentTimeMillis()) + " by the user.");
            return true;
        }
        catch (EndpointActivationException endpointActivationException) {
            if (debugLogger.isDebugEnabled()) {
                JCABindingManager.debug("** FAILED to suspend endpoint: " + (Object)((Object)endpointActivationException));
                endpointActivationException.printStackTrace(System.err);
            }
            throw new RuntimeException((Throwable)((Object)endpointActivationException));
        }
    }

    public synchronized boolean resume(boolean bl) {
        try {
            EndpointActivationUtils.accessor.resumeInbound(this.info.getResourceAdapterJndiName(), this.factory, null);
            this.factory.setReady(true);
            this.runtimeMBean.setMDBStatus("running");
            return true;
        }
        catch (EndpointActivationException endpointActivationException) {
            if (debugLogger.isDebugEnabled()) {
                JCABindingManager.debug("** FAILED to suspend endpoint: " + (Object)((Object)endpointActivationException));
                endpointActivationException.printStackTrace(System.err);
            }
            throw new RuntimeException((Throwable)((Object)endpointActivationException));
        }
    }

    public void shutdown() {
        Debug.say((String)"This operation is not supported for JCA based MDB");
    }

    protected List getMessagingTypeMethods() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Class clazz = this.info.getMessagingTypeInterfaceClass();
        if (clazz != null) {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                arrayList.add(methodArray[i]);
            }
        }
        return arrayList;
    }

    private void testRA() {
        Debug.say((String)"isDeliveryTransacted started");
        boolean bl = false;
        for (Method method : this.getMessagingTypeMethods()) {
            try {
                bl = this.factory.isDeliveryTransacted(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Debug.say((String)("NoSuchMethodException= " + noSuchMethodException));
            }
            Debug.say((String)("isDeliveryTransacted for " + method.getName() + " = " + bl));
        }
        Debug.say((String)"isDeliveryTransacted ended");
    }

    private static void debug(String string) {
        debugLogger.debug("[JCABindingManager] " + string);
    }
}

