/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.security.PasswordCredential;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import weblogic.deployment.jms.ForeignOpaqueReference;
import weblogic.deployment.jms.JMSConnectionHelper;
import weblogic.deployment.jms.JMSSessionPoolManager;
import weblogic.deployment.jms.MDBSession;
import weblogic.deployment.jms.WrappedClassManager;
import weblogic.deployment.jms.WrappedTransactionalSession;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.internal.ContinuousJMSMessagePoller;
import weblogic.ejb.container.internal.JMSMessagePoller;
import weblogic.ejb.container.internal.JMSPollerManager;
import weblogic.ejb.container.internal.MDConnectionManager;
import weblogic.ejb.container.internal.MDListener;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.spi.SecurityPlugin;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.extensions.DestinationDetail;
import weblogic.jms.extensions.MDBTransaction;
import weblogic.jms.extensions.WLConnection;
import weblogic.jms.extensions.WLSession;
import weblogic.logging.Loggable;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.rmi.cluster.ThreadPreferredHost;
import weblogic.rmi.spi.HostID;
import weblogic.security.UsernameAndPassword;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.EJBResource;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.security.subject.AbstractSubject;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.AssertionError;
import weblogic.utils.PlatformConstants;
import weblogic.work.MaxThreadsConstraint;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerHelper;
import weblogic.work.WorkManagerImpl;

public class JMSConnectionPoller
extends MDConnectionManager
implements ExceptionListener {
    static final int MAX_JMS_ERRORS = 3;
    private static final int DEFAULT_MAX_ERRORS = 10;
    private static final String MAX_ERROR_COUNT_PROPERTY = "weblogic.ejb.container.MaxMDBErrors";
    static final int MAX_ERROR_COUNT = Integer.getInteger("weblogic.ejb.container.MaxMDBErrors", 10);
    private static final int DEFAULT_ERROR_SLEEP_TIME_SECS = 5;
    private static final String ERROR_SLEEP_TIME_PROPERTY = "weblogic.ejb.container.MDBErrorSleepTime";
    static final int ERROR_SLEEP_TIME = Integer.getInteger("weblogic.ejb.container.MDBErrorSleepTime", 5) * 1000;
    private static final String XA_RESOURCE_NAME_PREFIX = "weblogic.ejb.container.JMSConnectionPoller.";
    private static final int POLLER_EXIT_WAIT = 60000;
    private static final String PROVIDERS_NEED_CONTINUOUS_POLLING = System.getProperty("weblogic.mdb.JMSProviders.NeedContinuousPolling");
    private static final boolean USE_81_STYLE_POLLING = Boolean.getBoolean("weblogic.mdb.message.81StylePolling");
    private Context environmentContext;
    private Hashtable foreignJNDIEnv;
    private Hashtable foreignDestJNDIEnv;
    Destination destination = null;
    private static final int WORK_MODE_ASYNC_NOTRAN = 1;
    private static final int WORK_MODE_ASYNC_2PC = 2;
    private static final int WORK_MODE_SYNC_2PC = 3;
    private static final int WORK_MODE_SYNC_1PC = 4;
    private static final int WORK_MODE_SYNC_NOTRAN = 5;
    private boolean disconnectInProgress;
    private AuthenticatedSubject runAsSubject;
    private XAResource registeredResource;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private JMSMessagePoller poller;
    private JMSPollerManager pm;
    private String dispatchPolicyName = "weblogic.kernel.Default";
    private WorkManager wm;
    private ConnectionFactory connectionFactory;
    private XAConnectionFactory xaConnectionFactory;
    private Connection connection;
    private Session[] sessions;
    private XASession[] xaSessions;
    private MessageConsumer[] consumers;
    private String xaResourceName;
    private WrappedClassManager jmsWrapperManager;
    private final Object contextSubjectLock = new Object();
    private AuthenticatedSubject contextSubject;
    private boolean isForeign = false;
    private int workMode;
    private String messageSelector;
    private int acknowledgeMode;
    private boolean isAQJMS;
    private boolean dynamicSessionClose = false;
    private boolean needsContinuousPolling = false;
    private boolean needsContinuousPollingInitialized = false;

    public JMSConnectionPoller(MessageDrivenBeanInfo messageDrivenBeanInfo, Context context, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) throws WLDeploymentException {
        super(messageDrivenBeanInfo, context, messageDrivenEJBRuntimeMBean);
        this.environmentContext = context;
        if (this.info.getDispatchPolicy() != null) {
            this.dispatchPolicyName = this.info.getDispatchPolicy();
        }
        this.wm = this.info.getCustomWorkManager();
        this.xaResourceName = XA_RESOURCE_NAME_PREFIX + this.info.getName() + this.mdManager.getUniqueGlobalID();
        this.jmsWrapperManager = new WrappedClassManager();
        try {
            this.runAsSubject = this.info.getRunAsSubject();
        }
        catch (Exception exception) {
            this.runtimeMBean.setLastException(exception);
            throw new WLDeploymentException(exception.toString());
        }
    }

    private boolean isDestinationQueue() {
        return this.info.isDestinationQueue();
    }

    private boolean isDestinationTopic() {
        return this.info.isDestinationTopic();
    }

    public static boolean getCredentials(MessageDrivenBeanInfo messageDrivenBeanInfo, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Exception {
        boolean bl = false;
        if (messageDrivenBeanInfo.getSecurityPlugin() != null) {
            String string = messageDrivenBeanInfo.getSecurityPlugin().getPluginClass();
            String string2 = messageDrivenBeanInfo.getSecurityPlugin().getKey();
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("getting username/password from info.getSecurityPlugin()");
            }
            Object var6_8 = null;
            try {
                var6_8 = Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                EJBLogger.logPluginClassNotFound((String)messageDrivenBeanInfo.getEJBName(), (String)string);
            }
            catch (InstantiationException instantiationException) {
                EJBLogger.logPluginClassInstantiationError((String)messageDrivenBeanInfo.getEJBName(), (String)string);
            }
            catch (IllegalAccessException illegalAccessException) {
                EJBLogger.logPluginClassIllegalAccess((String)messageDrivenBeanInfo.getEJBName(), (String)string);
            }
            if (var6_8 instanceof SecurityPlugin) {
                UsernameAndPassword usernameAndPassword = ((SecurityPlugin)var6_8).getCredentials(string2);
                stringBuffer.append(usernameAndPassword.getUsername());
                stringBuffer2.append(new String(usernameAndPassword.getPassword()));
                bl = true;
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("userName=" + stringBuffer + "; password= ***..*** ");
                }
            } else {
                EJBLogger.logPluginClassNotImplment((String)messageDrivenBeanInfo.getEJBName(), (String)string);
            }
            return bl;
        }
        EJBResource eJBResource = new EJBResource(messageDrivenBeanInfo.getDeploymentInfo().getApplicationName(), messageDrivenBeanInfo.getDeploymentInfo().getEJBComponentName(), messageDrivenBeanInfo.getEJBName(), "onMessage", null, null);
        String string = "weblogicDEFAULT";
        CredentialManager credentialManager = (CredentialManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.CREDENTIALMANAGER);
        String[] stringArray = new String[]{"weblogic.UserPassword"};
        Vector vector = credentialManager.getCredentials(kernelId, messageDrivenBeanInfo.getRunAsSubject(), (Resource)eJBResource, stringArray);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object e;
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("getCredentials() get next credential");
            }
            if (!((e = iterator.next()) instanceof PasswordCredential)) continue;
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("found a PasswordCredential");
            }
            PasswordCredential passwordCredential = (PasswordCredential)e;
            stringBuffer.append(passwordCredential.getUserName());
            stringBuffer2.append(passwordCredential.getPassword());
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("userName=" + stringBuffer + "; password= ***..*** ");
            }
            bl = true;
        }
        return bl;
    }

    private Connection getXAConnection(String string, String string2, boolean bl) throws NamingException, JMSException, ClassCastException {
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("Found a xaconnection factory of type " + this.xaConnectionFactory.getClass().getName());
        }
        if (this.isDestinationQueue()) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Creating XAQueueConnection from factory");
            }
            if (bl) {
                if (this.xaConnectionFactory instanceof XAQueueConnectionFactory) {
                    return ((XAQueueConnectionFactory)this.xaConnectionFactory).createXAQueueConnection(string, string2);
                }
                return this.xaConnectionFactory.createXAConnection(string, string2);
            }
            if (this.xaConnectionFactory instanceof XAQueueConnectionFactory) {
                return ((XAQueueConnectionFactory)this.xaConnectionFactory).createXAQueueConnection();
            }
            return this.xaConnectionFactory.createXAConnection();
        }
        if (this.isDestinationTopic()) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Creating XATopicConnection from factory");
            }
            if (bl) {
                if (this.xaConnectionFactory instanceof XATopicConnectionFactory) {
                    return ((XATopicConnectionFactory)this.xaConnectionFactory).createXATopicConnection(string, string2);
                }
                return this.xaConnectionFactory.createXAConnection(string, string2);
            }
            if (this.xaConnectionFactory instanceof XATopicConnectionFactory) {
                return ((XATopicConnectionFactory)this.xaConnectionFactory).createXATopicConnection();
            }
            return this.xaConnectionFactory.createXAConnection();
        }
        throw new AssertionError("Unkown JMS destination type");
    }

    private Connection getConnection(String string, String string2, boolean bl) throws WLDeploymentException {
        try {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Found a connection factory of type " + this.connectionFactory.getClass().getName());
            }
            if (this.isDestinationQueue()) {
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Creating QueueConnection from factory");
                }
                if (bl) {
                    if (this.connectionFactory instanceof QueueConnectionFactory) {
                        return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(string, string2);
                    }
                    return this.connectionFactory.createConnection(string, string2);
                }
                if (this.connectionFactory instanceof QueueConnectionFactory) {
                    return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
                }
                return this.connectionFactory.createConnection();
            }
            if (this.isDestinationTopic()) {
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Creating TopicConnection from factory");
                }
                if (bl) {
                    if (this.connectionFactory instanceof TopicConnectionFactory) {
                        return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection(string, string2);
                    }
                    return this.connectionFactory.createConnection(string, string2);
                }
                if (this.connectionFactory instanceof TopicConnectionFactory) {
                    return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
                }
                return this.connectionFactory.createConnection();
            }
            throw new AssertionError("Unkown JMS destination type");
        }
        catch (JMSException jMSException) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("JMSException looking up connection factory: " + (Object)((Object)jMSException));
            }
            Loggable loggable = EJBLogger.logJmsExceptionWhileCreatingConnectionLoggable((String)JMSConnectionPoller.getAllExceptionText(jMSException), (Exception)((Object)jMSException));
            throw new WLDeploymentException(loggable.getMessage(), jMSException);
        }
    }

    private Destination getDestination(Context context, String string) throws WLDeploymentException {
        try {
            if (this.isDestinationQueue()) {
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Looking up Queue in JNDI named \"" + string + "\"");
                }
                Queue queue = (Queue)context.lookup(string);
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Found an object of type " + queue.getClass().getName());
                }
                if (queue instanceof DestinationImpl && !((DestinationImpl)queue).isQueue()) {
                    Loggable loggable = EJBLogger.logJndiNameWasNotAJMSDestinationLoggable((String)string);
                    throw new WLDeploymentException(loggable.getMessage());
                }
                return queue;
            }
            if (this.isDestinationTopic()) {
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Looking up Topic in JNDI named \"" + string + "\"");
                }
                Topic topic = (Topic)context.lookup(string);
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Found an object of type " + topic.getClass().getName());
                }
                if (topic instanceof DestinationImpl && !((DestinationImpl)topic).isTopic()) {
                    Loggable loggable = EJBLogger.logJndiNameWasNotAJMSDestinationLoggable((String)string);
                    throw new WLDeploymentException(loggable.getMessage());
                }
                return topic;
            }
            throw new AssertionError("Unknown JMS destination type");
        }
        catch (NamingException namingException) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("NamingException looking up destination: " + namingException);
            }
            Loggable loggable = EJBLogger.logJmsDestinationNotFoundLoggable((String)string);
            throw new WLDeploymentException(loggable.getMessage() + PlatformConstants.EOL + JMSConnectionPoller.getAllExceptionText(namingException), namingException);
        }
        catch (ClassCastException classCastException) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("ClassCastException looking up destination: " + classCastException);
            }
            Loggable loggable = EJBLogger.logJndiNameWasNotAJMSDestinationLoggable((String)string);
            throw new WLDeploymentException(loggable.getMessage(), classCastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jMSException) {
        this.runtimeMBean.setLastException(jMSException);
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("** JMS Failure detected on destination:" + this.mdManager.getDestinationName() + ". The exception was: " + JMSConnectionPoller.getAllExceptionText(jMSException));
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.state = 6;
            } else if (this.state == 5) {
                this.state = 7;
            }
        }
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        if (this.getState() == 6) {
            this.stopMessagePollerThread();
        }
        object = this.info.getClassLoader();
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader((ClassLoader)object);
        try {
            this.scheduleReconnection();
            Object var6_6 = null;
            if (classLoader != null) {
                thread2.setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (classLoader != null) {
                thread2.setContextClassLoader(classLoader);
            }
            throw throwable;
        }
    }

    static String getAllExceptionText(Throwable throwable) {
        JMSException jMSException;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(throwable.toString());
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuffer.append(PlatformConstants.EOL);
            stringBuffer.append("Nested exception: ");
            stringBuffer.append(throwable2.toString());
        }
        if (throwable instanceof JMSException && (jMSException = (JMSException)throwable).getLinkedException() != null && jMSException.getLinkedException() != throwable.getCause()) {
            stringBuffer.append(PlatformConstants.EOL);
            stringBuffer.append("Linked exception: ");
            stringBuffer.append(JMSConnectionPoller.getAllExceptionText(jMSException.getLinkedException()));
        }
        return stringBuffer.toString();
    }

    protected void logException(Exception exception) {
        EJBLogger.logMDBUnableToConnectToJMS((String)this.info.getEJBName(), (String)this.mdManager.getDestinationName(), (String)JMSConnectionPoller.getAllExceptionText(exception));
    }

    private void startMessagePollerThread() {
        if (this.poller != null) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Starting a thread to poll for messages for MDB " + this.info.getName());
            }
            this.poller.start();
            WorkManagerImpl.executeDaemonTask((String)this.info.getEJBName(), (int)10, (Runnable)this.poller);
        } else if (this.pm != null) {
            this.pm.start();
        }
    }

    protected synchronized void stopMessagePollerThread() {
        if (this.poller != null) {
            this.poller.stop();
        } else if (this.pm != null) {
            this.pm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitForMessagePollerExit(long l, boolean bl) {
        if (this.poller != null) {
            JMSMessagePoller jMSMessagePoller = this.poller;
            synchronized (jMSMessagePoller) {
                this.poller.stop();
                if (this.poller.getRunning()) {
                    try {
                        this.poller.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (bl) {
                    this.poller = null;
                }
            }
        }
        if (this.pm != null) {
            this.pm.waitForPollersToStop();
            if (bl) {
                this.pm.cleanupTimerManager();
                this.pm = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void connect() throws WLDeploymentException, JMSException, SystemException {
        assert (this.getState() != 2);
        try {
            try {
                if (debugLogger.isDebugEnabled()) {
                    this.debugState();
                }
                ++this.reconnectionCount;
                this.createJMSConnection(false);
                if (this.getState() != 3) {
                    this.setState(2);
                }
                if (debugLogger.isDebugEnabled()) {
                    this.debugState();
                }
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("\n\n +++++++++++  Got JMSConnection ++++++++++\n");
                }
                this.startJMSConnection();
            }
            catch (WLDeploymentException wLDeploymentException) {
                if (!debugLogger.isDebugEnabled()) throw wLDeploymentException;
                JMSConnectionPoller.debug("** FAILED TO CONNECT TO JMS WITH: " + wLDeploymentException);
                wLDeploymentException.printStackTrace(System.err);
                throw wLDeploymentException;
            }
            catch (JMSException jMSException) {
                if (!debugLogger.isDebugEnabled()) throw jMSException;
                JMSConnectionPoller.debug("** FAILED TO CONNECT TO JMS WITH: " + JMSConnectionPoller.getAllExceptionText(jMSException));
                jMSException.printStackTrace(System.err);
                throw jMSException;
            }
            catch (SystemException systemException) {
                if (!debugLogger.isDebugEnabled()) throw systemException;
                JMSConnectionPoller.debug("** FAILED TO CONNECT TO JMS WITH: " + (Object)((Object)systemException));
                systemException.printStackTrace(System.err);
                throw systemException;
            }
            catch (RuntimeException runtimeException) {
                if (!debugLogger.isDebugEnabled()) throw runtimeException;
                JMSConnectionPoller.debug("** FAILED TO CONNECT TO JMS WITH: " + runtimeException);
                runtimeException.printStackTrace(System.err);
                throw runtimeException;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.runtimeMBean.setJMSConnectionAlive(this.getState() == 2);
            if (this.getState() == 2) {
                this.runtimeMBean.setConnectionStatus("Connected");
            } else {
                this.info.reSetUsernameAndPassword();
                this.runtimeMBean.setConnectionStatus("re-connecting");
            }
            if (this.getState() != 6) throw throwable;
            this.stopMessagePollerThread();
            throw throwable;
        }
        this.runtimeMBean.setJMSConnectionAlive(this.getState() == 2);
        if (this.getState() == 2) {
            this.runtimeMBean.setConnectionStatus("Connected");
        } else {
            this.info.reSetUsernameAndPassword();
            this.runtimeMBean.setConnectionStatus("re-connecting");
        }
        if (this.getState() != 6) return;
        this.stopMessagePollerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(boolean bl) throws JMSException {
        String string;
        boolean bl2 = false;
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("disconnect is called");
        }
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.disconnectInProgress) {
                return;
            }
            this.disconnectInProgress = true;
        }
        try {
            block39: {
                int n;
                block38: {
                    object = this;
                    synchronized (object) {
                        this.stopMessagePollerThread();
                    }
                    SecurityHelper.pushRunAsSubject(this.getRightSubject(this.getContextSubject()));
                    this.stopJMSConnection();
                    this.waitForMessagePollerExit(60000L, true);
                    if (this.getState() == 6 && this.registeredResource != null) {
                        try {
                            TxHelper.getTransactionManager().unregisterResource(this.xaResourceName, true);
                        }
                        catch (Exception exception) {
                            if (!debugLogger.isDebugEnabled()) break block38;
                            JMSConnectionPoller.debug("Error unregistering XA resource: " + this.xaResourceName + " " + exception);
                        }
                    }
                }
                this.registeredResource = null;
                if (this.consumers != null) {
                    for (n = 0; n < this.consumers.length; ++n) {
                        if (this.consumers[n] == null) continue;
                        try {
                            this.consumers[n].close();
                            continue;
                        }
                        catch (JMSException jMSException) {
                            if (!bl) continue;
                            throw jMSException;
                        }
                    }
                    this.consumers = null;
                }
                if (this.sessions != null) {
                    for (n = 0; n < this.sessions.length; ++n) {
                        if (this.sessions[n] == null) continue;
                        try {
                            this.sessions[n].setMessageListener(null);
                            this.sessions[n].close();
                            continue;
                        }
                        catch (JMSException jMSException) {
                            if (!bl) continue;
                            throw jMSException;
                        }
                    }
                    this.sessions = null;
                }
                if (this.xaSessions != null) {
                    for (n = 0; n < this.xaSessions.length; ++n) {
                        if (this.xaSessions[n] == null) continue;
                        try {
                            this.xaSessions[n].close();
                            continue;
                        }
                        catch (JMSException jMSException) {
                            if (!bl) continue;
                            throw jMSException;
                        }
                    }
                    this.xaSessions = null;
                }
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (JMSException jMSException) {
                        if (!bl) break block39;
                        throw jMSException;
                    }
                }
            }
            bl2 = true;
            Object var8_12 = null;
            string = this.stateLock;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            String string2 = this.stateLock;
            synchronized (string2) {
                this.disconnectInProgress = false;
                if (bl2) {
                    this.state = this.state == 3 || this.state == 4 ? 4 : (this.state == 5 ? 7 : 1);
                }
            }
            this.destination = null;
            SecurityHelper.popRunAsSubject();
            if (debugLogger.isDebugEnabled()) {
                this.debugState();
            }
            throw throwable;
        }
        synchronized (string) {
            this.disconnectInProgress = false;
            if (bl2) {
                this.state = this.state == 3 || this.state == 4 ? 4 : (this.state == 5 ? 7 : 1);
            }
        }
        this.destination = null;
        SecurityHelper.popRunAsSubject();
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deleteDurableSubscriber() {
        block18: {
            if (this.isDestinationTopic() && this.info.isDurableSubscriber()) {
                String string = debugLogger.isDebugEnabled() ? "JMSClientID=" + this.mdManager.getJMSClientID() + " ejb=" + this.info.getEJBName() : null;
                this.createJMSConnection(true);
                if (this.connection instanceof WLConnection && this.info.getTopicMessagesDistributionMode() > 0) {
                    ((WLSession)this.sessions[0]).unsubscribe((Topic)this.destination, this.info.getEJBName());
                } else {
                    this.sessions[0].unsubscribe(this.mdManager.getJMSClientID());
                }
                this.runtimeMBean.setJmsClientID("");
                EJBLogger.logMDBDurableSubscriptionDeletion((String)this.mdManager.getJMSClientID(), (String)this.info.getEJBName());
                Object var4_2 = null;
                try {
                    this.disconnect(false);
                }
                catch (Exception exception) {}
                break block18;
                {
                    catch (WLDeploymentException wLDeploymentException) {
                        if (debugLogger.isDebugEnabled()) {
                            JMSConnectionPoller.debug("Exception is thrown while deleting durable subscriber " + string + ": " + wLDeploymentException);
                        }
                        Object var4_3 = null;
                        try {
                            this.disconnect(false);
                        }
                        catch (Exception exception) {}
                        break block18;
                    }
                    catch (JMSException jMSException) {
                        if (debugLogger.isDebugEnabled()) {
                            JMSConnectionPoller.debug("Exception is thrown while deleting durable subscriber " + string + ": " + (Object)((Object)jMSException));
                        }
                        Object var4_4 = null;
                        try {
                            this.disconnect(false);
                        }
                        catch (Exception exception) {}
                        break block18;
                    }
                    catch (SystemException systemException) {
                        if (debugLogger.isDebugEnabled()) {
                            JMSConnectionPoller.debug("Exception is thrown while deleting durable subscriber " + string + ": " + (Object)((Object)systemException));
                        }
                        Object var4_5 = null;
                        try {
                            this.disconnect(false);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    try {
                        this.disconnect(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startJMSConnection() {
        if (this.getState() != 2) return;
        EJBLogger.logMDBReConnectedToJMS((String)this.info.getEJBName(), (String)this.mdManager.getDestinationName());
        if (this.connection == null) return;
        try {
            try {
                SecurityHelper.pushRunAsSubject(this.getContextSubject());
                this.connection.start();
                this.runtimeMBean.setMDBStatus("running");
            }
            catch (JMSException jMSException) {
                this.runtimeMBean.setLastException(jMSException);
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("JMS exception starting JMS connection: " + JMSConnectionPoller.getAllExceptionText(jMSException));
                }
                this.setState(6);
                Object var3_2 = null;
                SecurityHelper.popRunAsSubject();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            SecurityHelper.popRunAsSubject();
            throw throwable;
        }
        SecurityHelper.popRunAsSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopJMSConnection() {
        if (this.connection != null) {
            try {
                try {
                    this.connection.stop();
                }
                catch (JMSException jMSException) {
                    if (debugLogger.isDebugEnabled()) {
                        JMSConnectionPoller.debug("Exception on stopping connection: " + (Object)((Object)jMSException));
                    }
                    if (this.getState() == 5) {
                        this.setState(7);
                    }
                    Object var3_2 = null;
                    if (!this.scheduleResume) {
                        this.runtimeMBean.setMDBStatus("Suspended at " + new Date(System.currentTimeMillis()) + " by the user.");
                    }
                }
                Object var3_1 = null;
                if (!this.scheduleResume) {
                    this.runtimeMBean.setMDBStatus("Suspended at " + new Date(System.currentTimeMillis()) + " by the user.");
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (!this.scheduleResume) {
                    this.runtimeMBean.setMDBStatus("Suspended at " + new Date(System.currentTimeMillis()) + " by the user.");
                }
                throw throwable;
            }
        }
    }

    private int determineWorkMode() throws JMSException, WLDeploymentException {
        XAQueueSession xAQueueSession;
        boolean bl = this.isAQJMS = this.connection != null && this.connection.getClass().getName().startsWith("oracle.jms");
        if (!this.info.isOnMessageTransacted()) {
            if (this.isAQJMS && this.info.getMinimizeAQSessions()) {
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("MDB will poll synchronously with non transacted MDB");
                }
                if (!this.info.isDestinationTopic() || this.info.isDurableSubscriber()) {
                    this.dynamicSessionClose = true;
                }
                return 5;
            }
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("MDB will poll asynchronously with no transactions");
            }
            return 1;
        }
        if (!(this.connection instanceof XAConnection)) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("MDB will poll synchronously using a one-phase commit transaction");
            }
            return 4;
        }
        if (this.isAQJMS) {
            if (this.info.getMinimizeAQSessions() && (!this.info.isDestinationTopic() || this.info.isDurableSubscriber())) {
                this.dynamicSessionClose = true;
            }
            return 3;
        }
        if (this.info.getMaxMessagesInTransaction() > 1) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("MDB will poll synchronously, two-phase transaction, multiple msg in tran");
            }
            return 3;
        }
        if (this.connection instanceof XAQueueConnection) {
            xAQueueSession = ((XAQueueConnection)this.connection).createXAQueueSession();
        } else if (this.connection instanceof XATopicConnection) {
            xAQueueSession = ((XATopicConnection)this.connection).createXATopicSession();
        } else if (this.connection instanceof XAConnection) {
            xAQueueSession = ((XAConnection)this.connection).createXASession();
        } else if (this.connection instanceof QueueConnection) {
            xAQueueSession = ((QueueConnection)this.connection).createQueueSession(true, 1);
        } else if (this.connection instanceof TopicConnection) {
            xAQueueSession = ((TopicConnection)this.connection).createTopicSession(true, 1);
        } else if (this.connection instanceof Connection) {
            xAQueueSession = this.connection.createSession(true, 1);
        } else {
            throw new AssertionError("JMS Connection object of an unknown type");
        }
        if (xAQueueSession instanceof MDBTransaction) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("MDB will poll asynchronously using MDBTransaction");
            }
            xAQueueSession.close();
            return 2;
        }
        xAQueueSession.close();
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("MDB will poll synchronously using XA");
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpTopicSessions(Connection connection, int n, Destination destination, int n2) throws WLDeploymentException, JMSException, SystemException {
        boolean bl = true;
        if (!this.isAQJMS && (connection instanceof TopicConnection || connection instanceof XATopicConnection)) {
            bl = false;
        }
        boolean bl2 = false;
        MDListener[] mDListenerArray = new MDListener[n];
        this.sessions = new Session[n];
        this.consumers = new MessageConsumer[n];
        this.xaSessions = new XASession[n];
        if ((this.acknowledgeMode == 1 || this.acknowledgeMode == 3) && n2 > 1 && this.workMode != 5) {
            this.acknowledgeMode = 2;
        }
        if ((this.workMode == 3 || this.workMode == 4) && n2 > 1) {
            if (this.mdManager.getTopicMessagesDistributionMode() == 0) {
                EJBLogger.logUsingSingleThreadForMDBTopic((String)this.info.getName());
            }
            n2 = 1;
        }
        if (this.workMode == 5 && n2 > 1) {
            n2 = 1;
        }
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("Will create " + n2 + " message listener objects to process messages for MDB " + this.info.getName());
        }
        if (this.mdManager.needsSetForwardFilter()) {
            this.messageSelector = this.messageSelector == null || this.messageSelector != null && this.messageSelector.trim().length() == 0 ? "NOT JMS_WL_DDForwarded" : "NOT JMS_WL_DDForwarded AND (" + this.messageSelector + ")";
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("message selector on " + this.info.getComponentName() + " is \"" + this.messageSelector + "\"");
            }
        }
        for (int i = 0; i < n; ++i) {
            Object var13_12;
            MDBSession mDBSession = this.setUpTopicSessionAt(i, bl);
            if (i == 0 && this.workMode == 1 && this.acknowledgeMode == 2 && this.sessions[i] instanceof WLSession) {
                bl2 = true;
            }
            mDListenerArray[i] = new MDListener(null, this, n2 <= 1 ? 0 : n2, this.environmentContext, this.sessions[i], mDBSession, this.acknowledgeMode, this.runtimeMBean, this.info, this.mdManager.getPool(), bl2, this.wm, this.workMode == 5);
            if (this.workMode == 3 || this.workMode == 4 || this.workMode == 5) {
                if (this.xaSessions[i] != null && !(this.xaSessions[i] instanceof WLSession) && this.registeredResource == null) {
                    if (debugLogger.isDebugEnabled()) {
                        JMSConnectionPoller.debug("Registering XA resource " + this.xaResourceName);
                    }
                    TransactionManager transactionManager = TxHelper.getTransactionManager();
                    this.registeredResource = ((WrappedTransactionalSession)this.sessions[i]).getXAResource();
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("weblogic.transaction.registration.type", "dynamic");
                    hashtable.put("weblogic.transaction.registration.settransactiontimeout", "true");
                    transactionManager.registerResource(this.xaResourceName, this.registeredResource, hashtable);
                    transactionManager.setTransactionTimeout(this.info.getTransactionTimeoutMS() / 1000);
                }
                if (this.dynamicSessionClose) {
                    assert (i == 0) : "For dynamicSessionClose, there is only one session created";
                    this.pm = new JMSPollerManager(this.info.getName(), this, this.consumers, mDListenerArray, this.wm, false, destination, this.dynamicSessionClose);
                    continue;
                }
                if (this.mdManager.getTopicMessagesDistributionMode() == 0) {
                    this.poller = new JMSMessagePoller(this.info.getName(), this, null, this.consumers[i], mDListenerArray[i], this.wm, i, this.dynamicSessionClose);
                    continue;
                }
                if (i != n - 1 || this.mdManager.getTopicMessagesDistributionMode() != 2 && this.mdManager.getTopicMessagesDistributionMode() != 1) continue;
                this.pm = new JMSPollerManager(this.info.getName(), this, this.consumers, mDListenerArray, this.wm, false, destination, this.dynamicSessionClose);
                continue;
            }
            try {
                SecurityHelper.pushRunAsSubject(this.getContextSubject());
                this.consumers[i].setMessageListener((MessageListener)mDListenerArray[i]);
                connection.setExceptionListener((ExceptionListener)this);
                if (this.sessions[i] instanceof WLSession) {
                    ((WLSession)this.sessions[i]).setExceptionListener(this);
                }
                var13_12 = null;
            }
            catch (Throwable throwable) {
                var13_12 = null;
                SecurityHelper.popRunAsSubject();
                throw throwable;
            }
            SecurityHelper.popRunAsSubject();
            {
                continue;
            }
        }
        this.startMessagePollerThread();
    }

    private MDBSession setUpTopicSessionAt(int n, boolean bl) throws JMSException, WLDeploymentException {
        Session session;
        switch (this.workMode) {
            case 1: {
                if (bl) {
                    this.sessions[n] = this.connection.createSession(false, this.acknowledgeMode);
                    break;
                }
                this.sessions[n] = ((TopicConnection)this.connection).createTopicSession(false, this.acknowledgeMode);
                break;
            }
            case 5: {
                if (bl) {
                    this.sessions[n] = this.connection.createSession(false, 2);
                    break;
                }
                this.sessions[n] = ((TopicConnection)this.connection).createTopicSession(false, 2);
                break;
            }
            case 2: {
                if (bl) {
                    this.xaSessions[n] = ((XAConnection)this.connection).createXASession();
                    this.sessions[n] = this.xaSessions[n].getSession();
                    break;
                }
                this.xaSessions[n] = ((XATopicConnection)this.connection).createXATopicSession();
                this.sessions[n] = ((XATopicSession)this.xaSessions[n]).getTopicSession();
                break;
            }
            case 3: {
                if (bl) {
                    this.xaSessions[n] = ((XAConnection)this.connection).createXASession();
                    session = this.xaSessions[n].getSession();
                    this.sessions[n] = (Session)JMSSessionPoolManager.getWrappedMDBPollerSession((Session)session, (XASession)this.xaSessions[n], (int)3, (boolean)(session instanceof WLSession), (String)this.xaResourceName, (WrappedClassManager)this.jmsWrapperManager);
                    break;
                }
                this.xaSessions[n] = ((XATopicConnection)this.connection).createXATopicSession();
                session = ((XATopicSession)this.xaSessions[n]).getTopicSession();
                this.sessions[n] = (Session)JMSSessionPoolManager.getWrappedMDBPollerSession((Session)session, (XASession)this.xaSessions[n], (int)2, (boolean)(session instanceof WLSession), (String)this.xaResourceName, (WrappedClassManager)this.jmsWrapperManager);
                break;
            }
            case 4: {
                Loggable loggable = EJBLogger.logproviderIsNotTransactedButMDBIsTransactedLoggable((String)this.info.getEJBName());
                throw new WLDeploymentException(loggable.getMessage());
            }
            default: {
                throw new AssertionError("Internal error in JMSConnectionPoller: Unknown work mode");
            }
        }
        session = null;
        session = bl ? JMSSessionPoolManager.getWrappedMDBSession((Session)this.sessions[n], (int)3, (WrappedClassManager)this.jmsWrapperManager) : JMSSessionPoolManager.getWrappedMDBSession((Session)this.sessions[n], (int)2, (WrappedClassManager)this.jmsWrapperManager);
        String string = null;
        if (this.info.isDurableSubscriber()) {
            string = this.mdManager.getTopicMessagesDistributionMode() > 0 && this.info.isDurableSubscriber() ? this.info.getEJBName() : this.mdManager.getJMSClientID();
            this.consumers[n] = bl ? this.sessions[n].createDurableSubscriber((Topic)this.destination, string, this.messageSelector, this.info.noLocalMessages()) : ((TopicSession)this.sessions[n]).createDurableSubscriber((Topic)this.destination, string, this.messageSelector, this.info.noLocalMessages());
        } else {
            this.consumers[n] = bl ? this.sessions[n].createConsumer((Destination)((Topic)this.destination), this.messageSelector, this.info.noLocalMessages()) : ((TopicSession)this.sessions[n]).createSubscriber((Topic)this.destination, this.messageSelector, this.info.noLocalMessages());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpQueueSessions(Destination destination, int n) throws WLDeploymentException, JMSException, SystemException {
        Object object;
        int n2;
        boolean bl = false;
        if (!this.isAQJMS && (this.connection instanceof QueueConnection || this.connection instanceof XAQueueConnection)) {
            this.sessions = new QueueSession[n];
            this.xaSessions = new XAQueueSession[n];
            this.consumers = new QueueReceiver[n];
        } else {
            this.sessions = new Session[n];
            this.xaSessions = new XASession[n];
            this.consumers = new MessageConsumer[n];
            bl = true;
        }
        MDListener[] mDListenerArray = new MDListener[n];
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("Will create " + n + " message listener objects to process messages for MDB " + this.info.getName());
        }
        int n3 = this.dynamicSessionClose ? 1 : n;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.setUpQueueSessionAt(n2, bl);
            mDListenerArray[n2] = new MDListener(null, this, 0, this.environmentContext, this.sessions[n2], (MDBSession)object, this.acknowledgeMode, this.runtimeMBean, this.info, this.mdManager.getPool(), false, this.wm, this.workMode == 5);
        }
        if (n3 < n) {
            for (n2 = n3; n2 < n; ++n2) {
                mDListenerArray[n2] = new MDListener(null, this, 0, this.environmentContext, null, null, this.acknowledgeMode, this.runtimeMBean, this.info, this.mdManager.getPool(), false, this.wm, this.workMode == 5);
            }
        }
        if (this.workMode == 3 || this.workMode == 4 || this.workMode == 5) {
            if (this.xaSessions[0] != null && !(this.xaSessions[0] instanceof WLSession) && this.registeredResource == null) {
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Registering XA resource " + this.xaResourceName);
                }
                TransactionManager transactionManager = TxHelper.getTransactionManager();
                this.registeredResource = ((WrappedTransactionalSession)this.sessions[0]).getXAResource();
                object = new Hashtable();
                ((Hashtable)object).put("weblogic.transaction.registration.type", "standard");
                ((Hashtable)object).put("weblogic.transaction.registration.settransactiontimeout", "true");
                transactionManager.registerResource(this.xaResourceName, this.registeredResource, (Hashtable)object);
                transactionManager.setTransactionTimeout(this.info.getTransactionTimeoutMS() / 1000);
            }
            boolean bl2 = this.needsContinuousJMSMessagePolling();
            if (USE_81_STYLE_POLLING || this.info.getUse81StylePolling()) {
                if (bl2) {
                    this.poller = new ContinuousJMSMessagePoller(this.info.getName(), this, null, this.consumers[0], mDListenerArray[0], this.wm, 0);
                    for (int i = 1; i < n; ++i) {
                        ContinuousJMSMessagePoller continuousJMSMessagePoller = new ContinuousJMSMessagePoller(this.info.getName(), this, this.poller, this.consumers[i], mDListenerArray[i], this.wm, i);
                        this.poller.addChild(continuousJMSMessagePoller);
                    }
                } else {
                    this.poller = new JMSMessagePoller(this.info.getName(), this, null, this.consumers[0], mDListenerArray[0], this.wm, 0, this.dynamicSessionClose);
                    for (int i = 1; i < n; ++i) {
                        JMSMessagePoller jMSMessagePoller = new JMSMessagePoller(this.info.getName(), this, this.poller, this.consumers[i], mDListenerArray[i], this.wm, i, this.dynamicSessionClose);
                        this.poller.addChild(jMSMessagePoller);
                    }
                }
            } else {
                this.pm = new JMSPollerManager(this.info.getName(), this, this.consumers, mDListenerArray, this.wm, bl2, destination, this.dynamicSessionClose);
            }
            this.startMessagePollerThread();
        } else {
            try {
                SecurityHelper.pushRunAsSubject(this.getContextSubject());
                assert (n3 == n) : "dynamic close should not happen for async polling";
                for (n2 = 0; n2 < n; ++n2) {
                    this.consumers[n2].setMessageListener((MessageListener)mDListenerArray[n2]);
                    if (!(this.sessions[n2] instanceof WLSession)) continue;
                    ((WLSession)this.sessions[n2]).setExceptionListener(this);
                }
                this.connection.setExceptionListener((ExceptionListener)this);
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                SecurityHelper.popRunAsSubject();
                throw throwable;
            }
            SecurityHelper.popRunAsSubject();
            {
            }
        }
    }

    private MDBSession setUpQueueSessionAt(int n, boolean bl) throws JMSException, WLDeploymentException {
        Session session;
        this.xaSessions[n] = null;
        switch (this.workMode) {
            case 1: {
                if (bl) {
                    this.sessions[n] = this.connection.createSession(false, this.acknowledgeMode);
                    break;
                }
                this.sessions[n] = ((QueueConnection)this.connection).createQueueSession(false, this.acknowledgeMode);
                break;
            }
            case 5: {
                if (bl) {
                    this.sessions[n] = this.connection.createSession(false, 2);
                    break;
                }
                this.sessions[n] = ((QueueConnection)this.connection).createQueueSession(false, 2);
                break;
            }
            case 2: {
                if (bl) {
                    this.xaSessions[n] = ((XAConnection)this.connection).createXASession();
                    this.sessions[n] = this.xaSessions[n].getSession();
                    break;
                }
                this.xaSessions[n] = ((XAQueueConnection)this.connection).createXAQueueSession();
                this.sessions[n] = ((XAQueueSession)this.xaSessions[n]).getQueueSession();
                break;
            }
            case 3: {
                if (bl) {
                    this.xaSessions[n] = ((XAConnection)this.connection).createXASession();
                    session = this.xaSessions[n].getSession();
                    this.sessions[n] = (Session)JMSSessionPoolManager.getWrappedMDBPollerSession((Session)session, (XASession)this.xaSessions[n], (int)3, (boolean)(session instanceof WLSession), (String)this.xaResourceName, (WrappedClassManager)this.jmsWrapperManager);
                    break;
                }
                this.xaSessions[n] = ((XAQueueConnection)this.connection).createXAQueueSession();
                session = ((XAQueueSession)this.xaSessions[n]).getQueueSession();
                this.sessions[n] = (QueueSession)JMSSessionPoolManager.getWrappedMDBPollerSession((Session)session, (XASession)this.xaSessions[n], (int)1, (boolean)(session instanceof WLSession), (String)this.xaResourceName, (WrappedClassManager)this.jmsWrapperManager);
                break;
            }
            case 4: {
                Loggable loggable = EJBLogger.logproviderIsNotTransactedButMDBIsTransactedLoggable((String)this.info.getEJBName());
                throw new WLDeploymentException(loggable.getMessage());
            }
            default: {
                throw new AssertionError("Internal error in JMSConnectionPoller: Unknown work mode");
            }
        }
        if (this.sessions[n] == null) {
            throw new AssertionError("Internal error in JMSConnectionPoller: failed to create session");
        }
        session = null;
        if (bl) {
            session = JMSSessionPoolManager.getWrappedMDBSession((Session)this.sessions[n], (int)3, (WrappedClassManager)this.jmsWrapperManager);
            this.consumers[n] = this.sessions[n].createConsumer((Destination)((Queue)this.destination), this.messageSelector);
        } else {
            session = JMSSessionPoolManager.getWrappedMDBSession((Session)this.sessions[n], (int)1, (WrappedClassManager)this.jmsWrapperManager);
            this.consumers[n] = ((QueueSession)this.sessions[n]).createReceiver((Queue)this.destination, this.messageSelector);
        }
        return session;
    }

    public MessageConsumer reCreateMessageConsumer(Destination destination, int n) throws JMSException {
        String string = this.consumers[n].getMessageSelector();
        this.consumers[n].close();
        this.consumers[n] = this.connection instanceof QueueConnection || this.connection instanceof XAQueueConnection ? ((QueueSession)this.sessions[n]).createReceiver((Queue)destination, string) : this.sessions[n].createConsumer((Destination)((Queue)destination), string);
        return this.consumers[n];
    }

    void dynamicCloseSession(int n) throws JMSException {
        Throwable throwable;
        block13: {
            XASession xASession;
            block12: {
                assert (this.workMode == 5 || this.workMode == 3) : "work mode is " + this.workMode + ", dynamicClosingSession is only supported for SYNC_NOTRAN and SYNC_2PC";
                MessageConsumer messageConsumer = this.consumers[n];
                this.consumers[n] = null;
                Session session = this.sessions[n];
                this.sessions[n] = null;
                xASession = this.xaSessions[n];
                this.xaSessions[n] = null;
                throwable = null;
                try {
                    if (messageConsumer != null) {
                        messageConsumer.close();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block12;
                    throwable = throwable3;
                }
            }
            try {
                if (xASession != null) {
                    xASession.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block13;
                throwable = throwable4;
            }
        }
        if (throwable != null) {
            if (throwable instanceof JMSException) {
                throw (JMSException)throwable;
            }
            JMSException jMSException = new JMSException("Error in closing MDB session");
            jMSException.initCause(throwable);
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CreateSessionResult dynamicCreateSession(int n) throws JMSException {
        MDBSession mDBSession;
        block14: {
            assert (this.workMode == 5 || this.workMode == 3) : "work mode is " + this.workMode + ", dynamicCreateSession is only supported for SYNC_NOTRAN and SYNC_2PC";
            assert (this.consumers[n] == null) : "MessageConsumer at index " + n + " is not null";
            assert (this.sessions[n] == null) : "Session at index " + n + " is not null";
            assert (this.consumers[n] == null) : "XASession at index " + n + " is not null";
            mDBSession = null;
            if (this.isDestinationQueue()) {
                boolean bl = this.isAQJMS || !(this.connection instanceof QueueConnection) && !(this.connection instanceof XAQueueConnection);
                mDBSession = this.setUpQueueSessionAt(n, bl);
                break block14;
            }
            boolean bl = this.isAQJMS || !(this.connection instanceof TopicConnection) && !(this.connection instanceof XATopicConnection);
            mDBSession = this.setUpTopicSessionAt(n, bl);
        }
        Object var5_6 = null;
        if (mDBSession != null) return new CreateSessionResult(this.sessions[n], mDBSession, this.consumers[n]);
        try {
            this.dynamicCloseSession(n);
            return new CreateSessionResult(this.sessions[n], mDBSession, this.consumers[n]);
        }
        catch (Throwable throwable) {}
        return new CreateSessionResult(this.sessions[n], mDBSession, this.consumers[n]);
        {
            catch (WLDeploymentException wLDeploymentException) {
                assert (false) : "WLDeploymentException should not happen in dynamicCreateSession:" + wLDeploymentException;
                Object var5_7 = null;
                if (mDBSession != null) return new CreateSessionResult(this.sessions[n], mDBSession, this.consumers[n]);
                try {
                    this.dynamicCloseSession(n);
                    return new CreateSessionResult(this.sessions[n], mDBSession, this.consumers[n]);
                }
                catch (Throwable throwable) {}
                return new CreateSessionResult(this.sessions[n], mDBSession, this.consumers[n]);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (mDBSession != null) throw throwable;
            try {
                this.dynamicCloseSession(n);
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void checkNonCompliantConnectionUsage() throws JMSException {
        this.connection = JMSConnectionHelper.getXAConnectionToUse((Connection)this.connection);
    }

    private boolean needsContinuousJMSMessagePolling() {
        if (!this.needsContinuousPollingInitialized) {
            block12: {
                String string = this.connection.getClass().getName();
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("connectionClassName :" + string);
                }
                if (string.startsWith("com.tibco.tibjms") || string.startsWith("progress.message.jimpl.xa")) {
                    this.needsContinuousPolling = true;
                } else {
                    try {
                        String string2 = this.connection.getMetaData().getJMSProviderName().toLowerCase(Locale.ENGLISH);
                        if (debugLogger.isDebugEnabled()) {
                            JMSConnectionPoller.debug("connection provider name is: " + string2);
                        }
                        if (string2 != null && string2.contains("tibco")) {
                            this.needsContinuousPolling = true;
                        } else if (PROVIDERS_NEED_CONTINUOUS_POLLING != null && PROVIDERS_NEED_CONTINUOUS_POLLING.toLowerCase(Locale.ENGLISH).contains(string2)) {
                            this.needsContinuousPolling = true;
                            if (debugLogger.isDebugEnabled()) {
                                JMSConnectionPoller.debug("weblogic.mdb.JMSProviders.NeedContinuousPolling system property contains provider: " + string2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (!debugLogger.isDebugEnabled()) break block12;
                        JMSConnectionPoller.debug("provider name not found. getMetaData may not implemented.");
                    }
                }
            }
            this.needsContinuousPollingInitialized = true;
        }
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("needsContinuousPolling :" + this.needsContinuousPolling);
        }
        return this.needsContinuousPolling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createJMSConnection(boolean bl) throws WLDeploymentException, JMSException, SystemException {
        StringBuffer stringBuffer;
        int n2;
        Context context;
        block68: {
            this.messageSelector = this.mdManager.getMessageSelector();
            this.acknowledgeMode = this.info.getAcknowledgeMode();
            context = null;
            n2 = 1;
            try {
                if (this.connection == null) break block68;
                SecurityHelper.pushRunAsSubject(this.getRightSubject(this.getContextSubject()));
                try {
                    this.connection.close();
                    stringBuffer = null;
                    SecurityHelper.popRunAsSubject();
                    this.connection = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    SecurityHelper.popRunAsSubject();
                    this.connection = null;
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("Starting MDB: acknowledge mode = " + this.acknowledgeMode);
            JMSConnectionPoller.debug("Transacted = " + this.info.isOnMessageTransacted());
            JMSConnectionPoller.debug("Bean-managed = " + this.info.usesBeanManagedTx());
        }
        int n = this.calculateMaxConcurrentInstances();
        try {
            block72: {
                block70: {
                    block71: {
                        Object object;
                        SecurityHelper.pushRunAsSubject(this.runAsSubject);
                        stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        boolean bl2 = false;
                        String string = null;
                        try {
                            bl2 = JMSConnectionPoller.getCredentials(this.info, stringBuffer, stringBuffer2);
                            string = this.mdManager.getDestinationName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (debugLogger.isDebugEnabled()) {
                            JMSConnectionPoller.debug(" DestinationName from poolInfo " + string);
                        }
                        String string2 = this.mdManager.getConnectionFactoryJNDIName();
                        try {
                            if (bl2) {
                                if (debugLogger.isDebugEnabled()) {
                                    JMSConnectionPoller.debug("Obtained credentials user " + stringBuffer.toString() + " and " + "password ***..*** using Credential Mapper");
                                }
                                context = this.info.getInitialContext(stringBuffer.toString(), stringBuffer2.toString());
                                object = this.contextSubjectLock;
                                // MONITORENTER : object
                                this.contextSubject = this.getRightSubject((AuthenticatedSubject)this.info.getSubject());
                                // MONITOREXIT : object
                            } else {
                                if (debugLogger.isDebugEnabled()) {
                                    JMSConnectionPoller.debug("Check provider url " + this.mdManager.getProviderURL());
                                }
                                if (this.mdManager.getProviderURL() == null || this.mdManager.getProviderURL() != null && this.mdManager.getProviderURL().trim().length() == 0) {
                                    if (debugLogger.isDebugEnabled()) {
                                        JMSConnectionPoller.debug("Check foreign credentials");
                                    }
                                    if ((bl2 = this.getForeignJMSCredentials(stringBuffer, stringBuffer2)) && debugLogger.isDebugEnabled()) {
                                        JMSConnectionPoller.debug("Obtained credentials user " + stringBuffer.toString() + " and password ***..*** using " + "ForeignJMSConnectionFactoryMBean");
                                    }
                                    string2 = this.getRemoteJndiName(string2);
                                    string = this.getRemoteJndiName(string);
                                    if (debugLogger.isDebugEnabled()) {
                                        JMSConnectionPoller.debug(" destinationJNDIName for foreignJNDI " + string + " connFactoryJndiName " + string2);
                                    }
                                    context = this.getForeignContext(this.foreignJNDIEnv, true);
                                }
                            }
                            if (context == null && !this.isForeign() || this.isConfiguredAQJMSForeignServer()) {
                                context = this.getInitialContextFromInfo(this.info);
                                string2 = this.mdManager.getConnectionFactoryJNDIName();
                                string = this.mdManager.getDestinationName();
                                object = this.contextSubjectLock;
                                // MONITORENTER : object
                                this.contextSubject = this.getRightSubject((AuthenticatedSubject)this.info.getSubject());
                                // MONITOREXIT : object
                            }
                            if (context == null) {
                                throw new NamingException("JNDI Environment is unavailable");
                            }
                        }
                        catch (NamingException namingException) {
                            Loggable loggable = EJBLogger.logFailedJNDIContextToJMSProviderLoggable((Exception)namingException);
                            throw new WLDeploymentException(loggable.getMessage(), namingException);
                        }
                        SecurityHelper.pushRunAsSubject(this.getContextSubject());
                        try {
                            TopicSession[] topicSessionArray;
                            Context loggable;
                            object = this.mdManager.getDestination();
                            if (this.isThe3rdJMSVendor((DestinationDetail)object) || this.mdManager.isNoneDDMD()) {
                                loggable = context;
                                if (this.foreignDestJNDIEnv != null && !this.isConfiguredAQJMSForeignServer()) {
                                    loggable = this.getForeignContext(this.foreignDestJNDIEnv, false);
                                }
                                this.destination = this.getDestination(loggable, string);
                                if (!loggable.equals(context)) {
                                    try {
                                        loggable.close();
                                    }
                                    catch (NamingException namingException) {}
                                }
                            } else {
                                this.destination = object.getDestination();
                            }
                            loggable = null;
                            if (this.destination instanceof DestinationImpl) {
                                loggable = ThreadPreferredHost.get();
                                ThreadPreferredHost.set((HostID)JMSServerUtilities.getHostId(context, (DestinationImpl)this.destination));
                            }
                            try {
                                try {
                                    if (debugLogger.isDebugEnabled()) {
                                        JMSConnectionPoller.debug("Looking up connection factory in JNDI named \"" + string2 + "\"");
                                    }
                                    Object object2 = context.lookup(string2);
                                    if (this.mdManager.supportMultipleConncitons()) {
                                        if (debugLogger.isDebugEnabled()) {
                                            JMSConnectionPoller.debug("Under this mode, container creates" + n + " connections to destionation " + string);
                                        }
                                        n2 = n;
                                        n = 1;
                                    }
                                    if (object2 instanceof XAConnectionFactory || object2 instanceof XAQueueConnectionFactory || object2 instanceof XATopicConnectionFactory) {
                                        this.xaConnectionFactory = (XAConnectionFactory)object2;
                                        this.connection = this.getXAConnection(stringBuffer.toString(), stringBuffer2.toString(), bl2);
                                    } else {
                                        if (!(object2 instanceof ConnectionFactory || object2 instanceof QueueConnectionFactory || object2 instanceof TopicConnectionFactory)) {
                                            Loggable loggable2 = EJBLogger.logJndiNameWasNotAJMSConnectionFactoryLoggable((String)string2);
                                            throw new WLDeploymentException(loggable2.getMessage());
                                        }
                                        if (this.info.isOnMessageTransacted()) {
                                            Loggable loggable3 = EJBLogger.logJndiNameWasNotAXAJMSConnectionFactoryLoggable((String)string2);
                                            throw new WLDeploymentException(loggable3.getMessage());
                                        }
                                        this.connectionFactory = (ConnectionFactory)object2;
                                        this.connection = this.getConnection(stringBuffer.toString(), stringBuffer2.toString(), bl2);
                                    }
                                    Object var15_24 = null;
                                }
                                catch (NamingException namingException) {
                                    if (debugLogger.isDebugEnabled()) {
                                        JMSConnectionPoller.debug("NamingException looking up connection factory: " + namingException);
                                    }
                                    Loggable loggable4 = EJBLogger.logJmsConnectionFactoryNotFoundLoggable((String)string2);
                                    throw new WLDeploymentException(loggable4.getMessage() + PlatformConstants.EOL + JMSConnectionPoller.getAllExceptionText(namingException), namingException);
                                }
                                if (this.destination instanceof DestinationImpl) {
                                    ThreadPreferredHost.set((HostID)loggable);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var15_25 = null;
                                if (!(this.destination instanceof DestinationImpl)) throw throwable;
                                ThreadPreferredHost.set((HostID)loggable);
                                throw throwable;
                            }
                            if (this.isDestinationTopic()) {
                                this.setupConnection(this.connection);
                            }
                            if (!bl) break block70;
                            if (this.connection instanceof TopicConnection) {
                                TopicSession[] topicSessionArray2 = new TopicSession[1];
                                topicSessionArray = topicSessionArray2;
                                topicSessionArray2[0] = ((TopicConnection)this.connection).createTopicSession(false, this.acknowledgeMode);
                            } else {
                                Session[] sessionArray = new Session[1];
                                topicSessionArray = sessionArray;
                                sessionArray[0] = this.connection.createSession(false, this.acknowledgeMode);
                            }
                            this.sessions = topicSessionArray;
                            Object var17_27 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_29 = null;
                            SecurityHelper.popRunAsSubject();
                            throw throwable;
                        }
                        SecurityHelper.popRunAsSubject();
                        Object var19_30 = null;
                        if (context != null) {
                            SecurityHelper.pushRunAsSubject(this.getContextSubject());
                            try {
                                try {
                                    context.close();
                                }
                                catch (NamingException namingException) {
                                    Object var22_34 = null;
                                    SecurityHelper.popRunAsSubject();
                                    break block71;
                                }
                                Object var22_33 = null;
                                SecurityHelper.popRunAsSubject();
                            }
                            catch (Throwable throwable) {
                                Object var22_35 = null;
                                SecurityHelper.popRunAsSubject();
                                throw throwable;
                            }
                        }
                    }
                    SecurityHelper.popRunAsSubject();
                    return;
                }
                this.workMode = this.determineWorkMode();
                if (this.connection instanceof WLConnection) {
                    ((WLConnection)this.connection).setDispatchPolicy(this.dispatchPolicyName);
                    ((WLConnection)this.connection).setReconnectPolicy(JMSConstants.RECONNECT_POLICY_NONE);
                } else if (!WorkManagerHelper.isDefault(this.wm) && this.isDestinationQueue() && (this.workMode == 1 || this.workMode == 2)) {
                    EJBLogger.logMDBDispatchPolicyIgnored((String)this.info.getEJBName(), (String)this.dispatchPolicyName);
                }
                if (this.isDestinationTopic()) {
                    this.setUpTopicSessions(this.connection, n2, this.destination, n);
                } else {
                    if (!this.isDestinationQueue()) throw new AssertionError("Unknown JMS destination type");
                    this.setUpQueueSessions(this.destination, n);
                }
                this.checkNonCompliantConnectionUsage();
                Object var17_28 = null;
                SecurityHelper.popRunAsSubject();
                Object var19_31 = null;
                if (context != null) {
                    SecurityHelper.pushRunAsSubject(this.getContextSubject());
                    try {}
                    catch (Throwable throwable) {
                        Object var22_38 = null;
                        SecurityHelper.popRunAsSubject();
                        throw throwable;
                    }
                    try {}
                    catch (NamingException namingException) {
                        Object var22_37 = null;
                        SecurityHelper.popRunAsSubject();
                        break block72;
                    }
                    context.close();
                    Object var22_36 = null;
                    SecurityHelper.popRunAsSubject();
                }
            }
            SecurityHelper.popRunAsSubject();
            return;
        }
        catch (Throwable throwable) {
            block73: {
                Object var19_32 = null;
                if (context != null) {
                    SecurityHelper.pushRunAsSubject(this.getContextSubject());
                    try {}
                    catch (Throwable throwable2) {
                        Object var22_41 = null;
                        SecurityHelper.popRunAsSubject();
                        throw throwable2;
                    }
                    try {}
                    catch (NamingException namingException) {
                        Object var22_40 = null;
                        SecurityHelper.popRunAsSubject();
                        break block73;
                    }
                    context.close();
                    Object var22_39 = null;
                    SecurityHelper.popRunAsSubject();
                }
            }
            SecurityHelper.popRunAsSubject();
            throw throwable;
        }
    }

    private int calculateMaxConcurrentInstances() {
        int n;
        MaxThreadsConstraint maxThreadsConstraint = null;
        if (!WorkManagerHelper.isDefault(this.wm)) {
            maxThreadsConstraint = WorkManagerHelper.getMaxThreadsConstraint(this.wm);
        }
        if (maxThreadsConstraint != null) {
            n = maxThreadsConstraint.getCount();
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Custom WorkManager with MaxThreadsConstraint is specified, use MaxThreadsConstraint of maxConcurrentInstances=" + n);
            }
        } else if (!WorkManagerHelper.isDefault(this.wm) && this.wm.getType() == 2) {
            n = this.wm.getConfiguredThreadCount();
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Custom ExecuteThread is specified, use ExecuteThreadCount maxConcurrentInstances=" + n);
            }
        } else if (this.wm.getType() == 2) {
            n = this.wm.getConfiguredThreadCount() / 2 + 1;
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Default ExecuteThread, use ExecuteThreadCount/2+1 maxConcurrentInstances=" + n);
            }
        } else {
            n = Integer.getInteger("weblogic.mdb.DefaultThreadCount", 16);
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("no custom ExecuteThread or WorkManager with MaxThreadsConstraint is specified, use default thread size maxConcurrentInstances=" + n);
            }
        }
        if (this.info.getMaxConcurrentInstances() < n && debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("Thread size is limited by max-beans-in-free-pool, new maxConcurrentInstances=" + n);
        }
        n = n == -1 ? 16 : n;
        n = Math.min(this.info.getMaxConcurrentInstances(), n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalBackgroundThreads() {
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("JMS connection for MDB " + this.info.getName() + " signalled to exit");
        }
        String string = this.stateLock;
        synchronized (string) {
            if (this.state == 2) {
                this.state = 5;
            } else if (this.state != 3 && this.state != 5) {
                this.state = 7;
            }
        }
        this.stopMessagePollerThread();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean suspend(boolean bl) {
        this.signalBackgroundThreads();
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("JMS connection for MDB " + this.info.getName() + " is suspending");
        }
        if (bl && this.scheduleResume) {
            this.initDeliveryFailureParams();
            this.timer.cancel();
            this.timer = null;
        }
        this.waitForMessagePollerExit(60000L, false);
        try {
            SecurityHelper.pushRunAsSubject(this.getRightSubject(this.getContextSubject()));
            this.stopJMSConnection();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            SecurityHelper.popRunAsSubject();
            throw throwable;
        }
        SecurityHelper.popRunAsSubject();
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        this.runtimeMBean.incrementSuspendCount();
        return this.getState() != 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean resume(boolean bl) {
        int n;
        if (debugLogger.isDebugEnabled()) {
            JMSConnectionPoller.debug("JMS connection for MDB " + this.info.getName() + " is resuming.");
        }
        if (bl && this.scheduleResume) {
            this.initDeliveryFailureParams();
            this.timer.cancel();
            this.timer = null;
        }
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        String string = this.stateLock;
        synchronized (string) {
            this.state = this.state == 5 && this.connection != null ? 2 : 6;
            n = this.state;
        }
        this.startJMSConnection();
        if (n != 2) {
            this.scheduleReconnection();
        } else {
            this.startMessagePollerThread();
        }
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        return this.getState() == 2;
    }

    public void shutdown() {
        this.suspend(true);
    }

    private static void debug(String string) {
        debugLogger.debug("[JMSConnectionPoller] " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getForeignJMSCredentials(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        boolean bl = false;
        try {
            String string = this.mdManager.getConnectionFactoryJNDIName();
            Object object = this.lookupForeignObject(string);
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("getForeignJMSCredentials, lookup on " + string);
            }
            SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId);
            try {
                ForeignOpaqueReference foreignOpaqueReference;
                boolean bl2;
                if (object instanceof ForeignOpaqueReference && (bl2 = (foreignOpaqueReference = (ForeignOpaqueReference)object).isFactory())) {
                    if (foreignOpaqueReference.getUsername() != null && foreignOpaqueReference.getUsername().length() > 0) {
                        bl = true;
                        stringBuffer.append(foreignOpaqueReference.getUsername());
                        if (debugLogger.isDebugEnabled()) {
                            JMSConnectionPoller.debug("Found credentials for connection factory with username " + stringBuffer.toString());
                        }
                    }
                    if (foreignOpaqueReference.getPassword() != null && foreignOpaqueReference.getPassword().length() > 0) {
                        bl = true;
                        stringBuffer2.append(foreignOpaqueReference.getPassword());
                    }
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
                throw throwable;
            }
            SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
            if (!bl && !bl && debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("No credentials associated with foreign jms connection factory");
            }
            return bl;
        }
        catch (NamingException namingException) {
            if (debugLogger.isDebugEnabled()) {
                JMSConnectionPoller.debug("Can't get credentials associated with foreign jmsconnection factory: " + namingException);
            }
            return false;
        }
    }

    private boolean isConfiguredAQJMSForeignServer() {
        return this.foreignJNDIEnv != null && "oracle.jms.AQjmsInitialContextFactory".equals(this.foreignJNDIEnv.get("java.naming.factory.initial"));
    }

    private String getRemoteJndiName(String string) throws WLDeploymentException {
        String string2;
        block9: {
            string2 = string;
            try {
                Object object = this.lookupForeignObject(string);
                if (object instanceof ForeignOpaqueReference) {
                    ForeignOpaqueReference foreignOpaqueReference = (ForeignOpaqueReference)object;
                    string2 = foreignOpaqueReference.getRemoteJNDIName();
                    if (this.foreignJNDIEnv == null && foreignOpaqueReference.isFactory()) {
                        this.foreignJNDIEnv = foreignOpaqueReference.getJNDIEnvironment();
                        this.isForeign = true;
                    } else if (this.foreignDestJNDIEnv == null && !foreignOpaqueReference.isFactory()) {
                        this.foreignDestJNDIEnv = foreignOpaqueReference.getJNDIEnvironment();
                        this.isForeign = true;
                        if (this.foreignJNDIEnv == null) {
                            this.foreignJNDIEnv = this.foreignDestJNDIEnv;
                        }
                    }
                } else if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Can't find foreign JMS jndi name for " + string);
                }
            }
            catch (NamingException namingException) {
                if (!debugLogger.isDebugEnabled()) break block9;
                JMSConnectionPoller.debug("Can't get foreign JMS jndi name " + namingException);
            }
        }
        return string2;
    }

    private boolean isForeign() {
        if (!this.isForeign) {
            return false;
        }
        if (this.foreignJNDIEnv != null) {
            return true;
        }
        if (this.foreignJNDIEnv == null) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Context getForeignContext(Hashtable hashtable, boolean bl) {
        InitialContext initialContext = null;
        if (hashtable == null) return initialContext;
        SecurityHelper.pushRunAsSubject(this.getRightSubject(SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId)));
        try {
            try {
                initialContext = new InitialContext(hashtable);
                Object object = this.contextSubjectLock;
                synchronized (object) {
                    if (bl) {
                        this.contextSubject = this.getRightSubject(SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId));
                    }
                }
            }
            catch (NamingException namingException) {
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("Can't get initial context using foreign JNDI properties " + this.foreignJNDIEnv + " " + namingException);
                }
                Object var7_7 = null;
                SecurityHelper.popRunAsSubject();
                return initialContext;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SecurityHelper.popRunAsSubject();
            throw throwable;
        }
        SecurityHelper.popRunAsSubject();
        return initialContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getInitialContextFromInfo(MessageDrivenBeanInfo messageDrivenBeanInfo) throws NamingException {
        Context context;
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        SecurityHelper.pushRunAsSubject(this.getRightSubject(authenticatedSubject));
        try {
            context = messageDrivenBeanInfo.getInitialContext();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            SecurityHelper.popRunAsSubject();
            throw throwable;
        }
        SecurityHelper.popRunAsSubject();
        return context;
    }

    private AuthenticatedSubject getRightSubject(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject == null || SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isServerIdentity((AuthenticatedSubject)authenticatedSubject) || this.info.getIsRemoteSubjectExists() && authenticatedSubject.equals((Object)this.runAsSubject)) {
            return (AuthenticatedSubject)CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.mdManager.getProviderURL(), (AbstractSubject)authenticatedSubject);
        }
        return authenticatedSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupForeignObject(String string) throws NamingException {
        Object object;
        Context context = this.getInitialContextFromInfo(this.info);
        SecurityHelper.pushRunAsSubject(this.getRightSubject((AuthenticatedSubject)this.info.getSubject()));
        try {
            object = context.lookupLink(string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            SecurityHelper.popRunAsSubject();
            throw throwable;
        }
        context.close();
        SecurityHelper.popRunAsSubject();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticatedSubject getContextSubject() {
        Object object = this.contextSubjectLock;
        synchronized (object) {
            return this.contextSubject;
        }
    }

    Object doPrivilegedJMSAction(PrivilegedExceptionAction privilegedExceptionAction) throws JMSException {
        AuthenticatedSubject authenticatedSubject = this.getRightSubject(this.getContextSubject());
        try {
            return authenticatedSubject.doAs((AbstractSubject)kernelId, privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getCause() instanceof JMSException) {
                throw (JMSException)privilegedActionException.getCause();
            }
            throw new AssertionError((Throwable)privilegedActionException);
        }
    }

    boolean isCurrentSubjectKernelIdentity() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        return SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isServerIdentity((AuthenticatedSubject)authenticatedSubject);
    }

    private void setupConnection(Connection connection) throws JMSException {
        if (connection instanceof WLConnection && this.mdManager.getTopicMessagesDistributionMode() > 0 && this.mdManager.isAdvancedTopicSupported()) {
            if (this.mdManager.supportMultipleConncitons()) {
                ((WLConnection)connection).setClientID(this.mdManager.getJMSClientID(), WLConnection.CLIENT_ID_POLICY_UNRESTRICTED);
                ((WLConnection)connection).setSubscriptionSharingPolicy(WLConnection.SUBSCRIPTION_SHARABLE);
                if (debugLogger.isDebugEnabled()) {
                    JMSConnectionPoller.debug("MDB [" + this.info.getName() + "] JMS connection ClientID policy to " + this.mdManager.getDestinationName() + " is " + WLConnection.CLIENT_ID_POLICY_UNRESTRICTED);
                    JMSConnectionPoller.debug("jms connection SubscriptionSharingPolicy to " + this.mdManager.getDestinationName() + " is " + WLConnection.SUBSCRIPTION_SHARABLE);
                }
            } else {
                ((WLConnection)connection).setClientID(this.mdManager.getJMSClientID(), WLConnection.CLIENT_ID_POLICY_RESTRICTED);
                ((WLConnection)connection).setSubscriptionSharingPolicy(WLConnection.SUBSCRIPTION_EXCLUSIVE);
            }
            this.runtimeMBean.setJmsClientID(this.mdManager.getJMSClientID());
        } else if (this.info.isDurableSubscriber()) {
            this.runtimeMBean.setJmsClientID(this.mdManager.getJMSClientID());
            if (connection.getClientID() == null) {
                connection.setClientID(this.mdManager.getJMSClientID());
            }
        }
    }

    private boolean isThe3rdJMSVendor(DestinationDetail destinationDetail) {
        return destinationDetail.getType() == 2 || destinationDetail.getType() == 3;
    }

    static class CreateSessionResult {
        Session session;
        MDBSession wrappedSession;
        MessageConsumer consumer;

        CreateSessionResult(Session session, MDBSession mDBSession, MessageConsumer messageConsumer) {
            this.session = session;
            this.wrappedSession = mDBSession;
            this.consumer = messageConsumer;
        }
    }
}

