/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.internal.JMSConnectionPoller;
import weblogic.ejb.container.internal.MDListener;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManager;

public class JMSMessagePoller
implements Runnable {
    private static final DebugLogger debugLogger = EJBDebugService.invokeLogger;
    private static final int DEFAULT_EMPTY_QUEUE_WAIT_SECS = 2;
    private static final int SHORT_EMPTY_QUEUE_WAIT = 250;
    private static final String MESSAGE_WAIT_TIME_PROPERTY = "weblogic.ejb.container.MDBMessageWaitTime";
    private static final String TRANSACTION_NAME_PREFIX = "JMSMessagePoller.";
    private static final int MESSAGE_WAIT_TIME = Integer.getInteger("weblogic.ejb.container.MDBMessageWaitTime", 2) * 1000;
    private final String mdbName;
    protected final JMSConnectionPoller connectionPoller;
    private MessageConsumer consumer;
    private final TransactionManager tranManager;
    private final MDListener listener;
    private final WorkManager wm;
    private final String transactionName;
    private LinkedList availableChildren;
    private LinkedList allChildren;
    private JMSMessagePoller parentPoller;
    private volatile boolean keepRunning;
    private boolean isRunning;
    private int errorCount;
    private int jmsErrorCount;
    private int childCount = 0;
    private int childNo = 0;
    private int id;
    private boolean dynamicSessionClose;

    public JMSMessagePoller(String string, JMSConnectionPoller jMSConnectionPoller, JMSMessagePoller jMSMessagePoller, MessageConsumer messageConsumer, MDListener mDListener, WorkManager workManager, int n, boolean bl) {
        if (debugLogger.isDebugEnabled()) {
            Debug.assertion((messageConsumer != null ? 1 : 0) != 0, (String)"A consumer object must be provided");
            Debug.assertion((mDListener != null ? 1 : 0) != 0, (String)"An MDListener object must be provided");
        }
        this.mdbName = string;
        this.connectionPoller = jMSConnectionPoller;
        this.parentPoller = jMSMessagePoller;
        this.listener = mDListener;
        this.consumer = messageConsumer;
        this.tranManager = TxHelper.getTransactionManager();
        this.wm = workManager;
        this.transactionName = TRANSACTION_NAME_PREFIX + string;
        this.id = n;
        this.dynamicSessionClose = bl;
    }

    public synchronized void addChild(JMSMessagePoller jMSMessagePoller) {
        if (this.allChildren == null) {
            this.allChildren = new LinkedList();
        }
        this.allChildren.add(jMSMessagePoller);
        jMSMessagePoller.childNo = ++this.childCount;
        if (this.availableChildren == null) {
            this.availableChildren = new LinkedList();
        }
        this.availableChildren.add(jMSMessagePoller);
    }

    public synchronized void stop() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Stopping :" + this));
        }
        if (!this.keepRunning) {
            return;
        }
        this.keepRunning = false;
        if (this.allChildren != null) {
            for (JMSMessagePoller jMSMessagePoller : this.allChildren) {
                jMSMessagePoller.stop();
            }
        }
    }

    public synchronized void start() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Starting :" + this));
        }
        this.keepRunning = true;
        if (this.allChildren != null) {
            for (JMSMessagePoller jMSMessagePoller : this.allChildren) {
                jMSMessagePoller.start();
            }
        }
    }

    public synchronized boolean getRunning() {
        return this.isRunning;
    }

    private synchronized void wakeUpChildPoller() {
        JMSMessagePoller jMSMessagePoller = (JMSMessagePoller)this.getChildFromPool();
        if (jMSMessagePoller != null) {
            if (debugLogger.isDebugEnabled()) {
                Debug.say((String)("Scheduling work on :" + this.wm + " for child :" + jMSMessagePoller));
            }
            this.wm.schedule((Runnable)jMSMessagePoller);
        }
    }

    synchronized Object getChildFromPool() {
        if (this.availableChildren != null && this.availableChildren.size() > 0) {
            return this.availableChildren.removeFirst();
        }
        return null;
    }

    private synchronized void returnChildToPool(JMSMessagePoller jMSMessagePoller) {
        if (this.availableChildren != null) {
            this.availableChildren.addFirst(jMSMessagePoller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processOneMessage(final boolean bl, int n) throws JMSException, NotSupportedException, SystemException, RollbackException {
        JMSConnectionPoller.CreateSessionResult createSessionResult;
        block11: {
            int n2;
            if (this.consumer == null) {
                assert (this.listener.isDetached()) : "The MDListener should be deteched when consumer is null";
                createSessionResult = this.connectionPoller.dynamicCreateSession(this.id);
                this.consumer = createSessionResult.consumer;
                this.listener.attach(createSessionResult.session, createSessionResult.wrappedSession);
            }
            createSessionResult = null;
            Transaction transaction = null;
            if (this.listener.isTransacted()) {
                n2 = this.listener.getTransactionTimeoutMS();
                if (bl) {
                    n2 += MESSAGE_WAIT_TIME;
                }
                this.tranManager.begin(this.transactionName, n2 /= 1000);
                transaction = this.tranManager.getTransaction();
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    final int n3 = n2;
                    createSessionResult = (Message)this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction(){

                        public Object run() throws JMSException {
                            if (n3 == 0) {
                                if (bl) {
                                    return JMSMessagePoller.this.consumer.receive((long)MESSAGE_WAIT_TIME);
                                }
                                return JMSMessagePoller.this.consumer.receive(250L);
                            }
                            return JMSMessagePoller.this.consumer.receiveNoWait();
                        }
                    });
                    if (createSessionResult != null) {
                        if (debugLogger.isDebugEnabled()) {
                            Debug.say((String)("Got message " + createSessionResult.getJMSMessageID() + " #" + n2 + " for processing by MDB " + this.mdbName));
                        }
                        if (bl) {
                            this.wakeUpChildPoller();
                        }
                        if (n2 >= n - 1) {
                            this.listener.transactionalOnMessage((Message)createSessionResult, true);
                            transaction = null;
                            continue;
                        }
                        if (this.listener.transactionalOnMessage((Message)createSessionResult, false)) continue;
                        transaction = null;
                        break;
                    }
                    if (n2 <= 0) break;
                    this.listener.transactionalOnMessage(null, true);
                    transaction = null;
                    break;
                }
                Object var8_7 = null;
                if (transaction == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (transaction == null) throw throwable;
                transaction.rollback();
                throw throwable;
            }
            transaction.rollback();
        }
        if (createSessionResult == null) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollContinuously() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)(this + " started polling."));
        }
        int n = 0;
        JMSMessagePoller jMSMessagePoller = this;
        synchronized (jMSMessagePoller) {
            this.isRunning = true;
        }
        while (this.keepRunning) {
            int n2;
            boolean bl = false;
            JMSException jMSException = null;
            if (n > 0) {
                n2 = 1;
                --n;
            } else {
                n2 = this.listener.getMaxMessagesInTransaction();
            }
            try {
                if (this.processOneMessage(true, n2)) {
                    if (this.listener.getExecuteException() != null) {
                        throw this.listener.getExecuteException();
                    }
                    if (this.listener.getRolledBack()) {
                        bl = true;
                    }
                }
            }
            catch (JMSException jMSException2) {
                EJBLogger.logJMSExceptionReceivingForMDB((String)JMSConnectionPoller.getAllExceptionText(jMSException2), (String)StackTraceUtils.throwable2StackTrace((Throwable)jMSException2));
                ++this.jmsErrorCount;
                jMSException = jMSException2;
                bl = true;
            }
            catch (SystemException systemException) {
                EJBLogger.logJMSExceptionReceivingForMDB((String)JMSConnectionPoller.getAllExceptionText(systemException), (String)StackTraceUtils.throwable2StackTrace((Throwable)systemException));
                ++this.jmsErrorCount;
                JMSException jMSException3 = new JMSException(systemException.toString());
                jMSException3.setLinkedException((Exception)((Object)systemException));
                jMSException = jMSException3;
                bl = true;
            }
            catch (Throwable throwable) {
                EJBLogger.logJMSExceptionProcessingMDB((String)JMSConnectionPoller.getAllExceptionText(throwable), (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                bl = true;
            }
            if (bl) {
                ++this.errorCount;
                if (n2 > 1) {
                    n = n2;
                }
                if (this.jmsErrorCount >= 3 && jMSException != null) {
                    this.connectionPoller.onException(jMSException);
                    this.jmsErrorCount = 0;
                    continue;
                }
                if (JMSConnectionPoller.MAX_ERROR_COUNT <= 0 || this.errorCount < JMSConnectionPoller.MAX_ERROR_COUNT) continue;
                if (debugLogger.isDebugEnabled()) {
                    Debug.say((String)"Sleeping after error in MDB poller thread");
                }
                try {
                    Thread.sleep(JMSConnectionPoller.ERROR_SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.errorCount = 0;
                continue;
            }
            this.jmsErrorCount = 0;
            this.errorCount = 0;
        }
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)(this + " has stopped"));
        }
        jMSMessagePoller = this;
        synchronized (jMSMessagePoller) {
            this.isRunning = false;
            this.notifyAll();
        }
    }

    private void pollForAWhile() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Child message polling loop started for MDB " + this.mdbName));
        }
        try {
            while (this.keepRunning) {
                if (this.processOneMessage(false, this.listener.getMaxMessagesInTransaction())) {
                    if (this.listener.getExecuteException() != null) {
                        throw this.listener.getExecuteException();
                    }
                    if (!this.listener.getRolledBack()) {
                        if (!this.wm.scheduleIfBusy((Runnable)this)) continue;
                        return;
                    }
                } else if (this.dynamicSessionClose) {
                    this.consumer = null;
                    this.listener.detach();
                    this.connectionPoller.dynamicCloseSession(this.id);
                }
                break;
            }
        }
        catch (JMSException jMSException) {
            EJBLogger.logJMSExceptionReceivingForMDB((String)JMSConnectionPoller.getAllExceptionText(jMSException), (String)StackTraceUtils.throwable2StackTrace((Throwable)jMSException));
        }
        catch (Throwable throwable) {
            EJBLogger.logJMSExceptionProcessingMDB((String)JMSConnectionPoller.getAllExceptionText(throwable), (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
        this.parentPoller.returnChildToPool(this);
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Child message polling loop ended for MDB " + this.mdbName));
        }
    }

    void pollForChild() {
        this.pollForAWhile();
    }

    void pollForParent() {
        this.pollContinuously();
    }

    public void run() {
        if (this.parentPoller != null) {
            this.pollForChild();
        } else {
            this.pollForParent();
        }
    }

    String getMDBName() {
        return this.mdbName;
    }

    MessageConsumer getConsumer() {
        return this.consumer;
    }

    MDListener getMDListener() {
        return this.listener;
    }

    int getMessageWaitTime() {
        return MESSAGE_WAIT_TIME;
    }

    DebugLogger getDebugLogger() {
        return debugLogger;
    }

    int getChildCount() {
        return this.childCount;
    }

    boolean getKeepRunning() {
        return this.keepRunning;
    }

    boolean isParent() {
        return this.parentPoller == null;
    }

    JMSMessagePoller getParentPoller() {
        return this.parentPoller;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parentPoller == null) {
            stringBuffer.append("[parent poller for " + this.mdbName + " with " + this.childCount + " children. ] ");
        } else {
            stringBuffer.append("[child poller for " + this.mdbName + " with childNo :" + this.childNo + ". ]");
        }
        return stringBuffer.toString();
    }
}

