/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.internal.JMSConnectionPoller;
import weblogic.ejb.container.internal.MDListener;
import weblogic.ejb.container.internal.NewJMSMessagePoller;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.work.WorkManager;

public class JMSPollerManager {
    private static final String TIMER_MANAGER_NAME = "JMSPoller-";
    private static final DebugLogger debugLogger = EJBDebugService.invokeLogger;
    private final NewJMSMessagePoller[] allPollers;
    private final List<NewJMSMessagePoller> availablePollers;
    private final WorkManager wm;
    private final TimerManager timerMgr;
    private final AtomicInteger token = new AtomicInteger(-1);
    private volatile boolean hasErrors;
    private final Object numErrorsLock = new Object();
    private int numErrors = 0;

    public JMSPollerManager(String string, JMSConnectionPoller jMSConnectionPoller, MessageConsumer[] messageConsumerArray, MDListener[] mDListenerArray, WorkManager workManager, boolean bl, Destination destination, boolean bl2) {
        this.availablePollers = Collections.synchronizedList(new LinkedList());
        this.wm = workManager;
        for (int i = 0; i < messageConsumerArray.length; ++i) {
            NewJMSMessagePoller newJMSMessagePoller = new NewJMSMessagePoller(i, string, jMSConnectionPoller, this, messageConsumerArray[i], mDListenerArray[i], bl, destination, bl2);
            this.availablePollers.add(newJMSMessagePoller);
        }
        this.allPollers = this.availablePollers.toArray(new NewJMSMessagePoller[this.availablePollers.size()]);
        this.timerMgr = TimerManagerFactory.getTimerManagerFactory().getTimerManager(TIMER_MANAGER_NAME + string + this, workManager);
    }

    synchronized void stop() {
        for (int i = 0; i < this.allPollers.length; ++i) {
            this.allPollers[i].stop();
        }
    }

    synchronized void start() {
        int n;
        for (n = 0; n < this.allPollers.length; ++n) {
            this.allPollers[n].start();
        }
        n = this.getTokenHolderId();
        if (n != -1) {
            if (debugLogger.isDebugEnabled()) {
                Debug.say((String)("Start found token holder" + this.allPollers[n] + "- scheduling"));
            }
            this.wm.schedule((Runnable)this.allPollers[n]);
        } else {
            this.wakeUpPoller(null, this.allPollers[0]);
        }
    }

    void waitForPollersToStop() {
        int n = this.allPollers.length;
        do {
            if (debugLogger.isDebugEnabled()) {
                Debug.say((String)("JMSPollerManager.waitForPollersToStop() size " + n + " availablePollers.size() " + this.availablePollers.size()));
                Debug.assertion((this.availablePollers.size() <= n ? 1 : 0) != 0, (String)("JMSPollerManager.waitForPollersToStop() availablePollers.size() " + this.availablePollers.size() + " > " + n + " leaking pollers"));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.availablePollers.size() < n);
    }

    void cleanupTimerManager() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)"cleanupTimerManager() is called");
        }
        this.timerMgr.stop();
    }

    synchronized void wakeUpPoller(NewJMSMessagePoller newJMSMessagePoller, NewJMSMessagePoller newJMSMessagePoller2) {
        int n;
        int n2 = n = newJMSMessagePoller != null ? newJMSMessagePoller.getId() : -1;
        if (newJMSMessagePoller2 == null) {
            newJMSMessagePoller2 = this.getFromPool(null);
        } else {
            newJMSMessagePoller2 = this.getFromPool(newJMSMessagePoller2);
            assert (newJMSMessagePoller2 != null) : "The new poller parameter of the wakeUpPoller method should be in the available poller list";
        }
        if (newJMSMessagePoller2 != null) {
            if (debugLogger.isDebugEnabled()) {
                Debug.say((String)("Scheduling new token holder :" + newJMSMessagePoller2));
            }
            this.changeOwner(n, newJMSMessagePoller2.getId());
            this.wm.schedule((Runnable)newJMSMessagePoller2);
        } else {
            if (debugLogger.isDebugEnabled()) {
                Debug.say((String)("All pollers busy, releasing token from :" + newJMSMessagePoller));
            }
            this.releaseToken(n);
        }
    }

    private NewJMSMessagePoller getFromPool(NewJMSMessagePoller newJMSMessagePoller) {
        if (this.availablePollers.isEmpty()) {
            return null;
        }
        if (newJMSMessagePoller == null) {
            return this.availablePollers.remove(0);
        }
        return this.availablePollers.remove(newJMSMessagePoller) ? newJMSMessagePoller : null;
    }

    void returnToPool(NewJMSMessagePoller newJMSMessagePoller) {
        this.availablePollers.add(newJMSMessagePoller);
    }

    void scheduleTimer(TimerListener timerListener, long l) {
        this.timerMgr.schedule(timerListener, l);
    }

    boolean scheduleIfBusy(NewJMSMessagePoller newJMSMessagePoller) {
        return this.wm.scheduleIfBusy((Runnable)newJMSMessagePoller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBatchSize(int n) {
        int n2 = n;
        if (this.hasErrors) {
            Object object = this.numErrorsLock;
            synchronized (object) {
                if (this.numErrors > 0) {
                    --this.numErrors;
                    n2 = 1;
                    if (this.numErrors == 0) {
                        this.hasErrors = false;
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyError(int n) {
        this.hasErrors = true;
        Object object = this.numErrorsLock;
        synchronized (object) {
            this.numErrors += n;
        }
    }

    final int getTokenHolderId() {
        return this.token.get();
    }

    final boolean holdsToken(int n) {
        return this.token.get() == n;
    }

    final boolean acquireToken(int n) {
        return this.token.compareAndSet(-1, n);
    }

    final boolean releaseToken(int n) {
        return this.token.compareAndSet(n, -1);
    }

    private final boolean changeOwner(int n, int n2) {
        return this.token.compareAndSet(n, n2);
    }
}

