/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.FinderException;
import weblogic.ejb.Query;
import weblogic.ejb.container.interfaces.LocalQueryHandler;
import weblogic.ejb20.internal.WLQueryPropertiesImpl;
import weblogic.utils.StackTraceUtils;

public class LocalQueryImpl
extends WLQueryPropertiesImpl
implements Query {
    private static final long serialVersionUID = -3321561806626875272L;
    private LocalQueryHandler handler;
    private boolean isSql = false;

    public LocalQueryImpl(LocalQueryHandler localQueryHandler) {
        this.handler = localQueryHandler;
    }

    public LocalQueryImpl(LocalQueryHandler localQueryHandler, boolean bl) {
        this.handler = localQueryHandler;
        this.isSql = bl;
    }

    public String getLanguage() {
        if (this.isSql) {
            return "SQL";
        }
        return "EJB QL";
    }

    public Collection find(String string) throws FinderException {
        try {
            return (Collection)this.handler.executeQuery(string, this, false, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public Collection find(String string, Properties properties) throws FinderException {
        this.setProperties(properties);
        try {
            return (Collection)this.handler.executeQuery(string, this, false, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public ResultSet execute(String string) throws FinderException {
        try {
            return (ResultSet)this.handler.executeQuery(string, this, true, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }

    public ResultSet execute(String string, Properties properties) throws FinderException {
        this.setProperties(properties);
        try {
            return (ResultSet)this.handler.executeQuery(string, this, true, this.isSql);
        }
        catch (FinderException finderException) {
            throw finderException;
        }
        catch (Throwable throwable) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
        }
    }
}

