/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.util.Date;
import java.util.Random;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.transaction.SystemException;
import weblogic.connector.external.EndpointActivationException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.deployer.MDBService;
import weblogic.ejb.container.deployer.MDBServiceActivator;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.MessageDrivenManagerIntf;
import weblogic.ejb.container.internal.NewJMSMessagePoller;
import weblogic.ejb.container.monitoring.MessageDrivenEJBRuntimeMBeanImpl;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public abstract class MDConnectionManager
implements TimerListener {
    protected static final DebugLogger debugLogger = EJBDebugService.mdbConnectionLogger;
    protected MessageDrivenBeanInfo info;
    protected MessageDrivenEJBRuntimeMBeanImpl runtimeMBean;
    protected static final int STATE_DISCONNECTED = 1;
    protected static final int STATE_CONNECTED = 2;
    protected static final int STATE_UNDEPLOYING = 3;
    protected static final int STATE_UNDEPLOYED = 4;
    protected static final int STATE_SUSPENDED = 5;
    protected static final int STATE_CONNECTION_ERROR = 6;
    protected static final int STATE_SUSPENDED_CONNECTION_ERROR = 7;
    private static Random initConnectDelayRandomGenerator = null;
    protected String stateLock;
    protected int state = 1;
    private int reconnectionErrorInterval = 600000;
    protected int reconnectionCount = 0;
    private long lastReconnectionFailureTime = 0L;
    private Exception lastReconnectionFailureException = new Exception("init exception");
    private int jmsPollingIntervalMS;
    protected boolean scheduleResume;
    private int errorRepeatCount;
    private int deliveryFailureCount;
    private Throwable lastDeliveryFailureException = new Throwable("init exception");
    private int suspendInterval;
    protected String scheduleResumeLock;
    protected Timer timer;
    protected TimerManager timerManager;
    protected MessageDrivenManagerIntf mdManager;

    public MDConnectionManager(MessageDrivenBeanInfo messageDrivenBeanInfo, Context context, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) throws WLDeploymentException {
        this.info = messageDrivenBeanInfo;
        this.mdManager = (MessageDrivenManagerIntf)this.info.getBeanManager();
        this.runtimeMBean = (MessageDrivenEJBRuntimeMBeanImpl)messageDrivenEJBRuntimeMBean;
        this.runtimeMBean.setMDConnManager(this);
        this.initDeliveryFailureParams();
        this.jmsPollingIntervalMS = this.info.getJMSPollingIntervalSeconds() * 1000;
        this.stateLock = new String("StateLock" + this.info.getName());
        this.scheduleResumeLock = new String("scheduleResumeLock" + this.info.getName());
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        this.timerManager = timerManagerFactory.getDefaultTimerManager();
    }

    protected abstract void connect() throws WLDeploymentException, JMSException, SystemException, EndpointActivationException;

    protected abstract void disconnect(boolean var1) throws JMSException, EndpointActivationException;

    protected abstract void logException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        Object object;
        String string;
        block23: {
            string = this.scheduleResumeLock;
            synchronized (string) {
                if (this.scheduleResume) {
                    if (this.timer != null) {
                        this.timer.cancel();
                        this.timer = null;
                    }
                    this.resume(false);
                    this.scheduleResume = false;
                    this.errorRepeatCount = 0;
                    return;
                }
            }
            string = this.info.getIsWeblogicJMS() ? this.mdManager.getDestinationName() : this.info.getResourceAdapterJndiName();
            if (debugLogger.isDebugEnabled()) {
                MDConnectionManager.debug("** Trying to reconnect to: " + string);
            }
            try {
                if (debugLogger.isDebugEnabled()) {
                    this.debugState();
                }
                if (this.getState() == 6) {
                    try {
                        this.disconnect(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.getState() == 1) {
                    this.connect();
                }
                if (debugLogger.isDebugEnabled()) {
                    this.debugState();
                }
                if ((object = MDBServiceActivator.INSTANCE.getMDBService()) != null) {
                    object.addDeployedMDB(this);
                }
            }
            catch (Exception exception) {
                this.runtimeMBean.setLastException(exception);
                long l = System.currentTimeMillis();
                if (exception.toString().equals(this.lastReconnectionFailureException.toString()) && this.lastReconnectionFailureTime + (long)this.reconnectionErrorInterval > l) break block23;
                this.lastReconnectionFailureTime = l;
                this.lastReconnectionFailureException = exception;
                EJBLogger.logMDBReconnectInfo((String)this.info.getEJBName(), (String)string, (int)this.reconnectionCount, (int)(this.jmsPollingIntervalMS / 1000), (long)(this.reconnectionErrorInterval / 1000));
                this.logException(exception);
            }
        }
        object = this;
        synchronized (object) {
            String string2 = this.stateLock;
            synchronized (string2) {
                if (this.state != 1 && this.state != 6 && this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
        if (debugLogger.isDebugEnabled()) {
            MDConnectionManager.debug("** Connect attempt for: " + string + " was: " + (this.getState() == 2 ? "Successful" : "unsuccessful"));
        }
    }

    public synchronized void startConnectionPolling() throws WLDeploymentException {
        int n;
        if (this.timer != null) {
            return;
        }
        if (this.state == 4) {
            this.setState(1);
        }
        if (debugLogger.isDebugEnabled()) {
            Debug.assertion((this.getState() == 1 ? 1 : 0) != 0);
        }
        if ((n = this.getRandomInitialConnectDelay()) >= 5) {
            this.scheduleInitialConnection(n);
            return;
        }
        try {
            MDBService mDBService;
            if (debugLogger.isDebugEnabled()) {
                this.debugState();
            }
            this.connect();
            if (debugLogger.isDebugEnabled()) {
                this.debugState();
            }
            if ((mDBService = MDBServiceActivator.INSTANCE.getMDBService()) != null) {
                mDBService.addDeployedMDB(this);
            }
            assert (this.getState() == 2);
        }
        catch (Exception exception) {
            if (exception instanceof EndpointActivationException && !((EndpointActivationException)((Object)exception)).isChangeable()) {
                throw new WLDeploymentException(exception.getMessage() + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            this.runtimeMBean.setLastException(exception);
            this.logException(exception);
        }
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        if (this.getState() != 2) {
            this.scheduleReconnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelConnectionPolling() {
        MDBService mDBService = MDBServiceActivator.INSTANCE.getMDBService();
        if (mDBService != null) {
            mDBService.removeDeployedMDB(this);
        }
        MDConnectionManager mDConnectionManager = this;
        synchronized (mDConnectionManager) {
            block8: {
                this.setState(3);
                if (debugLogger.isDebugEnabled()) {
                    this.debugState();
                }
                try {
                    this.disconnect(false);
                }
                catch (Exception exception) {
                    this.runtimeMBean.setLastException(exception);
                    if (!debugLogger.isDebugEnabled()) break block8;
                    MDConnectionManager.debug("exception on disconnect: " + exception);
                }
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    public void deleteDurableSubscriber() {
    }

    private int getRandomInitialConnectDelay() {
        boolean bl = this.info.getMinimizeAQSessions();
        if (!bl) {
            return -1;
        }
        int n = NewJMSMessagePoller.DESTINATION_POLL_INTERVAL_MILLIS;
        if (n <= 5000) {
            return -1;
        }
        if (initConnectDelayRandomGenerator == null) {
            initConnectDelayRandomGenerator = new Random();
        }
        int n2 = initConnectDelayRandomGenerator.nextInt(n);
        if (debugLogger.isDebugEnabled()) {
            MDConnectionManager.debug("Initial connect delay is " + n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scheduleInitialConnection(long l) {
        if (this.info.getIsInactive()) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        String string = this.stateLock;
        synchronized (string) {
            if (this.state != 1 && this.state != 6) {
                return;
            }
        }
        this.timer = this.timerManager.scheduleAtFixedRate((TimerListener)this, l, (long)this.jmsPollingIntervalMS);
        if (debugLogger.isDebugEnabled()) {
            MDConnectionManager.debug("Initial connection is scheduled at delay of " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void scheduleReconnection() {
        if (this.info.getIsInactive()) {
            return;
        }
        if (this.scheduleResume) {
            this.initDeliveryFailureParams();
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        if (this.timer != null) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            this.debugState();
        }
        String string = this.stateLock;
        synchronized (string) {
            if (this.state != 1 && this.state != 6) {
                return;
            }
        }
        this.timer = this.timerManager.scheduleAtFixedRate((TimerListener)this, (long)this.jmsPollingIntervalMS, (long)this.jmsPollingIntervalMS);
        if (debugLogger.isDebugEnabled()) {
            MDConnectionManager.debug("Reconnection is scheduled at interval of every " + this.jmsPollingIntervalMS);
        }
        this.reconnectionCount = 1;
        this.lastReconnectionFailureTime = System.currentTimeMillis();
        this.lastReconnectionFailureException = new Exception("init exception");
    }

    protected synchronized void scheduleResume() {
        if (this.timer != null) {
            return;
        }
        this.scheduleResume = true;
        if (this.info.getMaxSuspendSeconds() == 0) {
            this.suspendInterval = 0;
        }
        this.timer = this.timerManager.schedule((TimerListener)this, (long)this.suspendInterval);
    }

    protected void initDeliveryFailureParams() {
        this.scheduleResume = false;
        this.errorRepeatCount = 0;
        this.suspendInterval = this.info.getInitSuspendSeconds() * 1000;
        if (this.info.getInitSuspendSeconds() == 0) {
            this.suspendInterval = 5000;
        }
        if (this.info.getMaxSuspendSeconds() == 0) {
            this.suspendInterval = 0;
        }
        this.deliveryFailureCount = 0;
        this.lastDeliveryFailureException = new Throwable("init exception");
    }

    protected boolean isPrintErrorMessage(Throwable throwable) {
        boolean bl = false;
        ++this.deliveryFailureCount;
        this.runtimeMBean.setLastException(throwable);
        if (throwable.toString().equals(this.lastDeliveryFailureException.toString()) && this.suspendInterval != 0) {
            ++this.errorRepeatCount;
            if (this.errorRepeatCount >= 10) {
                SuspendThread suspendThread = new SuspendThread(this);
                WorkManagerFactory.getInstance().getSystem().schedule((Runnable)suspendThread);
                bl = true;
            }
        } else {
            bl = true;
            this.errorRepeatCount = 1;
            this.lastDeliveryFailureException = throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callSuspend() {
        String string = this.scheduleResumeLock;
        synchronized (string) {
            if (this.timer != null) {
                return;
            }
            this.suspend(false);
            this.scheduleResume();
            EJBLogger.logMDBRedeliveryInfo((String)this.info.getEJBName(), (int)this.deliveryFailureCount, (long)(this.suspendInterval / 1000));
            long l = System.currentTimeMillis();
            this.runtimeMBean.setMDBStatus("Suspended at " + new Date(l) + " by the EJB container, resume is scheduled at " + new Date(l + (long)this.suspendInterval));
            this.suspendInterval *= 2;
            if (this.suspendInterval > this.info.getMaxSuspendSeconds() * 1000) {
                this.suspendInterval = this.info.getMaxSuspendSeconds() * 1000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getState() {
        String string = this.stateLock;
        synchronized (string) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int setState(int n) {
        String string = this.stateLock;
        synchronized (string) {
            int n2 = this.state;
            this.state = n;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debugState() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MDB ");
        stringBuffer.append(this.info.getName());
        stringBuffer.append(": State = ");
        String string = this.stateLock;
        synchronized (string) {
            switch (this.state) {
                case 1: {
                    stringBuffer.append("DISCONNECTED");
                    break;
                }
                case 2: {
                    stringBuffer.append("CONNECTED");
                    break;
                }
                case 3: {
                    stringBuffer.append("UNDEPLOYING");
                    break;
                }
                case 4: {
                    stringBuffer.append("UNDEPLOYED");
                    break;
                }
                case 5: {
                    stringBuffer.append("SUSPENDED");
                    break;
                }
                case 6: {
                    stringBuffer.append("CONNECTION_ERROR");
                    break;
                }
                case 7: {
                    stringBuffer.append("SUSPENDED_CONNECTION_ERROR");
                    break;
                }
                default: {
                    stringBuffer.append("<unknown>");
                }
            }
        }
        MDConnectionManager.debug(stringBuffer.toString());
    }

    public void updateJMSPollingIntervalSeconds(int n) {
        this.jmsPollingIntervalMS = n * 1000;
    }

    public abstract void signalBackgroundThreads();

    public abstract boolean suspend(boolean var1);

    public abstract boolean resume(boolean var1);

    public abstract void shutdown();

    private static void debug(String string) {
        debugLogger.debug("[MDConnectionManager] " + string);
    }

    class SuspendThread
    implements Runnable {
        private MDConnectionManager mdConnectionManager;

        SuspendThread(MDConnectionManager mDConnectionManager2) {
            this.mdConnectionManager = mDConnectionManager2;
        }

        public void run() {
            this.mdConnectionManager.callSuspend();
        }
    }
}

