/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import javax.ejb.EnterpriseBean;
import javax.ejb.MessageDrivenBean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.naming.Context;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import weblogic.deployment.jms.MDBSession;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.NonDestructiveRuntimeException;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.interfaces.MessageDrivenBeanInfo;
import weblogic.ejb.container.interfaces.PoolIntf;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.JMSConnectionPoller;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.monitoring.EJBTransactionRuntimeMBeanImpl;
import weblogic.ejb.spi.JmsMessageDrivenBean;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.extensions.MDBTransaction;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.transaction.RollbackException;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManager;

final class MDListener
implements MessageListener,
Runnable {
    protected static final DebugLogger debugLogger = EJBDebugService.invokeLogger;
    private final JMSConnectionPoller connectionPoller;
    private final AuthenticatedSubject runAsSubject;
    private final Context m_envContext;
    private final EJBTransactionRuntimeMBeanImpl txMBean;
    private final LinkedList m_listenerList;
    private final LinkedList m_messageList;
    private final MDListener m_parent;
    private final MessageDrivenBeanInfo m_info;
    private final MessageDrivenEJBRuntimeMBean rtMBean;
    private final PoolIntf m_pool;
    private volatile MDBSession m_wrappedSession;
    private volatile Session m_session;
    private final WorkManager m_wm;
    private final TransactionManager m_tranManager;
    private final boolean m_isTransacted;
    private final int m_acknowledgeMode;
    private final int m_numChildren;
    private MDMessage m_message;
    private Throwable executeException = null;
    private Transaction m_transaction;
    private boolean rolledBack = false;
    private boolean recovered = false;
    private int m_numWaiters;
    private boolean useAcknowledgePreviousMode = false;
    private String txName;
    private boolean detached = false;
    private final boolean syncNoTranMode;

    MDListener(MDListener mDListener, JMSConnectionPoller jMSConnectionPoller, int n, Context context, Session session, MDBSession mDBSession, int n2, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean, MessageDrivenBeanInfo messageDrivenBeanInfo, PoolIntf poolIntf, boolean bl, WorkManager workManager, boolean bl2) throws WLDeploymentException {
        this.m_info = messageDrivenBeanInfo;
        this.m_pool = poolIntf;
        this.m_isTransacted = messageDrivenBeanInfo.isOnMessageTransacted();
        this.m_parent = mDListener;
        this.m_envContext = context;
        this.m_session = session;
        this.m_wrappedSession = mDBSession;
        this.rtMBean = messageDrivenEJBRuntimeMBean;
        this.txMBean = (EJBTransactionRuntimeMBeanImpl)messageDrivenEJBRuntimeMBean.getTransactionRuntime();
        this.m_acknowledgeMode = n2;
        this.useAcknowledgePreviousMode = bl;
        this.m_tranManager = TxHelper.getTransactionManager();
        this.m_wm = workManager;
        this.syncNoTranMode = bl2;
        if (session == null && mDListener == null) {
            this.detached = true;
        }
        String string = messageDrivenBeanInfo.getRunAsPrincipalName();
        this.connectionPoller = jMSConnectionPoller;
        if (string == null) {
            this.runAsSubject = SecurityHelper.getAnonymousUser();
        } else {
            try {
                SecurityHelper securityHelper = new SecurityHelper(this.m_info.getDeploymentInfo().getSecurityRealmName(), this.m_info.getJACCPolicyConfig(), this.m_info.getJACCPolicyContextId(), this.m_info.getJACCCodeSource(), this.m_info.getJACCRoleMapper());
                this.runAsSubject = securityHelper.getSubjectForPrincipal(string);
            }
            catch (Exception exception) {
                throw new WLDeploymentException(exception.toString());
            }
        }
        this.m_numChildren = n;
        if (n > 0) {
            this.m_listenerList = new LinkedList();
            for (int i = 0; i < n; ++i) {
                this.putListener(new MDListener(this, this.connectionPoller, 0, context, null, null, n2, this.rtMBean, this.m_info, poolIntf, bl, workManager, bl2));
            }
        } else {
            this.m_listenerList = null;
        }
        this.m_messageList = n2 == 2 && !this.m_isTransacted ? new LinkedList() : null;
        this.txName = "[EJB " + this.m_info.getBeanClassName() + "." + this.m_info.getOnMessageMethodInfo().getSignature() + "]";
    }

    boolean isTransacted() {
        return this.m_isTransacted;
    }

    MDBSession getWrappedSession() {
        return this.m_parent == null ? this.m_wrappedSession : this.m_parent.m_wrappedSession;
    }

    Session getSession() {
        return this.m_parent == null ? this.m_session : this.m_parent.m_session;
    }

    boolean isDetached() {
        return this.m_parent == null ? this.detached : this.m_parent.detached;
    }

    void detach() {
        if (this.m_parent != null) {
            return;
        }
        assert (this.m_messageList == null || this.m_messageList.isEmpty()) : "Cannot detach a MDListener with pending message list";
        assert (this.m_message == null) : "Cannot detach a MDListener with pending message";
        this.detached = true;
        this.m_wrappedSession = null;
        this.m_session = null;
    }

    void attach(Session session, MDBSession mDBSession) {
        if (this.m_parent != null) {
            return;
        }
        assert (this.m_messageList == null || this.m_messageList.isEmpty()) : "Cannot attach a MDListener with pending message list";
        assert (this.m_message == null) : "Cannot attach a MDListener with pending message";
        this.m_session = session;
        this.m_wrappedSession = mDBSession;
        this.detached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MDListener getListener() {
        LinkedList linkedList = this.m_listenerList;
        synchronized (linkedList) {
            while (this.m_listenerList.isEmpty()) {
                Object var4_3;
                try {
                    try {
                        ++this.m_numWaiters;
                        this.m_listenerList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        var4_3 = null;
                        --this.m_numWaiters;
                        continue;
                    }
                    var4_3 = null;
                    --this.m_numWaiters;
                }
                catch (Throwable throwable) {
                    var4_3 = null;
                    --this.m_numWaiters;
                    throw throwable;
                }
            }
            return (MDListener)this.m_listenerList.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putListener(MDListener mDListener) {
        Object object;
        if (this.m_messageList != null && mDListener.m_message != null) {
            object = null;
            Object object2 = this.m_messageList;
            synchronized (object2) {
                if (mDListener.recovered) {
                    mDListener.m_message.setRecovered();
                    for (int i = 0; i < this.m_messageList.size(); ++i) {
                        if (!((MDMessage)this.m_messageList.get(i)).isRecovered()) continue;
                        object = (MDMessage)this.m_messageList.remove(i);
                    }
                } else {
                    mDListener.m_message.setAcknowledged();
                    while (((MDMessage)this.m_messageList.getFirst()).isAcknowledged()) {
                        object = (MDMessage)this.m_messageList.removeFirst();
                        if (!this.m_messageList.isEmpty()) continue;
                    }
                }
            }
            if (object != null && !mDListener.recovered) {
                if (this.connectionPoller.isCurrentSubjectKernelIdentity()) {
                    object2 = object;
                    try {
                        this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction((MDMessage)object2){
                            final /* synthetic */ MDMessage val$mdMessage_final;
                            {
                                this.val$mdMessage_final = mDMessage;
                            }

                            public Object run() throws Exception {
                                this.val$mdMessage_final.acknowledge();
                                return null;
                            }
                        });
                    }
                    catch (JMSException jMSException) {}
                } else {
                    ((MDMessage)object).acknowledge();
                }
            }
        }
        mDListener.m_message = null;
        mDListener.m_transaction = null;
        object = this.m_listenerList;
        synchronized (object) {
            this.m_listenerList.add(mDListener);
            if (this.m_numWaiters > 0) {
                this.m_listenerList.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(final Message message) {
        block49: {
            Object v0;
            Throwable throwable;
            weblogic.transaction.Transaction transaction;
            UserTransaction userTransaction;
            block46: {
                assert (!this.isDetached()) : "MDListener.onMessage cannot be called in detached mode";
                userTransaction = TxHelper.getUserTransaction();
                transaction = TxHelper.getTransaction();
                throwable = null;
                try {
                    if (this.m_isTransacted) {
                        Session session;
                        int n;
                        if (this.m_tranManager.getStatus() != 6) {
                            this.m_tranManager.suspend();
                        }
                        if ((n = this.getTransactionTimeoutMS()) > 0) {
                            userTransaction.setTransactionTimeout(n / 1000);
                        }
                        userTransaction.begin();
                        if (transaction == null) {
                            transaction = TxHelper.getTransaction();
                        }
                        transaction.setName(this.txName);
                        Integer n2 = this.m_info.getOnMessageTxIsolationLevel();
                        if (n2 != null) {
                            ((TransactionImpl)transaction).setProperty("ISOLATION LEVEL", (Serializable)n2);
                        }
                        if ((session = this.getSession()) instanceof MDBTransaction) {
                            if (this.connectionPoller.isCurrentSubjectKernelIdentity() || this.isRemoteDomain()) {
                                this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        ((MDBTransaction)session).associateTransaction(message);
                                        return null;
                                    }
                                });
                            } else {
                                ((MDBTransaction)session).associateTransaction(message);
                            }
                        }
                    }
                }
                catch (NotSupportedException notSupportedException) {
                    throwable = notSupportedException;
                }
                catch (JMSException jMSException) {
                    throwable = jMSException;
                }
                catch (SystemException systemException) {
                    throwable = systemException;
                }
                if (throwable == null) {
                    this.transactionalOnMessage(message, true);
                    return;
                }
                this.executeException = throwable;
                final Session session = this.getSession();
                if (this.connectionPoller.isCurrentSubjectKernelIdentity() || this.isRemoteDomain()) {
                    this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            session.recover();
                            return null;
                        }
                    });
                    break block46;
                }
                session.recover();
            }
            Object var9_13 = null;
            try {
                try {
                    if (userTransaction != null) {
                        this.txMBean.incrementTransactionsRolledBack();
                        if (transaction != null && ((TransactionImpl)transaction).isTimedOut()) {
                            this.txMBean.incrementTransactionsTimedOut();
                        }
                        userTransaction.rollback();
                    }
                    v0 = null;
                }
                catch (SystemException throwable2) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("[MDListener]: onMessage ", throwable2);
                    }
                    v0 = null;
                }
                catch (Exception throwable2) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("[MDListener]: onMessage ", throwable2);
                    }
                    v0 = null;
                }
            }
            catch (Throwable throwable3) {
                Object var12_22;
                v0 = var12_22 = null;
            }
            if (this.connectionPoller.isPrintErrorMessage(throwable)) {
                EJBLogger.logerrorStartingMDBTx((String)throwable.toString());
            }
            break block49;
            {
                catch (JMSException jMSException) {
                    Object v1;
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("[MDListener]: onMessage ", (Throwable)jMSException);
                    }
                    Object var9_14 = null;
                    try {
                        try {
                            if (userTransaction != null) {
                                this.txMBean.incrementTransactionsRolledBack();
                                if (transaction != null && ((TransactionImpl)transaction).isTimedOut()) {
                                    this.txMBean.incrementTransactionsTimedOut();
                                }
                                userTransaction.rollback();
                            }
                            v1 = null;
                        }
                        catch (SystemException throwable4) {
                            if (debugLogger.isDebugEnabled()) {
                                debugLogger.debug("[MDListener]: onMessage ", throwable4);
                            }
                            v1 = null;
                        }
                        catch (Exception throwable4) {
                            if (debugLogger.isDebugEnabled()) {
                                debugLogger.debug("[MDListener]: onMessage ", throwable4);
                            }
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable5) {
                        Object var12_23;
                        v1 = var12_23 = null;
                    }
                    if (this.connectionPoller.isPrintErrorMessage(throwable)) {
                        EJBLogger.logerrorStartingMDBTx((String)throwable.toString());
                    }
                }
            }
            catch (Throwable throwable6) {
                Object v2;
                Object var9_15 = null;
                try {
                    try {
                        if (userTransaction != null) {
                            this.txMBean.incrementTransactionsRolledBack();
                            if (transaction != null && ((TransactionImpl)transaction).isTimedOut()) {
                                this.txMBean.incrementTransactionsTimedOut();
                            }
                            userTransaction.rollback();
                        }
                        v2 = null;
                    }
                    catch (SystemException throwable7) {
                        if (debugLogger.isDebugEnabled()) {
                            debugLogger.debug("[MDListener]: onMessage ", throwable7);
                        }
                        v2 = null;
                    }
                    catch (Exception throwable7) {
                        if (debugLogger.isDebugEnabled()) {
                            debugLogger.debug("[MDListener]: onMessage ", throwable7);
                        }
                        v2 = null;
                    }
                }
                catch (Throwable throwable8) {
                    Object var12_24;
                    v2 = var12_24 = null;
                }
                if (this.connectionPoller.isPrintErrorMessage(throwable)) {
                    EJBLogger.logerrorStartingMDBTx((String)throwable.toString());
                }
                throw throwable6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean transactionalOnMessage(Message message, boolean bl) {
        if (this.m_numChildren == 0 || !bl) {
            if (message != null) {
                this.m_message = new MDMessage(message, this.getSession(), this.useAcknowledgePreviousMode);
                if (this.m_messageList != null) {
                    LinkedList linkedList = this.m_messageList;
                    synchronized (linkedList) {
                        this.m_messageList.add(this.m_message);
                    }
                }
            }
            return this.execute(bl);
        }
        MDListener mDListener = this.getListener();
        mDListener.m_message = new MDMessage(message, this.getSession(), this.useAcknowledgePreviousMode);
        if (this.m_messageList != null) {
            LinkedList linkedList = this.m_messageList;
            synchronized (linkedList) {
                this.m_messageList.add(mDListener.m_message);
            }
        }
        if (this.m_isTransacted) {
            mDListener.m_transaction = this.m_tranManager.forceSuspend();
        }
        this.m_wm.schedule((Runnable)mDListener);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean execute(boolean bl) {
        boolean bl2;
        assert (!this.isDetached()) : "MDListener.execute cannot be called in detached mode";
        boolean bl3 = false;
        boolean bl4 = false;
        this.executeException = null;
        this.rolledBack = false;
        this.recovered = false;
        if (this.m_parent != null && this.m_transaction != null) {
            this.m_tranManager.forceResume(this.m_transaction);
            this.m_transaction = null;
        }
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        MessageDrivenBean messageDrivenBean = null;
        try {
            block127: {
                block126: {
                    EJBRuntimeUtils.pushEnvironment(this.m_envContext);
                    SecurityHelper.pushRunAsSubject(this.runAsSubject);
                    ClassLoader classLoader = this.m_info.getModuleClassLoader();
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader2 = thread2.getContextClassLoader();
                    thread2.setContextClassLoader(classLoader);
                    try {
                        messageDrivenBean = (MessageDrivenBean)this.m_pool.getBean(this.getTransactionTimeoutMS());
                    }
                    catch (Exception exception) {
                        if (classLoader2 != null) {
                            thread2.setContextClassLoader(classLoader2);
                        }
                        bl4 = true;
                        throw exception;
                    }
                    try {
                        MethodInvocationHelper.pushMethodObject(this.m_info);
                        if (messageDrivenBean instanceof JmsMessageDrivenBean) {
                            this.getWrappedSession().reOpen();
                            ((JmsMessageDrivenBean)messageDrivenBean).setSession((Session)this.getWrappedSession());
                        }
                        if (this.m_message != null) {
                            ((MessageListener)messageDrivenBean).onMessage(this.m_message.getMessage());
                        }
                        Object var11_22 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_23 = null;
                        MethodInvocationHelper.popMethodObject(this.m_info);
                        if (classLoader2 != null) {
                            thread2.setContextClassLoader(classLoader2);
                        }
                        if (messageDrivenBean instanceof JmsMessageDrivenBean) {
                            ((JmsMessageDrivenBean)messageDrivenBean).setSession(null);
                            this.getWrappedSession().close();
                        }
                        throw throwable;
                    }
                    MethodInvocationHelper.popMethodObject(this.m_info);
                    if (classLoader2 != null) {
                        thread2.setContextClassLoader(classLoader2);
                    }
                    if (messageDrivenBean instanceof JmsMessageDrivenBean) {
                        ((JmsMessageDrivenBean)messageDrivenBean).setSession(null);
                        this.getWrappedSession().close();
                    }
                    this.m_pool.releaseBean((EnterpriseBean)messageDrivenBean);
                    if (transaction == null) break block126;
                    switch (transaction.getStatus()) {
                        case 0: {
                            if (bl) {
                                try {
                                    transaction.commit();
                                    this.txMBean.incrementTransactionsCommitted();
                                    break;
                                }
                                catch (Exception exception) {
                                    Object var13_28;
                                    try {
                                        transaction.rollback();
                                        var13_28 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_29 = null;
                                        if (transaction.getStatus() == 3) {
                                            this.txMBean.incrementTransactionsCommitted();
                                        } else if (transaction.getStatus() == 4) {
                                            this.txMBean.incrementTransactionsRolledBack();
                                        }
                                        if (transaction.isTimedOut()) {
                                            this.txMBean.incrementTransactionsTimedOut();
                                        }
                                        String string = null;
                                        string = exception instanceof RollbackException && EJBRuntimeUtils.isOptimisticLockException(((RollbackException)exception).getNested()) ? ((RollbackException)exception).getNested().getMessage() : StackTraceUtils.throwable2StackTrace((Throwable)exception);
                                        EJBLogger.logErrorDuringCommit((String)transaction.toString(), (String)string);
                                        this.executeException = exception;
                                        throw throwable;
                                    }
                                    if (transaction.getStatus() == 3) {
                                        this.txMBean.incrementTransactionsCommitted();
                                    } else if (transaction.getStatus() == 4) {
                                        this.txMBean.incrementTransactionsRolledBack();
                                    }
                                    if (transaction.isTimedOut()) {
                                        this.txMBean.incrementTransactionsTimedOut();
                                    }
                                    String string = null;
                                    string = exception instanceof RollbackException && EJBRuntimeUtils.isOptimisticLockException(((RollbackException)exception).getNested()) ? ((RollbackException)exception).getNested().getMessage() : StackTraceUtils.throwable2StackTrace((Throwable)exception);
                                    EJBLogger.logErrorDuringCommit((String)transaction.toString(), (String)string);
                                    this.executeException = exception;
                                    break;
                                    {
                                        catch (Exception exception2) {
                                            debugLogger.debug("[MDListener]: execute", (Throwable)exception2);
                                            var13_28 = null;
                                            if (transaction.getStatus() == 3) {
                                                this.txMBean.incrementTransactionsCommitted();
                                            } else if (transaction.getStatus() == 4) {
                                                this.txMBean.incrementTransactionsRolledBack();
                                            }
                                            if (transaction.isTimedOut()) {
                                                this.txMBean.incrementTransactionsTimedOut();
                                            }
                                            string = null;
                                            string = exception instanceof RollbackException && EJBRuntimeUtils.isOptimisticLockException(((RollbackException)exception).getNested()) ? ((RollbackException)exception).getNested().getMessage() : StackTraceUtils.throwable2StackTrace((Throwable)exception);
                                            EJBLogger.logErrorDuringCommit((String)transaction.toString(), (String)string);
                                            this.executeException = exception;
                                            break;
                                        }
                                    }
                                }
                            }
                            bl3 = true;
                            break;
                        }
                        case 1: 
                        case 9: {
                            this.txMBean.incrementTransactionsRolledBack();
                            if (transaction.isTimedOut()) {
                                this.txMBean.incrementTransactionsTimedOut();
                            }
                            try {
                                this.rolledBack = true;
                                transaction.rollback();
                            }
                            catch (Exception exception) {
                                EJBLogger.logErrorDuringRollback((String)transaction.toString(), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                                this.executeException = exception;
                            }
                            EJBLogger.logTxRolledbackInfo((String)this.m_info.getEJBName(), (String)transaction.toString());
                            break;
                        }
                        case 4: {
                            this.txMBean.incrementTransactionsRolledBack();
                            if (transaction.isTimedOut()) {
                                this.txMBean.incrementTransactionsTimedOut();
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block127;
                }
                if (this.syncNoTranMode) {
                    try {
                        if (this.m_message != null) {
                            this.m_message.acknowledge();
                        }
                    }
                    catch (Exception exception) {
                        if (debugLogger.isDebugEnabled()) {
                            debugLogger.debug("[MDListener]: execute ", (Throwable)exception);
                        }
                        try {
                            this.getSession().rollback();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                    }
                }
            }
            this.connectionPoller.initDeliveryFailureParams();
            bl2 = bl3;
            Object var16_33 = null;
        }
        catch (Throwable throwable) {
            try {
                block124: {
                    boolean bl5;
                    this.executeException = throwable;
                    if (!bl4) {
                        if (throwable instanceof NonDestructiveRuntimeException) {
                            this.m_pool.releaseBean((EnterpriseBean)messageDrivenBean);
                        } else {
                            this.m_pool.destroyBean((EnterpriseBean)messageDrivenBean);
                        }
                    }
                    if (bl5 = this.connectionPoller.isPrintErrorMessage(this.executeException)) {
                        EJBLogger.logExcepInOnMessageCallOnMDB((Throwable)throwable);
                    }
                    if (this.m_isTransacted) {
                        block121: {
                            try {
                                this.rolledBack = true;
                                transaction.rollback();
                            }
                            catch (Exception exception) {
                                if (!bl5) break block121;
                                EJBLogger.logErrorOnRollback((Exception)exception);
                            }
                        }
                        this.txMBean.incrementTransactionsRolledBack();
                        if (transaction.isTimedOut()) {
                            this.txMBean.incrementTransactionsTimedOut();
                        }
                        if (bl5) {
                            EJBLogger.logTxRolledbackInfo((String)this.m_info.getEJBName(), (String)transaction.toString());
                            EJBLogger.logExcepInOnMessageCallOnMDB((Throwable)throwable);
                        }
                    } else {
                        block122: {
                            try {
                                block123: {
                                    if (transaction == null || transaction.getStatus() == 6) break block122;
                                    try {
                                        this.rolledBack = true;
                                        transaction.rollback();
                                    }
                                    catch (Exception exception) {
                                        if (!bl5) break block123;
                                        EJBLogger.logErrorOnRollback((Exception)exception);
                                    }
                                }
                                this.txMBean.incrementTransactionsRolledBack();
                                if (transaction.isTimedOut()) {
                                    this.txMBean.incrementTransactionsTimedOut();
                                }
                                if (bl5) {
                                    EJBLogger.logTxRolledbackInfo((String)this.m_info.getEJBName(), (String)transaction.toString());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            if (this.syncNoTranMode) {
                                this.getSession().recover();
                            } else {
                                final Session session = this.getSession();
                                if (this.m_info.isDestinationQueue() || this.m_info.isDestinationTopic() && this.m_parent == null) {
                                    if (this.connectionPoller.isCurrentSubjectKernelIdentity() || this.isRemoteDomain()) {
                                        this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction(){

                                            public Object run() throws Exception {
                                                session.recover();
                                                return null;
                                            }
                                        });
                                    } else {
                                        session.recover();
                                    }
                                    this.recovered = true;
                                }
                            }
                        }
                        catch (JMSException jMSException) {
                            if (!bl5) break block124;
                            EJBLogger.logExceptionRecoveringJMSSession((String)this.m_info.getDisplayName(), (Exception)((Object)jMSException));
                        }
                    }
                }
                Object var16_34 = null;
            }
            catch (Throwable throwable2) {
                Object var16_35 = null;
                EJBRuntimeUtils.popEnvironment();
                SecurityHelper.popRunAsSubject();
                if (this.syncNoTranMode) {
                    this.m_message = null;
                    this.m_transaction = null;
                } else if (this.m_parent != null) {
                    this.m_parent.putListener(this);
                } else {
                    if (this.m_messageList != null && this.m_message != null) {
                        MDMessage mDMessage = null;
                        Object object = this.m_messageList;
                        synchronized (object) {
                            if (this.recovered) {
                                this.m_message.setRecovered();
                                for (int i = 0; i < this.m_messageList.size(); ++i) {
                                    if (!((MDMessage)this.m_messageList.get(i)).isRecovered()) continue;
                                    mDMessage = (MDMessage)this.m_messageList.remove(i);
                                }
                            } else {
                                this.m_message.setAcknowledged();
                                while (((MDMessage)this.m_messageList.getFirst()).isAcknowledged()) {
                                    mDMessage = (MDMessage)this.m_messageList.removeFirst();
                                    if (!this.m_messageList.isEmpty()) continue;
                                }
                            }
                        }
                        if (mDMessage != null && !this.recovered) {
                            if (this.connectionPoller.isCurrentSubjectKernelIdentity()) {
                                object = mDMessage;
                                try {
                                    this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction((MDMessage)object){
                                        final /* synthetic */ MDMessage val$mdMessage_final;
                                        {
                                            this.val$mdMessage_final = mDMessage;
                                        }

                                        public Object run() throws Exception {
                                            this.val$mdMessage_final.acknowledge();
                                            return null;
                                        }
                                    });
                                }
                                catch (JMSException jMSException) {}
                            } else {
                                mDMessage.acknowledge();
                            }
                        }
                    }
                    this.m_message = null;
                    this.m_transaction = null;
                }
                throw throwable2;
            }
            EJBRuntimeUtils.popEnvironment();
            SecurityHelper.popRunAsSubject();
            if (this.syncNoTranMode) {
                this.m_message = null;
                this.m_transaction = null;
            }
            if (this.m_parent != null) {
                this.m_parent.putListener(this);
            }
            if (this.m_messageList != null && this.m_message != null) {
                MDMessage mDMessage = null;
                Object object = this.m_messageList;
                synchronized (object) {
                    if (this.recovered) {
                        this.m_message.setRecovered();
                        for (int i = 0; i < this.m_messageList.size(); ++i) {
                            if (!((MDMessage)this.m_messageList.get(i)).isRecovered()) continue;
                            mDMessage = (MDMessage)this.m_messageList.remove(i);
                        }
                    } else {
                        this.m_message.setAcknowledged();
                        while (((MDMessage)this.m_messageList.getFirst()).isAcknowledged()) {
                            mDMessage = (MDMessage)this.m_messageList.removeFirst();
                            if (!this.m_messageList.isEmpty()) continue;
                        }
                    }
                }
                if (mDMessage != null && !this.recovered) {
                    if (this.connectionPoller.isCurrentSubjectKernelIdentity()) {
                        object = mDMessage;
                        try {
                            this.connectionPoller.doPrivilegedJMSAction(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (JMSException jMSException) {}
                    } else {
                        mDMessage.acknowledge();
                    }
                }
            }
            this.m_message = null;
            this.m_transaction = null;
            {
            }
        }
        EJBRuntimeUtils.popEnvironment();
        SecurityHelper.popRunAsSubject();
        if (this.syncNoTranMode) {
            this.m_message = null;
            this.m_transaction = null;
        } else if (this.m_parent != null) {
            this.m_parent.putListener(this);
        } else {
            if (this.m_messageList != null && this.m_message != null) {
                MDMessage mDMessage = null;
                Object object = this.m_messageList;
                synchronized (object) {
                    if (this.recovered) {
                        this.m_message.setRecovered();
                        for (int i = 0; i < this.m_messageList.size(); ++i) {
                            if (!((MDMessage)this.m_messageList.get(i)).isRecovered()) continue;
                            mDMessage = (MDMessage)this.m_messageList.remove(i);
                        }
                    } else {
                        this.m_message.setAcknowledged();
                        while (((MDMessage)this.m_messageList.getFirst()).isAcknowledged()) {
                            mDMessage = (MDMessage)this.m_messageList.removeFirst();
                            if (!this.m_messageList.isEmpty()) continue;
                        }
                    }
                }
                if (mDMessage != null && !this.recovered) {
                    if (this.connectionPoller.isCurrentSubjectKernelIdentity()) {
                        object = mDMessage;
                        try {
                            this.connectionPoller.doPrivilegedJMSAction(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (JMSException jMSException) {}
                    } else {
                        mDMessage.acknowledge();
                    }
                }
            }
            this.m_message = null;
            this.m_transaction = null;
        }
        return bl2;
        return bl3;
    }

    public void run() {
        this.execute(true);
    }

    int getTransactionTimeoutMS() {
        return this.m_info.getTransactionTimeoutMS();
    }

    Throwable getExecuteException() {
        return this.executeException;
    }

    boolean getRolledBack() {
        return this.rolledBack;
    }

    int getMaxMessagesInTransaction() {
        if (!this.m_isTransacted) {
            return 1;
        }
        return this.m_info.getMaxMessagesInTransaction();
    }

    private boolean isRemoteDomain() {
        boolean bl = false;
        try {
            bl = CrossDomainSecurityManager.getCrossDomainSecurityUtil().isRemoteDomain(this.m_info.getProviderURL());
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    private static final class MDMessage {
        private final Message m_message;
        private boolean m_isAcknowledged;
        private boolean m_isRecovered;
        private Session m_session;
        private final boolean m_acknowledgePreviousMode;

        MDMessage(Message message, Session session, boolean bl) {
            this.m_message = message;
            this.m_session = session;
            this.m_acknowledgePreviousMode = bl;
        }

        void setAcknowledged() {
            this.m_isAcknowledged = true;
        }

        void setRecovered() {
            this.m_isRecovered = true;
        }

        boolean isAcknowledged() {
            return this.m_isAcknowledged;
        }

        boolean isRecovered() {
            return this.m_isRecovered;
        }

        Message getMessage() {
            return this.m_message;
        }

        void acknowledge() {
            try {
                if (this.m_acknowledgePreviousMode) {
                    ((WLSessionImpl)this.m_session).acknowledge(this.m_message, 2, false);
                } else {
                    this.m_message.acknowledge();
                }
            }
            catch (JMSException jMSException) {
                EJBLogger.logStackTrace((Throwable)jMSException);
            }
        }
    }
}

