/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.TransactionRequiredLocalException;
import javax.security.jacc.EJBMethodPermission;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRequiredException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.EntityBeanInfo;
import weblogic.ejb.container.interfaces.MethodInfo;
import weblogic.ejb.container.internal.EJBRuntimeUtils;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.container.utils.ToStringUtils;
import weblogic.logging.Loggable;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.EJBResource;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.utils.AssertionError;

public final class MethodDescriptor
implements Cloneable {
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    private int txAttribute;
    private String applicationName;
    private String ejbComponentName;
    private String ejbName;
    private Method method;
    private String methodName;
    private int txTimeoutMS;
    private Integer isolationLevel;
    private int selectForUpdate = 0;
    private final MethodInfo methodInfo;
    private boolean entityAlwaysUsesTransaction;
    private boolean isLocal;
    private String methodId;
    private EJBResource ejbResource;
    private EJBMethodPermission ejbMethodPermission;
    private boolean usingAlternateRunAsSubject = false;
    private AuthenticatedSubject runAsSubject;
    private SecurityHelper securityHelper;
    private boolean isEntityBean = false;
    private String txName;

    public MethodDescriptor(BeanInfo beanInfo, String string, String string2, String string3, Method method, MethodInfo methodInfo, int n, int n2, boolean bl, boolean bl2) {
        this.applicationName = string;
        this.ejbComponentName = string2;
        this.ejbName = string3;
        this.txTimeoutMS = n2;
        this.txAttribute = n;
        this.method = method;
        this.methodName = method.getName();
        this.isLocal = bl2;
        this.entityAlwaysUsesTransaction = bl;
        this.methodInfo = methodInfo;
        assert (methodInfo != null) : "Could not find MethodInfo for method:" + method;
        this.setupIsolationLevel(methodInfo.getTxIsolationLevel());
        this.txName = "[EJB " + beanInfo.getBeanClassName() + "." + methodInfo.getSignature() + "]";
        if (beanInfo instanceof EntityBeanInfo) {
            this.isEntityBean = true;
        }
        this.selectForUpdate = methodInfo.getSelectForUpdate();
    }

    public void setupIsolationLevel(int n) {
        switch (n) {
            case -1: {
                this.isolationLevel = null;
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.isolationLevel = new Integer(n);
                return;
            }
        }
        throw new AssertionError("Bad isolation level setting" + n);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEjbComponentName() {
        return this.ejbComponentName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setTXAttribute(int n) {
        this.txAttribute = n;
    }

    public int getTXAttribute() {
        return this.txAttribute;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.methodName + "(");
        String[] stringArray = this.methodInfo.getMethodParams();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(")");
        return "MethodDescriptor: Method: " + stringBuffer.toString() + " Transaction attribute: " + ToStringUtils.txAttributeToString(this.txAttribute) + " Isolation Level: " + ToStringUtils.isoToString(this.isolationLevel) + " Tx Timeout: " + this.txTimeoutMS;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    Transaction getCallerTx() {
        return TxHelper.getTransaction();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.methodName = method.getName();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public int getSelectForUpdate() {
        return this.selectForUpdate;
    }

    private void setSelectForUpdateInTxMaybe(Transaction transaction) {
        Object var2_2 = null;
        switch (this.selectForUpdate) {
            case 0: {
                return;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new AssertionError("Unknown selectForUpdate type: '" + this.selectForUpdate + "'");
            }
        }
        ((TransactionImpl)transaction).setProperty("SELECT_FOR_UPDATE", (Serializable)new Integer(this.selectForUpdate));
    }

    public void setRunAsSubject(AuthenticatedSubject authenticatedSubject) {
        this.runAsSubject = authenticatedSubject;
    }

    public void setEJBResource(EJBResource eJBResource) {
        this.ejbResource = eJBResource;
    }

    public void setEJBMethodPermission(EJBMethodPermission eJBMethodPermission) {
        this.ejbMethodPermission = eJBMethodPermission;
    }

    public int getTxTimeoutMS() {
        return this.txTimeoutMS;
    }

    public void updateTxTimeoutMS(int n) {
        this.txTimeoutMS = n;
    }

    public void setRetryOnRollbackCount(int n) {
        this.methodInfo.setRetryOnRollbackCount(n);
    }

    public int getRetryOnRollbackCount() {
        return this.methodInfo.getRetryOnRollbackCount();
    }

    private Transaction startLocalTransaction() throws InvalidTransactionException {
        Transaction transaction = this.startTransaction();
        ((TransactionImpl)transaction).setProperty("LOCAL_ENTITY_TX", (Serializable)((Object)"true"));
        return transaction;
    }

    private Transaction startTransaction() throws InvalidTransactionException {
        try {
            TransactionManager transactionManager = TxHelper.getTransactionManager();
            transactionManager.setTransactionTimeout(this.txTimeoutMS / 1000);
            transactionManager.begin();
            Transaction transaction = transactionManager.getTransaction();
            ((weblogic.transaction.Transaction)transaction).setName(this.txName);
            if (this.isolationLevel != null) {
                ((TransactionImpl)transaction).setProperty("ISOLATION LEVEL", (Serializable)this.isolationLevel);
            }
            this.setSelectForUpdateInTxMaybe(transaction);
            return transaction;
        }
        catch (Exception exception) {
            throw new InvalidTransactionException("Transaction could not begin:\n" + exception.getMessage());
        }
    }

    Object getInvokeTx() throws InternalException {
        Transaction transaction = this.getCallerTx();
        return this.getInvokeTx(transaction);
    }

    Object getInvokeTx(Transaction transaction) throws InternalException {
        try {
            TransactionImpl transactionImpl;
            if (this.entityAlwaysUsesTransaction && this.isEntityBean && transaction != null && (transactionImpl = (TransactionImpl)transaction).getProperty("LOCAL_ENTITY_TX") != null) {
                try {
                    TxHelper.getTransactionManager().suspend();
                }
                catch (SystemException systemException) {
                    EJBRuntimeUtils.throwInternalException("Error suspending tx:", systemException);
                }
                transaction = null;
            }
            switch (this.txAttribute) {
                case 5: {
                    if (transaction != null) {
                        transactionImpl = EJBLogger.logTxNerverMethodCalledWithnInTxLoggable((String)this.methodName);
                        String string = transactionImpl.getMessage();
                        if (this.isLocal) {
                            throw new EJBException(string);
                        }
                        throw new RemoteException(string);
                    }
                    if (this.isEntityBean) {
                        if (this.entityAlwaysUsesTransaction) {
                            return this.startLocalTransaction();
                        }
                        return Thread.currentThread();
                    }
                    return null;
                }
                case 0: {
                    try {
                        TxHelper.getTransactionManager().suspend();
                        if (this.isEntityBean) {
                            if (this.entityAlwaysUsesTransaction) {
                                return this.startLocalTransaction();
                            }
                            return Thread.currentThread();
                        }
                        return null;
                    }
                    catch (SystemException systemException) {
                        EJBRuntimeUtils.throwInternalException("Error suspending tx:", systemException);
                    }
                }
                case 2: {
                    if (this.isEntityBean) {
                        if (transaction == null) {
                            if (this.entityAlwaysUsesTransaction) {
                                return this.startLocalTransaction();
                            }
                            return Thread.currentThread();
                        }
                        this.setSelectForUpdateInTxMaybe(transaction);
                        return transaction;
                    }
                    return transaction;
                }
                case 1: {
                    if (transaction == null) {
                        return this.startTransaction();
                    }
                    this.setSelectForUpdateInTxMaybe(transaction);
                    return transaction;
                }
                case 3: {
                    try {
                        TxHelper.getTransactionManager().suspend();
                    }
                    catch (SystemException systemException) {
                        EJBRuntimeUtils.throwInternalException("Error suspending tx:", systemException);
                    }
                    return this.startTransaction();
                }
                case 4: {
                    if (transaction == null) {
                        throw new TxRequiredException("Method " + this.methodName + " is deployed as TX_MANDATORY, but it was called without " + "a transaction.");
                    }
                    this.setSelectForUpdateInTxMaybe(transaction);
                    return transaction;
                }
            }
            throw new AssertionError("Unexpected tx Attribute:" + this.txAttribute);
        }
        catch (Exception exception) {
            if (exception instanceof TxRequiredException) {
                throw (TxRequiredException)exception;
            }
            EJBRuntimeUtils.throwInternalException("EJBerror: ", exception);
            throw new AssertionError("Should not reach.");
        }
    }

    Object getInvokeTxForCom(Transaction transaction) throws InternalException {
        try {
            try {
                return this.getInvokeTx(transaction);
            }
            catch (TxRequiredException txRequiredException) {
                if (this.isLocal) {
                    throw new TransactionRequiredLocalException(txRequiredException.getMessage());
                }
                throw new TransactionRequiredException(txRequiredException.getMessage());
            }
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJBerror: ", exception);
            return transaction;
        }
    }

    Object getInvokeTxForBus(Transaction transaction) throws InternalException {
        try {
            try {
                return this.getInvokeTx(transaction);
            }
            catch (TxRequiredException txRequiredException) {
                throw new EJBTransactionRequiredException(txRequiredException.getMessage());
            }
        }
        catch (Exception exception) {
            EJBRuntimeUtils.throwInternalException("EJBerror: ", exception);
            return transaction;
        }
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public void pushRunAsIdentity() {
        this.pushRunAsIdentity(null);
    }

    public void pushRunAsIdentity(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject == null) {
            if (this.runAsSubject != null) {
                if (debugLogger.isDebugEnabled()) {
                    MethodDescriptor.debug(" method: '" + this.methodName + "' push RunAs for Subject: '" + this.runAsSubject.toString() + "'");
                }
                SecurityHelper.pushRunAsSubject(this.runAsSubject);
            }
        } else {
            if (debugLogger.isDebugEnabled()) {
                MethodDescriptor.debug(" method: '" + this.methodName + "' push alternateRunAs for Subject: '" + authenticatedSubject.toString() + "'");
            }
            SecurityHelper.pushRunAsSubject(authenticatedSubject);
            this.usingAlternateRunAsSubject = true;
        }
    }

    public void popRunAsIdentity() {
        if (this.usingAlternateRunAsSubject) {
            if (debugLogger.isDebugEnabled()) {
                MethodDescriptor.debug(" method: '" + this.methodName + "' pop RunAs for Alternate Subject");
            }
            SecurityHelper.popRunAsSubject();
            this.usingAlternateRunAsSubject = false;
        } else if (this.runAsSubject != null) {
            if (debugLogger.isDebugEnabled()) {
                MethodDescriptor.debug(" method: '" + this.methodName + "' pop RunAs for Subject: '" + this.runAsSubject.toString() + "'");
            }
            SecurityHelper.popRunAsSubject();
        }
    }

    public boolean checkMethodPermissionsRemote(ContextHandler contextHandler) throws AccessException {
        if (!this.checkMethodPermissions(contextHandler)) {
            if (this.checkExcluded()) {
                Loggable loggable = EJBLogger.logaccessExceptionLoggable((String)this.methodName);
                throw new AccessException(loggable.getMessage());
            }
            throw new AccessException(this.getAccessDeniedMessage());
        }
        return true;
    }

    public boolean checkMethodPermissionsLocal(ContextHandler contextHandler) throws AccessLocalException {
        if (!this.checkMethodPermissions(contextHandler)) {
            if (this.checkExcluded()) {
                Loggable loggable = EJBLogger.logaccessExceptionLoggable((String)this.methodName);
                throw new AccessLocalException(loggable.getMessage());
            }
            throw new AccessLocalException(this.getAccessDeniedMessage());
        }
        return true;
    }

    public boolean checkMethodPermissionsBusiness(ContextHandler contextHandler) throws EJBAccessException {
        if (!this.checkMethodPermissions(contextHandler)) {
            if (this.checkExcluded()) {
                Loggable loggable = EJBLogger.logaccessExceptionLoggable((String)this.methodName);
                throw new EJBAccessException(loggable.getMessage());
            }
            throw new EJBAccessException(this.getAccessDeniedMessage());
        }
        return true;
    }

    public boolean checkMethodPermissions(ContextHandler contextHandler) {
        if (!this.securityHelper.fullyDelegateSecurityCheck()) {
            if (this.checkExcluded()) {
                return false;
            }
            if (this.isUnchecked()) {
                return true;
            }
        }
        return this.checkAccess(contextHandler);
    }

    private boolean checkAccess(ContextHandler contextHandler) {
        if (debugLogger.isDebugEnabled()) {
            MethodDescriptor.debug(this.toString());
            MethodDescriptor.debug("needsSecurityCheck: " + this.methodInfo.needsSecurityCheck());
            MethodDescriptor.debug("subject: " + SecurityHelper.getCurrentSubject());
        }
        if (this.methodInfo.needsSecurityCheck()) {
            this.securityHelper.setContext(contextHandler);
            boolean bl = this.securityHelper.isAccessAllowed(this.ejbResource, this.ejbMethodPermission, contextHandler);
            if (debugLogger.isDebugEnabled()) {
                MethodDescriptor.debug(bl ? "  Access Allowed. \n" : "  Access Denied ! \n");
            }
            this.securityHelper.resetContext();
            return bl;
        }
        return true;
    }

    public boolean checkExcluded() {
        return this.methodInfo.getIsExcluded();
    }

    public boolean isUnchecked() {
        return this.methodInfo.getUnchecked();
    }

    private String getAccessDeniedMessage() {
        MethodDescriptor methodDescriptor = this;
        String string = methodDescriptor.securityHelper.getCurrentPrincipal().getName();
        if (string == null) {
            string = "UNKNOWN";
        }
        String string2 = null;
        if (this.ejbResource != null) {
            string2 = this.ejbResource.toString();
        } else if (this.ejbMethodPermission != null) {
            string2 = this.ejbMethodPermission.toString();
        }
        if (string2 == null) {
            string2 = this.methodName;
        }
        Loggable loggable = EJBLogger.logaccessDeniedOnEJBResourceLoggable((String)string, (String)string2);
        return loggable.getMessage();
    }

    public void setMethodId(String string) {
        this.methodId = string;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError("Unable to clone MethodDescriptor", (Throwable)cloneNotSupportedException);
        }
    }

    private static void debug(String string) {
        debugLogger.debug("[MethodDescriptor] " + string);
    }

    public final class TxRequiredException
    extends RuntimeException {
        private static final long serialVersionUID = 1239800172031557020L;

        public TxRequiredException(String string) {
            super(string);
        }
    }
}

