/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.security.PrivilegedExceptionAction;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.internal.JMSConnectionPoller;
import weblogic.ejb.container.internal.JMSPollerManager;
import weblogic.ejb.container.internal.MDListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public class NewJMSMessagePoller
implements Runnable,
TimerListener {
    private static final DebugLogger debugLogger = EJBDebugService.invokeLogger;
    private static final int MESSAGE_RECEIVE_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_DESTINATION_POLL_INTERVAL_MILLIS = 1000;
    private static final String DESTINATION_POLL_INTERVAL_PROPERTY = "weblogic.ejb.container.MDBDestinationPollIntervalMillis";
    static final int DESTINATION_POLL_INTERVAL_MILLIS = Integer.getInteger("weblogic.ejb.container.MDBDestinationPollIntervalMillis", 1000);
    static final int LAST_SESSION_CLOSE_IDLE_THRESHOLD_MILLIS = 5000;
    private static final String TRANSACTION_NAME_PREFIX = "NewJMSMessagePoller.";
    private final int id;
    private final String mdbName;
    private final JMSConnectionPoller connectionPoller;
    private volatile MessageConsumer consumer;
    private final TransactionManager txManager;
    private final MDListener listener;
    private final String txName;
    private final JMSPollerManager pm;
    private final boolean reCreateMC;
    private final Destination dest;
    private final boolean dynamicSessionClose;
    private volatile boolean keepRunning;

    public NewJMSMessagePoller(int n, String string, JMSConnectionPoller jMSConnectionPoller, JMSPollerManager jMSPollerManager, MessageConsumer messageConsumer, MDListener mDListener, boolean bl, Destination destination, boolean bl2) {
        this.mdbName = string;
        this.connectionPoller = jMSConnectionPoller;
        this.pm = jMSPollerManager;
        this.listener = mDListener;
        this.consumer = messageConsumer;
        this.txManager = TxHelper.getTransactionManager();
        this.txName = TRANSACTION_NAME_PREFIX + string;
        this.id = n;
        this.reCreateMC = bl;
        this.dest = destination;
        this.dynamicSessionClose = bl2;
    }

    public void stop() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Stopping : " + this));
        }
        this.keepRunning = false;
    }

    public void start() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Starting : " + this));
        }
        this.keepRunning = true;
    }

    public void run() {
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Message polling started for MDB " + this.mdbName + " poller " + this.id));
        }
        boolean bl = false;
        JMSException jMSException = null;
        int n = 0;
        int n2 = 0;
        while (this.keepRunning) {
            int n3;
            block27: {
                bl = false;
                jMSException = null;
                n3 = this.pm.getBatchSize(this.listener.getMaxMessagesInTransaction());
                try {
                    if (this.consumer == null) {
                        assert (this.listener.isDetached()) : "The MDListener should be deteched when consumer is null";
                        JMSConnectionPoller.CreateSessionResult createSessionResult = this.connectionPoller.dynamicCreateSession(this.id);
                        this.consumer = createSessionResult.consumer;
                        this.listener.attach(createSessionResult.session, createSessionResult.wrappedSession);
                    }
                    if (this.processOneMessage(n3, 2000)) {
                        if (this.listener.getExecuteException() != null) {
                            throw this.listener.getExecuteException();
                        }
                        if (this.listener.getRolledBack()) {
                            bl = true;
                        }
                        if (this.keepRunning && this.pm.scheduleIfBusy(this)) {
                            if (debugLogger.isDebugEnabled()) {
                                Debug.say((String)("Got scheduled as server is busy, poller : " + this));
                            }
                            return;
                        }
                        break block27;
                    }
                    if (this.pm.holdsToken(this.id) || this.pm.acquireToken(this.id)) {
                        if (DESTINATION_POLL_INTERVAL_MILLIS > 5000 && this.dynamicSessionClose) {
                            block28: {
                                this.listener.detach();
                                try {
                                    this.connectionPoller.dynamicCloseSession(this.id);
                                }
                                catch (Throwable throwable) {
                                    if (!debugLogger.isDebugEnabled()) break block28;
                                    Debug.say((String)("Failed to dynamic close session:" + throwable));
                                }
                            }
                            this.consumer = null;
                        }
                        this.pm.scheduleTimer(this, DESTINATION_POLL_INTERVAL_MILLIS);
                        return;
                    }
                    if (!this.keepRunning) break;
                    if (this.dynamicSessionClose) {
                        block29: {
                            this.listener.detach();
                            try {
                                this.connectionPoller.dynamicCloseSession(this.id);
                            }
                            catch (Throwable throwable) {
                                if (!debugLogger.isDebugEnabled()) break block29;
                                Debug.say((String)("Failed to dynamic close session:" + throwable));
                            }
                        }
                        this.consumer = null;
                        break;
                    }
                    if (!this.reCreateMC) break;
                    this.consumer = this.connectionPoller.reCreateMessageConsumer(this.dest, this.id);
                    break;
                }
                catch (JMSException jMSException2) {
                    EJBLogger.logJMSExceptionReceivingForMDB((String)JMSConnectionPoller.getAllExceptionText(jMSException2), (String)StackTraceUtils.throwable2StackTrace((Throwable)jMSException2));
                    ++n2;
                    jMSException = jMSException2;
                    bl = true;
                }
                catch (SystemException systemException) {
                    EJBLogger.logJMSExceptionReceivingForMDB((String)JMSConnectionPoller.getAllExceptionText(systemException), (String)StackTraceUtils.throwable2StackTrace((Throwable)systemException));
                    ++n2;
                    JMSException jMSException3 = new JMSException(systemException.toString());
                    jMSException3.setLinkedException((Exception)((Object)systemException));
                    jMSException = jMSException3;
                    bl = true;
                }
                catch (Throwable throwable) {
                    EJBLogger.logJMSExceptionProcessingMDB((String)JMSConnectionPoller.getAllExceptionText(throwable), (String)StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                    bl = true;
                }
            }
            if (bl) {
                ++n;
                this.pm.notifyError(n3);
                if (n2 >= 3 && jMSException != null) {
                    if (debugLogger.isDebugEnabled()) {
                        Debug.say((String)"Too many errors, attempting re-connect");
                    }
                    this.connectionPoller.onException(jMSException);
                    n2 = 0;
                    continue;
                }
                if (JMSConnectionPoller.MAX_ERROR_COUNT <= 0 || n < JMSConnectionPoller.MAX_ERROR_COUNT) continue;
                if (debugLogger.isDebugEnabled()) {
                    Debug.say((String)"Sleeping after error in MDB poller thread");
                }
                try {
                    Thread.sleep(JMSConnectionPoller.ERROR_SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = 0;
                continue;
            }
            n2 = 0;
            n = 0;
        }
        this.pm.releaseToken(this.id);
        this.pm.returnToPool(this);
        if (debugLogger.isDebugEnabled()) {
            Debug.say((String)("Message polling ended for MDB " + this.mdbName + " poller " + this.id));
        }
    }

    public void timerExpired(Timer timer) {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processOneMessage(int n, final int n2) throws JMSException, NotSupportedException, SystemException, RollbackException {
        Message message;
        block8: {
            int n3;
            message = null;
            Transaction transaction = null;
            if (this.listener.isTransacted()) {
                n3 = (this.listener.getTransactionTimeoutMS() + n2) / 1000;
                this.txManager.begin(this.txName, n3);
                transaction = this.txManager.getTransaction();
            }
            try {
                for (n3 = 0; n3 < n; ++n3) {
                    final int n4 = n3;
                    message = (Message)this.connectionPoller.doPrivilegedJMSAction(new PrivilegedExceptionAction(){

                        public Object run() throws JMSException {
                            if (n4 == 0) {
                                return NewJMSMessagePoller.this.consumer.receive((long)n2);
                            }
                            return NewJMSMessagePoller.this.consumer.receiveNoWait();
                        }
                    });
                    if (message != null) {
                        if (debugLogger.isDebugEnabled()) {
                            Debug.say((String)("Got message " + message.getJMSMessageID() + " #" + n3 + " for processing by MDB " + this.mdbName));
                        }
                        if (this.pm.holdsToken(this.id)) {
                            this.pm.wakeUpPoller(this, null);
                        }
                        if (n3 >= n - 1) {
                            this.listener.transactionalOnMessage(message, true);
                            transaction = null;
                            continue;
                        }
                        if (this.listener.transactionalOnMessage(message, false)) continue;
                        transaction = null;
                        break;
                    }
                    if (n3 <= 0) break;
                    this.listener.transactionalOnMessage(null, true);
                    transaction = null;
                    break;
                }
                Object var8_7 = null;
                if (transaction == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (transaction == null) throw throwable;
                transaction.rollback();
                throw throwable;
            }
            transaction.rollback();
        }
        if (message == null) return false;
        return true;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return "[Poller for " + this.mdbName + " with id :" + this.id + ". ]";
    }
}

