/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import javax.security.jacc.PolicyConfiguration;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.jacc.RoleMapper;
import weblogic.utils.Debug;

public final class PoolHelper {
    private SecurityHelper helper;
    private String name;
    private String pid;
    private String src;
    private PolicyConfiguration cf;
    private RoleMapper rm;

    public PoolHelper(String string, PolicyConfiguration policyConfiguration, String string2, String string3, RoleMapper roleMapper) {
        this.name = string;
        this.pid = string2;
        this.src = string3;
        this.cf = policyConfiguration;
        this.rm = roleMapper;
    }

    public AuthenticatedSubject getFileDesc(String string) throws PrincipalNotFoundException {
        this.initialize();
        return this.helper.getSubjectForPrincipal(string);
    }

    public static boolean setFile(AuthenticatedSubject authenticatedSubject, AuthenticatedSubject authenticatedSubject2) {
        return SecurityHelper.pushSpecificRunAsMaybe(authenticatedSubject, authenticatedSubject2);
    }

    public static boolean setSegment(AuthenticatedSubject authenticatedSubject, AuthenticatedSubject authenticatedSubject2) {
        return SecurityHelper.pushSpecificRunAsMaybe(authenticatedSubject, authenticatedSubject2);
    }

    public static void resetFile() {
        SecurityHelper.popRunAsSubject();
    }

    public static void setDir() {
        SecurityHelper.pushCallerPrincipal();
    }

    public static void resetDir() {
        try {
            SecurityHelper.popCallerPrincipal();
        }
        catch (Exception exception) {
            EJBLogger.logErrorPoppingCallerPrincipal((Exception)exception);
        }
    }

    public static void setFile2(AuthenticatedSubject authenticatedSubject) {
        SecurityHelper.pushRunAsSubject(authenticatedSubject);
    }

    public static void resetFile2() {
        SecurityHelper.popRunAsSubject();
    }

    private void initialize() {
        if (this.helper == null) {
            try {
                this.helper = new SecurityHelper(this.name, this.cf, this.pid, this.src, this.rm);
            }
            catch (Throwable throwable) {
                Debug.assertion((boolean)false, (String)("could not create SecurityHelper: " + throwable.getMessage()));
            }
        }
    }
}

