/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.container.cache.QueryCacheElement;
import weblogic.ejb.container.cache.QueryCacheKey;
import weblogic.ejb.container.cmp.rdbms.finders.Finder;
import weblogic.ejb.container.manager.TTLManager;

public class QueryCachingHandler {
    private TTLManager ownerManager;
    private String finderIdentifierOrQuery;
    private Object[] arguments;
    private int maxElements = -1;
    private QueryCacheKey queryCacheKey;
    private Map queryCacheEntries;
    private boolean isDynamic = false;
    private Finder finder;

    public QueryCachingHandler(String string, Object[] objectArray, Finder finder, TTLManager tTLManager) {
        this.finderIdentifierOrQuery = string;
        this.arguments = objectArray;
        this.finder = finder;
        this.ownerManager = tTLManager;
        this.isDynamic = false;
        Class clazz = finder.getReturnClassType();
        this.queryCacheKey = Set.class.isAssignableFrom(clazz) ? new QueryCacheKey(string, objectArray, tTLManager, 1) : (Collection.class.isAssignableFrom(clazz) ? new QueryCacheKey(string, objectArray, tTLManager, 2) : new QueryCacheKey(string, objectArray, tTLManager, 3));
        this.queryCacheEntries = new HashMap();
    }

    public QueryCachingHandler(String string, int n, Finder finder, TTLManager tTLManager) {
        this.finderIdentifierOrQuery = string;
        this.maxElements = n;
        this.finder = finder;
        this.ownerManager = tTLManager;
        this.isDynamic = true;
        Class clazz = finder.getReturnClassType();
        this.queryCacheKey = Set.class.isAssignableFrom(clazz) ? new QueryCacheKey(string, n, tTLManager, 1) : (Collection.class.isAssignableFrom(clazz) ? new QueryCacheKey(string, n, tTLManager, 2) : new QueryCacheKey(string, n, tTLManager, 3));
        this.queryCacheEntries = new HashMap();
    }

    public QueryCachingHandler(Finder finder) {
        this.finder = finder;
        this.queryCacheEntries = new HashMap();
    }

    public boolean isQueryCachingEnabledForFinder() {
        return this.finder.isQueryCachingEnabled();
    }

    public void addQueryCachingEntry(TTLManager tTLManager, QueryCacheElement queryCacheElement) {
        QueryCacheKey queryCacheKey = this.generateQueryCacheKey(tTLManager);
        if (!queryCacheKey.equals(this.queryCacheKey)) {
            queryCacheKey.addSourceQuery(this.queryCacheKey);
            this.queryCacheKey.addDependentQuery(queryCacheKey);
        }
        this.addToEntryCollection(tTLManager, queryCacheKey, queryCacheElement);
    }

    public void addQueryCachingEntry(TTLManager tTLManager, QueryCacheKey queryCacheKey, QueryCacheElement queryCacheElement) {
        if (this.finder.isQueryCachingEnabled()) {
            queryCacheKey.addSourceQuery(this.queryCacheKey);
            this.queryCacheKey.addDependentQuery(queryCacheKey);
        }
        this.addToEntryCollection(tTLManager, queryCacheKey, queryCacheElement);
    }

    public void putInQueryCache() {
        for (TTLManager tTLManager : this.queryCacheEntries.keySet()) {
            Map map = (Map)this.queryCacheEntries.get(tTLManager);
            for (QueryCacheKey queryCacheKey : map.keySet()) {
                tTLManager.putInQueryCache(queryCacheKey, (Collection)map.get(queryCacheKey));
            }
        }
    }

    protected QueryCacheKey generateQueryCacheKey(TTLManager tTLManager) {
        if (tTLManager.equals(this.ownerManager) && this.queryCacheKey != null) {
            return this.queryCacheKey;
        }
        if (this.isDynamic) {
            return new QueryCacheKey(this.finderIdentifierOrQuery, this.maxElements, tTLManager, 0);
        }
        return new QueryCacheKey(this.finderIdentifierOrQuery, this.arguments, tTLManager, 0);
    }

    private void addToEntryCollection(TTLManager tTLManager, QueryCacheKey queryCacheKey, QueryCacheElement queryCacheElement) {
        ArrayList<QueryCacheElement> arrayList;
        HashMap<QueryCacheKey, ArrayList<QueryCacheElement>> hashMap = (HashMap<QueryCacheKey, ArrayList<QueryCacheElement>>)this.queryCacheEntries.get(tTLManager);
        if (hashMap == null) {
            hashMap = new HashMap<QueryCacheKey, ArrayList<QueryCacheElement>>();
            this.queryCacheEntries.put(tTLManager, hashMap);
        }
        if ((arrayList = (ArrayList<QueryCacheElement>)hashMap.get(queryCacheKey)) == null) {
            arrayList = new ArrayList<QueryCacheElement>();
            hashMap.put(queryCacheKey, arrayList);
        }
        arrayList.add(queryCacheElement);
    }
}

