/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import weblogic.ejb.container.deployer.DownloadRemoteBizIntfClassLoader;
import weblogic.ejb.container.deployer.RemoteBizIntfClassLoader;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;

@Deprecated
public final class RemoteBusinessIntfGenerator {
    private String remoteInterfaceName;
    private Class businessInterface;
    private Class generatedRemoteInterface;
    private GenericClassLoader cl;
    private static final Map<LoaderCacheKey, WeakReference> classLoaderCache = new HashMap<LoaderCacheKey, WeakReference>();
    private static boolean debug = Boolean.getBoolean("weblogic.ejb.enhancement.debug");

    public RemoteBusinessIntfGenerator(String string, Class clazz, GenericClassLoader genericClassLoader) {
        this.remoteInterfaceName = string;
        this.businessInterface = clazz;
        this.cl = genericClassLoader;
    }

    public Class getGeneratedRemoteInterface() {
        return this.generatedRemoteInterface;
    }

    public Class generateRemoteInterface() {
        Method[] methodArray;
        boolean bl = false;
        for (Method method : methodArray = this.businessInterface.getMethods()) {
            if (method.toGenericString().equals(method.toString()) || !this.isGenericInterfaceDeclared(this.businessInterface)) continue;
            bl = true;
            break;
        }
        String string = this.businessInterface.getName();
        if (!bl) {
            try {
                RemoteBizIntfClassLoader classNotFoundException = this.getEnhanceLoader();
                Class<?> clazz = classNotFoundException.loadClass(string);
                this.debug("loaded by enhanceCL:" + clazz.getName());
                if (clazz.getName().equals(this.remoteInterfaceName)) {
                    this.generatedRemoteInterface = clazz;
                    this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by enhancing business interface on RemoteBizIntfClassLoader: \n" + (Object)((Object)classNotFoundException));
                } else {
                    this.generatedRemoteInterface = classNotFoundException.loadClass(this.remoteInterfaceName);
                    this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by loading it directly on RemoteBizIntfClassLoader: \n" + (Object)((Object)classNotFoundException));
                }
                return this.generatedRemoteInterface;
            }
            catch (ClassNotFoundException downloadRemoteBizIntfClassLoader) {
                throw new AssertionError((Object)downloadRemoteBizIntfClassLoader);
            }
        }
        DownloadRemoteBizIntfClassLoader downloadRemoteBizIntfClassLoader = null;
        try {
            downloadRemoteBizIntfClassLoader = new DownloadRemoteBizIntfClassLoader(this.remoteInterfaceName, (ClassLoader)this.cl);
            Class<?> classNotFoundException = downloadRemoteBizIntfClassLoader.loadClass(string);
            if (classNotFoundException.getName().equals(this.remoteInterfaceName)) {
                this.generatedRemoteInterface = classNotFoundException;
                this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by enhancing business interface on RemoteBizIntfClassLoader: \n" + downloadRemoteBizIntfClassLoader);
            } else {
                this.generatedRemoteInterface = downloadRemoteBizIntfClassLoader.loadClass(this.remoteInterfaceName);
                this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by loading it directly on RemoteBizIntfClassLoader: \n" + downloadRemoteBizIntfClassLoader);
            }
            return this.generatedRemoteInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteBizIntfClassLoader getEnhanceLoader() {
        if (debug) {
            this.debug("enhance loader cache: " + classLoaderCache);
        }
        this.debug("businessInterface: " + this.businessInterface.getName() + " and generated interface: " + this.remoteInterfaceName);
        LoaderCacheKey loaderCacheKey = new LoaderCacheKey(this.businessInterface.getName(), this.remoteInterfaceName, this.cl);
        RemoteBizIntfClassLoader remoteBizIntfClassLoader = null;
        Map<LoaderCacheKey, WeakReference> map = classLoaderCache;
        synchronized (map) {
            WeakReference<RemoteBizIntfClassLoader> weakReference = classLoaderCache.get(loaderCacheKey);
            if (weakReference == null || weakReference.get() == null) {
                remoteBizIntfClassLoader = new RemoteBizIntfClassLoader(this.businessInterface.getName(), this.remoteInterfaceName, this.cl);
                weakReference = new WeakReference<RemoteBizIntfClassLoader>(remoteBizIntfClassLoader);
                classLoaderCache.put(loaderCacheKey, weakReference);
                if (debug) {
                    this.debug("newly created RemoteBizIntfClassLoader: " + (Object)((Object)remoteBizIntfClassLoader) + " enhanceLoaderCache: " + classLoaderCache);
                }
            } else {
                remoteBizIntfClassLoader = (RemoteBizIntfClassLoader)((Object)weakReference.get());
                this.debug("got RemoteBizIntfClassLoader from cache: " + (Object)((Object)remoteBizIntfClassLoader));
            }
        }
        return remoteBizIntfClassLoader;
    }

    private boolean isGenericInterfaceDeclared(Type type) {
        if (type == null) {
            return false;
        }
        if (!(type instanceof Class)) {
            return true;
        }
        Class clazz = (Class)type;
        if (!clazz.isInterface()) {
            return false;
        }
        Type[] typeArray = clazz.getGenericInterfaces();
        if (typeArray.length == 0) {
            return clazz.getTypeParameters().length != 0;
        }
        int n = 0;
        Type[] typeArray2 = typeArray;
        int n2 = typeArray2.length;
        if (n < n2) {
            Type type2 = typeArray2[n];
            return this.isGenericInterfaceDeclared(type2);
        }
        return false;
    }

    private static void dumpIfaceInfo(Class clazz) {
        System.out.println("iface name: " + clazz.getName());
        System.out.println("isInterface: " + clazz.isInterface());
        System.out.println("super: " + clazz.getSuperclass());
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            System.out.println("implemented interface: " + classArray[i]);
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            System.out.println("Method: " + methodArray[i]);
        }
        System.out.println("\n");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: java RemoteBusinessIntfGenerator <remote-business-interface-name>");
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String string = stringArray[0];
            Class<?> clazz = classLoader.loadClass(string);
            GenericClassLoader genericClassLoader = AugmentableClassLoaderManager.getAugmentableClassLoader((ClassLoader)classLoader);
            RemoteBusinessIntfGenerator remoteBusinessIntfGenerator = new RemoteBusinessIntfGenerator(string + "Remote", clazz, genericClassLoader);
            Class clazz2 = remoteBusinessIntfGenerator.generateRemoteInterface();
            RemoteBusinessIntfGenerator.dumpIfaceInfo(clazz2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void debug(String string) {
        if (debug) {
            System.out.println("[" + this.getClass().getSimpleName() + "]" + "---" + Thread.currentThread() + "---" + "\n\t" + string);
        }
    }

    private static class LoaderCacheKey {
        private String biName;
        private String remoteBIName;
        private GenericClassLoader appLoader;
        private final int hashCode;

        public LoaderCacheKey(String string, String string2, GenericClassLoader genericClassLoader) {
            if (string == null || string2 == null || genericClassLoader == null) {
                throw new AssertionError((Object)("Invalid loader cache key. business interface name: " + string + ", remote business interface name: " + string2 + ",\nGenericClassLoader: " + genericClassLoader));
            }
            this.biName = string;
            this.remoteBIName = string2;
            this.appLoader = genericClassLoader;
            this.hashCode = string.hashCode() ^ string2.hashCode() ^ genericClassLoader.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof LoaderCacheKey)) {
                return false;
            }
            LoaderCacheKey loaderCacheKey = (LoaderCacheKey)object;
            return this.biName.equals(loaderCacheKey.biName) && this.remoteBIName.equals(loaderCacheKey.remoteBIName) && this.appLoader.equals(loaderCacheKey.appLoader);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

