/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Map;
import javax.ejb.EJBException;
import weblogic.application.AppClassLoaderManager;
import weblogic.ejb.container.ejbc.bytecodegen.RemoteBusIntfClassAdapter;
import weblogic.ejb.container.ejbc.codegen.MethodSignature;
import weblogic.ejb.container.internal.RemoteBusinessIntfGenerator;
import weblogic.ejb.spi.BusinessObject;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.SoftHashMap;

public class RemoteBusinessIntfProxy
implements InvocationHandler,
Serializable {
    private Object ejbObject;
    private String applicationName;
    private String remoteBusinessInterfaceName;
    private String generatedRemoteInterfaceName;
    private boolean newProxy = false;
    @Deprecated
    private Map methodsCache = null;
    private static final long serialVersionUID = 4118555029445466816L;
    private static boolean debug = Boolean.getBoolean("weblogic.ejb.enhancement.debug");

    public RemoteBusinessIntfProxy(Object object, String string, String string2, String string3) {
        this.ejbObject = object;
        this.applicationName = string;
        this.remoteBusinessInterfaceName = string2;
        this.generatedRemoteInterfaceName = string3;
        this.newProxy = true;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            Object object2 = this.getTargetObject(method);
            Method method2 = null;
            method2 = this.newProxy ? object2.getClass().getMethod(method.getName(), method.getParameterTypes()) : this.getTargetMethod(method, object2);
            if (method2.getName().equals("equals") && method2.getParameterTypes().length == 1 && method2.getParameterTypes()[0].equals(Object.class)) {
                if (!Proxy.isProxyClass(objectArray[0].getClass())) {
                    return Boolean.FALSE;
                }
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(objectArray[0]);
                if (invocationHandler instanceof RemoteBusinessIntfProxy) {
                    objectArray[0] = ((RemoteBusinessIntfProxy)invocationHandler).ejbObject;
                } else {
                    return Boolean.FALSE;
                }
            }
            return method2.invoke(object2, objectArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvocationTargetException) {
                Throwable throwable2 = ((InvocationTargetException)throwable).getTargetException();
                if (throwable2 instanceof RemoteRuntimeException) {
                    RemoteRuntimeException remoteRuntimeException = (RemoteRuntimeException)throwable2;
                    if (remoteRuntimeException.getCause() instanceof RemoteException) {
                        RemoteException remoteException = (RemoteException)remoteRuntimeException.getCause();
                        throw this.unwrapRemoteException(remoteException);
                    }
                    throw throwable2;
                }
                if (throwable2 instanceof RemoteException) {
                    RemoteException remoteException = (RemoteException)throwable2;
                    throw this.unwrapRemoteException(remoteException);
                }
                throw throwable2;
            }
            throw throwable;
        }
    }

    private Throwable unwrapRemoteException(RemoteException remoteException) {
        if (remoteException instanceof ServerException && remoteException.detail instanceof RemoteException) {
            remoteException = (RemoteException)remoteException.detail;
        }
        if (remoteException.detail != null && remoteException.detail instanceof Exception) {
            if (remoteException.detail instanceof EJBException) {
                return (EJBException)remoteException.detail;
            }
            return new EJBException(remoteException.getMessage(), (Exception)remoteException.detail).initCause(remoteException.detail);
        }
        return new EJBException(remoteException.getMessage(), (Exception)remoteException).initCause((Throwable)remoteException);
    }

    private Object getTargetObject(Method method) {
        if (method.getDeclaringClass() == BusinessObject.class) {
            return PortableRemoteObject.narrow((Object)this.ejbObject, BusinessObject.class);
        }
        return this.ejbObject;
    }

    @Deprecated
    private Method getTargetMethod(Method method, Object object) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Method method2;
        if (this.methodsCache == null) {
            this.methodsCache = new SoftHashMap();
        }
        if ((method2 = (Method)this.methodsCache.get(method.toGenericString())) == null) {
            boolean bl;
            boolean bl2 = bl = !method.toGenericString().equals(method.toString());
            if (bl) {
                Class<?> clazz = this.getClassLoader().loadClass(this.remoteBusinessInterfaceName);
                MethodSignature methodSignature = new MethodSignature(method, clazz);
                Method[] methodArray = object.getClass().getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (method.getTypeParameters().length > 0) {
                        method2 = object.getClass().getMethod(method.getName(), method.getParameterTypes());
                        continue;
                    }
                    MethodSignature methodSignature2 = new MethodSignature(methodArray[i], object.getClass());
                    if (!MethodSignature.equalsMethodsBySig(methodSignature, methodSignature2)) continue;
                    method2 = methodArray[i];
                    break;
                }
                if (method2 == null) {
                    throw new AssertionError((Object)("Can not find generic method " + methodSignature + " in EJB Object"));
                }
            } else {
                method2 = object.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            this.methodsCache.put(method.toGenericString(), method2);
        }
        return method2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.applicationName);
        objectOutputStream.writeObject(this.generatedRemoteInterfaceName);
        objectOutputStream.writeObject(this.remoteBusinessInterfaceName);
        objectOutputStream.writeObject(this.ejbObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.applicationName = (String)objectInputStream.readObject();
        this.generatedRemoteInterfaceName = (String)objectInputStream.readObject();
        if (this.generatedRemoteInterfaceName.endsWith("RIntf")) {
            this.newProxy = true;
        }
        this.remoteBusinessInterfaceName = (String)objectInputStream.readObject();
        ClassLoader classLoader = this.getClassLoader();
        Class<?> clazz = null;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (!KernelStatus.isThinIIOPClient()) {
            GenericClassLoader genericClassLoader = AugmentableClassLoaderManager.getAugmentableClassLoader((ClassLoader)classLoader);
            try {
                clazz = genericClassLoader.loadClass(this.generatedRemoteInterfaceName);
                this.debug("can load generated Remote interface: " + this.generatedRemoteInterfaceName + "\n\t on ClassLoader: " + genericClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.debug("can't load generated Remote interface: " + this.generatedRemoteInterfaceName + "\n\t on ClassLoader: " + genericClassLoader + ", try to enhance");
                Class clazz2 = genericClassLoader.loadClass(this.remoteBusinessInterfaceName);
                if (this.newProxy) {
                    String string = this.generatedRemoteInterfaceName.replace('.', '/');
                    byte[] byArray = RemoteBusIntfClassAdapter.getRBIBytes(clazz2, string);
                    clazz = genericClassLoader.defineCodeGenClass(this.generatedRemoteInterfaceName, byArray, null);
                } else {
                    RemoteBusinessIntfGenerator remoteBusinessIntfGenerator = new RemoteBusinessIntfGenerator(this.generatedRemoteInterfaceName, clazz2, genericClassLoader);
                    clazz = remoteBusinessIntfGenerator.generateRemoteInterface();
                }
                this.debug("generated Remote interface: " + clazz);
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader);
            try {
                Object object = objectInputStream.readObject();
                this.ejbObject = PortableRemoteObject.narrow((Object)object, (Class)clazz);
                Object var11_15 = null;
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                Thread.currentThread().setContextClassLoader(classLoader2);
                throw throwable;
            }
        }
        try {
            clazz = classLoader.loadClass(this.generatedRemoteInterfaceName);
            this.debug("can load generated Remote interface: " + this.generatedRemoteInterfaceName + "\n\t on ClassLoader: " + classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug("can't load generated Remote interface: " + this.generatedRemoteInterfaceName + "\n\t on ClassLoader: " + classLoader + ", try to load it after reading the stub from the stream.");
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Object object = objectInputStream.readObject();
            if (clazz == null) {
                ClassLoader classLoader3 = object.getClass().getClassLoader();
                this.debug("trying to load generated Remote interface: " + this.generatedRemoteInterfaceName + "\n\t on ClassLoader: " + classLoader3);
                clazz = Class.forName(this.generatedRemoteInterfaceName, false, classLoader3);
            }
            this.ejbObject = PortableRemoteObject.narrow((Object)object, (Class)clazz);
            Object var13_18 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
            throw throwable;
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (Kernel.isApplet()) {
            return classLoader;
        }
        if (this.applicationName != null && KernelStatus.isServer()) {
            Annotation annotation;
            AppClassLoaderManager appClassLoaderManager = AppClassLoaderManager.getAppClassLoaderManager();
            GenericClassLoader genericClassLoader = appClassLoaderManager.findLoader(annotation = new Annotation(this.applicationName));
            if (genericClassLoader != null) {
                for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                    if (classLoader2 != genericClassLoader) continue;
                    return classLoader;
                }
            }
            if ((genericClassLoader = appClassLoaderManager.findOrCreateInterAppLoader(annotation, classLoader)) != null) {
                return genericClassLoader;
            }
        }
        return classLoader;
    }

    private void debug(String string) {
        if (debug) {
            System.out.println("[" + this.getClass().getSimpleName() + "]" + "---" + Thread.currentThread() + "---" + "\n\t" + string);
        }
    }
}

