/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.SecurityRole;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.EJBLogger;
import weblogic.ejb.container.compliance.EJBComplianceTextFormatter;
import weblogic.ejb.container.interfaces.BeanInfo;
import weblogic.ejb.container.interfaces.DeploymentInfo;
import weblogic.ejb.container.interfaces.NoSuchRoleException;
import weblogic.ejb.container.interfaces.SecurityRoleMapping;
import weblogic.ejb.container.interfaces.WLEnterpriseBean;
import weblogic.ejb.container.internal.AllowedMethodsHelper;
import weblogic.ejb.container.internal.MethodDescriptor;
import weblogic.ejb.container.internal.SecurityHelper;
import weblogic.ejb.spi.WLDeploymentException;
import weblogic.ejb20.interfaces.PrincipalNotFoundException;
import weblogic.logging.Loggable;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityApplicationInfo;
import weblogic.security.service.SecurityApplicationInfoImpl;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.ApplicationInfo;

public final class RuntimeHelper {
    private static final DebugLogger debugLogger = EJBDebugService.securityLogger;
    private SecurityHelper helper;
    private Map principal2Subject;
    private DeploymentInfo deploymentInfo;
    private int roleMappingBehavior;
    private SecurityApplicationInfo securityAppInfo;
    private ApplicationContextInternal appContext;

    public RuntimeHelper(DeploymentInfo deploymentInfo, ApplicationContextInternal applicationContextInternal) throws WLDeploymentException {
        this.deploymentInfo = deploymentInfo;
        this.appContext = applicationContextInternal;
        this.securityAppInfo = new SecurityApplicationInfoImpl(this.appContext.getAppDeploymentMBean(), ApplicationInfo.ComponentType.EJB, this.deploymentInfo.getEJBComponentName());
        this.helper = new SecurityHelper(this.deploymentInfo.getSecurityRealmName(), this.deploymentInfo.getJACCPolicyConfig(), this.deploymentInfo.getJACCPolicyContextId(), this.deploymentInfo.getJACCCodeSource(), this.deploymentInfo.getJACCRoleMapper());
        this.helper.setupApplicationInfo(this.appContext, this.deploymentInfo, this.securityAppInfo);
        this.roleMappingBehavior = SecurityServiceManager.getRoleMappingBehavior((String)this.deploymentInfo.getSecurityRealmName(), (SecurityApplicationInfo)this.securityAppInfo);
    }

    public boolean fullyDelegateSecurityCheck(String string) {
        return this.helper.fullyDelegateSecurityCheck(string);
    }

    public void setRunAsSubject(MethodDescriptor methodDescriptor, String string) throws PrincipalNotFoundException {
        if (string != null) {
            AuthenticatedSubject authenticatedSubject;
            if (this.principal2Subject == null) {
                this.principal2Subject = new HashMap();
            }
            if ((authenticatedSubject = (AuthenticatedSubject)this.principal2Subject.get(string)) == null) {
                authenticatedSubject = this.helper.getSubjectForPrincipal(string);
                this.principal2Subject.put(string, authenticatedSubject);
            }
            methodDescriptor.setRunAsSubject(authenticatedSubject);
        }
    }

    public void checkRunAsPrivileges(BeanInfo beanInfo) throws WLDeploymentException {
        AuthenticatedSubject authenticatedSubject = this.appContext.getDeploymentInitiator();
        boolean bl = SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject);
        if (!(bl || this.appContext.isStaticDeploymentOperation() && SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject))) {
            this.checkRunAsPrivilege(beanInfo.getRunAsPrincipalName(), "run", beanInfo);
            this.checkRunAsPrivilege(beanInfo.getCreateAsPrincipalName(), "create", beanInfo);
            this.checkRunAsPrivilege(beanInfo.getRemoveAsPrincipalName(), "remove", beanInfo);
            this.checkRunAsPrivilege(beanInfo.getPassivateAsPrincipalName(), "passivate", beanInfo);
        }
    }

    private void checkRunAsPrivilege(String string, String string2, BeanInfo beanInfo) throws WLDeploymentException {
        if (string != null) {
            try {
                AuthenticatedSubject authenticatedSubject = this.helper.getSubjectForPrincipal(string);
                if (authenticatedSubject != null && SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject)) {
                    Loggable loggable = EJBLogger.logAttemptToBumpUpPrivilegesWithRunAsLoggable((String)beanInfo.getDisplayName(), (String)string2);
                    throw new WLDeploymentException(loggable.getMessage());
                }
            }
            catch (PrincipalNotFoundException principalNotFoundException) {
                Loggable loggable = EJBLogger.logRunAsPrincipalNotFoundLoggable((String)beanInfo.getDisplayName(), (String)string2, (String)string);
                throw new WLDeploymentException(loggable.getMessage());
            }
        }
    }

    public void registerRoleRefs(String string, Map map) throws WLDeploymentException {
        this.helper.registerRoleRefs(string, map);
    }

    public boolean processUncheckedExcludedMethod(MethodDescriptor methodDescriptor) throws WLDeploymentException {
        return this.helper.processUncheckedExcludedMethod(methodDescriptor);
    }

    public void deployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping) throws Exception {
        this.helper.deployRoles(deploymentInfo, securityRoleMapping, this.appContext, this.roleMappingBehavior);
    }

    public void unDeployRoles(DeploymentInfo deploymentInfo, SecurityRoleMapping securityRoleMapping) {
        this.helper.unDeployRoles(deploymentInfo, securityRoleMapping);
    }

    public void activate() {
        this.helper.activate();
    }

    public void deactivate() {
        this.helper.deactivate();
    }

    public boolean isUserPrincipal(String string) {
        if (string == null) {
            return false;
        }
        try {
            if (this.helper.getSubjectForPrincipal(string) == null) {
                return false;
            }
        }
        catch (PrincipalNotFoundException principalNotFoundException) {
            return false;
        }
        return true;
    }

    public static void registerSupplementalPolicyObject(String[] stringArray, String string) {
        SecurityHelper.registerSupplementalPolicyObject(stringArray, string);
    }

    public static void removeSupplementalPolicyObject(String[] stringArray) {
        SecurityHelper.removeSupplementalPolicyObject(stringArray);
    }

    public static String getDefaultRealmName() {
        return SecurityHelper.getDefaultRealmName();
    }

    public static String getCurrent() {
        return SecurityHelper.getCurrentPrincipal().getName();
    }

    public void deployAllPolicies() throws Exception {
        this.helper.deployAllPolicies();
    }

    public String getRunAsPrincipalFromRoleMapping(String string, String string2, SecurityRoleMapping securityRoleMapping) throws WLDeploymentException {
        if (debugLogger.isDebugEnabled()) {
            RuntimeHelper.debug("attempting to get the run-as principal for run-as role " + string2 + " from a security-role assignment for the role.");
        }
        String string32 = null;
        switch (this.roleMappingBehavior) {
            case 0: {
                Collection collection = null;
                try {
                    collection = securityRoleMapping.getSecurityRolePrincipalNames(string2);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    throw new AssertionError((Object)"Expected role in mapping");
                }
                for (String string32 : collection) {
                    if (!this.isUserPrincipal(string32)) {
                        string32 = null;
                        continue;
                    }
                    EJBLogger.logRunAsPrincipalChosenFromSecurityRoleAssignment((String)string, (String)string2, (String)string32);
                    break;
                }
                if (string32 == null) {
                    EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                    throw new WLDeploymentException(eJBComplianceTextFormatter.COULD_NOT_DETERMINE_RUN_AS_PRINCIPAL_FROM_ROLE_ASSIGNMENT(string, string2));
                }
                return string32;
            }
            case 1: 
            case 2: {
                Collection collection = null;
                try {
                    collection = securityRoleMapping.getSecurityRolePrincipalNames(string2);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    throw new AssertionError((Object)"Expected role in mapping");
                }
                if (!collection.isEmpty()) {
                    string32 = (String)collection.iterator().next();
                    EJBLogger.logRunAsPrincipalChosenFromSecurityRoleAssignment((String)string, (String)string2, (String)string32);
                    return string32;
                }
                String[] stringArray = null;
                SecurityRole securityRole = this.appContext.getSecurityRole(string2);
                if (securityRole != null) {
                    stringArray = securityRole.getPrincipalNames();
                }
                if (stringArray != null && stringArray.length > 0) {
                    string32 = stringArray[0];
                    EJBLogger.logRunAsPrincipalChosenFromSecurityRoleAssignment((String)string, (String)string2, (String)string32);
                    return string32;
                }
                if (this.roleMappingBehavior == 1) {
                    EJBComplianceTextFormatter eJBComplianceTextFormatter = new EJBComplianceTextFormatter();
                    throw new WLDeploymentException(eJBComplianceTextFormatter.COULD_NOT_DETERMINE_RUN_AS_PRINCIPAL_FROM_ROLE_ASSIGNMENT(string, string2));
                }
                if (debugLogger.isDebugEnabled()) {
                    RuntimeHelper.debug("setting run-as principal equal to the role name for run-as role " + string2);
                }
                return string2;
            }
        }
        throw new AssertionError((Object)("Unexpected role mapping behavior: " + this.roleMappingBehavior));
    }

    public static Object getCurrentNew() {
        return SecurityHelper.getCurrentSubject();
    }

    private static void debug(String string) {
        debugLogger.debug("[RuntimeHelper] " + string);
    }

    public static int getCurrentState(Object object) {
        int n = 0;
        if (object != null) {
            n = ((WLEnterpriseBean)object).__WL_getMethodState();
        } else {
            Object object2 = AllowedMethodsHelper.getMethodInvocationState();
            if (object2 != null) {
                n = (Integer)object2;
            }
        }
        return n;
    }
}

